/*
 * Decompiled with CFR 0.152.
 */
package ai.heavy.jdbc;

import ai.heavy.jdbc.HeavyAIConnection;
import ai.heavy.jdbc.HeavyAIEscapeParser;
import ai.heavy.jdbc.HeavyAIExceptionText;
import ai.heavy.jdbc.HeavyAIResultSet;
import ai.heavy.jdbc.Options;
import ai.heavy.thrift.server.Heavy;
import ai.heavy.thrift.server.TDBException;
import ai.heavy.thrift.server.TQueryResult;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeavyAIStatement
implements Statement {
    static final Logger logger = LoggerFactory.getLogger(HeavyAIStatement.class);
    public SQLWarning rootWarning = null;
    private String session;
    private Heavy.Client client;
    private HeavyAIConnection connection;
    private ResultSet currentRS = null;
    private TQueryResult sqlResult = null;
    private int maxRows;
    private boolean escapeProcessing = false;
    private boolean isClosed = false;
    static Pattern top_pattern = Pattern.compile("select top\\s+([0-9]+)\\s+", 2);
    private static final Pattern QUARTER = Pattern.compile("\\sQUARTER\\(([^\\{]*?)", 34);
    private static final Pattern DAYOFYEAR = Pattern.compile("\\sDAYOFYEAR\\(([^\\{]*?)", 34);
    private static final Pattern DAYOFWEEK = Pattern.compile("\\sDAYOFWEEK\\(([^\\{]*?)", 34);
    private static final Pattern WEEK = Pattern.compile("\\sWEEK\\(([^\\{]*?)", 34);
    private static final Pattern CURRENTDATE = Pattern.compile("(?<![\\w.])CURRENT_DATE(?:\\(\\))?(?![\\w.])", 34);

    HeavyAIStatement(String tsession, HeavyAIConnection tconnection) {
        this.session = tsession;
        this.connection = tconnection;
        this.client = this.connection.client;
        this.maxRows = Integer.parseInt(this.connection.cP.getProperty(Options.max_rows));
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        String[] tokens;
        this.checkClosed();
        if (this.maxRows >= 0 && (tokens = sql.toLowerCase().split(" ", 3))[0].equals("select") && !sql.toLowerCase().contains("limit")) {
            Matcher matcher = top_pattern.matcher(sql);
            if (matcher.find()) {
                this.maxRows = Integer.parseInt(matcher.group(1));
                sql = top_pattern.matcher(sql).replaceAll("select ");
            }
            sql = sql + " LIMIT " + this.maxRows;
            logger.debug("Added LIMIT of " + this.maxRows);
        }
        logger.debug("Before HeavyAIEscapeParser [" + sql + "]");
        String afterEscapeParseSQL = HeavyAIEscapeParser.parse(sql);
        String afterSimpleParse = HeavyAIStatement.simplisticDateTransform(afterEscapeParseSQL);
        logger.debug("After HeavyAIEscapeParser [" + afterSimpleParse + "]");
        try {
            this.sqlResult = this.client.sql_execute(this.session, afterSimpleParse + ";", true, null, -1, -1);
        }
        catch (TDBException ex) {
            throw new SQLException("Query failed : " + HeavyAIExceptionText.getExceptionDetail(ex));
        }
        catch (TException ex) {
            throw new SQLException("Query failed : " + HeavyAIExceptionText.getExceptionDetail(ex));
        }
        this.currentRS = new HeavyAIResultSet(this.sqlResult, sql);
        return this.currentRS;
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClosed();
        HeavyAIConnection alternate_connection = null;
        try {
            alternate_connection = this.connection.getAlternateConnection();
            alternate_connection.client.interrupt(this.session, this.session);
        }
        catch (TDBException ttE) {
            throw new SQLException("Thrift transport connection failed - " + HeavyAIExceptionText.getExceptionDetail(ttE), ttE);
        }
        catch (TException tE) {
            throw new SQLException("Thrift failed - " + HeavyAIExceptionText.getExceptionDetail(tE), tE);
        }
        finally {
            alternate_connection.closeConnection();
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkClosed();
        try {
            if (sql.trim().substring(0, 6).compareToIgnoreCase("CREATE") == 0) {
                sql = sql.replace('\"', ' ');
            }
            this.sqlResult = this.client.sql_execute(this.session, sql + ";", true, null, -1, -1);
        }
        catch (TDBException ex) {
            throw new SQLException("Query failed :  sql was '" + sql + "' " + HeavyAIExceptionText.getExceptionDetail(ex), ex);
        }
        catch (TException ex) {
            throw new SQLException("Query failed : " + HeavyAIExceptionText.getExceptionDetail(ex), ex);
        }
        return -1;
    }

    @Override
    public void close() throws SQLException {
        if (this.currentRS != null) {
            this.currentRS.close();
        }
        this.isClosed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.escapeProcessing = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    public int getQueryInternalExecuteTime() throws SQLException {
        return (int)this.sqlResult.execution_time_ms;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        SQLWarning warning = new SQLWarning("Query timeouts are not supported.  Substituting a value of zero.");
        if (this.rootWarning == null) {
            this.rootWarning = warning;
        } else {
            this.rootWarning.setNextWarning(warning);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.rootWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.rootWarning = null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        ResultSet rs = this.executeQuery(sql);
        return rs != null;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        return this.currentRS;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkClosed();
        return -1;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        SQLWarning warning = new SQLWarning("Query FetchSize are not supported.  Substituting a value of zero.");
        if (this.rootWarning == null) {
            this.rootWarning = warning;
        } else {
            this.rootWarning.setNextWarning(warning);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    public static String simplisticDateTransform(String sql) {
        String start;
        do {
            start = sql;
        } while (!(sql = QUARTER.matcher(sql).replaceAll(" EXTRACT(QUARTER FROM $1")).equals(start));
        do {
            start = sql;
        } while (!(sql = DAYOFYEAR.matcher(sql).replaceAll(" EXTRACT(DOY FROM $1")).equals(start));
        do {
            start = sql;
        } while (!(sql = DAYOFWEEK.matcher(sql).replaceAll(" EXTRACT(ISODOW FROM $1")).equals(start));
        do {
            start = sql;
        } while (!(sql = WEEK.matcher(sql).replaceAll(" EXTRACT(WEEK FROM $1")).equals(start));
        do {
            start = sql;
        } while (!(sql = CURRENTDATE.matcher(sql).replaceAll(" cast(now() as date) ")).equals(start));
        return sql;
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Statement is closed.");
        }
    }
}

