/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamBase;
import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.ByteBufferCursor;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.Interop;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiPointImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.VertexDescription;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class OperatorExportToESRIShapeCursor
extends ByteBufferCursor {
    GeometryCursor m_inputGeometryCursor;
    int m_exportFlags;
    int m_index = -1;
    ByteBuffer m_shapeBuffer;

    public OperatorExportToESRIShapeCursor(int exportFlags, GeometryCursor geometryCursor) {
        if (geometryCursor == null) {
            throw new GeometryException("invalid argument");
        }
        this.m_exportFlags = exportFlags;
        this.m_inputGeometryCursor = geometryCursor;
        this.m_shapeBuffer = null;
    }

    @Override
    public int getByteBufferID() {
        return this.m_index;
    }

    @Override
    public ByteBuffer next() {
        Geometry geometry = this.m_inputGeometryCursor.next();
        if (geometry != null) {
            this.m_index = this.m_inputGeometryCursor.getGeometryID();
            int size = OperatorExportToESRIShapeCursor.exportToESRIShape(this.m_exportFlags, geometry, null);
            if (this.m_shapeBuffer == null || size > this.m_shapeBuffer.capacity()) {
                this.m_shapeBuffer = ByteBuffer.allocate(size).order(ByteOrder.LITTLE_ENDIAN);
            }
            OperatorExportToESRIShapeCursor.exportToESRIShape(this.m_exportFlags, geometry, this.m_shapeBuffer);
            return this.m_shapeBuffer;
        }
        return null;
    }

    static int exportToESRIShape(int exportFlags, Geometry geometry, ByteBuffer shapeBuffer) {
        if (geometry == null) {
            if (shapeBuffer != null) {
                shapeBuffer.putInt(0, 0);
            }
            return 4;
        }
        int type = geometry.getType().value();
        switch (type) {
            case 1736: {
                return OperatorExportToESRIShapeCursor.exportMultiPathToESRIShape(true, exportFlags, (MultiPath)geometry, shapeBuffer);
            }
            case 1607: {
                return OperatorExportToESRIShapeCursor.exportMultiPathToESRIShape(false, exportFlags, (MultiPath)geometry, shapeBuffer);
            }
            case 550: {
                return OperatorExportToESRIShapeCursor.exportMultiPointToESRIShape(exportFlags, (MultiPoint)geometry, shapeBuffer);
            }
            case 33: {
                return OperatorExportToESRIShapeCursor.exportPointToESRIShape(exportFlags, (Point)geometry, shapeBuffer);
            }
            case 197: {
                return OperatorExportToESRIShapeCursor.exportEnvelopeToESRIShape(exportFlags, (Envelope)geometry, shapeBuffer);
            }
        }
        throw GeometryException.GeometryInternalError();
    }

    private static int exportEnvelopeToESRIShape(int exportFlags, Envelope envelope, ByteBuffer shapeBuffer) {
        boolean bExportZs = envelope.hasAttribute(1) && (exportFlags & 0x10) == 0;
        boolean bExportMs = envelope.hasAttribute(2) && (exportFlags & 0x20) == 0;
        boolean bExportIDs = envelope.hasAttribute(3) && (exportFlags & 0x40) == 0;
        boolean bArcViewNaNs = (exportFlags & 8) == 0;
        boolean bEmpty = envelope.isEmpty();
        int partCount = bEmpty ? 0 : 1;
        int pointCount = bEmpty ? 0 : 5;
        int size = 44 + partCount * 4 + pointCount * 2 * 8;
        if (bExportZs) {
            size += 16 + pointCount * 8;
        }
        if (bExportMs) {
            size += 16 + pointCount * 8;
        }
        if (bExportIDs) {
            size += pointCount * 4;
        }
        if (shapeBuffer == null) {
            return size;
        }
        if (shapeBuffer.capacity() < size) {
            throw new GeometryException("buffer is too small");
        }
        int type = !bExportZs && !bExportMs ? (bExportIDs ? 0x10000033 : 5) : (bExportZs && !bExportMs ? (bExportIDs ? -1879048141 : 19) : (bExportMs && !bExportZs ? (bExportIDs ? 0x50000033 : 25) : (bExportIDs ? -805306317 : 15)));
        int offset = 0;
        shapeBuffer.putInt(offset, type);
        Envelope2D env = new Envelope2D();
        envelope.queryEnvelope2D(env);
        shapeBuffer.putDouble(offset += 4, env.xmin);
        shapeBuffer.putDouble(offset += 8, env.ymin);
        shapeBuffer.putDouble(offset += 8, env.xmax);
        shapeBuffer.putDouble(offset += 8, env.ymax);
        shapeBuffer.putInt(offset += 8, partCount);
        shapeBuffer.putInt(offset += 4, pointCount);
        offset += 4;
        if (!bEmpty) {
            shapeBuffer.putInt(offset, 0);
            shapeBuffer.putDouble(offset += 4, env.xmin);
            shapeBuffer.putDouble(offset += 8, env.ymin);
            shapeBuffer.putDouble(offset += 8, env.xmin);
            shapeBuffer.putDouble(offset += 8, env.ymax);
            shapeBuffer.putDouble(offset += 8, env.xmax);
            shapeBuffer.putDouble(offset += 8, env.ymax);
            shapeBuffer.putDouble(offset += 8, env.xmax);
            shapeBuffer.putDouble(offset += 8, env.ymin);
            shapeBuffer.putDouble(offset += 8, env.xmin);
            shapeBuffer.putDouble(offset += 8, env.ymin);
            offset += 8;
        }
        if (bExportZs) {
            Envelope1D zInterval = envelope.queryInterval(1, 0);
            double zmin = bArcViewNaNs ? Interop.translateToAVNaN(zInterval.vmin) : zInterval.vmin;
            double zmax = bArcViewNaNs ? Interop.translateToAVNaN(zInterval.vmax) : zInterval.vmax;
            shapeBuffer.putDouble(offset, zmin);
            shapeBuffer.putDouble(offset += 8, zmax);
            offset += 8;
            if (!bEmpty) {
                shapeBuffer.putDouble(offset, zmin);
                shapeBuffer.putDouble(offset += 8, zmax);
                shapeBuffer.putDouble(offset += 8, zmin);
                shapeBuffer.putDouble(offset += 8, zmax);
                shapeBuffer.putDouble(offset += 8, zmin);
                offset += 8;
            }
        }
        if (bExportMs) {
            Envelope1D mInterval = envelope.queryInterval(2, 0);
            double mmin = bArcViewNaNs ? Interop.translateToAVNaN(mInterval.vmin) : mInterval.vmin;
            double mmax = bArcViewNaNs ? Interop.translateToAVNaN(mInterval.vmax) : mInterval.vmax;
            shapeBuffer.putDouble(offset, mmin);
            shapeBuffer.putDouble(offset += 8, mmax);
            offset += 8;
            if (!bEmpty) {
                shapeBuffer.putDouble(offset, mmin);
                shapeBuffer.putDouble(offset += 8, mmax);
                shapeBuffer.putDouble(offset += 8, mmin);
                shapeBuffer.putDouble(offset += 8, mmax);
                shapeBuffer.putDouble(offset += 8, mmin);
                offset += 8;
            }
        }
        if (bExportIDs && !bEmpty) {
            Envelope1D idInterval = envelope.queryInterval(3, 0);
            int idmin = (int)idInterval.vmin;
            int idmax = (int)idInterval.vmax;
            shapeBuffer.putInt(offset, idmin);
            shapeBuffer.putInt(offset += 4, idmax);
            shapeBuffer.putInt(offset += 4, idmin);
            shapeBuffer.putInt(offset += 4, idmax);
            shapeBuffer.putInt(offset += 4, idmin);
            offset += 4;
        }
        return offset;
    }

    private static int exportPointToESRIShape(int exportFlags, Point point, ByteBuffer shapeBuffer) {
        boolean bExportZ = point.hasAttribute(1) && (exportFlags & 0x10) == 0;
        boolean bExportM = point.hasAttribute(2) && (exportFlags & 0x20) == 0;
        boolean bExportID = point.hasAttribute(3) && (exportFlags & 0x40) == 0;
        boolean bArcViewNaNs = (exportFlags & 8) == 0;
        int size = 20;
        if (bExportZ) {
            size += 8;
        }
        if (bExportM) {
            size += 8;
        }
        if (bExportID) {
            size += 4;
        }
        if (shapeBuffer == null) {
            return size;
        }
        if (shapeBuffer.capacity() < size) {
            throw new GeometryException("buffer is too small");
        }
        int type = !bExportZ && !bExportM ? (bExportID ? 268435508 : 1) : (bExportZ && !bExportM ? (bExportID ? -1879048140 : 9) : (bExportM && !bExportZ ? (bExportID ? 1342177332 : 21) : (bExportID ? -805306316 : 11)));
        int offset = 0;
        shapeBuffer.putInt(offset, type);
        boolean bEmpty = point.isEmpty();
        double x = !bEmpty ? point.getX() : NumberUtils.NaN();
        double y = !bEmpty ? point.getY() : NumberUtils.NaN();
        shapeBuffer.putDouble(offset += 4, bArcViewNaNs ? Interop.translateToAVNaN(x) : x);
        shapeBuffer.putDouble(offset += 8, bArcViewNaNs ? Interop.translateToAVNaN(y) : y);
        offset += 8;
        if (bExportZ) {
            double z = !bEmpty ? point.getZ() : NumberUtils.NaN();
            shapeBuffer.putDouble(offset, bArcViewNaNs ? Interop.translateToAVNaN(z) : z);
            offset += 8;
        }
        if (bExportM) {
            double m3 = !bEmpty ? point.getM() : NumberUtils.NaN();
            shapeBuffer.putDouble(offset, bArcViewNaNs ? Interop.translateToAVNaN(m3) : m3);
            offset += 8;
        }
        if (bExportID) {
            int id = !bEmpty ? point.getID() : 0;
            shapeBuffer.putInt(offset, id);
            offset += 4;
        }
        return offset;
    }

    private static int exportMultiPointToESRIShape(int exportFlags, MultiPoint multipoint, ByteBuffer shapeBuffer) {
        int i;
        MultiPointImpl multipointImpl = (MultiPointImpl)multipoint._getImpl();
        boolean bExportZs = multipointImpl.hasAttribute(1) && (exportFlags & 0x10) == 0;
        boolean bExportMs = multipointImpl.hasAttribute(2) && (exportFlags & 0x20) == 0;
        boolean bExportIDs = multipointImpl.hasAttribute(3) && (exportFlags & 0x40) == 0;
        boolean bArcViewNaNs = (exportFlags & 8) == 0;
        int pointCount = multipointImpl.getPointCount();
        int size = 40 + pointCount * 2 * 8;
        if (bExportZs) {
            size += 16 + pointCount * 8;
        }
        if (bExportMs) {
            size += 16 + pointCount * 8;
        }
        if (bExportIDs) {
            size += pointCount * 4;
        }
        if (size >= NumberUtils.intMax()) {
            throw new GeometryException("invalid call");
        }
        if (shapeBuffer == null) {
            return size;
        }
        if (shapeBuffer.capacity() < size) {
            throw new GeometryException("buffer is too small");
        }
        int type = !bExportZs && !bExportMs ? (bExportIDs ? 268435509 : 8) : (bExportZs && !bExportMs ? (bExportIDs ? -1879048139 : 20) : (bExportMs && !bExportZs ? (bExportIDs ? 0x50000035 : 28) : (bExportIDs ? -805306315 : 18)));
        int offset = 0;
        shapeBuffer.putInt(offset, type);
        Envelope2D env = new Envelope2D();
        multipointImpl.queryEnvelope2D(env);
        shapeBuffer.putDouble(offset += 4, env.xmin);
        shapeBuffer.putDouble(offset += 8, env.ymin);
        shapeBuffer.putDouble(offset += 8, env.xmax);
        shapeBuffer.putDouble(offset += 8, env.ymax);
        shapeBuffer.putInt(offset += 8, pointCount);
        offset += 4;
        if (pointCount > 0) {
            AttributeStreamBase positionStream = multipointImpl.getAttributeStreamRef(0);
            AttributeStreamOfDbl position = (AttributeStreamOfDbl)positionStream;
            for (i = 0; i < pointCount; ++i) {
                double x = position.read(2 * i);
                double y = position.read(2 * i + 1);
                shapeBuffer.putDouble(offset, x);
                shapeBuffer.putDouble(offset += 8, y);
                offset += 8;
            }
        }
        if (bExportZs) {
            Envelope1D zInterval = multipointImpl.queryInterval(1, 0);
            shapeBuffer.putDouble(offset, bArcViewNaNs ? Interop.translateToAVNaN(zInterval.vmin) : zInterval.vmin);
            shapeBuffer.putDouble(offset += 8, bArcViewNaNs ? Interop.translateToAVNaN(zInterval.vmax) : zInterval.vmax);
            offset += 8;
            if (pointCount > 0) {
                if (multipointImpl._attributeStreamIsAllocated(1)) {
                    AttributeStreamOfDbl zs = (AttributeStreamOfDbl)multipointImpl.getAttributeStreamRef(1);
                    for (i = 0; i < pointCount; ++i) {
                        double z = zs.read(i);
                        shapeBuffer.putDouble(offset, bArcViewNaNs ? Interop.translateToAVNaN(z) : z);
                        offset += 8;
                    }
                } else {
                    double z = VertexDescription.getDefaultValue(1);
                    if (bArcViewNaNs) {
                        z = Interop.translateToAVNaN(z);
                    }
                    for (int i2 = 0; i2 < pointCount; ++i2) {
                        shapeBuffer.putDouble(offset, z);
                    }
                    offset += 8;
                }
            }
        }
        if (bExportMs) {
            Envelope1D mInterval = multipointImpl.queryInterval(2, 0);
            shapeBuffer.putDouble(offset, bArcViewNaNs ? Interop.translateToAVNaN(mInterval.vmin) : mInterval.vmin);
            shapeBuffer.putDouble(offset += 8, bArcViewNaNs ? Interop.translateToAVNaN(mInterval.vmax) : mInterval.vmax);
            offset += 8;
            if (pointCount > 0) {
                if (multipointImpl._attributeStreamIsAllocated(2)) {
                    AttributeStreamOfDbl ms = (AttributeStreamOfDbl)multipointImpl.getAttributeStreamRef(2);
                    for (i = 0; i < pointCount; ++i) {
                        double m3 = ms.read(i);
                        shapeBuffer.putDouble(offset, bArcViewNaNs ? Interop.translateToAVNaN(m3) : m3);
                        offset += 8;
                    }
                } else {
                    double m4 = VertexDescription.getDefaultValue(2);
                    if (bArcViewNaNs) {
                        m4 = Interop.translateToAVNaN(m4);
                    }
                    for (int i3 = 0; i3 < pointCount; ++i3) {
                        shapeBuffer.putDouble(offset, m4);
                    }
                    offset += 8;
                }
            }
        }
        if (bExportIDs && pointCount > 0) {
            if (multipointImpl._attributeStreamIsAllocated(3)) {
                AttributeStreamOfInt32 ids = (AttributeStreamOfInt32)multipointImpl.getAttributeStreamRef(3);
                for (int i4 = 0; i4 < pointCount; ++i4) {
                    int id = ids.read(i4);
                    shapeBuffer.putInt(offset, id);
                    offset += 4;
                }
            } else {
                int id = (int)VertexDescription.getDefaultValue(3);
                for (int i5 = 0; i5 < pointCount; ++i5) {
                    shapeBuffer.putInt(offset, id);
                }
                offset += 4;
            }
        }
        return offset;
    }

    private static int exportMultiPathToESRIShape(boolean bPolygon, int exportFlags, MultiPath multipath, ByteBuffer shapeBuffer) {
        int i;
        int partEnd;
        int partStart;
        int ipart;
        int type;
        MultiPathImpl multipathImpl = (MultiPathImpl)multipath._getImpl();
        boolean bExportZs = multipathImpl.hasAttribute(1) && (exportFlags & 0x10) == 0;
        boolean bExportMs = multipathImpl.hasAttribute(2) && (exportFlags & 0x20) == 0;
        boolean bExportIDs = multipathImpl.hasAttribute(3) && (exportFlags & 0x40) == 0;
        boolean bHasCurves = multipathImpl.hasNonLinearSegments();
        boolean bArcViewNaNs = (exportFlags & 8) == 0;
        int partCount = multipathImpl.getPathCount();
        int pointCount = multipathImpl.getPointCount();
        if (!bPolygon) {
            for (int ipart2 = 0; ipart2 < partCount; ++ipart2) {
                if (!multipath.isClosedPath(ipart2)) continue;
                ++pointCount;
            }
        } else {
            pointCount += partCount;
        }
        int size = 44 + partCount * 4 + pointCount * 2 * 8;
        if (bExportZs) {
            size += 16 + pointCount * 8;
        }
        if (bExportMs) {
            size += 16 + pointCount * 8;
        }
        if (bExportIDs) {
            size += pointCount * 4;
        }
        if (bHasCurves) {
            // empty if block
        }
        if (size >= NumberUtils.intMax()) {
            throw new GeometryException("invalid call");
        }
        if (shapeBuffer == null) {
            return size;
        }
        if (shapeBuffer.capacity() < size) {
            throw new GeometryException("buffer is too small");
        }
        int offset = 0;
        if (!bExportZs && !bExportMs) {
            if (bExportIDs || bHasCurves) {
                int n = type = bPolygon ? 51 : 50;
                if (bExportIDs) {
                    type |= 0x10000000;
                }
                if (bHasCurves) {
                    type |= 0x20000000;
                }
            } else {
                type = bPolygon ? 5 : 3;
            }
        } else if (bExportZs && !bExportMs) {
            if (bExportIDs || bHasCurves) {
                type = bPolygon ? 51 : 50;
                type |= Integer.MIN_VALUE;
                if (bExportIDs) {
                    type |= 0x10000000;
                }
                if (bHasCurves) {
                    type |= 0x20000000;
                }
            } else {
                type = bPolygon ? 19 : 10;
            }
        } else if (bExportMs && !bExportZs) {
            if (bExportIDs || bHasCurves) {
                type = bPolygon ? 51 : 50;
                type |= 0x40000000;
                if (bExportIDs) {
                    type |= 0x10000000;
                }
                if (bHasCurves) {
                    type |= 0x20000000;
                }
            } else {
                type = bPolygon ? 25 : 23;
            }
        } else if (bExportIDs || bHasCurves) {
            type = bPolygon ? 51 : 50;
            type |= 0xC0000000;
            if (bExportIDs) {
                type |= 0x10000000;
            }
            if (bHasCurves) {
                type |= 0x20000000;
            }
        } else {
            type = bPolygon ? 15 : 13;
        }
        shapeBuffer.putInt(offset, type);
        Envelope2D env = new Envelope2D();
        multipathImpl.queryEnvelope2D(env);
        shapeBuffer.putDouble(offset += 4, env.xmin);
        shapeBuffer.putDouble(offset += 8, env.ymin);
        shapeBuffer.putDouble(offset += 8, env.xmax);
        shapeBuffer.putDouble(offset += 8, env.ymax);
        shapeBuffer.putInt(offset += 8, partCount);
        shapeBuffer.putInt(offset += 4, pointCount);
        offset += 4;
        int pointIndexDelta = 0;
        for (int ipart3 = 0; ipart3 < partCount; ++ipart3) {
            int istart = multipathImpl.getPathStart(ipart3) + pointIndexDelta;
            shapeBuffer.putInt(offset, istart);
            offset += 4;
            if (!bPolygon && !multipathImpl.isClosedPath(ipart3)) continue;
            ++pointIndexDelta;
        }
        if (pointCount > 0) {
            AttributeStreamBase positionStream = multipathImpl.getAttributeStreamRef(0);
            AttributeStreamOfDbl position = (AttributeStreamOfDbl)positionStream;
            for (ipart = 0; ipart < partCount; ++ipart) {
                partStart = multipathImpl.getPathStart(ipart);
                partEnd = multipathImpl.getPathEnd(ipart);
                for (int i2 = partStart; i2 < partEnd; ++i2) {
                    double x = position.read(2 * i2);
                    double y = position.read(2 * i2 + 1);
                    shapeBuffer.putDouble(offset, x);
                    shapeBuffer.putDouble(offset += 8, y);
                    offset += 8;
                }
                if (!bPolygon && !multipathImpl.isClosedPath(ipart)) continue;
                double x = position.read(2 * partStart);
                double y = position.read(2 * partStart + 1);
                shapeBuffer.putDouble(offset, x);
                shapeBuffer.putDouble(offset += 8, y);
                offset += 8;
            }
        }
        if (bExportZs) {
            Envelope1D zInterval = multipathImpl.queryInterval(1, 0);
            shapeBuffer.putDouble(offset, bArcViewNaNs ? Interop.translateToAVNaN(zInterval.vmin) : zInterval.vmin);
            shapeBuffer.putDouble(offset += 8, bArcViewNaNs ? Interop.translateToAVNaN(zInterval.vmax) : zInterval.vmax);
            offset += 8;
            if (pointCount > 0) {
                if (multipathImpl._attributeStreamIsAllocated(1)) {
                    AttributeStreamOfDbl zs = (AttributeStreamOfDbl)multipathImpl.getAttributeStreamRef(1);
                    for (ipart = 0; ipart < partCount; ++ipart) {
                        partStart = multipathImpl.getPathStart(ipart);
                        partEnd = multipathImpl.getPathEnd(ipart);
                        for (int i3 = partStart; i3 < partEnd; ++i3) {
                            double z = zs.read(i3);
                            shapeBuffer.putDouble(offset, bArcViewNaNs ? Interop.translateToAVNaN(z) : z);
                            offset += 8;
                        }
                        if (!bPolygon && !multipathImpl.isClosedPath(ipart)) continue;
                        double z = zs.read(partStart);
                        shapeBuffer.putDouble(offset, z);
                        offset += 8;
                    }
                } else {
                    double z = VertexDescription.getDefaultValue(1);
                    if (bArcViewNaNs) {
                        z = Interop.translateToAVNaN(z);
                    }
                    for (i = 0; i < pointCount; ++i) {
                        shapeBuffer.putDouble(offset, z);
                    }
                    offset += 8;
                }
            }
        }
        if (bExportMs) {
            Envelope1D mInterval = multipathImpl.queryInterval(2, 0);
            shapeBuffer.putDouble(offset, bArcViewNaNs ? Interop.translateToAVNaN(mInterval.vmin) : mInterval.vmin);
            shapeBuffer.putDouble(offset += 8, bArcViewNaNs ? Interop.translateToAVNaN(mInterval.vmax) : mInterval.vmax);
            offset += 8;
            if (pointCount > 0) {
                if (multipathImpl._attributeStreamIsAllocated(2)) {
                    AttributeStreamOfDbl ms = (AttributeStreamOfDbl)multipathImpl.getAttributeStreamRef(2);
                    for (ipart = 0; ipart < partCount; ++ipart) {
                        partStart = multipathImpl.getPathStart(ipart);
                        partEnd = multipathImpl.getPathEnd(ipart);
                        for (int i4 = partStart; i4 < partEnd; ++i4) {
                            double m3 = ms.read(i4);
                            shapeBuffer.putDouble(offset, bArcViewNaNs ? Interop.translateToAVNaN(m3) : m3);
                            offset += 8;
                        }
                        if (!bPolygon && !multipathImpl.isClosedPath(ipart)) continue;
                        double m4 = ms.read(partStart);
                        shapeBuffer.putDouble(offset, m4);
                        offset += 8;
                    }
                } else {
                    double m5 = VertexDescription.getDefaultValue(2);
                    if (bArcViewNaNs) {
                        m5 = Interop.translateToAVNaN(m5);
                    }
                    for (i = 0; i < pointCount; ++i) {
                        shapeBuffer.putDouble(offset, m5);
                    }
                    offset += 8;
                }
            }
        }
        if (bHasCurves) {
            // empty if block
        }
        if (bExportIDs && pointCount > 0) {
            if (multipathImpl._attributeStreamIsAllocated(3)) {
                AttributeStreamOfInt32 ids = (AttributeStreamOfInt32)multipathImpl.getAttributeStreamRef(3);
                for (int ipart4 = 0; ipart4 < partCount; ++ipart4) {
                    int partStart2 = multipathImpl.getPathStart(ipart4);
                    int partEnd2 = multipathImpl.getPathEnd(ipart4);
                    for (int i5 = partStart2; i5 < partEnd2; ++i5) {
                        int id = ids.read(i5);
                        shapeBuffer.putInt(offset, id);
                        offset += 4;
                    }
                    if (!bPolygon && !multipathImpl.isClosedPath(ipart4)) continue;
                    int id = ids.read(partStart2);
                    shapeBuffer.putInt(offset, id);
                    offset += 4;
                }
            } else {
                int id = (int)VertexDescription.getDefaultValue(3);
                for (int i6 = 0; i6 < pointCount; ++i6) {
                    shapeBuffer.putInt(offset, id);
                }
                offset += 4;
            }
        }
        return offset;
    }
}

