/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.bench;

import ai.heavy.jdbc.HeavyAIStatement;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Benchmark {
    static final Logger logger = LoggerFactory.getLogger(Benchmark.class);
    static final String JDBC_DRIVER = "ai.heavy.jdbc.HeavyAIDriver";
    static final String DB_URL = "jdbc:heavyai:localhost:6274:mapd";
    static final String USER = "admin";
    static final String PASS = "HyperInteractive";
    private String driver;
    private String url;
    private String iUser;
    private String iPasswd;
    private String headDescriptor = "%3s, %8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s";
    private String header2 = String.format(this.headDescriptor, "QRY", "T-Avg", "T-Min", "T-Max", "T-85%", "E-Avg", "E-Min", "E-Max", "E-85%", "E-25%", "E-StdD", "J-Avg", "J-Min", "J-Max", "J-85%", "I-Avg", "I-Min", "I-Max", "I-85%", "F-Exec", "F-jdbc", "F-iter", "ITER", "Total", "Account");
    private String lineDescriptor = "Q%02d, %8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8d,%8d,%8d,%8d,%8d,%8d";

    public static void main(String[] args) {
        Benchmark bm = new Benchmark();
        bm.doWork(args, 1);
    }

    void doWork(String[] args, int query) {
        int iterations = Integer.valueOf(args[0]);
        logger.debug("Iterations per query is " + iterations);
        String queryFile = args[1];
        this.driver = args.length > 2 ? args[2] : JDBC_DRIVER;
        this.url = args.length > 3 ? args[3] : DB_URL;
        this.iUser = args.length > 4 ? args[4] : USER;
        this.iPasswd = args.length > 5 ? args[5] : PASS;
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException ex) {
            logger.error("Could not load class " + this.driver + " " + ex.getMessage());
            System.exit(1);
        }
        ArrayList<String> resultArray = new ArrayList<String>();
        try {
            String sCurrentLine;
            BufferedReader br = new BufferedReader(new FileReader(queryFile));
            int qCount = 1;
            while ((sCurrentLine = br.readLine()) != null) {
                int expected = 0;
                String sqlQuery = null;
                for (int i = sCurrentLine.length(); i > 0; --i) {
                    if (sCurrentLine.charAt(i - 1) != ',') continue;
                    expected = Integer.valueOf(sCurrentLine.substring(i).trim());
                    sqlQuery = sCurrentLine.substring(0, i - 1).trim().substring(1);
                    break;
                }
                sqlQuery = sqlQuery.substring(0, sqlQuery.length() - 1);
                System.out.println(String.format("Q%02d %s", qCount, sqlQuery));
                resultArray.add(this.executeQuery(sqlQuery, expected, iterations, qCount));
                ++qCount;
            }
        }
        catch (FileNotFoundException ex) {
            logger.error("Could not find file " + queryFile + " " + ex.getMessage());
            System.exit(2);
        }
        catch (IOException ex) {
            logger.error("IO Exeception " + ex.getMessage());
            System.exit(3);
        }
        System.out.println(this.header2);
        for (String s2 : resultArray) {
            System.out.println(s2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String executeQuery(String sql, int expected, int iterations, int queryNum) {
        Connection conn = null;
        Statement stmt = null;
        Long firstExecute = 0L;
        Long firstJdbc = 0L;
        Long firstIterate = 0L;
        DescriptiveStatistics statsExecute = new DescriptiveStatistics();
        DescriptiveStatistics statsJdbc = new DescriptiveStatistics();
        DescriptiveStatistics statsIterate = new DescriptiveStatistics();
        DescriptiveStatistics statsTotal = new DescriptiveStatistics();
        long totalTime = 0L;
        try {
            logger.debug("Connecting to database url :" + this.url);
            conn = DriverManager.getConnection(this.url, this.iUser, this.iPasswd);
            long startTime = System.currentTimeMillis();
            for (int loop = 0; loop < iterations; ++loop) {
                stmt = conn.createStatement();
                long timer = System.currentTimeMillis();
                ResultSet rs = stmt.executeQuery(sql);
                long executeTime = 0L;
                long jdbcTime = 0L;
                if (this.driver.equals(JDBC_DRIVER)) {
                    executeTime = ((HeavyAIStatement)stmt).getQueryInternalExecuteTime();
                    jdbcTime = System.currentTimeMillis() - timer - executeTime;
                } else {
                    jdbcTime = System.currentTimeMillis() - timer;
                    executeTime = 0L;
                }
                logger.debug("Query Timeout/AKA internal Execution Time was " + stmt.getQueryTimeout() + " ms Elapsed time in JVM space was " + (System.currentTimeMillis() - timer) + "ms");
                timer = System.currentTimeMillis();
                int resultCount = 0;
                while (rs.next()) {
                    Object obj = rs.getObject(1);
                    if (obj != null && obj.equals(statsExecute)) {
                        logger.info("Impossible");
                    }
                    ++resultCount;
                }
                long iterateTime = System.currentTimeMillis() - timer;
                if (resultCount != expected) {
                    logger.error("Expect " + expected + " actual " + resultCount + " for query " + sql);
                    break;
                }
                if (loop == 0) {
                    firstJdbc = jdbcTime;
                    firstExecute = executeTime;
                    firstIterate = iterateTime;
                } else {
                    statsJdbc.addValue(jdbcTime);
                    statsExecute.addValue(executeTime);
                    statsIterate.addValue(iterateTime);
                    statsTotal.addValue(jdbcTime + executeTime + iterateTime);
                }
                rs.close();
                stmt.close();
            }
            totalTime = System.currentTimeMillis() - startTime;
            conn.close();
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return String.format(this.lineDescriptor, queryNum, statsTotal.getMean(), statsTotal.getMin(), statsTotal.getMax(), statsTotal.getPercentile(85.0), statsExecute.getMean(), statsExecute.getMin(), statsExecute.getMax(), statsExecute.getPercentile(85.0), statsExecute.getPercentile(25.0), statsExecute.getStandardDeviation(), statsJdbc.getMean(), statsJdbc.getMin(), statsJdbc.getMax(), statsJdbc.getPercentile(85.0), statsIterate.getMean(), statsIterate.getMin(), statsIterate.getMax(), statsIterate.getPercentile(85.0), firstExecute, firstJdbc, firstIterate, iterations, totalTime, (long)statsTotal.getSum() + firstExecute + firstJdbc + firstIterate);
    }
}

