/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.bench;

import ai.heavy.jdbc.HeavyAIStatement;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BenchmarkCloud {
    static final Logger logger = LoggerFactory.getLogger(BenchmarkCloud.class);
    static final String QUERY_RESULT_MACHINE = "bencher";
    static final String DB_URL = "jdbc:heavyai:localhost:6274:mapd";
    static final String JDBC_DRIVER = "ai.heavy.jdbc.HeavyAIDriver";
    static final String USER = "admin";
    static final String PASS = "";
    static final String RESULTS_USER = "admin";
    static final String RESULTS_PASS = "";
    private String driver;
    private String url;
    private String iUser;
    private String queryResultMachine;
    private String iPasswd;
    private String iResultsUser;
    private String iResultsPasswd;
    private String rid;
    private String rTimestamp;
    private String tableName;
    private String label;
    private String gpuCount;
    private String targetDBVersion;
    Connection bencherCon;
    private List<String> LResult = new ArrayList<String>();
    private String headDescriptor = "%3s, %8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s";
    private String header2 = String.format(this.headDescriptor, "QRY", "T-Avg", "T-Min", "T-Max", "T-85%", "E-Avg", "E-Min", "E-Max", "E-85%", "E-25%", "E-StdD", "J-Avg", "J-Min", "J-Max", "J-85%", "I-Avg", "I-Min", "I-Max", "I-85%", "F-Exec", "F-jdbc", "F-iter", "ITER", "Total", "Account");
    private String lineDescriptor = "%3s, %8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8d,%8d,%8d,%8d,%8d,%8d";
    private String insertDescriptor = "('%s','%s','%s','%s','%s',%s,'%s','%s',%d,'%s', %8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8d,%8d,%8d,%8d,%8d,%8d, '%s')";

    public static void main(String[] args) {
        BenchmarkCloud bm = new BenchmarkCloud();
        bm.doWork(args, 1);
    }

    void doWork(String[] args, int query) {
        int iterations = Integer.valueOf(args[0]);
        logger.debug("Iterations per query is " + iterations);
        String queryFile = args[1];
        this.tableName = args[2];
        this.label = args[3];
        this.gpuCount = args[4];
        this.queryResultMachine = args.length > 5 ? args[5] : QUERY_RESULT_MACHINE;
        this.url = args.length > 6 ? args[6] : DB_URL;
        this.driver = args.length > 7 ? args[7] : JDBC_DRIVER;
        this.iUser = args.length > 8 ? args[8] : "admin";
        this.iPasswd = args.length > 9 ? args[9] : "";
        this.iResultsUser = args.length > 10 ? args[10] : "admin";
        this.iResultsPasswd = args.length > 11 ? args[11] : "";
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException ex) {
            logger.error("Could not load class " + this.driver + " " + ex.getMessage());
            System.exit(1);
        }
        UUID uuid = UUID.randomUUID();
        this.rid = uuid.toString();
        Date date = new Date();
        Timestamp t = new Timestamp(date.getTime());
        this.rTimestamp = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(t);
        System.out.println("run id is " + this.rid + " date is " + this.rTimestamp);
        ArrayList<String> resultArray = new ArrayList<String>();
        LinkedHashMap<String, String> queryIDMap = new LinkedHashMap<String, String>();
        try {
            String sCurrentLine;
            BufferedReader br = new BufferedReader(new FileReader(queryFile));
            while ((sCurrentLine = br.readLine()) != null) {
                queryIDMap.put(sCurrentLine, null);
            }
            br.close();
        }
        catch (FileNotFoundException ex) {
            logger.error("Could not find file " + queryFile + " " + ex.getMessage());
            System.exit(2);
        }
        catch (IOException ex) {
            logger.error("IO Exeception " + ex.getMessage());
            System.exit(3);
        }
        this.bencherCon = this.getConnection("jdbc:heavyai:" + this.queryResultMachine + ":6274:mapd", this.iResultsUser, this.iResultsPasswd);
        this.getQueries(queryIDMap, this.bencherCon, this.tableName);
        this.runQueries(resultArray, queryIDMap, iterations);
        this.storeResults();
        System.out.println(this.header2);
        for (String s2 : resultArray) {
            System.out.println(s2);
        }
    }

    Connection getConnection(String url, String iUser, String iPasswd) {
        logger.debug("Connecting to database url :" + url);
        try {
            Connection conn = DriverManager.getConnection(url, iUser, iPasswd);
            this.targetDBVersion = conn.getMetaData().getDatabaseProductVersion();
            logger.debug("Target DB version is " + this.targetDBVersion);
            return conn;
        }
        catch (SQLException ex) {
            logger.error("Exception making connection to " + url + " text is " + ex.getMessage());
            System.exit(2);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String executeQuery(Connection conn1, String qid, String sql, int iterations) {
        Statement stmt = null;
        Connection conn = this.getConnection(this.url, this.iUser, this.iPasswd);
        Long firstExecute = 0L;
        Long firstJdbc = 0L;
        Long firstIterate = 0L;
        DescriptiveStatistics statsExecute = new DescriptiveStatistics();
        DescriptiveStatistics statsJdbc = new DescriptiveStatistics();
        DescriptiveStatistics statsIterate = new DescriptiveStatistics();
        DescriptiveStatistics statsTotal = new DescriptiveStatistics();
        long totalTime = 0L;
        int resultCount = 0;
        try {
            long startTime = System.currentTimeMillis();
            for (int loop = 0; loop < iterations; ++loop) {
                stmt = conn.createStatement();
                long timer = System.currentTimeMillis();
                if (loop == 0) {
                    System.out.println(String.format("Query Id is %s : query is '%s'", qid, sql));
                }
                ResultSet rs = stmt.executeQuery(sql);
                long executeTime = 0L;
                long jdbcTime = 0L;
                if (this.driver.equals(JDBC_DRIVER)) {
                    executeTime = ((HeavyAIStatement)stmt).getQueryInternalExecuteTime();
                    jdbcTime = System.currentTimeMillis() - timer - executeTime;
                } else {
                    jdbcTime = System.currentTimeMillis() - timer;
                    executeTime = 0L;
                }
                logger.debug("Query Timeout/AKA internal Execution Time was " + stmt.getQueryTimeout() + " ms Elapsed time in JVM space was " + (System.currentTimeMillis() - timer) + "ms");
                timer = System.currentTimeMillis();
                resultCount = 0;
                while (rs.next()) {
                    Object obj = rs.getObject(1);
                    if (obj != null && obj.equals(statsExecute)) {
                        logger.info("Impossible");
                    }
                    ++resultCount;
                }
                long iterateTime = System.currentTimeMillis() - timer;
                if (loop == 0) {
                    firstJdbc = jdbcTime;
                    firstExecute = executeTime;
                    firstIterate = iterateTime;
                } else {
                    statsJdbc.addValue(jdbcTime);
                    statsExecute.addValue(executeTime);
                    statsIterate.addValue(iterateTime);
                    statsTotal.addValue(jdbcTime + executeTime + iterateTime);
                }
                rs.close();
                stmt.close();
            }
            totalTime = System.currentTimeMillis() - startTime;
            conn.close();
        }
        catch (SQLException se) {
            se.printStackTrace();
            System.exit(4);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(3);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
                System.exit(6);
            }
        }
        String insertPart = String.format(this.insertDescriptor, this.rid, this.rTimestamp, this.url, this.driver, this.label, this.gpuCount, this.tableName, qid, resultCount, "", statsTotal.getMean(), statsTotal.getMin(), statsTotal.getMax(), statsTotal.getPercentile(85.0), statsExecute.getMean(), statsExecute.getMin(), statsExecute.getMax(), statsExecute.getPercentile(85.0), statsExecute.getPercentile(25.0), statsExecute.getStandardDeviation(), statsJdbc.getMean(), statsJdbc.getMin(), statsJdbc.getMax(), statsJdbc.getPercentile(85.0), statsIterate.getMean(), statsIterate.getMin(), statsIterate.getMax(), statsIterate.getPercentile(85.0), firstExecute, firstJdbc, firstIterate, iterations, totalTime, (long)statsTotal.getSum() + firstExecute + firstJdbc + firstIterate, this.targetDBVersion);
        this.LResult.add("Insert into results values " + insertPart);
        return String.format(this.lineDescriptor, qid, statsTotal.getMean(), statsTotal.getMin(), statsTotal.getMax(), statsTotal.getPercentile(85.0), statsExecute.getMean(), statsExecute.getMin(), statsExecute.getMax(), statsExecute.getPercentile(85.0), statsExecute.getPercentile(25.0), statsExecute.getStandardDeviation(), statsJdbc.getMean(), statsJdbc.getMin(), statsJdbc.getMax(), statsJdbc.getPercentile(85.0), statsIterate.getMean(), statsIterate.getMin(), statsIterate.getMax(), statsIterate.getPercentile(85.0), firstExecute, firstJdbc, firstIterate, iterations, totalTime, (long)statsTotal.getSum() + firstExecute + firstJdbc + firstIterate);
    }

    private void getQueries(Map<String, String> queryIDMap, Connection benderCon, String tableName) {
        for (Map.Entry<String, String> entry : queryIDMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            Statement stmt = null;
            try {
                stmt = benderCon.createStatement();
            }
            catch (SQLException ex) {
                logger.error("Exception creating statement text is " + ex.getMessage());
                System.exit(2);
            }
            String sql = String.format("Select query_text from queries where query_id = '%s'", key);
            ResultSet rs = null;
            try {
                rs = stmt.executeQuery(sql);
            }
            catch (SQLException ex) {
                logger.error("Exception running query " + sql + " text is " + ex.getMessage());
                System.exit(2);
            }
            int resultCount = 0;
            try {
                while (rs.next()) {
                    String qString = rs.getString(1);
                    qString = qString.replaceAll("##TAB##", tableName);
                    queryIDMap.put(key, qString);
                    ++resultCount;
                }
            }
            catch (SQLException ex) {
                logger.error("Exception making next call text is " + ex.getMessage());
                System.exit(2);
            }
            if (resultCount <= true) continue;
            System.out.println("multiple values for queryId " + key);
        }
    }

    private void runQueries(List<String> resultArray, Map<String, String> queryIDMap, int iterations) {
        Connection conn = this.getConnection(this.url, this.iUser, this.iPasswd);
        for (Map.Entry<String, String> entry : queryIDMap.entrySet()) {
            String id = entry.getKey();
            String query = entry.getValue();
            resultArray.add(this.executeQuery(conn, id, query, iterations));
        }
    }

    private void storeResults() {
        for (String insertPart : this.LResult) {
            try {
                Statement sin = this.bencherCon.createStatement();
                sin.execute(insertPart);
            }
            catch (SQLException ex) {
                logger.error("Exception performing insert '" + insertPart + "' text is " + ex.getMessage());
                System.exit(2);
            }
        }
    }
}

