/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.calcite.parser;

import com.mapd.calcite.parser.HeavyDBSqlOperatorTable;
import com.mapd.calcite.parser.HeavyDBTypeCoercion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.calcite.sql.validate.SqlValidatorScope;

public class ExtTableFunctionTypeChecker
implements SqlOperandTypeChecker {
    final HeavyDBSqlOperatorTable opTable;
    public static final ExtTableFunctionErrors UDTF_ERRORS = Resources.create(ExtTableFunctionErrors.class);

    ExtTableFunctionTypeChecker(HeavyDBSqlOperatorTable opTable) {
        this.opTable = opTable;
    }

    @Override
    public boolean isOptional(int argIndex) {
        return false;
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        HeavyDBSqlOperatorTable.ExtTableFunction minCandidate;
        HashSet<HeavyDBSqlOperatorTable.ExtTableFunction> candidateOverloads = new HashSet<HeavyDBSqlOperatorTable.ExtTableFunction>(this.getOperatorOverloads(callBinding.getOperator()));
        for (SqlNode sqlNode : callBinding.getCall().getOperandList()) {
            if (sqlNode == null || sqlNode.getKind() != SqlKind.ARGUMENT_ASSIGNMENT) continue;
            SqlCall sqlCall = (SqlCall)sqlNode;
            SqlIdentifier id = (SqlIdentifier)sqlCall.operand(1);
            String paramName = id.getSimple();
            if (candidateOverloads.stream().anyMatch(tf -> tf.getParamNames().contains(paramName))) continue;
            throw this.newExtTableFunctionNameError(callBinding, sqlNode, id.getSimple());
        }
        candidateOverloads.removeIf(tf -> callBinding.getOperandCount() < tf.getArgTypes().size() - tf.getNumOptionalArguments() || callBinding.getOperandCount() > tf.getArgTypes().size());
        SqlNode[] operandArray = new SqlNode[callBinding.getCall().getOperandList().size()];
        for (Ord<SqlNode> ord : Ord.zip(callBinding.getCall().getOperandList())) {
            operandArray[ord.i] = (SqlNode)ord.e;
        }
        HashMap<HeavyDBSqlOperatorTable.ExtTableFunction, SqlCallBinding> hashMap = new HashMap<HeavyDBSqlOperatorTable.ExtTableFunction, SqlCallBinding>(candidateOverloads.size());
        for (HeavyDBSqlOperatorTable.ExtTableFunction tf2 : candidateOverloads) {
            SqlBasicCall newCall = new SqlBasicCall(tf2, operandArray, callBinding.getCall().getParserPosition());
            SqlCallBinding candidateBinding = new SqlCallBinding(callBinding.getValidator(), callBinding.getScope(), newCall);
            hashMap.put(tf2, candidateBinding);
        }
        candidateOverloads.removeIf(tf -> IntStream.range(0, ((SqlCallBinding)candidateBindings.get(tf)).permutedCall().getOperandList().size()).anyMatch(idx -> ((SqlNode)((SqlCallBinding)candidateBindings.get(tf)).permutedCall().operand(idx)).getKind() == SqlKind.DEFAULT && !tf.isArgumentOptional(idx)));
        HeavyDBTypeCoercion heavyDBTypeCoercion = (HeavyDBTypeCoercion)callBinding.getValidator().getTypeCoercion();
        HashMap scoredCandidates = new HashMap();
        candidateOverloads.stream().forEach(udtf -> scoredCandidates.put(udtf, tc.calculateTypeCoercionScore((SqlCallBinding)candidateBindings.get(udtf), (HeavyDBSqlOperatorTable.ExtTableFunction)udtf)));
        try {
            minCandidate = (HeavyDBSqlOperatorTable.ExtTableFunction)Collections.min(scoredCandidates.entrySet().stream().filter(entry -> (Integer)entry.getValue() >= 0).collect(Collectors.toSet()), Map.Entry.comparingByValue()).getKey();
        }
        catch (NoSuchElementException e) {
            if (throwOnFailure) {
                throw this.newExtTableFunctionSignatureError(callBinding);
            }
            return false;
        }
        if ((Integer)scoredCandidates.get(minCandidate) > 0) {
            heavyDBTypeCoercion.extTableFunctionTypeCoercion((SqlCallBinding)hashMap.get(minCandidate), minCandidate);
        }
        ((SqlBasicCall)callBinding.getCall()).setOperator(minCandidate);
        return true;
    }

    public List<HeavyDBSqlOperatorTable.ExtTableFunction> getOperatorOverloads(SqlOperator op) {
        ArrayList<SqlOperator> overloads = new ArrayList<SqlOperator>();
        this.opTable.lookupOperatorOverloads(op.getNameAsId(), SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION, SqlSyntax.FUNCTION, overloads, SqlNameMatchers.liberal());
        return overloads.stream().filter(p -> p instanceof HeavyDBSqlOperatorTable.ExtTableFunction).map(p -> (HeavyDBSqlOperatorTable.ExtTableFunction)p).collect(Collectors.toList());
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.any();
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        List<HeavyDBSqlOperatorTable.ExtTableFunction> overloads = this.getOperatorOverloads(op);
        return String.join((CharSequence)(System.lineSeparator() + "\t"), overloads.stream().map(tf -> tf.getExtendedSignature()).collect(Collectors.toList()));
    }

    @Override
    public SqlOperandTypeChecker.Consistency getConsistency() {
        return SqlOperandTypeChecker.Consistency.NONE;
    }

    public CalciteException newExtTableFunctionNameError(SqlCallBinding callBinding, SqlNode operand, String operandName) {
        return callBinding.getValidator().newValidationError(operand, UDTF_ERRORS.paramNameMismatch(callBinding.getOperator().getName(), operandName));
    }

    public CalciteException newExtTableFunctionSignatureError(SqlCallBinding callBinding) {
        return callBinding.getValidator().newValidationError(callBinding.permutedCall(), UDTF_ERRORS.typeMismatch(callBinding.getOperator().getName(), this.getCallSignature(callBinding, callBinding.getValidator(), callBinding.getScope()), System.getProperty("line.separator") + "\t" + callBinding.getOperator().getAllowedSignatures()));
    }

    public String getCallSignature(SqlCallBinding callBinding, SqlValidator validator, SqlValidatorScope scope) {
        ArrayList<String> signatureList = new ArrayList<String>();
        for (SqlNode operand : callBinding.permutedCall().getOperandList()) {
            RelDataType argType = validator.deriveType(scope, operand);
            if (null == argType) continue;
            if (argType.getSqlTypeName() == SqlTypeName.CURSOR) {
                SqlCall cursorCall = (SqlCall)operand;
                RelDataType cursorType = callBinding.getValidator().deriveType(callBinding.getScope(), (SqlNode)cursorCall.operand(0));
                StringBuilder cursorTypeName = new StringBuilder();
                cursorTypeName.append("CURSOR[");
                for (int j = 0; j < cursorType.getFieldList().size(); ++j) {
                    if (j > 0) {
                        cursorTypeName.append(",");
                    }
                    cursorTypeName.append((Object)cursorType.getFieldList().get(j).getType().getSqlTypeName());
                }
                cursorTypeName.append("]");
                signatureList.add(cursorTypeName.toString());
                continue;
            }
            signatureList.add(argType.toString());
        }
        return SqlUtil.getOperatorSignature(callBinding.getOperator(), signatureList);
    }

    public static interface ExtTableFunctionErrors {
        @Resources.BaseMessage(value="No candidate for User-defined Table Function ''{0}'' with input parameter named ''{1}''")
        public Resources.ExInst<SqlValidatorException> paramNameMismatch(String var1, String var2);

        @Resources.BaseMessage(value="Cannot apply User-defined Table Function ''{0}'' to arguments of type {1}. Supported form(s): {2}")
        public Resources.ExInst<SqlValidatorException> typeMismatch(String var1, String var2, String var3);
    }
}

