/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.calcite.parser;

import ai.heavy.thrift.server.TTableDetails;
import com.mapd.calcite.parser.HeavyDBParser;
import com.mapd.calcite.parser.HeavyDBParserOptions;
import com.mapd.calcite.parser.HeavyDBTable;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.SqlIdentifierCapturer;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeavyDBView
extends HeavyDBTable
implements TranslatableTable {
    static final Logger HEAVYDBLOGGER = LoggerFactory.getLogger(HeavyDBView.class);
    private final String viewSql;
    private SqlIdentifierCapturer accessObjects;
    private RelRoot viewRelRoot;

    public HeavyDBView(String view_sql, TTableDetails ri, HeavyDBParser mp) {
        super(ri);
        this.viewSql = view_sql;
        try {
            HeavyDBParserOptions parserOptions = new HeavyDBParserOptions();
            this.viewRelRoot = mp.queryToRelNode(this.viewSql, parserOptions);
            this.accessObjects = mp.captureIdentifiers(this.viewSql, parserOptions.isLegacySyntax());
        }
        catch (SqlParseException e) {
            HEAVYDBLOGGER.error("error parsing view SQL: " + view_sql, e);
        }
        catch (ValidationException ex) {
            HEAVYDBLOGGER.error("error validating view SQL: " + view_sql, ex);
        }
        catch (RelConversionException ex) {
            HEAVYDBLOGGER.error("error doing Rel Conversion view SQL: " + view_sql, ex);
        }
    }

    public String toString() {
        return "View SQL: " + this.viewSql + "\nAccessed Objects\n" + this.accessObjects;
    }

    public SqlIdentifierCapturer getAccessedObjects() {
        return this.accessObjects;
    }

    String getViewSql() {
        return this.viewSql;
    }

    @Override
    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.VIEW;
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        return this.viewRelRoot.rel;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory rdtf) {
        return this.viewRelRoot.validatedRowType;
    }
}

