/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.calcite.rel.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rel.metadata.RelColumnMapping;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;

public class FilterTableFunctionMultiInputTransposeRule
extends RelRule<Config>
implements TransformationRule {
    protected FilterTableFunctionMultiInputTransposeRule(Config config) {
        super(config);
    }

    @Deprecated
    public FilterTableFunctionMultiInputTransposeRule(RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Serializable validInputFields;
        Object inputFields;
        Boolean debugMode = false;
        LogicalFilter filter = (LogicalFilter)call.rel(0);
        LogicalTableFunctionScan funcRel = (LogicalTableFunctionScan)call.rel(1);
        Set<RelColumnMapping> columnMappings = funcRel.getColumnMappings();
        if (columnMappings == null || columnMappings.isEmpty()) {
            return;
        }
        List<RelNode> funcInputs = funcRel.getInputs();
        Integer numFuncInputs = funcInputs.size();
        if (numFuncInputs < 1) {
            this.debugPrint("RETURN: funcInputs.size()=" + funcInputs.size(), debugMode);
            return;
        }
        ArrayList columnMaps = new ArrayList(numFuncInputs);
        Object i = 0;
        while ((Integer)i < numFuncInputs) {
            columnMaps.add((Integer)i, new HashMap());
            Object object = i;
            i = (Integer)i + 1;
            Integer n = i;
        }
        for (RelColumnMapping mapping : columnMappings) {
            this.debugPrint("iInputRel.iInputColumn:  mapping.iOutputColumn=" + mapping.iInputRel + "." + mapping.iInputColumn + ": " + mapping.iOutputColumn, debugMode);
            if (mapping.derived) {
                return;
            }
            ((HashMap)columnMaps.get(mapping.iInputRel)).put(mapping.iOutputColumn, mapping.iInputColumn);
        }
        ArrayList<RelNode> newFuncInputs = new ArrayList<RelNode>();
        RelOptCluster cluster = funcRel.getCluster();
        RexNode condition = filter.getCondition();
        this.debugPrint("condition=" + condition, debugMode);
        List<RelDataTypeField> outputFields = funcRel.getRowType().getFieldList();
        Integer numOutputs = outputFields.size();
        List<RexNode> outputConjunctivePredicates = RelOptUtil.conjunctions(condition);
        Integer numConjunctivePredicates = outputConjunctivePredicates.size();
        int[] outputColPushdownCount = new int[numOutputs.intValue()];
        int[] successfulFilterPushDowns = new int[numConjunctivePredicates.intValue()];
        int[] failedFilterPushDowns = new int[numConjunctivePredicates.intValue()];
        Integer inputRelIdx = 0;
        Boolean didPushDown = false;
        for (RelNode funcInput : funcInputs) {
            Comparable<ImmutableBitSet> filterRefs;
            Object inputColIdx;
            inputFields = funcInput.getRowType().getFieldList();
            this.debugPrint("inputFields=" + inputFields, debugMode);
            validInputFields = new ArrayList();
            ArrayList<RelDataTypeField> validOutputFields = new ArrayList<RelDataTypeField>();
            int[] adjustments = new int[numOutputs.intValue()];
            ArrayList<RexNode> filtersToBePushedDown = new ArrayList<RexNode>();
            HashSet<Integer> uniquePushedDownOutputIdxs = new HashSet<Integer>();
            HashSet<Integer> seenOutputIdxs = new HashSet<Integer>();
            for (Map.Entry outputInputColMapping : ((HashMap)columnMaps.get(inputRelIdx)).entrySet()) {
                inputColIdx = (Integer)outputInputColMapping.getValue();
                Integer n = (Integer)outputInputColMapping.getKey();
                validInputFields.add(inputFields.get((Integer)inputColIdx));
                validOutputFields.add(outputFields.get(n));
                adjustments[n.intValue()] = (Integer)inputColIdx - n;
            }
            this.debugPrint("validInputFields: " + validInputFields, debugMode);
            this.debugPrint("validOutputFields: " + validOutputFields, debugMode);
            this.debugPrint("adjustments=" + Arrays.toString(adjustments), debugMode);
            Boolean anyFilterRefsPartiallyMapToInputs = false;
            ArrayList<Boolean> subFiltersDidMapToAnyInputs = new ArrayList<Boolean>();
            for (RexNode rexNode : outputConjunctivePredicates) {
                filterRefs = RelOptUtil.InputFinder.bits(rexNode);
                List<Integer> filterRefColIdxList = filterRefs.toList();
                Boolean anyFilterColsPresentInInput = false;
                Boolean allFilterColsPresentInInput = true;
                for (Integer filterRefColIdx : filterRefColIdxList) {
                    this.debugPrint("filterColIdx: " + filterRefColIdx, debugMode);
                    if (!((HashMap)columnMaps.get(inputRelIdx)).containsKey(filterRefColIdx)) {
                        allFilterColsPresentInInput = false;
                        continue;
                    }
                    anyFilterColsPresentInInput = true;
                    uniquePushedDownOutputIdxs.add(filterRefColIdx);
                    seenOutputIdxs.add(filterRefColIdx);
                }
                subFiltersDidMapToAnyInputs.add(anyFilterColsPresentInInput);
                if (!anyFilterColsPresentInInput.booleanValue()) continue;
                if (allFilterColsPresentInInput.booleanValue()) {
                    filtersToBePushedDown.add(rexNode);
                    continue;
                }
                anyFilterRefsPartiallyMapToInputs = true;
                break;
            }
            this.debugPrint("Input idx: " + inputRelIdx + " Any filter refs partially map to inputs: " + anyFilterRefsPartiallyMapToInputs, debugMode);
            this.debugPrint("# Filters to be pushed down: " + filtersToBePushedDown.size(), debugMode);
            inputColIdx = inputRelIdx;
            Integer n = inputRelIdx = Integer.valueOf(inputRelIdx + 1);
            if (anyFilterRefsPartiallyMapToInputs.booleanValue()) {
                Integer filterIdx = 0;
                while (filterIdx < numConjunctivePredicates) {
                    if (((Boolean)subFiltersDidMapToAnyInputs.get(filterIdx)).booleanValue()) {
                        int n2 = filterIdx;
                        failedFilterPushDowns[n2] = failedFilterPushDowns[n2] + 1;
                    }
                    Integer n3 = filterIdx;
                    filterIdx = filterIdx + 1;
                    filterRefs = filterIdx;
                }
                this.debugPrint("Failed to push down input: " + inputRelIdx, debugMode);
                newFuncInputs.add(funcInput);
                continue;
            }
            if (filtersToBePushedDown.isEmpty()) {
                this.debugPrint("No filters to push down: " + inputRelIdx, debugMode);
                newFuncInputs.add(funcInput);
                continue;
            }
            this.debugPrint("Func input at pushdown: " + funcInput, debugMode);
            if (funcInput instanceof HepRelVertex && ((HepRelVertex)funcInput).getCurrentRel() instanceof LogicalFilter) {
                this.debugPrint("Filter existed on input node", debugMode);
                HepRelVertex inputHepRelVertex = (HepRelVertex)funcInput;
                LogicalFilter logicalFilter = (LogicalFilter)inputHepRelVertex.getCurrentRel();
                RexNode inputCondition = logicalFilter.getCondition();
                List<RexNode> inputConjunctivePredicates = RelOptUtil.conjunctions(inputCondition);
                if (inputConjunctivePredicates.size() > 0) {
                    RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
                    RexNode pushdownCondition = RexUtil.composeConjunction(rexBuilder, filtersToBePushedDown, false);
                    RexNode newPushdownCondition = pushdownCondition.accept(new RelOptUtil.RexInputConverter(rexBuilder, validOutputFields, (List<RelDataTypeField>)((Object)validInputFields), adjustments));
                    List<RexNode> newPushdownConjunctivePredicates = RelOptUtil.conjunctions(newPushdownCondition);
                    Integer numOriginalPushdownConjunctivePredicates = newPushdownConjunctivePredicates.size();
                    this.debugPrint("Output predicates: " + newPushdownConjunctivePredicates, debugMode);
                    this.debugPrint("Input predicates: " + inputConjunctivePredicates, debugMode);
                    newPushdownConjunctivePredicates.removeAll(inputConjunctivePredicates);
                    if (newPushdownConjunctivePredicates.isEmpty()) {
                        this.debugPrint("All filters existed on input node", debugMode);
                        newFuncInputs.add(funcInput);
                        continue;
                    }
                    if (newPushdownConjunctivePredicates.size() < numOriginalPushdownConjunctivePredicates) {
                        this.debugPrint("Some predicates eliminated.", debugMode);
                    }
                }
                this.debugPrint("# Filters to be pushed down after prune: " + filtersToBePushedDown.size(), debugMode);
            } else {
                this.debugPrint("No filter detected on input node", debugMode);
            }
            RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
            RexNode rexNode = RexUtil.composeConjunction(rexBuilder, filtersToBePushedDown, false);
            try {
                this.debugPrint("Trying to push down filter", debugMode);
                RexNode newCondition = rexNode.accept(new RelOptUtil.RexInputConverter(rexBuilder, validOutputFields, (List<RelDataTypeField>)((Object)validInputFields), adjustments));
                didPushDown = true;
                newFuncInputs.add(LogicalFilter.create(funcInput, newCondition));
                for (Integer pushedDownOutputIdx : uniquePushedDownOutputIdxs) {
                    int n4 = pushedDownOutputIdx;
                    outputColPushdownCount[n4] = outputColPushdownCount[n4] + 1;
                }
                Integer filterIdx = 0;
                while (filterIdx < numConjunctivePredicates) {
                    if (((Boolean)subFiltersDidMapToAnyInputs.get(filterIdx)).booleanValue()) {
                        int n5 = filterIdx;
                        successfulFilterPushDowns[n5] = successfulFilterPushDowns[n5] + 1;
                    }
                    Integer n6 = filterIdx;
                    Integer n7 = filterIdx = Integer.valueOf(filterIdx + 1);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
                return;
            }
        }
        if (!didPushDown.booleanValue()) {
            this.debugPrint("Did not push down - returning", debugMode);
            return;
        }
        ArrayList<RexNode> remainingFilters = new ArrayList<RexNode>();
        Integer filterIdx = 0;
        while (filterIdx < numConjunctivePredicates) {
            if (successfulFilterPushDowns[filterIdx] == 0 || failedFilterPushDowns[filterIdx] > 0) {
                remainingFilters.add(outputConjunctivePredicates.get(filterIdx));
            }
            inputFields = filterIdx;
            filterIdx = filterIdx + 1;
            validInputFields = filterIdx;
        }
        this.debugPrint("Remaining filters: " + remainingFilters, debugMode);
        LogicalTableFunctionScan newTableFuncRel = LogicalTableFunctionScan.create(cluster, newFuncInputs, funcRel.getCall(), funcRel.getElementType(), funcRel.getRowType(), columnMappings);
        RelBuilder relBuilder = call.builder();
        relBuilder.push(newTableFuncRel);
        if (!remainingFilters.isEmpty()) {
            relBuilder.filter(remainingFilters);
        }
        RelNode outputNode = relBuilder.build();
        this.debugPrint(RelOptUtil.toString(outputNode), debugMode);
        call.transformTo(outputNode);
    }

    private void debugPrint(String msg, Boolean debugMode) {
        if (debugMode.booleanValue()) {
            System.out.println(msg);
        }
    }

    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = EMPTY.withOperandSupplier(b0 -> b0.operand(LogicalFilter.class).oneInput(b1 -> b1.operand(LogicalTableFunctionScan.class).anyInputs())).as(Config.class);

        @Override
        default public FilterTableFunctionMultiInputTransposeRule toRule() {
            return new FilterTableFunctionMultiInputTransposeRule(this);
        }
    }
}

