/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.common;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.thrift.TException;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SockTransportProperties {
    static final Logger HEAVYDBLOGGER = LoggerFactory.getLogger(SockTransportProperties.class);
    private TrustManager[] trustManagers;
    private TransportType transportType = null;
    private KeyManager[] keyManagers;
    private String key_store_name = null;
    private char[] key_store_password = null;
    X509HostnameVerifier x509HostnameVerifier_ = SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;

    public static SockTransportProperties getUnencryptedClient() throws Exception {
        boolean validate_server_name = false;
        return new SockTransportProperties(TransportType.unencryptedClient, validate_server_name);
    }

    public static SockTransportProperties getEncryptedClientDefaultTrustStore(boolean validate_server_name) throws Exception {
        return new SockTransportProperties(TransportType.encryptedClientDefaultTrustStore, validate_server_name);
    }

    public static SockTransportProperties getEncryptedClientSpecifiedTrustStore(String trustStoreName, String trustStorePassword) throws Exception {
        return SockTransportProperties.getEncryptedClientSpecifiedTrustStore(trustStoreName, trustStorePassword, true);
    }

    public static SockTransportProperties getEncryptedClientSpecifiedTrustStore(String trustStoreName, String trustStorePassword, boolean validate_server_name) throws Exception {
        return new SockTransportProperties(TransportType.encryptedClientSpecifiedTrustStore, trustStoreName, trustStorePassword, validate_server_name);
    }

    public static SockTransportProperties getEncryptedServer(String keyStoreName, String keyStorePassword) throws Exception {
        boolean validate_server_name = false;
        if (keyStoreName == null || keyStorePassword == null) {
            String errStr = new String("Invalid null parameter(s) used for getEncryptedServer. Both keyStoreName and keyStorePassword must be specified");
            RuntimeException rE = new RuntimeException(errStr);
            HEAVYDBLOGGER.error(errStr, rE);
            throw rE;
        }
        return new SockTransportProperties(TransportType.encryptedServer, keyStoreName, keyStorePassword, validate_server_name);
    }

    public static SockTransportProperties getUnecryptedServer() throws Exception {
        boolean validate_server_name = false;
        return new SockTransportProperties(TransportType.unencryptedServer, validate_server_name);
    }

    public SockTransportProperties(String truststore_name, String truststore_passwd) throws Exception {
        this(TransportType.encryptedClientSpecifiedTrustStore, truststore_name, truststore_passwd, true);
    }

    private SockTransportProperties(TransportType tT, String store_name, String passwd, boolean validate_server_name) throws Exception {
        this.x509HostnameVerifier_ = validate_server_name ? SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER : SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
        this.transportType = tT;
        char[] store_password = "".toCharArray();
        if (passwd != null && !passwd.isEmpty()) {
            store_password = passwd.toCharArray();
        }
        switch (this.transportType) {
            case encryptedServer: {
                this.key_store_password = store_password;
                this.key_store_name = store_name;
                break;
            }
            case encryptedClientSpecifiedTrustStore: {
                if (store_name == null) {
                    this.initializeAcceptedIssuers(null);
                    break;
                }
                KeyStore trust_store = KeyStore.getInstance(KeyStore.getDefaultType());
                try {
                    FileInputStream fis = new FileInputStream(store_name);
                    trust_store.load(fis, store_password);
                }
                catch (Exception eX) {
                    String err_str = new String("Error loading key/trust store [" + store_name + "]");
                    HEAVYDBLOGGER.error(err_str, eX);
                    throw eX;
                }
                this.initializeAcceptedIssuers(trust_store);
                break;
            }
            default: {
                String errStr = new String("Invalid transportType [" + (Object)((Object)this.transportType) + "] used in constructor");
                RuntimeException rE = new RuntimeException(errStr);
                HEAVYDBLOGGER.error(errStr, rE);
                throw rE;
            }
        }
    }

    private SockTransportProperties(TransportType transportType, boolean validate_server_name) throws Exception {
        this.x509HostnameVerifier_ = validate_server_name ? SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER : SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
        this.transportType = transportType;
        switch (transportType) {
            case encryptedClientDefaultTrustStore: {
                this.initializeAcceptedIssuers(null);
                break;
            }
            case unencryptedClient: 
            case unencryptedServer: {
                break;
            }
            default: {
                String errStr = new String("Invalid transportType [" + (Object)((Object)transportType) + "] used in constructor");
                RuntimeException rE = new RuntimeException(errStr);
                HEAVYDBLOGGER.error(errStr, rE);
                throw rE;
            }
        }
    }

    private void initializeAcceptedIssuers(KeyStore trust_store) throws Exception {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
        trustManagerFactory.init(trust_store);
        this.trustManagers = trustManagerFactory.getTrustManagers();
    }

    public TTransport openClientTransport(String server_host, int port) throws TException {
        TTransport tTransport = null;
        switch (this.transportType) {
            case encryptedClientSpecifiedTrustStore: 
            case encryptedClientDefaultTrustStore: {
                tTransport = this.openBinaryEncrypted(server_host, port);
                break;
            }
            case unencryptedClient: {
                tTransport = new TSocket(server_host, port);
                break;
            }
            default: {
                String errStr = new String("Invalid transportType [" + (Object)((Object)this.transportType) + "] used in openClientTransport");
                RuntimeException rE = new RuntimeException(errStr);
                HEAVYDBLOGGER.error(errStr, rE);
                throw rE;
            }
        }
        return tTransport;
    }

    private TTransport openBinaryEncrypted(String server_host, int port) throws TException {
        int socket_so_timeout_ms = 0;
        TSocket tsocket = null;
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, this.trustManagers, new SecureRandom());
            SSLSocket sx = (SSLSocket)sc.getSocketFactory().createSocket(server_host, port);
            sx.setSoTimeout(socket_so_timeout_ms);
            tsocket = new TSocket(sx);
        }
        catch (Exception ex) {
            String errStr = new String("Error openBinaryEncrypted [" + server_host + ":" + port + "] used in openClientTransport - ");
            errStr = errStr + ex.toString();
            RuntimeException rE = new RuntimeException(errStr);
            HEAVYDBLOGGER.error(errStr, rE);
            throw rE;
        }
        return tsocket;
    }

    public TTransport openHttpsClientTransport(String server_host, int port) throws Exception {
        if (this.transportType != TransportType.encryptedClientDefaultTrustStore && this.transportType != TransportType.encryptedClientSpecifiedTrustStore) {
            String errStr = new String("Invalid transportType [" + (Object)((Object)this.transportType) + "] used in openHttpsClientTransport");
            RuntimeException rE = new RuntimeException(errStr);
            HEAVYDBLOGGER.error(errStr, rE);
            throw rE;
        }
        THttpClient transport = null;
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, this.trustManagers, new SecureRandom());
            SSLConnectionSocketFactory sslConnectionSocketFactory = null;
            sslConnectionSocketFactory = new SSLConnectionSocketFactory(sc, this.x509HostnameVerifier_);
            CloseableHttpClient closeableHttpClient = HttpClients.custom().setSSLSocketFactory(sslConnectionSocketFactory).build();
            transport = new THttpClient("https://" + server_host + ":" + port, closeableHttpClient);
        }
        catch (Exception ex) {
            String err_str = new String("Exception:" + ex.getClass().getCanonicalName() + " thrown. Unable to create Secure socket for the HTTPS connection");
            HEAVYDBLOGGER.error(err_str, ex);
            throw ex;
        }
        return transport;
    }

    public TTransport openHttpClientTransport(String server_host, int port) throws TException {
        if (this.transportType != TransportType.unencryptedClient) {
            String errStr = new String("Invalid transportType [" + (Object)((Object)this.transportType) + "] used in openHttpClientTransport");
            RuntimeException rE = new RuntimeException(errStr);
            HEAVYDBLOGGER.error(errStr, rE);
            throw rE;
        }
        String url = "http://" + server_host + ":" + port;
        return new THttpClient(url);
    }

    public TServerTransport openServerTransport(int port) throws TException {
        if (this.transportType == TransportType.encryptedServer) {
            return this.openServerTransportEncrypted(port);
        }
        if (this.transportType == TransportType.unencryptedServer) {
            return new TServerSocket(port);
        }
        String errStr = new String("Invalid transportType [" + (Object)((Object)this.transportType) + "] used in openServerTransport");
        RuntimeException rE = new RuntimeException(errStr);
        HEAVYDBLOGGER.error(errStr, rE);
        throw rE;
    }

    private TServerTransport openServerTransportEncrypted(int port) throws TException {
        int socket_so_timeout_ms = 0;
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
        params.setKeyStore(this.key_store_name, this.key_store_password != null ? new String(this.key_store_password) : null);
        params.requireClientAuth(false);
        TServerSocket t = TSSLTransportFactory.getServerSocket(port, socket_so_timeout_ms, null, params);
        return t;
    }

    private static enum TransportType {
        encryptedServer,
        unencryptedServer,
        unencryptedClient,
        encryptedClientDefaultTrustStore,
        encryptedClientSpecifiedTrustStore;

    }
}

