/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.logrunner;

import ai.heavy.thrift.server.Heavy;
import ai.heavy.thrift.server.TColumn;
import ai.heavy.thrift.server.TColumnData;
import ai.heavy.thrift.server.TColumnType;
import ai.heavy.thrift.server.TDBException;
import ai.heavy.thrift.server.TDBInfo;
import ai.heavy.thrift.server.TDatum;
import ai.heavy.thrift.server.TExecuteMode;
import ai.heavy.thrift.server.TPixel;
import ai.heavy.thrift.server.TQueryResult;
import ai.heavy.thrift.server.TRenderResult;
import ai.heavy.thrift.server.TRow;
import ai.heavy.thrift.server.TRowSet;
import ai.heavy.thrift.server.TTableDetails;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogRunner {
    static final Logger logger = LoggerFactory.getLogger(LogRunner.class);
    private HashMap<Integer, String> sqlquery = new HashMap();
    private HashMap<Integer, String> originalSql = new HashMap();
    private HashMap<Integer, String> json = new HashMap();
    private boolean gpuMode = false;
    private boolean cpuMode = false;

    public static void main(String[] args) throws TException {
        logger.info("Hello, World");
        LogRunner x = new LogRunner();
        try {
            x.doWork(args);
        }
        catch (TTransportException ex) {
            logger.error(ex.toString());
            ex.printStackTrace();
        }
    }

    void doWork(String[] args) throws TTransportException, TException {
        logger.info("In doWork here");
        int numberThreads = 3;
        Heavy.Client client = this.getClient(args[0], Integer.valueOf(args[1]));
        String session = this.getSession(client);
        logger.info("got session");
        try {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(numberThreads, numberThreads, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(15), new ThreadPoolExecutor.CallerRunsPolicy());
            while (true) {
                String str;
                BufferedReader in = new BufferedReader(new FileReader(args[2]));
                boolean current = false;
                while ((str = in.readLine()) != null) {
                    myThread worker = new myThread(str, client, session);
                    worker.run();
                }
                in.close();
                logger.info("############loop complete");
            }
        }
        catch (IOException e) {
            logger.error("IOException " + e.getMessage());
            return;
        }
    }

    private Heavy.Client getClient(String hostname, int port) throws TTransportException {
        THttpClient transport = null;
        transport = new THttpClient("http://" + hostname + ":" + port);
        ((TTransport)transport).open();
        TJSONProtocol protocol = new TJSONProtocol(transport);
        return new Heavy.Client(protocol);
    }

    private String getSession(Heavy.Client client) throws TTransportException, TDBException, TException {
        String session = client.connect("mapd", "HyperInteractive", "mapd");
        logger.info("Connected session is " + session);
        return session;
    }

    private void closeSession(Heavy.Client client, String session) throws TDBException, TException {
        logger.info("Trying to disconnect session " + session);
        client.disconnect(session);
    }

    private void theRest(Heavy.Client client, String session) throws TException {
        List<TDBInfo> dbs = client.get_databases(session);
        for (TDBInfo tDBInfo : dbs) {
            logger.info("db is " + tDBInfo.toString());
        }
        List<String> tables = client.get_tables(session);
        for (String string : tables) {
            logger.info("Tables is " + string);
        }
        logger.info("Version " + client.get_version());
        TTableDetails tTableDetails = client.get_table_details(session, "flights");
        for (TColumnType col : tTableDetails.row_desc) {
            logger.info("col name :" + col.col_name);
            logger.info("\tcol encoding :" + col.col_type.encoding);
            logger.info("\tcol is_array :" + col.col_type.is_array);
            logger.info("\tcol nullable :" + col.col_type.nullable);
            logger.info("\tcol type :" + col.col_type.type);
        }
        logger.info(" -- before query -- ");
        TQueryResult tQueryResult = client.sql_execute(session, "Select uniquecarrier,flightnum  from flights LIMIT 3;", true, null, -1, -1);
        logger.info(" -- after query -- ");
        logger.info("TQueryResult execution time is " + tQueryResult.getExecution_time_ms());
        logger.info("TQueryResult is " + tQueryResult.toString());
        logger.info("TQueryResult getFieldValue is " + tQueryResult.getFieldValue(TQueryResult._Fields.ROW_SET));
        TRowSet row_set = tQueryResult.getRow_set();
        Object fieldValue = tQueryResult.getFieldValue(TQueryResult._Fields.ROW_SET);
        logger.info("fieldValue " + fieldValue);
        logger.info("TRowSet is " + row_set.toString());
        logger.info("Get rows size " + row_set.getRowsSize());
        logger.info("Get col size " + row_set.getRowsSize());
        List<TRow> rows = row_set.getRows();
        int count = 1;
        for (TRow row : rows) {
            List<TDatum> cols = row.getCols();
            if (cols == null) continue;
            for (TDatum dat : cols) {
                logger.info("ROW " + count + " " + dat.getFieldValue(TDatum._Fields.VAL));
            }
            ++count;
        }
        List<TColumn> columns = row_set.getColumns();
        logger.info("columns " + columns);
        count = 1;
        for (TColumn col : columns) {
            TColumnData data = col.getData();
            if (data != null) {
                logger.info("COL " + count + " " + data.toString());
            }
            ++count;
        }
    }

    public class myThread
    implements Runnable {
        private String str;
        private Heavy.Client client;
        private String session;

        myThread(String str1, Heavy.Client client1, String session1) {
            this.str = str1;
            this.client = client1;
            this.session = session1;
        }

        @Override
        public void run() {
            int logStart = this.str.indexOf(93);
            if (logStart != -1) {
                String det = this.str.substring(logStart + 1).trim();
                String header = this.str.substring(0, logStart).trim();
                String[] headDet = header.split(" .");
                if (headDet.length != 4 || headDet[0].equals("Log")) {
                    return;
                }
                Integer pid = Integer.valueOf(headDet[2]);
                if (det.contains("sql_execute :")) {
                    logger.info("det " + det);
                    String[] sl = det.split(":query_str:");
                    logger.info("run query " + sl[1]);
                    try {
                        this.client.sql_execute(this.session, sl[1], true, null, -1, -1);
                    }
                    catch (TDBException ex1) {
                        logger.error("Failed to execute " + sl[1] + " exception " + ex1.getError_msg());
                    }
                    catch (TException ex) {
                        logger.error("Failed to execute " + sl[1] + " exception " + ex.toString());
                    }
                    return;
                }
                if (det.contains("get_result_row_for_pixel :")) {
                    logger.info("det " + det);
                    String[] ss = det.split(":");
                    String[] sl = det.split(":table_col_names:");
                    logger.info("run get_result_for_pixel " + sl[1]);
                    HashMap<String, List<String>> tcn = new HashMap<String, List<String>>();
                    String[] tn = sl[1].split(":");
                    for (int i = 0; i < tn.length; ++i) {
                        String[] name = tn[i].split(",");
                        ArrayList<String> col = new ArrayList<String>();
                        for (int j = 1; j < name.length; ++j) {
                            col.add(name[j]);
                        }
                        tcn.put(name[0], col);
                    }
                    try {
                        this.client.get_result_row_for_pixel(this.session, Integer.parseInt(ss[3]), new TPixel(Integer.parseInt(ss[5]), Integer.parseInt(ss[7])), tcn, Boolean.TRUE, Integer.parseInt(ss[11]), null);
                    }
                    catch (TDBException ex1) {
                        logger.error("Failed to execute get_result_row_for_pixel exception " + ex1.getError_msg());
                    }
                    catch (TException ex) {
                        logger.error("Failed to execute get_result_row_for_pixel exception " + ex.toString());
                    }
                    return;
                }
                if (det.contains("render_vega :")) {
                    logger.info("det " + det);
                    String[] ss = det.split(":");
                    String[] sl = det.split(":vega_json:");
                    LogRunner.this.json.put(pid, det.substring(det.indexOf("render_vega :") + 13, det.length()));
                    logger.info("JSON = " + sl[1]);
                    logger.info("widget = " + Integer.parseInt(ss[3]));
                    logger.info("compressionLevel = " + Integer.parseInt(ss[5]));
                    logger.info("run render_vega");
                    if (LogRunner.this.cpuMode) {
                        logger.info("In render: setting gpu mode as we were in CPU mode");
                        LogRunner.this.gpuMode = true;
                        LogRunner.this.cpuMode = false;
                        try {
                            this.client.set_execution_mode(this.session, TExecuteMode.GPU);
                        }
                        catch (TException ex) {
                            logger.error("Failed to set_execution_mode exception " + ex.toString());
                        }
                    }
                    try {
                        TRenderResult ex = this.client.render_vega(this.session, Integer.parseInt(ss[3]), sl[1], Integer.parseInt(ss[5]), null);
                    }
                    catch (TException ex) {
                        logger.error("Failed to execute render_vega exception " + ex.toString());
                    }
                    return;
                }
                if (det.contains("User mapd sets CPU mode")) {
                    logger.info("Set cpu mode");
                    LogRunner.this.cpuMode = true;
                    LogRunner.this.gpuMode = false;
                    try {
                        this.client.set_execution_mode(this.session, TExecuteMode.CPU);
                    }
                    catch (TException ex) {
                        logger.error("Failed to set_execution_mode exception " + ex.toString());
                    }
                    return;
                }
                if (det.contains("User mapd sets GPU mode")) {
                    logger.info("Set gpu mode");
                    LogRunner.this.gpuMode = true;
                    LogRunner.this.cpuMode = false;
                    try {
                        this.client.set_execution_mode(this.session, TExecuteMode.GPU);
                    }
                    catch (TException ex) {
                        logger.error("Failed to execute set_execution_mode exception " + ex.toString());
                    }
                    return;
                }
            }
        }
    }
}

