/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.metadata;

import ai.heavy.thrift.server.Heavy;
import ai.heavy.thrift.server.TColumnType;
import ai.heavy.thrift.server.TDBException;
import ai.heavy.thrift.server.TDBInfo;
import ai.heavy.thrift.server.TDatumType;
import ai.heavy.thrift.server.TEncodingType;
import ai.heavy.thrift.server.TTableDetails;
import ai.heavy.thrift.server.TTypeInfo;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mapd.calcite.parser.HeavyDBParser;
import com.mapd.calcite.parser.HeavyDBTable;
import com.mapd.calcite.parser.HeavyDBUser;
import com.mapd.calcite.parser.HeavyDBView;
import com.mapd.common.SockTransportProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.calcite.schema.Table;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaConnect {
    static final Logger HEAVYDBLOGGER = LoggerFactory.getLogger(MetaConnect.class);
    private final String dataDir;
    private final String default_db;
    private final HeavyDBUser currentUser;
    private final int dbPort;
    private Connection catConn;
    private final HeavyDBParser parser;
    private static final int KBOOLEAN = 1;
    private static final int KCHAR = 2;
    private static final int KVARCHAR = 3;
    private static final int KNUMERIC = 4;
    private static final int KDECIMAL = 5;
    private static final int KINT = 6;
    private static final int KSMALLINT = 7;
    private static final int KFLOAT = 8;
    private static final int KDOUBLE = 9;
    private static final int KTIME = 10;
    private static final int KTIMESTAMP = 11;
    private static final int KBIGINT = 12;
    private static final int KTEXT = 13;
    private static final int KDATE = 14;
    private static final int KARRAY = 15;
    private static final int KINTERVAL_DAY_TIME = 16;
    private static final int KINTERVAL_YEAR_MONTH = 17;
    private static final int KPOINT = 18;
    private static final int KLINESTRING = 19;
    private static final int KPOLYGON = 20;
    private static final int KMULTIPOLYGON = 21;
    private static final int KTINYINT = 22;
    private static final int KMULTILINESTRING = 30;
    private static final int KMULTIPOINT = 31;
    private static final String CATALOG_DIR_NAME = "catalogs";
    private static volatile Map<String, Set<String>> DATABASE_TO_TABLES = new ConcurrentHashMap<String, Set<String>>();
    private static volatile Map<List<String>, Table> DB_TABLE_DETAILS = new ConcurrentHashMap<List<String>, Table>();
    private final SockTransportProperties sock_transport_properties;

    public MetaConnect(int dbPort, String dataDir, HeavyDBUser currentHeavyDBUser, HeavyDBParser parser, SockTransportProperties skT, String db) {
        this.dataDir = dataDir;
        this.default_db = db != null ? db : (currentHeavyDBUser != null ? currentHeavyDBUser.getDB() : null);
        this.currentUser = currentHeavyDBUser;
        this.dbPort = dbPort;
        this.parser = parser;
        this.sock_transport_properties = skT;
        if (this.currentUser != null && DATABASE_TO_TABLES.size() == 0) {
            this.populateDatabases();
        }
    }

    public MetaConnect(int dbPort, String dataDir, HeavyDBUser currentHeavyDBUser, HeavyDBParser parser, SockTransportProperties skT) {
        this(dbPort, dataDir, currentHeavyDBUser, parser, skT, null);
    }

    public List<String> getDatabases() {
        ArrayList<String> dbList = new ArrayList<String>(DATABASE_TO_TABLES.size());
        for (String db : DATABASE_TO_TABLES.keySet()) {
            dbList.add(db);
        }
        return dbList;
    }

    private void connectToCatalog(String catalog) {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException ex) {
            String err = "Could not find class for metadata connection; DB: '" + catalog + "' data dir '" + this.dataDir + "', error was " + ex.getMessage();
            HEAVYDBLOGGER.error(err);
            throw new RuntimeException(err);
        }
        String connectURL = "jdbc:sqlite:" + this.dataDir + "/" + CATALOG_DIR_NAME + "/" + this.getCatalogFileName(catalog);
        try {
            this.catConn = DriverManager.getConnection(connectURL);
        }
        catch (SQLException ex) {
            String err = "Could not establish a connection for metadata; DB: '" + catalog + "' data dir '" + this.dataDir + "', error was " + ex.getMessage();
            HEAVYDBLOGGER.error(err);
            throw new RuntimeException(err);
        }
        HEAVYDBLOGGER.debug("Opened database successfully");
    }

    String getCatalogFileName(String catalog) {
        String path = this.dataDir + "/" + CATALOG_DIR_NAME;
        File directory = new File(path);
        if (!directory.isDirectory()) {
            throw new RuntimeException("Catalog directory not found at: " + path);
        }
        for (File file : directory.listFiles()) {
            if (!file.getName().equalsIgnoreCase(catalog)) continue;
            return file.getName();
        }
        throw new RuntimeException("Database file not found for: " + catalog);
    }

    private void disconnectFromCatalog() {
        try {
            this.catConn.close();
        }
        catch (SQLException ex) {
            String err = "Could not disconnect from metadata  data dir '" + this.dataDir + "', error was " + ex.getMessage();
            HEAVYDBLOGGER.error(err);
            throw new RuntimeException(err);
        }
    }

    private void connectToDBCatalog() {
        this.connectToCatalog(this.default_db);
    }

    public Table getTable(String tableName) {
        ImmutableList<String> dbTable = ImmutableList.of(this.default_db.toUpperCase(), tableName.toUpperCase());
        Table cTable = DB_TABLE_DETAILS.get(dbTable);
        if (cTable != null) {
            HEAVYDBLOGGER.debug("Metaconnect DB " + this.default_db + " get table " + tableName + " details " + cTable);
            return cTable;
        }
        TTableDetails td = this.get_table_details(tableName);
        if (td.getView_sql() == null || td.getView_sql().isEmpty()) {
            HEAVYDBLOGGER.debug("Processing a table");
            HeavyDBTable rTable = new HeavyDBTable(td);
            DB_TABLE_DETAILS.putIfAbsent(dbTable, rTable);
            HEAVYDBLOGGER.debug("Metaconnect DB " + this.default_db + " get table " + tableName + " details " + rTable + " Not in buffer");
            return rTable;
        }
        HEAVYDBLOGGER.debug("Processing a view");
        HeavyDBView rTable = new HeavyDBView(this.getViewSql(tableName), td, this.parser);
        DB_TABLE_DETAILS.putIfAbsent(dbTable, rTable);
        HEAVYDBLOGGER.debug("Metaconnect DB " + this.default_db + " get view " + tableName + " details " + rTable + " Not in buffer");
        return rTable;
    }

    public Set<String> getTables() {
        Set<String> mSet = DATABASE_TO_TABLES.get(this.default_db.toUpperCase());
        if (mSet != null && mSet.size() > 0) {
            HEAVYDBLOGGER.debug("Metaconnect DB getTables " + this.default_db + " tables " + mSet);
            return mSet;
        }
        if (this.dbPort == -1) {
            this.connectToDBCatalog();
            Set<String> ts = this.getTables_SQL();
            this.disconnectFromCatalog();
            DATABASE_TO_TABLES.put(this.default_db.toUpperCase(), ts);
            HEAVYDBLOGGER.debug("Metaconnect DB getTables " + this.default_db + " tables " + ts + " from catDB");
            return ts;
        }
        try {
            TBinaryProtocol protocol = null;
            TTransport transport = this.sock_transport_properties.openClientTransport("localhost", this.dbPort);
            if (!transport.isOpen()) {
                transport.open();
            }
            protocol = new TBinaryProtocol(transport);
            Heavy.Client client = new Heavy.Client(protocol);
            List<String> tablesList = client.get_tables_for_database(this.currentUser.getSession(), this.default_db);
            HashSet<String> ts = new HashSet<String>(tablesList.size());
            for (String tableName : tablesList) {
                ts.add(tableName);
            }
            transport.close();
            DATABASE_TO_TABLES.put(this.default_db.toUpperCase(), ts);
            HEAVYDBLOGGER.debug("Metaconnect DB getTables " + this.default_db + " tables " + ts + " from server");
            return ts;
        }
        catch (TTransportException ex) {
            HEAVYDBLOGGER.error("TTransportException on port [" + this.dbPort + "]");
            HEAVYDBLOGGER.error(ex.toString());
            throw new RuntimeException(ex.toString());
        }
        catch (TDBException ex) {
            HEAVYDBLOGGER.error(ex.getError_msg());
            throw new RuntimeException(ex.getError_msg());
        }
        catch (TException ex) {
            HEAVYDBLOGGER.error(ex.toString());
            throw new RuntimeException(ex.toString());
        }
    }

    private Set<String> getTables_SQL() {
        this.connectToDBCatalog();
        HashSet<String> tableSet = new HashSet<String>();
        Statement stmt = null;
        ResultSet rs = null;
        String sqlText = "";
        try {
            stmt = this.catConn.createStatement();
            rs = stmt.executeQuery("SELECT name FROM mapd_tables ");
            while (rs.next()) {
                tableSet.add(rs.getString("name"));
                HEAVYDBLOGGER.debug("Object name = " + rs.getString("name"));
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            String err = "error trying to get all the tables, error was " + e.getMessage();
            HEAVYDBLOGGER.error(err);
            throw new RuntimeException(err);
        }
        this.disconnectFromCatalog();
        try {
            String tempTablesJsonStr;
            String filePath = this.dataDir + "/" + CATALOG_DIR_NAME + "/" + this.default_db + "_temp_tables.json";
            HEAVYDBLOGGER.debug("Opening temp table file at " + filePath);
            try {
                File tempTablesFile = new File(filePath);
                FileInputStream tempTablesStream = new FileInputStream(tempTablesFile);
                byte[] data = new byte[(int)tempTablesFile.length()];
                tempTablesStream.read(data);
                tempTablesStream.close();
                tempTablesJsonStr = new String(data, "UTF-8");
            }
            catch (FileNotFoundException e) {
                return tableSet;
            }
            Gson gson = new Gson();
            JsonObject fileParentObject = gson.fromJson(tempTablesJsonStr, JsonObject.class);
            for (Map.Entry<String, JsonElement> member : fileParentObject.entrySet()) {
                String tableName = member.getKey();
                tableSet.add(tableName);
                HEAVYDBLOGGER.debug("Temp table object name = " + tableName);
            }
        }
        catch (Exception e) {
            String err = "error trying to load temporary tables from json file, error was " + e.getMessage();
            HEAVYDBLOGGER.error(err);
            throw new RuntimeException(err);
        }
        return tableSet;
    }

    public TTableDetails get_table_details(String tableName) {
        if (this.dbPort == -1) {
            this.connectToDBCatalog();
            TTableDetails td = this.get_table_detail_SQL(tableName);
            this.disconnectFromCatalog();
            return td;
        }
        try {
            TBinaryProtocol protocol = null;
            TTransport transport = this.sock_transport_properties.openClientTransport("localhost", this.dbPort);
            if (!transport.isOpen()) {
                transport.open();
            }
            protocol = new TBinaryProtocol(transport);
            Heavy.Client client = new Heavy.Client(protocol);
            TTableDetails td = client.get_internal_table_details_for_database(this.currentUser.getSession(), tableName, this.default_db);
            transport.close();
            return td;
        }
        catch (TTransportException ex) {
            HEAVYDBLOGGER.error(ex.toString());
            throw new RuntimeException(ex.toString());
        }
        catch (TDBException ex) {
            HEAVYDBLOGGER.error(ex.getError_msg());
            throw new RuntimeException(ex.getError_msg());
        }
        catch (TException ex) {
            HEAVYDBLOGGER.error(ex.toString());
            throw new RuntimeException(ex.toString());
        }
    }

    public static final int get_physical_cols(int type) {
        switch (type) {
            case 18: {
                return 1;
            }
            case 19: 
            case 31: {
                return 2;
            }
            case 30: {
                return 3;
            }
            case 20: {
                return 3;
            }
            case 21: {
                return 4;
            }
        }
        return 0;
    }

    public static final boolean is_geometry(int type) {
        return type == 18 || type == 19 || type == 30 || type == 20 || type == 21 || type == 31;
    }

    private TTableDetails get_table_detail_SQL(String tableName) {
        TTableDetails td = new TTableDetails();
        td.getRow_descIterator();
        int id = this.getTableId(tableName);
        if (id == -1) {
            try {
                TTableDetails tempTableTd = this.get_table_detail_JSON(tableName);
                tempTableTd.is_temporary = true;
                return tempTableTd;
            }
            catch (Exception e) {
                String err = "Table '" + tableName + "' does not exist for DB '" + this.default_db + "'";
                HEAVYDBLOGGER.error(err);
                throw new RuntimeException(err);
            }
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.catConn.createStatement();
            HEAVYDBLOGGER.debug("table id is " + id);
            HEAVYDBLOGGER.debug("table name is " + tableName);
            String query = String.format("SELECT * FROM mapd_columns where tableid = %d and not is_deletedcol order by columnid;", id);
            HEAVYDBLOGGER.debug(query);
            rs = stmt.executeQuery(query);
            int skip_physical_cols = 0;
            while (rs.next()) {
                TDatumType tdt;
                String colName = rs.getString("name");
                HEAVYDBLOGGER.debug("name = " + colName);
                int colType = rs.getInt("coltype");
                HEAVYDBLOGGER.debug("coltype = " + colType);
                int colSubType = rs.getInt("colsubtype");
                HEAVYDBLOGGER.debug("colsubtype = " + colSubType);
                int compression = rs.getInt("compression");
                HEAVYDBLOGGER.debug("compression = " + compression);
                int compression_param = rs.getInt("comp_param");
                HEAVYDBLOGGER.debug("comp_param = " + compression_param);
                int size = rs.getInt("size");
                HEAVYDBLOGGER.debug("size = " + size);
                int colDim = rs.getInt("coldim");
                HEAVYDBLOGGER.debug("coldim = " + colDim);
                int colScale = rs.getInt("colscale");
                HEAVYDBLOGGER.debug("colscale = " + colScale);
                boolean isNotNull = rs.getBoolean("is_notnull");
                HEAVYDBLOGGER.debug("is_notnull = " + isNotNull);
                boolean isSystemCol = rs.getBoolean("is_systemcol");
                HEAVYDBLOGGER.debug("is_systemcol = " + isSystemCol);
                boolean isVirtualCol = rs.getBoolean("is_virtualcol");
                HEAVYDBLOGGER.debug("is_vitrualcol = " + isVirtualCol);
                HEAVYDBLOGGER.debug("");
                TColumnType tct = new TColumnType();
                TTypeInfo tti = new TTypeInfo();
                if (colType == 15) {
                    tti.is_array = true;
                    tdt = this.typeToThrift(colSubType);
                } else {
                    tti.is_array = false;
                    tdt = this.typeToThrift(colType);
                }
                tti.nullable = !isNotNull;
                tti.encoding = this.encodingToThrift(compression);
                tti.comp_param = compression_param;
                tti.size = size;
                tti.type = tdt;
                tti.scale = colScale;
                tti.precision = colDim;
                tct.col_name = colName;
                tct.col_type = tti;
                tct.is_system = isSystemCol;
                if (skip_physical_cols <= 0) {
                    skip_physical_cols = MetaConnect.get_physical_cols(colType);
                }
                if (!MetaConnect.is_geometry(colType) && skip_physical_cols-- > 0) continue;
                td.addToRow_desc(tct);
            }
        }
        catch (Exception e) {
            String err = "error trying to read from mapd_columns, error was " + e.getMessage();
            HEAVYDBLOGGER.error(err);
            throw new RuntimeException(err);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    String err = "Could not close resultset, error was " + ex.getMessage();
                    HEAVYDBLOGGER.error(err);
                    throw new RuntimeException(err);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    String err = "Could not close stmt, error was " + ex.getMessage();
                    HEAVYDBLOGGER.error(err);
                    throw new RuntimeException(err);
                }
            }
        }
        if (this.isView(tableName)) {
            td.setView_sqlIsSet(true);
            td.setView_sql(this.getViewSqlViaSql(id));
        }
        return td;
    }

    private TTableDetails get_table_detail_JSON(String tableName) throws IOException, RuntimeException {
        String tempTablesJsonStr;
        TTableDetails td = new TTableDetails();
        td.getRow_descIterator();
        String filePath = this.dataDir + "/" + CATALOG_DIR_NAME + "/" + this.default_db + "_temp_tables.json";
        HEAVYDBLOGGER.debug("Opening temp table file at " + filePath);
        try {
            File tempTablesFile = new File(filePath);
            FileInputStream tempTablesStream = new FileInputStream(tempTablesFile);
            byte[] data = new byte[(int)tempTablesFile.length()];
            tempTablesStream.read(data);
            tempTablesStream.close();
            tempTablesJsonStr = new String(data, "UTF-8");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Failed to read temporary tables file.");
        }
        Gson gson = new Gson();
        JsonObject fileParentObject = gson.fromJson(tempTablesJsonStr, JsonObject.class);
        if (fileParentObject == null) {
            throw new IOException("Malformed temporary tables file.");
        }
        JsonObject tableObject = fileParentObject.getAsJsonObject(tableName);
        if (tableObject == null) {
            throw new RuntimeException("Failed to find table " + tableName + " in temporary tables file.");
        }
        String jsonTableName = tableObject.get("name").getAsString();
        assert (tableName == jsonTableName);
        int id = tableObject.get("id").getAsInt();
        HEAVYDBLOGGER.debug("table id is " + id);
        HEAVYDBLOGGER.debug("table name is " + tableName);
        JsonArray jsonColumns = tableObject.getAsJsonArray("columns");
        assert (jsonColumns != null);
        int skip_physical_cols = 0;
        for (JsonElement columnElement : jsonColumns) {
            TDatumType tdt;
            JsonObject columnObject = columnElement.getAsJsonObject();
            String colName = columnObject.get("name").getAsString();
            HEAVYDBLOGGER.debug("name = " + colName);
            int colType = columnObject.get("coltype").getAsInt();
            HEAVYDBLOGGER.debug("coltype = " + colType);
            int colSubType = columnObject.get("colsubtype").getAsInt();
            HEAVYDBLOGGER.debug("colsubtype = " + colSubType);
            int compression = columnObject.get("compression").getAsInt();
            HEAVYDBLOGGER.debug("compression = " + compression);
            int compression_param = columnObject.get("comp_param").getAsInt();
            HEAVYDBLOGGER.debug("comp_param = " + compression_param);
            int size = columnObject.get("size").getAsInt();
            HEAVYDBLOGGER.debug("size = " + size);
            int colDim = columnObject.get("coldim").getAsInt();
            HEAVYDBLOGGER.debug("coldim = " + colDim);
            int colScale = columnObject.get("colscale").getAsInt();
            HEAVYDBLOGGER.debug("colscale = " + colScale);
            boolean isNotNull = columnObject.get("is_notnull").getAsBoolean();
            HEAVYDBLOGGER.debug("is_notnull = " + isNotNull);
            boolean isSystemCol = columnObject.get("is_systemcol").getAsBoolean();
            HEAVYDBLOGGER.debug("is_systemcol = " + isSystemCol);
            boolean isVirtualCol = columnObject.get("is_virtualcol").getAsBoolean();
            HEAVYDBLOGGER.debug("is_vitrualcol = " + isVirtualCol);
            boolean isDeletedCol = columnObject.get("is_deletedcol").getAsBoolean();
            HEAVYDBLOGGER.debug("is_deletedcol = " + isDeletedCol);
            HEAVYDBLOGGER.debug("");
            if (isDeletedCol) {
                HEAVYDBLOGGER.debug("Skipping delete column.");
                continue;
            }
            TColumnType tct = new TColumnType();
            TTypeInfo tti = new TTypeInfo();
            if (colType == 15) {
                tti.is_array = true;
                tdt = this.typeToThrift(colSubType);
            } else {
                tti.is_array = false;
                tdt = this.typeToThrift(colType);
            }
            tti.nullable = !isNotNull;
            tti.encoding = this.encodingToThrift(compression);
            tti.comp_param = compression_param;
            tti.size = size;
            tti.type = tdt;
            tti.scale = colScale;
            tti.precision = colDim;
            tct.col_name = colName;
            tct.col_type = tti;
            tct.is_system = isSystemCol;
            if (skip_physical_cols <= 0) {
                skip_physical_cols = MetaConnect.get_physical_cols(colType);
            }
            if (!MetaConnect.is_geometry(colType) && skip_physical_cols-- > 0) continue;
            td.addToRow_desc(tct);
        }
        return td;
    }

    private int getTableId(String tableName) {
        Statement stmt = null;
        ResultSet rs = null;
        int tableId = -1;
        try {
            stmt = this.catConn.createStatement();
            rs = stmt.executeQuery(String.format("SELECT tableid FROM mapd_tables where name = '%s' COLLATE NOCASE;", tableName));
            while (rs.next()) {
                tableId = rs.getInt("tableid");
                HEAVYDBLOGGER.debug("tableId = " + tableId);
                HEAVYDBLOGGER.debug("");
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            String err = "Error trying to read from metadata table mapd_tables;DB: " + this.default_db + " data dir " + this.dataDir + ", error was " + e.getMessage();
            HEAVYDBLOGGER.error(err);
            throw new RuntimeException(err);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    String err = "Could not close resultset, error was " + ex.getMessage();
                    HEAVYDBLOGGER.error(err);
                    throw new RuntimeException(err);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    String err = "Could not close stmt, error was " + ex.getMessage();
                    HEAVYDBLOGGER.error(err);
                    throw new RuntimeException(err);
                }
            }
        }
        return tableId;
    }

    private boolean isView(String tableName) {
        int viewFlag = 0;
        try {
            Statement stmt = this.catConn.createStatement();
            ResultSet rs = stmt.executeQuery(String.format("SELECT isview FROM mapd_tables where name = '%s' COLLATE NOCASE;", tableName));
            while (rs.next()) {
                viewFlag = rs.getInt("isview");
                HEAVYDBLOGGER.debug("viewFlag = " + viewFlag);
                HEAVYDBLOGGER.debug("");
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            String err = "error trying to read from mapd_views, error was " + e.getMessage();
            HEAVYDBLOGGER.error(err);
            throw new RuntimeException(err);
        }
        return viewFlag == 1;
    }

    private String getViewSql(String tableName) {
        String sqlText;
        if (this.dbPort == -1) {
            this.connectToDBCatalog();
            sqlText = this.getViewSqlViaSql(this.getTableId(tableName));
            this.disconnectFromCatalog();
        } else {
            try {
                TBinaryProtocol protocol = null;
                TTransport transport = this.sock_transport_properties.openClientTransport("localhost", this.dbPort);
                if (!transport.isOpen()) {
                    transport.open();
                }
                protocol = new TBinaryProtocol(transport);
                Heavy.Client client = new Heavy.Client(protocol);
                TTableDetails td = client.get_table_details_for_database(this.currentUser.getSession(), tableName, this.default_db);
                transport.close();
                sqlText = td.getView_sql();
            }
            catch (TTransportException ex) {
                HEAVYDBLOGGER.error(ex.toString());
                throw new RuntimeException(ex.toString());
            }
            catch (TDBException ex) {
                HEAVYDBLOGGER.error(ex.getError_msg());
                throw new RuntimeException(ex.getError_msg());
            }
            catch (TException ex) {
                HEAVYDBLOGGER.error(ex.toString());
                throw new RuntimeException(ex.toString());
            }
        }
        if (sqlText.charAt(sqlText.length() - 1) == ';') {
            return sqlText.substring(0, sqlText.length() - 1);
        }
        return sqlText;
    }

    private String getViewSqlViaSql(int tableId) {
        String sqlText = "";
        try {
            Statement stmt = this.catConn.createStatement();
            ResultSet rs = stmt.executeQuery(String.format("SELECT sql FROM mapd_views where tableid = '%s' COLLATE NOCASE;", tableId));
            while (rs.next()) {
                sqlText = rs.getString("sql");
                HEAVYDBLOGGER.debug("View definition = " + sqlText);
                HEAVYDBLOGGER.debug("");
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            String err = "error trying to read from mapd_views, error was " + e.getMessage();
            HEAVYDBLOGGER.error(err);
            throw new RuntimeException(err);
        }
        if (sqlText == null || sqlText.length() == 0) {
            String err = "No view text found";
            HEAVYDBLOGGER.error(err);
            throw new RuntimeException(err);
        }
        return sqlText;
    }

    private TDatumType typeToThrift(int type) {
        switch (type) {
            case 1: {
                return TDatumType.BOOL;
            }
            case 22: {
                return TDatumType.TINYINT;
            }
            case 7: {
                return TDatumType.SMALLINT;
            }
            case 6: {
                return TDatumType.INT;
            }
            case 12: {
                return TDatumType.BIGINT;
            }
            case 8: {
                return TDatumType.FLOAT;
            }
            case 4: 
            case 5: {
                return TDatumType.DECIMAL;
            }
            case 9: {
                return TDatumType.DOUBLE;
            }
            case 2: 
            case 3: 
            case 13: {
                return TDatumType.STR;
            }
            case 10: {
                return TDatumType.TIME;
            }
            case 11: {
                return TDatumType.TIMESTAMP;
            }
            case 14: {
                return TDatumType.DATE;
            }
            case 16: {
                return TDatumType.INTERVAL_DAY_TIME;
            }
            case 17: {
                return TDatumType.INTERVAL_YEAR_MONTH;
            }
            case 18: {
                return TDatumType.POINT;
            }
            case 31: {
                return TDatumType.MULTIPOINT;
            }
            case 19: {
                return TDatumType.LINESTRING;
            }
            case 30: {
                return TDatumType.MULTILINESTRING;
            }
            case 20: {
                return TDatumType.POLYGON;
            }
            case 21: {
                return TDatumType.MULTIPOLYGON;
            }
        }
        return null;
    }

    private TEncodingType encodingToThrift(int comp) {
        switch (comp) {
            case 0: {
                return TEncodingType.NONE;
            }
            case 1: {
                return TEncodingType.FIXED;
            }
            case 2: {
                return TEncodingType.RL;
            }
            case 3: {
                return TEncodingType.DIFF;
            }
            case 4: {
                return TEncodingType.DICT;
            }
            case 5: {
                return TEncodingType.SPARSE;
            }
            case 6: {
                return TEncodingType.GEOINT;
            }
            case 7: {
                return TEncodingType.DATE_IN_DAYS;
            }
        }
        return null;
    }

    private void populateDatabases() {
        if (this.dbPort == 0) {
            return;
        }
        if (this.dbPort == -1) {
            this.connectToCatalog("system_catalog");
            Set<String> dbNames = this.getDatabases_SQL();
            this.disconnectFromCatalog();
            for (String dbName : dbNames) {
                HashSet ts = new HashSet();
                DATABASE_TO_TABLES.putIfAbsent(dbName.toUpperCase(), ts);
            }
            return;
        }
        try {
            TBinaryProtocol protocol = null;
            TTransport transport = this.sock_transport_properties.openClientTransport("localhost", this.dbPort);
            if (!transport.isOpen()) {
                transport.open();
            }
            protocol = new TBinaryProtocol(transport);
            Heavy.Client client = new Heavy.Client(protocol);
            List<TDBInfo> dbList = client.get_databases(this.currentUser.getSession());
            for (TDBInfo dbInfo : dbList) {
                HashSet ts = new HashSet();
                DATABASE_TO_TABLES.putIfAbsent(dbInfo.db_name.toUpperCase(), ts);
            }
            transport.close();
        }
        catch (TTransportException ex) {
            HEAVYDBLOGGER.error("TTransportException on port [" + this.dbPort + "]");
            HEAVYDBLOGGER.error(ex.toString());
            throw new RuntimeException(ex.toString());
        }
        catch (TDBException ex) {
            HEAVYDBLOGGER.error(ex.getError_msg());
            throw new RuntimeException(ex.getError_msg());
        }
        catch (TException ex) {
            HEAVYDBLOGGER.error(ex.toString());
            throw new RuntimeException(ex.toString());
        }
    }

    private Set<String> getDatabases_SQL() {
        HashSet<String> dbSet = new HashSet<String>();
        Statement stmt = null;
        ResultSet rs = null;
        String sqlText = "";
        try {
            stmt = this.catConn.createStatement();
            rs = stmt.executeQuery("SELECT name FROM mapd_databases ");
            while (rs.next()) {
                dbSet.add(rs.getString("name"));
                HEAVYDBLOGGER.debug("Object name = " + rs.getString("name"));
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            String err = "error trying to get all the databases, error was " + e.getMessage();
            HEAVYDBLOGGER.error(err);
            throw new RuntimeException(err);
        }
        return dbSet;
    }

    public void updateMetaData(String schema, String table) {
        HashSet<List<String>> all;
        if (table.equals("")) {
            all = new HashSet<List<String>>(DB_TABLE_DETAILS.keySet());
            for (List list : all) {
                if (!((String)list.get(0)).equals(schema.toUpperCase())) continue;
                HEAVYDBLOGGER.debug("removing all for schema " + (String)list.get(0) + " table " + (String)list.get(1));
                DB_TABLE_DETAILS.remove(list);
            }
        } else {
            HEAVYDBLOGGER.debug("removing schema " + schema.toUpperCase() + " table " + table.toUpperCase());
            DB_TABLE_DETAILS.remove(ImmutableList.of(schema.toUpperCase(), table.toUpperCase()));
        }
        all = new HashSet<List<String>>(DB_TABLE_DETAILS.keySet());
        for (List list : all) {
            Table ttable;
            if (!((String)list.get(0)).equals(schema.toUpperCase()) || !((ttable = DB_TABLE_DETAILS.get(list)) instanceof HeavyDBView)) continue;
            HEAVYDBLOGGER.debug("removing view in schema " + (String)list.get(0) + " view " + (String)list.get(1));
            DB_TABLE_DETAILS.remove(list);
        }
        Set<String> mSet = DATABASE_TO_TABLES.get(schema.toUpperCase());
        if (mSet != null) {
            if (table.isEmpty()) {
                HEAVYDBLOGGER.debug("removing schema " + schema.toUpperCase());
                DATABASE_TO_TABLES.remove(schema.toUpperCase());
            } else {
                mSet.clear();
            }
        } else {
            HashSet hashSet = new HashSet();
            DATABASE_TO_TABLES.putIfAbsent(schema.toUpperCase(), hashSet);
        }
    }
}

