/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.parser.extension.ddl;

import com.google.gson.annotations.Expose;
import com.mapd.parser.extension.ddl.SqlCustomDdl;
import com.mapd.parser.extension.ddl.SqlOptionsBuilder;
import java.util.Map;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.parser.SqlParserPos;

public class SqlAlterForeignTable
extends SqlCustomDdl {
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("ALTER_FOREIGN_TABLE", SqlKind.OTHER_DDL);
    @Expose
    private AlterType alterType;
    @Expose
    private String tableName;
    @Expose
    private String newTableName;
    @Expose
    private String oldColumnName;
    @Expose
    private String newColumnName;
    @Expose
    private Map<String, String> options;

    public SqlAlterForeignTable(SqlParserPos pos, AlterType alterType, String tableName, String newTableName, String oldColumnName, String newColumnName, Map<String, String> options) {
        super(OPERATOR, pos);
        this.alterType = alterType;
        this.tableName = tableName;
        this.newTableName = newTableName;
        this.oldColumnName = oldColumnName;
        this.newColumnName = newColumnName;
        this.options = options;
    }

    public static class Builder
    extends SqlOptionsBuilder {
        private SqlParserPos pos;
        private AlterType alterType;
        private String tableName;
        private String newTableName;
        private String oldColumnName;
        private String newColumnName;

        public void setPos(SqlParserPos pos) {
            this.pos = pos;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public void alterOptions(Map<String, String> options) {
            this.alterType = AlterType.ALTER_OPTIONS;
            this.options = options;
        }

        public void alterTableName(String newName) {
            this.alterType = AlterType.RENAME_TABLE;
            this.newTableName = newName;
        }

        public void alterColumnName(String oldName, String newName) {
            this.alterType = AlterType.RENAME_COLUMN;
            this.oldColumnName = oldName;
            this.newColumnName = newName;
        }

        public SqlAlterForeignTable build() {
            return new SqlAlterForeignTable(this.pos, this.alterType, this.tableName, this.newTableName, this.oldColumnName, this.newColumnName, this.options);
        }
    }

    public static enum AlterType {
        RENAME_TABLE,
        RENAME_COLUMN,
        ALTER_OPTIONS;

    }
}

