/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.parser.extension.ddl;

import com.google.common.collect.ImmutableList;
import com.mapd.parser.extension.ddl.heavydb.HeavyDBGeoTypeNameSpec;
import com.mapd.parser.extension.ddl.heavydb.HeavyDBSqlDataTypeSpec;
import com.mapd.parser.extension.ddl.heavydb.HeavyDBTypeNameSpec;
import java.util.List;
import java.util.Map;
import org.apache.calcite.schema.ColumnStrategy;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.EscapedStringJsonBuilder;

public class SqlColumnDeclaration
extends SqlCall {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("COLUMN_DECL", SqlKind.COLUMN_DECL);
    public final SqlIdentifier name;
    public final HeavyDBSqlDataTypeSpec dataType;
    public final SqlNode defaultValue;
    public final ColumnStrategy strategy;

    SqlColumnDeclaration(SqlParserPos pos, SqlIdentifier name, HeavyDBSqlDataTypeSpec dataType, SqlNode defaultValue, ColumnStrategy strategy) {
        super(pos);
        this.name = name;
        this.dataType = dataType;
        this.defaultValue = defaultValue;
        this.strategy = strategy;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableList.of(this.name, this.dataType);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.name.unparse(writer, 0, 0);
        this.dataType.unparse(writer, 0, 0);
        if (this.dataType.getNullable() != null && !this.dataType.getNullable().booleanValue()) {
            writer.keyword("NOT NULL");
        }
        if (this.defaultValue != null) {
            switch (this.strategy) {
                case DEFAULT: {
                    writer.keyword("DEFAULT");
                    this.exp(writer);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unexpected: " + (Object)((Object)this.strategy)));
                }
            }
        }
    }

    private void exp(SqlWriter writer) {
        if (writer.isAlwaysUseParentheses()) {
            this.defaultValue.unparse(writer, 0, 0);
        } else {
            writer.sep("(");
            this.defaultValue.unparse(writer, 0, 0);
            writer.sep(")");
        }
    }

    @Override
    public String toString() {
        EscapedStringJsonBuilder jsonBuilder = new EscapedStringJsonBuilder();
        Map<String, Object> map = jsonBuilder.map();
        jsonBuilder.put(map, "type", "SQL_COLUMN_DECLARATION");
        jsonBuilder.put(map, "name", this.name == null ? null : this.name.toString());
        jsonBuilder.put(map, "default", this.defaultValue == null ? null : this.defaultValue.toString());
        jsonBuilder.put(map, "nullable", !Boolean.FALSE.equals(this.dataType.getNullable()));
        jsonBuilder.put(map, "encodingType", this.dataType.getEncodingString());
        jsonBuilder.put(map, "encodingSize", this.dataType.getEncodingSize());
        SqlTypeNameSpec dataTypeSpec = this.dataType.getTypeNameSpec();
        if (dataTypeSpec instanceof HeavyDBGeoTypeNameSpec) {
            map = ((HeavyDBGeoTypeNameSpec)dataTypeSpec).toJsonMap(map);
        } else {
            boolean isText = false;
            if (dataTypeSpec instanceof HeavyDBTypeNameSpec) {
                HeavyDBTypeNameSpec heavyDBDataTypeSpec = (HeavyDBTypeNameSpec)dataTypeSpec;
                if (heavyDBDataTypeSpec.getIsArray()) {
                    jsonBuilder.put(map, "arraySize", heavyDBDataTypeSpec.getArraySize());
                }
                isText = heavyDBDataTypeSpec.getIsText();
            }
            jsonBuilder.put(map, "precision", ((SqlBasicTypeNameSpec)dataTypeSpec).getPrecision());
            jsonBuilder.put(map, "scale", ((SqlBasicTypeNameSpec)dataTypeSpec).getScale());
            if (isText) {
                jsonBuilder.put(map, "sqltype", "TEXT");
            } else {
                jsonBuilder.put(map, "sqltype", this.dataType == null ? null : dataTypeSpec.getTypeName().toString());
            }
        }
        return jsonBuilder.toJsonString(map);
    }
}

