/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.parser.extension.ddl;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.SqlWriterConfig;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.calcite.util.EscapedStringJsonBuilder;
import org.apache.calcite.util.ImmutableNullableList;

public class SqlCreateView
extends SqlCreate {
    public final SqlIdentifier name;
    public final SqlNodeList columnList;
    public final SqlNode query;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("CREATE VIEW", SqlKind.CREATE_VIEW);

    SqlCreateView(SqlParserPos pos, boolean replace, boolean ifNotExists, SqlIdentifier name, SqlNodeList columnList, SqlNode query) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.name = Objects.requireNonNull(name);
        this.columnList = columnList;
        this.query = Objects.requireNonNull(query);
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name, this.columnList, this.query);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.getReplace()) {
            writer.keyword("CREATE OR REPLACE");
        } else {
            writer.keyword("CREATE");
        }
        writer.keyword("VIEW");
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.columnList != null) {
            SqlWriter.Frame frame = writer.startList("(", ")");
            for (SqlNode c : this.columnList) {
                writer.sep(",");
                c.unparse(writer, 0, 0);
            }
            writer.endList(frame);
        }
        writer.keyword("AS");
        writer.newlineAndIndent();
        this.query.unparse(writer, 0, 0);
    }

    @Override
    public String toString() {
        EscapedStringJsonBuilder jsonBuilder = new EscapedStringJsonBuilder();
        Map<String, Object> map = jsonBuilder.map();
        jsonBuilder.put(map, "name", this.name.toString());
        SqlWriterConfig c = SqlPrettyWriter.config().withDialect(CalciteSqlDialect.DEFAULT).withQuoteAllIdentifiers(false).withSelectListItemsOnSeparateLines(false).withWhereListItemsOnSeparateLines(false).withValuesListNewline(false);
        SqlPrettyWriter writer = new SqlPrettyWriter(c);
        this.query.unparse(writer, 0, 0);
        jsonBuilder.put(map, "query", writer.toString());
        jsonBuilder.put(map, "ifNotExists", this.ifNotExists);
        map.put("command", "CREATE_VIEW");
        Map<String, Object> payload = jsonBuilder.map();
        payload.put("payload", map);
        return jsonBuilder.toJsonString(payload);
    }
}

