/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.parser.extension.ddl.heavydb;

import com.mapd.parser.extension.ddl.heavydb.HeavyDBEncoding;
import com.mapd.parser.extension.ddl.heavydb.HeavyDBGeo;
import java.util.Map;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.EscapedStringJsonBuilder;
import org.apache.calcite.util.Pair;

public class HeavyDBGeoTypeNameSpec
extends SqlBasicTypeNameSpec {
    private HeavyDBEncoding encodingType;
    private Integer encodingSize;
    private HeavyDBGeo geoType;
    private boolean isGeography;
    private Integer coordinateSystem;

    public HeavyDBGeoTypeNameSpec(HeavyDBGeo geoType, Integer coordinateSystem, boolean isGeography, Pair<HeavyDBEncoding, Integer> encodingInfo, SqlParserPos pos) {
        super(SqlTypeName.GEOMETRY, pos);
        this.geoType = geoType;
        this.coordinateSystem = coordinateSystem;
        if (encodingInfo != null) {
            this.encodingType = (HeavyDBEncoding)((Object)encodingInfo.left);
            this.encodingSize = (Integer)encodingInfo.right;
        }
    }

    public Map<String, Object> toJsonMap(Map<String, Object> map) {
        EscapedStringJsonBuilder jsonBuilder = new EscapedStringJsonBuilder();
        if (this.isGeography) {
            jsonBuilder.put(map, "sqltype", "GEOGRAPHY");
        } else {
            jsonBuilder.put(map, "sqltype", "GEOMETRY");
        }
        if (this.encodingType != null) {
            jsonBuilder.put(map, "encodingType", this.encodingType.name());
            jsonBuilder.put(map, "encodingSize", this.encodingSize);
        }
        jsonBuilder.put(map, "subtype", this.geoType.toString());
        jsonBuilder.put(map, "coordinateSystem", this.coordinateSystem);
        return map;
    }
}

