/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.tests;

import com.mapd.tests.HeavyDBAsserts;
import com.mapd.tests.HeavyDBTestClient;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogConcurrencyTest {
    static final Logger logger = LoggerFactory.getLogger(CatalogConcurrencyTest.class);

    public static void main(String[] args) throws Exception {
        CatalogConcurrencyTest test = new CatalogConcurrencyTest();
        test.testCatalogConcurrency();
    }

    private void run_test(HeavyDBTestClient dba, HeavyDBTestClient user, String prefix, int max) throws Exception {
        String sharedTableName = "table_shared";
        for (int i = 0; i < max; ++i) {
            String tableName = "table_" + prefix + "_" + i;
            String viewName = "view_" + prefix + "_" + i;
            String dashName = "dash_" + prefix + "_" + i;
            long tid = Thread.currentThread().getId();
            logger.info("[" + tid + "]CREATE " + tableName);
            user.runSql("CREATE TABLE " + tableName + " (id text);");
            HeavyDBAsserts.assertEqual(true, null != dba.get_table_details(tableName));
            logger.info("[" + tid + "]INSERT INTO " + tableName);
            user.runSql("INSERT INTO " + tableName + " VALUES(1);");
            dba.runSql("GRANT SELECT ON TABLE " + tableName + " TO bob;");
            logger.info("[" + tid + "]CREATE " + viewName);
            user.runSql("CREATE VIEW " + viewName + " AS SELECT * FROM " + tableName + ";");
            HeavyDBAsserts.assertEqual(true, null != dba.get_table_details(viewName));
            dba.runSql("GRANT SELECT ON VIEW " + viewName + " TO bob;");
            logger.info("[" + tid + "]CREATE " + dashName);
            int dash_id = user.create_dashboard(dashName);
            HeavyDBAsserts.assertEqual(true, null != dba.get_dashboard(dash_id));
            dba.runSql("GRANT VIEW ON DASHBOARD " + dash_id + " TO bob;");
            dba.runSql("REVOKE VIEW ON DASHBOARD " + dash_id + " FROM bob;");
            dba.runSql("REVOKE SELECT ON VIEW " + viewName + " FROM bob;");
            dba.runSql("REVOKE SELECT ON TABLE " + tableName + " FROM bob;");
            logger.info("[" + tid + "]DROP " + dashName);
            dba.delete_dashboard(dash_id);
            logger.info("[" + tid + "]DROP " + viewName);
            dba.runSql("DROP VIEW " + viewName + ";");
            logger.info("[" + tid + "]DROP " + tableName);
            dba.runSql("DROP TABLE " + tableName + ";");
            logger.info("[" + tid + "]CREATE IF NOT EXISTS " + "table_shared");
            dba.runSql("CREATE TABLE IF NOT EXISTS table_shared (id INTEGER);");
            logger.info("[" + tid + "]DROP IF EXISTS " + "table_shared");
            dba.runSql("DROP TABLE IF EXISTS table_shared;");
        }
    }

    private void runTest(final String db, final String dbaUser, final String dbaPassword, final String dbUser, final String dbPassword) throws Exception {
        int num_threads = 5;
        int runs = 25;
        final Exception[] exceptions = new Exception[num_threads];
        ArrayList<Thread> threads = new ArrayList<Thread>();
        int i = 0;
        while (i < num_threads) {
            logger.info("Starting " + i);
            final String prefix = "for_bob_" + i + "_";
            final int threadId = i++;
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        HeavyDBTestClient dba = HeavyDBTestClient.getClient("localhost", 6274, db, dbaUser, dbaPassword);
                        HeavyDBTestClient user = HeavyDBTestClient.getClient("localhost", 6274, db, dbUser, dbPassword);
                        CatalogConcurrencyTest.this.run_test(dba, user, prefix, 25);
                    }
                    catch (Exception e) {
                        logger.error("[" + Thread.currentThread().getId() + "]Caught Exception: " + e.getMessage(), e);
                        exceptions[threadId] = e;
                    }
                }
            });
            t.start();
            threads.add(t);
        }
        for (Thread t : threads) {
            t.join();
        }
        for (Exception e : exceptions) {
            if (null == e) continue;
            logger.error("Exception: " + e.getMessage(), e);
            throw new Exception(e.getMessage(), e);
        }
    }

    public void testCatalogConcurrency() throws Exception {
        logger.info("testCatalogConcurrency()");
        HeavyDBTestClient su = HeavyDBTestClient.getClient("localhost", 6274, "heavyai", "admin", "HyperInteractive");
        su.runSql("CREATE USER dba (password = 'password', is_super = 'true');");
        su.runSql("CREATE USER bob (password = 'password', is_super = 'false');");
        su.runSql("GRANT CREATE on DATABASE heavyai TO bob;");
        su.runSql("GRANT CREATE VIEW on DATABASE heavyai TO bob;");
        su.runSql("GRANT CREATE DASHBOARD on DATABASE heavyai TO bob;");
        su.runSql("GRANT DROP on DATABASE heavyai TO bob;");
        su.runSql("GRANT DROP VIEW on DATABASE heavyai TO bob;");
        su.runSql("GRANT DELETE DASHBOARD on DATABASE heavyai TO bob;");
        su.runSql("CREATE DATABASE db1;");
        su.runSql("GRANT CREATE on DATABASE db1 TO bob;");
        su.runSql("GRANT CREATE VIEW on DATABASE db1 TO bob;");
        su.runSql("GRANT CREATE DASHBOARD on DATABASE db1 TO bob;");
        su.runSql("GRANT DROP on DATABASE db1 TO bob;");
        su.runSql("GRANT DROP VIEW on DATABASE db1 TO bob;");
        su.runSql("GRANT DELETE DASHBOARD on DATABASE db1 TO bob;");
        su.runSql("GRANT ACCESS on database heavyai TO dba;");
        su.runSql("GRANT ACCESS on database heavyai TO bob;");
        su.runSql("GRANT ACCESS on database db1 TO dba;");
        su.runSql("GRANT ACCESS on database db1 TO bob;");
        this.runTest("db1", "admin", "HyperInteractive", "admin", "HyperInteractive");
        this.runTest("db1", "admin", "HyperInteractive", "dba", "password");
        this.runTest("db1", "admin", "HyperInteractive", "bob", "password");
        this.runTest("db1", "dba", "password", "admin", "HyperInteractive");
        this.runTest("db1", "dba", "password", "bob", "password");
        this.runTest("heavyai", "admin", "HyperInteractive", "admin", "HyperInteractive");
        this.runTest("heavyai", "admin", "HyperInteractive", "dba", "password");
        this.runTest("heavyai", "admin", "HyperInteractive", "bob", "password");
        this.runTest("heavyai", "dba", "password", "admin", "HyperInteractive");
        this.runTest("heavyai", "dba", "password", "bob", "password");
        su.runSql("DROP DATABASE db1;");
        su.runSql("DROP USER bob;");
        su.runSql("DROP USER dba;");
        logger.info("testCatalogConcurrency() done");
    }
}

