/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.tests;

import ai.heavy.thrift.server.TDBException;
import com.mapd.tests.HeavyDBTestClient;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CyclicBarrier;
import org.slf4j.Logger;

public abstract class ConcurrencyTest {
    public static final String db = "TestDB";
    public static final String userName = "admin";
    public static final String password = "HyperInteractive";
    public static final String localhost = "localhost";
    public static final String defaultDb = "heavyai";
    public static final int defaultPort = 6274;
    public static final int defaultNumThreads = 5;
    public static final int defaultNumIterations = 5;
    public static final boolean defaultEnableHeavyConnect = true;
    public static final boolean defaultEnableMonitorThread = false;
    public static int numThreads = 5;
    public static int numIterations = 5;
    public static boolean enableHeavyConnect = true;
    public static boolean enableMonitorThread = false;
    static Random rand = new Random();
    public static Logger logger = null;
    public static String testName = "";
    public static int[] ports = null;
    public CyclicBarrier barrier;
    public ArrayList<String> exceptionTexts = new ArrayList();

    public static boolean deleteDirectory(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                ConcurrencyTest.deleteDirectory(file);
            }
        }
        return dir.delete();
    }

    public static int[] getPorts() {
        List<String> portList;
        String portString = System.getProperty("PORT_LIST");
        if (portString != null && (portList = Arrays.asList(portString.split(","))).size() > 0) {
            int[] retPorts = new int[portList.size()];
            for (int i = 0; i < portList.size(); ++i) {
                retPorts[i] = Integer.parseInt(portList.get(i));
            }
            return retPorts;
        }
        int[] retPorts = new int[]{6274};
        return retPorts;
    }

    public static int getNumThreads() {
        String propertyString = System.getProperty("NUM_THREADS");
        if (propertyString == null) {
            return 5;
        }
        return Integer.parseInt(propertyString);
    }

    public static int getNumIterations() {
        String propertyString = System.getProperty("NUM_ITERATIONS");
        if (propertyString == null) {
            return 5;
        }
        return Integer.parseInt(propertyString);
    }

    public static boolean getEnableHeavyConnect() {
        String propertyString = System.getProperty("ENABLE_HEAVY_CONNECT");
        if (propertyString == null) {
            return true;
        }
        return Boolean.parseBoolean(propertyString);
    }

    public static boolean getEnableMonitorThread() {
        String propertyString = System.getProperty("ENABLE_MONITOR_THREAD");
        if (propertyString == null) {
            return false;
        }
        return Boolean.parseBoolean(propertyString);
    }

    public static String getConfig() {
        String log = "Config for " + testName + ":\n{\n  ports = {\n";
        for (int port : ports) {
            log = log + "    " + port + "\n";
        }
        log = log + "  }\n  num_threads = " + numThreads + "\n  num_iterations = " + numIterations + "\n  enable_heavy_connect = " + enableHeavyConnect + "\n  enable_monitor_thread = " + enableMonitorThread + "\n}";
        return log;
    }

    public static CyclicBarrier createBarrier(int numThreadsToWait) {
        return new CyclicBarrier(numThreadsToWait, new Runnable(){

            @Override
            public void run() {
                logger.info("Threads Synched");
            }
        });
    }

    public static void printErrors(ArrayList<String> exceptionTexts) {
        if (exceptionTexts.size() > 0) {
            String errors = "\n";
            for (String s2 : exceptionTexts) {
                errors = errors + s2 + "\n";
            }
            logger.error("Found exceptions:" + errors);
        }
    }

    public static int getRandomPort() {
        return ports[rand.nextInt(ports.length)];
    }

    public abstract List<SqlCommandThread[]> createTestThreads();

    public abstract void runTests(List<SqlCommandThread[]> var1) throws Exception;

    public abstract void setUpTests() throws Exception;

    public abstract void cleanUpTests(List<SqlCommandThread[]> var1) throws Exception;

    public void testConcurrency() throws Exception {
        if (testName.equals("")) {
            throw new RuntimeException("Derived test has not set a test name");
        }
        if (logger == null) {
            throw new RuntimeException("Derived test has not initialized logger");
        }
        logger.info(testName + "()");
        List<SqlCommandThread[]> tests = this.createTestThreads();
        this.setUpTests();
        this.runTests(tests);
        this.cleanUpTests(tests);
        logger.info(testName + "() done");
    }

    public HeavyDBTestClient getAdminClient(String db) throws Exception {
        return HeavyDBTestClient.getClient(localhost, ports[0], db, userName, password);
    }

    public void runAndLog(HeavyDBTestClient client, String sql) throws Exception {
        client.runSql(sql);
        logger.info("  " + sql);
    }

    public class SqlCommandThread
    extends Thread {
        final List<String> queries;
        final List<String> expectedExceptionTexts;
        final List<String> cleanUpQueries;
        final String threadName;
        final int port;
        final int iterations;
        final int threadId;

        SqlCommandThread(String threadName, List<String> queries, int threadId, int port, int iterations, List<String> exceptions, List<String> cleanUpQueries) {
            this.queries = queries;
            this.port = port;
            this.iterations = iterations;
            this.threadId = threadId;
            this.threadName = threadName + "[" + port + "][" + threadId + "]";
            this.expectedExceptionTexts = exceptions;
            this.cleanUpQueries = cleanUpQueries;
        }

        SqlCommandThread(String threadName, List<String> queries, int threadId, List<String> exceptions, List<String> cleanUpQueries) {
            this(threadName, queries, threadId, ConcurrencyTest.getRandomPort(), numIterations, exceptions, cleanUpQueries);
        }

        @Override
        public void run() {
            logger.info("  Starting: " + this.threadName);
            try {
                HeavyDBTestClient user = HeavyDBTestClient.getClient(ConcurrencyTest.localhost, this.port, ConcurrencyTest.db, ConcurrencyTest.userName, ConcurrencyTest.password);
                ConcurrencyTest.this.barrier.await();
                for (int iteration = 0; iteration < this.iterations; ++iteration) {
                    for (String query : this.queries) {
                        logger.info("  " + this.threadName + "[" + iteration + "]: " + query);
                        try {
                            user.runSql(query);
                        }
                        catch (TDBException e) {
                            boolean foundExpected = false;
                            for (String exceptionText : this.expectedExceptionTexts) {
                                if (!e.error_msg.contains(exceptionText)) continue;
                                foundExpected = true;
                            }
                            if (foundExpected) continue;
                            throw e;
                        }
                    }
                }
            }
            catch (TDBException e) {
                logger.error("  " + this.threadName + ": caught exception - " + e.error_msg);
                ConcurrencyTest.this.exceptionTexts.add(this.threadName + ": " + e.error_msg);
            }
            catch (Exception e) {
                logger.error("  " + this.threadName + ": caught exception - " + e.getMessage());
                ConcurrencyTest.this.exceptionTexts.add(this.threadName + ": " + e.getMessage());
            }
            logger.info("  Finished: " + this.threadName);
        }
    }

    public class MonitoringThread
    extends Thread {
        List<SqlCommandThread[]> monitoredThreads;
        int numThreads;

        MonitoringThread(List<SqlCommandThread[]> monitoredThreads, int numThreads) {
            this.monitoredThreads = monitoredThreads;
            this.numThreads = numThreads;
        }

        @Override
        public void run() {
            int finishedThreads = 0;
            int totalThreads = this.monitoredThreads.size() * this.numThreads;
            while (finishedThreads < totalThreads) {
                finishedThreads = 0;
                for (SqlCommandThread[] threadGroup : this.monitoredThreads) {
                    for (SqlCommandThread thread : threadGroup) {
                        if (thread.getState() != Thread.State.TERMINATED) continue;
                        ++finishedThreads;
                    }
                }
                logger.info("Threads running: " + (totalThreads - finishedThreads));
                try {
                    Thread.sleep(60000L);
                }
                catch (Exception e) {
                    logger.error("Monitoring thread: " + e.getMessage());
                }
            }
        }
    }
}

