/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.tests;

import ai.heavy.thrift.server.TDBException;
import com.mapd.tests.HeavyDBTestClient;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.CyclicBarrier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CtasItasSelectUpdelConcurrencyTest {
    static final Logger logger = LoggerFactory.getLogger(CtasItasSelectUpdelConcurrencyTest.class);
    static final String[] text_values = new String[]{"foo", "bar", "hello", "world", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p"};

    public static void main(String[] args) throws Exception {
        CtasItasSelectUpdelConcurrencyTest test = new CtasItasSelectUpdelConcurrencyTest();
        test.testConcurrency();
    }

    private void runTest(final String db, final String dbaUser, final String dbaPassword, final String dbUser, final String dbPassword) throws Exception {
        int num_threads = 5;
        int runs = 25;
        int num_rows = 1000;
        int fragment_size = 10;
        String tableName = "test";
        final Exception[] exceptions = new Exception[num_threads];
        final CyclicBarrier barrier = new CyclicBarrier(num_threads, new Runnable(){

            @Override
            public void run() {
                try {
                    HeavyDBTestClient dba = HeavyDBTestClient.getClient("localhost", 6274, db, dbaUser, dbaPassword);
                    dba.runSql("CREATE TABLE test(x BIGINT, y INTEGER, z SMALLINT, a TINYINT, f FLOAT, d DOUBLE, deci DECIMAL(18,6), str TEXT ENCODING NONE) WITH (FRAGMENT_SIZE = 10)");
                    for (int i = 0; i < 1000; ++i) {
                        String integer_val = Integer.toString(i);
                        String small_val = Integer.toString(i % 128);
                        String fp_val = Double.toString((double)i * 1.1);
                        String deci_val = Double.toString((double)i + 0.01);
                        String str_val = "'" + text_values[i % text_values.length] + "'";
                        String values_string = String.join((CharSequence)" , ", integer_val, integer_val, small_val, small_val, fp_val, fp_val, deci_val, str_val);
                        dba.runSql("INSERT INTO test VALUES (" + values_string + ")");
                    }
                }
                catch (Exception e) {
                    logger.error("[" + Thread.currentThread().getId() + "] Caught Exception: " + e.getMessage(), e);
                    exceptions[0] = e;
                }
            }
        });
        ArrayList<Thread> threads = new ArrayList<Thread>();
        int i = 0;
        while (i < num_threads) {
            logger.info("Starting " + i);
            final int threadId = i++;
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    long tid = Thread.currentThread().getId();
                    String logPrefix = "[" + tid + "]";
                    String sql = "";
                    String ctasTableName = "ctas_test";
                    try {
                        barrier.await();
                        HeavyDBTestClient user = HeavyDBTestClient.getClient("localhost", 6274, db, dbUser, dbPassword);
                        Random rand = new Random(tid);
                        if (threadId == 2) {
                            sql = "CREATE TABLE ctas_test AS (SELECT x, y, deci, str FROM test);";
                            logger.info(logPrefix + " " + sql);
                            user.runSql(sql);
                        }
                        sql = "SELECT * FROM test LIMIT 2;";
                        logger.info(logPrefix + " " + sql);
                        user.runSql(sql);
                        boolean ctas_table_created = false;
                        while (!ctas_table_created) {
                            ctas_table_created = true;
                            try {
                                sql = "SELECT COUNT(*) FROM ctas_test;";
                                logger.info(logPrefix + " VALIDATE " + sql);
                                user.sqlValidate(sql);
                            }
                            catch (TDBException e) {
                                if (e.getError_msg().indexOf("not found") != -1) {
                                    Thread.sleep(1000L);
                                    ctas_table_created = false;
                                    continue;
                                }
                                throw e;
                            }
                        }
                        sql = "DELETE FROM ctas_test WHERE y = " + rand.nextInt(1000) + ";";
                        logger.info(logPrefix + " " + sql);
                        user.runSql(sql);
                        if (threadId == 0) {
                            sql = "ALTER TABLE test ADD COLUMN n TEXT ENCODING DICT(8);";
                            logger.info(logPrefix + " VALIDATE " + sql);
                            user.runSql(sql);
                            sql = "INSERT INTO test VALUES (" + tid + "," + tid + "," + tid + "," + tid + "," + tid + "," + tid + "," + tid + "," + (tid % 2L == 0L ? "'value_1'" : "'value_2'") + ", 'z');";
                            logger.info(logPrefix + " " + sql);
                            user.runSql(sql);
                        }
                        sql = "INSERT INTO ctas_test (SELECT x, y, deci, str FROM test WHERE str = '" + text_values[rand.nextInt(text_values.length)] + "');";
                        logger.info(logPrefix + " " + sql);
                        user.runSql(sql);
                        sql = "UPDATE test SET str = (SELECT count(*) > 0 FROM test);";
                        logger.info(logPrefix + " " + sql);
                        user.runSql(sql);
                        sql = "TRUNCATE TABLE test;";
                        logger.info(logPrefix + " " + sql);
                        user.runSql(sql);
                    }
                    catch (Exception e) {
                        logger.error(logPrefix + " Caught Exception: " + e.getMessage(), e);
                        exceptions[threadId] = e;
                    }
                }
            });
            t.start();
            threads.add(t);
        }
        for (Thread t : threads) {
            t.join();
        }
        HeavyDBTestClient dba = HeavyDBTestClient.getClient("localhost", 6274, db, dbaUser, dbaPassword);
        dba.runSql("DROP TABLE test;");
        for (Exception e : exceptions) {
            if (null == e) continue;
            logger.error("Exception: " + e.getMessage(), e);
            throw e;
        }
    }

    public void testConcurrency() throws Exception {
        logger.info("CtasItasSelectUpdelConcurrencyTest()");
        HeavyDBTestClient su = HeavyDBTestClient.getClient("localhost", 6274, "heavyai", "admin", "HyperInteractive");
        su.runSql("CREATE USER dba (password = 'password', is_super = 'true');");
        su.runSql("CREATE USER bob (password = 'password', is_super = 'false');");
        su.runSql("GRANT CREATE on DATABASE heavyai TO bob;");
        su.runSql("CREATE DATABASE db1;");
        su.runSql("GRANT CREATE on DATABASE db1 TO bob;");
        su.runSql("GRANT CREATE VIEW on DATABASE db1 TO bob;");
        su.runSql("GRANT DROP on DATABASE db1 TO bob;");
        su.runSql("GRANT DROP VIEW on DATABASE db1 TO bob;");
        this.runTest("db1", "admin", "HyperInteractive", "admin", "HyperInteractive");
        su.runSql("DROP DATABASE db1;");
        su.runSql("DROP USER bob;");
        su.runSql("DROP USER dba;");
        logger.info("CtasItasSelectUpdelConcurrencyTest() done");
    }
}

