/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.tests;

import ai.heavy.thrift.server.TDBException;
import ai.heavy.thrift.server.TQueryResult;
import ai.heavy.thrift.server.TTypeInfo;
import com.mapd.tests.HeavyDBTestClient;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Random;
import java.util.function.Function;
import org.apache.commons.math3.util.Pair;

public class DateTimeTest {
    static EnumSet resultsToDump = EnumSet.of(Fuzzy.failed, Fuzzy.okish);
    static EnumSet addAllowed = EnumSet.allOf(DateAddUnit.class);

    static LocalDateTime createRandomDateTime(Random r) {
        try {
            int year = 1900 + r.nextInt(200);
            int month = 1 + r.nextInt(12);
            int dayOfMonth = 1 + r.nextInt(31);
            int hour = r.nextInt(24);
            int minute = r.nextInt(60);
            int second = r.nextInt(60);
            int nanoOfSecond = r.nextInt(1000000000);
            return LocalDateTime.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond);
        }
        catch (Exception e) {
            return DateTimeTest.createRandomDateTime(r);
        }
    }

    static LocalDateTime getDateTimeFromQuery(HeavyDBTestClient client, String sql) throws Exception {
        try {
            int nanosPow;
            long val;
            int pow;
            TQueryResult res = client.runSql(sql);
            LocalDateTime r = null;
            if (res.row_set.is_columnar) {
                TTypeInfo tt = res.row_set.row_desc.get((int)0).col_type;
                pow = (int)Math.pow(10.0, tt.precision);
                val = res.row_set.columns.get((int)0).data.int_col.get(0);
                nanosPow = (int)Math.pow(10.0, 9 - tt.precision);
                long nanos = val % (long)pow;
                if (nanos < 0L) {
                    nanos = (long)pow + nanos;
                }
            } else {
                throw new RuntimeException("Unsupported!");
            }
            r = LocalDateTime.ofEpochSecond(Math.floorDiv(val, (long)pow), (int)(nanos *= (long)nanosPow), ZoneOffset.UTC);
            return r;
        }
        catch (TDBException e) {
            System.out.println("Query failed: " + sql + " -- " + e.getError_msg());
            return LocalDateTime.MIN;
        }
        catch (Exception e) {
            System.out.println("Query failed: " + sql + " -- " + e.getMessage());
            return LocalDateTime.MIN;
        }
    }

    static long getLongFromQuery(HeavyDBTestClient client, String sql) throws Exception {
        try {
            long val;
            TQueryResult res = client.runSql(sql);
            long r = -1L;
            if (!res.row_set.is_columnar) {
                throw new RuntimeException("Unsupported!");
            }
            r = val = res.row_set.columns.get((int)0).data.int_col.get(0).longValue();
            return r;
        }
        catch (TDBException e) {
            System.out.println("Query failed: " + sql + " -- " + e.getError_msg());
            return Long.MIN_VALUE;
        }
        catch (Exception e) {
            System.out.println("Query failed: " + sql + " -- " + e.getMessage());
            return Long.MIN_VALUE;
        }
    }

    public static LocalDateTime testDateTrunc(LocalDateTime d, DateTruncUnit f, HeavyDBTestClient client, Encoding enc) throws Exception {
        if (!enc.isValid(d)) {
            return d;
        }
        String sql = "SELECT DATE_TRUNC('" + f.sqlToken + "', " + enc.toSql(d) + ");";
        LocalDateTime r = DateTimeTest.getDateTimeFromQuery(client, sql);
        LocalDateTime expected = f.trunc.apply(d);
        Fuzzy rc = Fuzzy.compare(expected = enc.clear(expected), r, enc);
        if (resultsToDump.contains((Object)rc)) {
            System.out.println("Query " + (Object)((Object)rc) + ": " + sql + " -> expected: " + expected.toString() + " got " + r.toString());
        }
        return DateTimeTest.testDateTruncTable(d, f, client, enc);
    }

    private static void updateValues(HeavyDBTestClient client, LocalDateTime a, Encoding aEnc) throws Exception {
        DateTimeTest.updateValues(client, a, aEnc, null, null);
    }

    private static void updateValues(HeavyDBTestClient client, LocalDateTime a, Encoding aEnc, LocalDateTime b, Encoding bEnc) throws Exception {
        String sqlUpdate = "UPDATE DateTimeTest set " + aEnc.toSqlColumn("a", null) + " = " + aEnc.toSql(a);
        if (null != b) {
            sqlUpdate = sqlUpdate + ", " + bEnc.toSqlColumn("b", null) + " = " + bEnc.toSql(b);
        }
        sqlUpdate = sqlUpdate + ";";
        try {
            client.runSql(sqlUpdate);
        }
        catch (TDBException e) {
            System.out.println("Update failed: " + sqlUpdate + " " + e.getError_msg());
        }
    }

    public static LocalDateTime testDateTruncTable(LocalDateTime d, DateTruncUnit f, HeavyDBTestClient client, Encoding enc) throws Exception {
        DateTimeTest.updateValues(client, d, enc);
        String sql = "SELECT DATE_TRUNC('" + f.sqlToken + "', " + enc.toSqlColumn("a", d) + ") FROM DateTimeTest;";
        LocalDateTime r = DateTimeTest.getDateTimeFromQuery(client, sql);
        LocalDateTime expected = f.trunc.apply(d);
        expected = enc.clear(expected);
        Fuzzy rc = Fuzzy.compare(expected, r, enc);
        if (resultsToDump.contains((Object)rc)) {
            System.out.println("Query " + (Object)((Object)rc) + ": " + sql + " -> expected: " + expected.toString() + " got " + r.toString());
        }
        return expected;
    }

    public static void testDateExtract(LocalDateTime d, DateExtractUnit f, HeavyDBTestClient client, Encoding enc) throws Exception {
        String sql = "SELECT EXTRACT(" + f.sqlToken + " FROM " + enc.toSql(d) + ");";
        long r = DateTimeTest.getLongFromQuery(client, sql);
        d = enc.clear(d);
        long expected = (Long)f.extract.apply(d);
        Fuzzy rc = Fuzzy.compare(expected, r);
        if (resultsToDump.contains((Object)rc)) {
            System.out.println("Query " + (Object)((Object)rc) + ": " + sql + " -> expected: " + expected + " got " + r);
        }
        DateTimeTest.testDateExtractTable(d, f, client, enc);
    }

    public static void testDateExtractTable(LocalDateTime d, DateExtractUnit f, HeavyDBTestClient client, Encoding enc) throws Exception {
        if (!enc.isValid(d)) {
            return;
        }
        DateTimeTest.updateValues(client, d, enc);
        String sql = "SELECT EXTRACT(" + f.sqlToken + " FROM " + enc.toSqlColumn("a", d) + ") FROM DateTimeTest;";
        long r = DateTimeTest.getLongFromQuery(client, sql);
        d = enc.clear(d);
        long expected = (Long)f.extract.apply(d);
        Fuzzy rc = Fuzzy.compare(expected, r);
        if (resultsToDump.contains((Object)rc)) {
            System.out.println("Query " + (Object)((Object)rc) + ": " + sql + " -> expected: " + expected + " got " + r);
        }
    }

    public static void testDiff(String fn, LocalDateTime d0, LocalDateTime d1, DateDiffUnit f, HeavyDBTestClient client, Encoding enc0, Encoding enc1) throws Exception {
        String sql = "SELECT " + fn + "(" + f.sqlToken + ", " + enc0.toSql(d0) + ", " + enc1.toSql(d1) + ");";
        long r = DateTimeTest.getLongFromQuery(client, sql);
        d0 = enc0.clear(d0);
        d1 = enc1.clear(d1);
        long expected = (Long)f.diff.apply(Pair.create(d0, d1));
        Fuzzy rc = Fuzzy.compare(expected, r);
        if (resultsToDump.contains((Object)rc)) {
            System.out.println("Query " + (Object)((Object)rc) + ": " + sql + " -> expected: " + expected + " got " + r);
        }
        DateTimeTest.testDiffTable(fn, d0, d1, f, client, enc0, enc1);
    }

    public static void testDiffTable(String fn, LocalDateTime d0, LocalDateTime d1, DateDiffUnit f, HeavyDBTestClient client, Encoding enc0, Encoding enc1) throws Exception {
        if (!enc0.isValid(d0) || !enc1.isValid(d1)) {
            return;
        }
        DateTimeTest.updateValues(client, d0, enc0, d1, enc1);
        String sql = "SELECT " + fn + "(" + f.sqlToken + ", " + enc0.toSqlColumn("a", d0) + ", " + enc1.toSqlColumn("b", d1) + ") FROM DateTimeTest;";
        long r = DateTimeTest.getLongFromQuery(client, sql);
        d0 = enc0.clear(d0);
        d1 = enc1.clear(d1);
        long expected = (Long)f.diff.apply(Pair.create(d0, d1));
        Fuzzy rc = Fuzzy.compare(expected, r);
        if (resultsToDump.contains((Object)rc)) {
            System.out.println("Query " + (Object)((Object)rc) + ": " + sql + " -> expected: " + expected + " got " + r);
        }
    }

    public static void testDateAdd(String fn, LocalDateTime d, DateAddUnit f, long units, HeavyDBTestClient client, Encoding enc) throws Exception {
        String sql = "SELECT " + fn + "(" + f.sqlToken + ", " + units + ", " + enc.toSql(d) + ");";
        LocalDateTime r = DateTimeTest.getDateTimeFromQuery(client, sql);
        LocalDateTime expected = (LocalDateTime)f.add.apply(Pair.create(enc.clear(d), units));
        Fuzzy rc = Fuzzy.compareDateAdd(expected = enc.clearForDateAddResult(expected), r, enc);
        if (resultsToDump.contains((Object)rc)) {
            System.out.println("Query " + (Object)((Object)rc) + ": " + sql + " -> expected: " + expected.toString() + " got " + r.toString());
        }
        DateTimeTest.testDateAddTable(fn, d, f, units, client, enc);
    }

    public static void testDateAddTable(String fn, LocalDateTime d, DateAddUnit f, long units, HeavyDBTestClient client, Encoding enc) throws Exception {
        if (!enc.isValid(d)) {
            return;
        }
        DateTimeTest.updateValues(client, d, enc);
        String sql = "SELECT " + fn + "(" + f.sqlToken + ", " + units + ", " + enc.toSqlColumn("a", d) + ") FROM DateTimeTest;";
        LocalDateTime r = DateTimeTest.getDateTimeFromQuery(client, sql);
        LocalDateTime expected = (LocalDateTime)f.add.apply(Pair.create(enc.clear(d), units));
        expected = enc.clearForDateAddResult(expected);
        Fuzzy rc = Fuzzy.compareDateAdd(expected, r, enc);
        if (resultsToDump.contains((Object)rc)) {
            System.out.println("Query " + (Object)((Object)rc) + ": " + sql + " -> expected: " + expected.toString() + " got " + r.toString());
        }
    }

    public static void testAdd(LocalDateTime d, DateAddUnit f, long units, HeavyDBTestClient client, Encoding enc) throws Exception {
        if (!addAllowed.contains((Object)f)) {
            return;
        }
        String sql = "SELECT " + enc.toSql(d) + " + INTERVAL '" + units + "' " + f.sqlToken + " ;";
        LocalDateTime r = DateTimeTest.getDateTimeFromQuery(client, sql);
        LocalDateTime expected = (LocalDateTime)f.add.apply(Pair.create(enc.clear(d), units));
        Fuzzy rc = Fuzzy.compareDateAdd(expected = enc.clearForDateAddResult(expected), r, enc);
        if (resultsToDump.contains((Object)rc)) {
            System.out.println("Query " + (Object)((Object)rc) + ": " + sql + " -> expected: " + expected.toString() + " got " + r.toString());
        }
    }

    public static void testSub(LocalDateTime d, DateAddUnit f, long units, HeavyDBTestClient client, Encoding enc) throws Exception {
        if (!addAllowed.contains((Object)f)) {
            return;
        }
        long toSub = -units;
        String sql = "SELECT " + enc.toSql(d) + " - INTERVAL '" + toSub + "' " + f.sqlToken + " ;";
        LocalDateTime r = DateTimeTest.getDateTimeFromQuery(client, sql);
        LocalDateTime expected = (LocalDateTime)f.add.apply(Pair.create(enc.clear(d), units));
        Fuzzy rc = Fuzzy.compareDateAdd(expected = enc.clearForDateAddResult(expected), r, enc);
        if (resultsToDump.contains((Object)rc)) {
            System.out.println("Query " + (Object)((Object)rc) + ": " + sql + " -> expected: " + expected.toString() + " got " + r.toString());
        }
    }

    public static void createTestTable(HeavyDBTestClient client) throws Exception {
        client.runSql("DROP TABLE IF EXISTS DateTimeTest;");
        String sqlCreate = "CREATE TABLE DateTimeTest(id int";
        String sqlInsert = "INSERT INTO DateTimeTest VALUES(0";
        for (Encoding e : Encoding.values()) {
            sqlCreate = sqlCreate + ", " + e.toSqlColumn("a", null) + " " + e.sqlType;
            sqlCreate = sqlCreate + ", " + e.toSqlColumn("b", null) + " " + e.sqlType;
            sqlInsert = sqlInsert + ", null, null";
        }
        sqlCreate = sqlCreate + ");";
        sqlInsert = sqlInsert + ");";
        client.runSql(sqlCreate);
        client.runSql(sqlInsert);
        System.out.println("CREATE: " + sqlCreate);
        System.out.println("INSERT: " + sqlInsert);
    }

    public static void main(String[] args) throws Exception {
        long seed = 0 < args.length ? Long.parseLong(args[0], 10) : System.currentTimeMillis();
        System.out.println("Seed: " + seed);
        Random r = new Random(seed);
        HeavyDBTestClient su = HeavyDBTestClient.getClient("localhost", 6274, "heavyai", "admin", "HyperInteractive");
        LocalDateTime d0 = DateTimeTest.createRandomDateTime(r);
        LocalDateTime d1 = DateTimeTest.createRandomDateTime(r);
        DateTimeTest.createTestTable(su);
        resultsToDump = EnumSet.of(Fuzzy.failed, Fuzzy.okish);
        boolean testTrunc = true;
        boolean testExtract = true;
        boolean testDiff = true;
        boolean testAdd = true;
        if (testTrunc) {
            for (Enum enum_ : Encoding.values()) {
                for (Enum enum_2 : DateTruncUnit.values()) {
                    LocalDateTime e = DateTimeTest.testDateTrunc(d0, (DateTruncUnit)enum_2, su, (Encoding)enum_);
                    e = e.minus(1L, ChronoUnit.NANOS);
                    DateTimeTest.testDateTrunc(e, (DateTruncUnit)enum_2, su, (Encoding)enum_);
                    e = DateTimeTest.testDateTrunc(d1, (DateTruncUnit)enum_2, su, (Encoding)enum_);
                    e = e.minus(1L, ChronoUnit.NANOS);
                    DateTimeTest.testDateTrunc(e, (DateTruncUnit)enum_2, su, (Encoding)enum_);
                }
            }
        }
        if (testExtract) {
            for (Enum enum_ : Encoding.values()) {
                for (Enum enum_3 : DateExtractUnit.values()) {
                    DateTimeTest.testDateExtract(d0, (DateExtractUnit)enum_3, su, (Encoding)enum_);
                    DateTimeTest.testDateExtract(d0.minusNanos(1L), (DateExtractUnit)enum_3, su, (Encoding)enum_);
                    DateTimeTest.testDateExtract(d0.plusNanos(1L), (DateExtractUnit)enum_3, su, (Encoding)enum_);
                    DateTimeTest.testDateExtract(d1, (DateExtractUnit)enum_3, su, (Encoding)enum_);
                    DateTimeTest.testDateExtract(d1.minusNanos(1L), (DateExtractUnit)enum_3, su, (Encoding)enum_);
                    DateTimeTest.testDateExtract(d1.plusNanos(1L), (DateExtractUnit)enum_3, su, (Encoding)enum_);
                }
            }
        }
        if (testDiff) {
            for (Enum enum_ : Encoding.values()) {
                for (Enum enum_4 : Encoding.values()) {
                    for (DateDiffUnit f : DateDiffUnit.values()) {
                        for (String fn : Arrays.asList("TIMESTAMPDIFF")) {
                            DateTimeTest.testDiff(fn, d0, d1, f, su, (Encoding)enum_, (Encoding)enum_4);
                            DateTimeTest.testDiff(fn, d1, d0, f, su, (Encoding)enum_, (Encoding)enum_4);
                            DateTimeTest.testDiff(fn, d0, d0, f, su, (Encoding)enum_, (Encoding)enum_4);
                            DateTimeTest.testDiff(fn, d1, d1, f, su, (Encoding)enum_, (Encoding)enum_4);
                        }
                    }
                }
            }
        }
        if (testAdd) {
            for (Enum enum_ : DateAddUnit.values()) {
                long units = r.nextLong() % ((DateAddUnit)enum_).max;
                if (r.nextBoolean()) {
                    units *= -1L;
                }
                for (Encoding enc0 : Encoding.values()) {
                    for (String fn : Arrays.asList("TIMESTAMPADD", "DATEADD")) {
                        DateTimeTest.testDateAdd(fn, d0, (DateAddUnit)enum_, units, su, enc0);
                        DateTimeTest.testDateAdd(fn, d1, (DateAddUnit)enum_, units, su, enc0);
                    }
                    DateTimeTest.testAdd(d0, (DateAddUnit)enum_, units, su, enc0);
                    DateTimeTest.testSub(d0, (DateAddUnit)enum_, units, su, enc0);
                    DateTimeTest.testAdd(d1, (DateAddUnit)enum_, units, su, enc0);
                    DateTimeTest.testSub(d1, (DateAddUnit)enum_, units, su, enc0);
                }
            }
        }
    }

    static {
        addAllowed.remove((Object)DateAddUnit.daQUARTER);
        addAllowed.remove((Object)DateAddUnit.daMILLISECOND);
        addAllowed.remove((Object)DateAddUnit.daMICROSECOND);
        addAllowed.remove((Object)DateAddUnit.daNANOSECOND);
        addAllowed.remove((Object)DateAddUnit.daWEEK);
    }

    static enum Fuzzy {
        ok,
        okish,
        failed;


        static Fuzzy compare(LocalDateTime expected, LocalDateTime result, Encoding enc) {
            if (expected.equals(result)) {
                return ok;
            }
            LocalDateTime okish = result.minus(1L, ChronoUnit.NANOS);
            if (expected.equals(okish = enc.clear(okish))) {
                return Fuzzy.okish;
            }
            okish = result.plus(1L, ChronoUnit.NANOS);
            if (expected.equals(okish = enc.clear(okish))) {
                return Fuzzy.okish;
            }
            return failed;
        }

        static Fuzzy compare(long expected, long result) {
            if (expected == result) {
                return ok;
            }
            long okish = result - 1L;
            if (expected == okish) {
                return Fuzzy.okish;
            }
            okish = result + 1L;
            if (expected == okish) {
                return Fuzzy.okish;
            }
            if (result == 59L && expected == 0L || result == 0L && expected == 59L) {
                return Fuzzy.okish;
            }
            if (result == 23L && expected == 0L || result == 0L && expected == 23L) {
                return Fuzzy.okish;
            }
            return failed;
        }

        static Fuzzy compareDateAdd(LocalDateTime expected, LocalDateTime result, Encoding enc) {
            if (expected.equals(result)) {
                return ok;
            }
            LocalDateTime okish = result.minus(1L, ChronoUnit.NANOS);
            if (expected.equals(okish = enc.clearForDateAddResult(okish))) {
                return Fuzzy.okish;
            }
            okish = result.plus(1L, ChronoUnit.NANOS);
            if (expected.equals(okish = enc.clearForDateAddResult(okish))) {
                return Fuzzy.okish;
            }
            return failed;
        }
    }

    static enum Encoding {
        TIMESTAMP("TIMESTAMP", "'TIMESTAMP' ''yyyy-MM-dd HH:mm:ss''", ChronoUnit.SECONDS, LocalDateTime.ofEpochSecond(-30610224000L, 0, ZoneOffset.UTC), LocalDateTime.ofEpochSecond(29379542399L, 0, ZoneOffset.UTC)),
        TIMESTAMP_0("TIMESTAMP(0)", "'TIMESTAMP(0)' ''yyyy-MM-dd HH:mm:ss''", ChronoUnit.SECONDS, LocalDateTime.ofEpochSecond(-30610224000L, 0, ZoneOffset.UTC), LocalDateTime.ofEpochSecond(29379542399L, 0, ZoneOffset.UTC)),
        TIMESTAMP_3("TIMESTAMP(3)", "'TIMESTAMP(3)' ''yyyy-MM-dd HH:mm:ss.SSS''", ChronoUnit.MILLIS, LocalDateTime.ofEpochSecond(-30610224000L, 0, ZoneOffset.UTC), LocalDateTime.ofEpochSecond(29379542399L, 0, ZoneOffset.UTC)),
        TIMESTAMP_6("TIMESTAMP(6)", "'TIMESTAMP(6)' ''yyyy-MM-dd HH:mm:ss.SSSSSS''", ChronoUnit.MICROS, LocalDateTime.ofEpochSecond(-30610224000L, 0, ZoneOffset.UTC), LocalDateTime.ofEpochSecond(29379542399L, 0, ZoneOffset.UTC)),
        TIMESTAMP_9("TIMESTAMP(9)", "'TIMESTAMP(9)' ''yyyy-MM-dd HH:mm:ss.SSSSSSSSS''", ChronoUnit.NANOS, LocalDateTime.ofEpochSecond(-9223372036L, 0, ZoneOffset.UTC), LocalDateTime.ofEpochSecond(9223372036L, 0, ZoneOffset.UTC)),
        TIMESTAMP_FIXED_32("TIMESTAMP ENCODING FIXED(32)", "'TIMESTAMP' ''yyyy-MM-dd HH:mm:ss''", ChronoUnit.SECONDS, LocalDateTime.ofEpochSecond(-2147483647L, 0, ZoneOffset.UTC), LocalDateTime.ofEpochSecond(Integer.MAX_VALUE, 0, ZoneOffset.UTC)),
        DATE("DATE", "'DATE' ''yyyy-MM-dd''", ChronoUnit.DAYS, LocalDateTime.ofEpochSecond(0L, 0, ZoneOffset.UTC).plusDays(Integer.MIN_VALUE), LocalDateTime.ofEpochSecond(0L, 0, ZoneOffset.UTC).plusDays(Integer.MAX_VALUE)),
        DATE_DAYS_16("DATE ENCODING DAYS(16)", "'DATE' ''yyyy-MM-dd''", ChronoUnit.DAYS, LocalDateTime.ofEpochSecond(0L, 0, ZoneOffset.UTC).plusDays(-32767L), LocalDateTime.ofEpochSecond(0L, 0, ZoneOffset.UTC).plusDays(32767L)),
        DATE_DAYS_32("DATE ENCODING DAYS(32)", "'DATE' ''yyyy-MM-dd''", ChronoUnit.DAYS, LocalDateTime.ofEpochSecond(0L, 0, ZoneOffset.UTC).plusDays(Integer.MIN_VALUE), LocalDateTime.ofEpochSecond(0L, 0, ZoneOffset.UTC).plusDays(Integer.MAX_VALUE));

        DateTimeFormatter formatter;
        String sqlType;
        ChronoUnit toClear;
        LocalDateTime min;
        LocalDateTime max;

        private Encoding(String sqlType, String pattern, ChronoUnit unit, LocalDateTime min2, LocalDateTime max) {
            this.sqlType = sqlType;
            this.formatter = DateTimeFormatter.ofPattern(pattern);
            this.toClear = unit;
            this.min = min2;
            this.max = max;
        }

        public String toSqlColumn(String prefx, LocalDateTime val) {
            if (null != val) {
                return prefx + "_" + this.name() + " /* " + this.toSql(val) + " */";
            }
            return prefx + "_" + this.name();
        }

        public String toSql(LocalDateTime d) {
            return this.formatter.format(d);
        }

        public LocalDateTime clear(LocalDateTime d) {
            if (null != this.toClear) {
                d = d.truncatedTo(this.toClear);
            }
            return d;
        }

        public LocalDateTime clearForDateAddResult(LocalDateTime d) {
            if (null != this.toClear) {
                d = this.toClear == ChronoUnit.DAYS ? d.truncatedTo(ChronoUnit.SECONDS) : d.truncatedTo(this.toClear);
            }
            return d;
        }

        public boolean isValid(LocalDateTime t) {
            return t.isAfter(this.min) && t.isBefore(this.max);
        }
    }

    static enum DateAddUnit {
        daYEAR("YEAR", 99L, new Function<Pair<LocalDateTime, Long>, LocalDateTime>(){

            @Override
            public LocalDateTime apply(Pair<LocalDateTime, Long> t) {
                return t.getFirst().plus(t.getSecond(), ChronoUnit.YEARS);
            }
        }),
        daQUARTER("QUARTER", 30L, new Function<Pair<LocalDateTime, Long>, LocalDateTime>(){

            @Override
            public LocalDateTime apply(Pair<LocalDateTime, Long> t) {
                return t.getFirst().plus(t.getSecond() * 3L, ChronoUnit.MONTHS);
            }
        }),
        daMONTH("MONTH", 99L, new Function<Pair<LocalDateTime, Long>, LocalDateTime>(){

            @Override
            public LocalDateTime apply(Pair<LocalDateTime, Long> t) {
                return t.getFirst().plus(t.getSecond(), ChronoUnit.MONTHS);
            }
        }),
        daDAY("DAY", 99L, new Function<Pair<LocalDateTime, Long>, LocalDateTime>(){

            @Override
            public LocalDateTime apply(Pair<LocalDateTime, Long> t) {
                return t.getFirst().plus(t.getSecond(), ChronoUnit.DAYS);
            }
        }),
        daHOUR("HOUR", 99L, new Function<Pair<LocalDateTime, Long>, LocalDateTime>(){

            @Override
            public LocalDateTime apply(Pair<LocalDateTime, Long> t) {
                return t.getFirst().plus(t.getSecond(), ChronoUnit.HOURS);
            }
        }),
        daMINUTE("MINUTE", 99L, new Function<Pair<LocalDateTime, Long>, LocalDateTime>(){

            @Override
            public LocalDateTime apply(Pair<LocalDateTime, Long> t) {
                return t.getFirst().plus(t.getSecond(), ChronoUnit.MINUTES);
            }
        }),
        daSECOND("SECOND", 99L, new Function<Pair<LocalDateTime, Long>, LocalDateTime>(){

            @Override
            public LocalDateTime apply(Pair<LocalDateTime, Long> t) {
                return t.getFirst().plus(t.getSecond(), ChronoUnit.SECONDS);
            }
        }),
        daMILLISECOND("MILLISECOND", 31104000000L, new Function<Pair<LocalDateTime, Long>, LocalDateTime>(){

            @Override
            public LocalDateTime apply(Pair<LocalDateTime, Long> t) {
                return t.getFirst().plus(t.getSecond(), ChronoUnit.MILLIS);
            }
        }),
        daMICROSECOND("MICROSECOND", -153157632L, new Function<Pair<LocalDateTime, Long>, LocalDateTime>(){

            @Override
            public LocalDateTime apply(Pair<LocalDateTime, Long> t) {
                return t.getFirst().plus(t.getSecond(), ChronoUnit.MICROS);
            }
        }),
        daNANOSECOND("NANOSECOND", 1461190656L, new Function<Pair<LocalDateTime, Long>, LocalDateTime>(){

            @Override
            public LocalDateTime apply(Pair<LocalDateTime, Long> t) {
                return t.getFirst().plus(t.getSecond(), ChronoUnit.NANOS);
            }
        }),
        daWEEK("WEEK", 53L, new Function<Pair<LocalDateTime, Long>, LocalDateTime>(){

            @Override
            public LocalDateTime apply(Pair<LocalDateTime, Long> t) {
                return t.getFirst().plus(t.getSecond(), ChronoUnit.WEEKS);
            }
        });

        private String sqlToken;
        private Function<Pair<LocalDateTime, Long>, LocalDateTime> add;
        private long max;

        private DateAddUnit(String token, long max, Function<Pair<LocalDateTime, Long>, LocalDateTime> f) {
            this.sqlToken = token;
            this.max = max;
            this.add = f;
        }
    }

    static enum DateDiffUnit {
        daYEAR("YEAR", new Function<Pair<LocalDateTime, LocalDateTime>, Long>(){

            @Override
            public Long apply(Pair<LocalDateTime, LocalDateTime> d) {
                return d.getFirst().until(d.getSecond(), ChronoUnit.YEARS);
            }
        }),
        daQUARTER("QUARTER", new Function<Pair<LocalDateTime, LocalDateTime>, Long>(){

            private Long applyCorrect(Pair<LocalDateTime, LocalDateTime> d) {
                LocalDateTime start = d.getFirst();
                LocalDateTime end = d.getSecond();
                int delta = 1;
                if (start.compareTo(end) > 0) {
                    delta = -1;
                    start = end;
                    end = d.getFirst();
                }
                start = DateTruncUnit.dtQUARTER.trunc.apply(start);
                long rc = 0L;
                while (start.compareTo(end) <= 0) {
                    rc += (long)delta;
                    start = start.plusMonths(3L);
                }
                return rc;
            }

            @Override
            public Long apply(Pair<LocalDateTime, LocalDateTime> d) {
                return d.getFirst().until(d.getSecond(), ChronoUnit.MONTHS) / 3L;
            }
        }),
        daMONTH("MONTH", new Function<Pair<LocalDateTime, LocalDateTime>, Long>(){

            @Override
            public Long apply(Pair<LocalDateTime, LocalDateTime> d) {
                return d.getFirst().until(d.getSecond(), ChronoUnit.MONTHS);
            }
        }),
        daDAY("DAY", new Function<Pair<LocalDateTime, LocalDateTime>, Long>(){

            @Override
            public Long apply(Pair<LocalDateTime, LocalDateTime> d) {
                return d.getFirst().until(d.getSecond(), ChronoUnit.DAYS);
            }
        }),
        daHOUR("HOUR", new Function<Pair<LocalDateTime, LocalDateTime>, Long>(){

            @Override
            public Long apply(Pair<LocalDateTime, LocalDateTime> d) {
                return d.getFirst().until(d.getSecond(), ChronoUnit.HOURS);
            }
        }),
        daMINUTE("MINUTE", new Function<Pair<LocalDateTime, LocalDateTime>, Long>(){

            @Override
            public Long apply(Pair<LocalDateTime, LocalDateTime> d) {
                return d.getFirst().until(d.getSecond(), ChronoUnit.MINUTES);
            }
        }),
        daSECOND("SECOND", new Function<Pair<LocalDateTime, LocalDateTime>, Long>(){

            @Override
            public Long apply(Pair<LocalDateTime, LocalDateTime> d) {
                return d.getFirst().until(d.getSecond(), ChronoUnit.SECONDS);
            }
        }),
        daMILLISECOND("MILLISECOND", new Function<Pair<LocalDateTime, LocalDateTime>, Long>(){

            @Override
            public Long apply(Pair<LocalDateTime, LocalDateTime> d) {
                return d.getFirst().until(d.getSecond(), ChronoUnit.MILLIS);
            }
        }),
        daMICROSECOND("MICROSECOND", new Function<Pair<LocalDateTime, LocalDateTime>, Long>(){

            @Override
            public Long apply(Pair<LocalDateTime, LocalDateTime> d) {
                return d.getFirst().until(d.getSecond(), ChronoUnit.MICROS);
            }
        }),
        daNANOSECOND("NANOSECOND", new Function<Pair<LocalDateTime, LocalDateTime>, Long>(){

            @Override
            public Long apply(Pair<LocalDateTime, LocalDateTime> d) {
                return d.getFirst().until(d.getSecond(), ChronoUnit.NANOS);
            }
        }),
        daWEEK("WEEK", new Function<Pair<LocalDateTime, LocalDateTime>, Long>(){

            @Override
            public Long apply(Pair<LocalDateTime, LocalDateTime> d) {
                return d.getFirst().until(d.getSecond(), ChronoUnit.WEEKS);
            }
        });

        private String sqlToken;
        private Function<Pair<LocalDateTime, LocalDateTime>, Long> diff;

        private DateDiffUnit(String token, Function<Pair<LocalDateTime, LocalDateTime>, Long> diff) {
            this.sqlToken = token;
            this.diff = diff;
        }
    }

    static enum DateExtractUnit {
        daYEAR("YEAR", new Function<LocalDateTime, Long>(){

            @Override
            public Long apply(LocalDateTime t) {
                return t.get(ChronoField.YEAR);
            }
        }),
        daQUARTER("QUARTER", new Function<LocalDateTime, Long>(){

            @Override
            public Long apply(LocalDateTime t) {
                int month = t.get(ChronoField.MONTH_OF_YEAR);
                switch (month) {
                    case 1: 
                    case 2: 
                    case 3: {
                        return 1L;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        return 2L;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        return 3L;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        return 4L;
                    }
                }
                return -1L;
            }
        }),
        daMONTH("MONTH", new Function<LocalDateTime, Long>(){

            @Override
            public Long apply(LocalDateTime t) {
                return t.get(ChronoField.MONTH_OF_YEAR);
            }
        }),
        daDAY("DAY", new Function<LocalDateTime, Long>(){

            @Override
            public Long apply(LocalDateTime t) {
                return t.get(ChronoField.DAY_OF_MONTH);
            }
        }),
        daHOUR("HOUR", new Function<LocalDateTime, Long>(){

            @Override
            public Long apply(LocalDateTime t) {
                return t.get(ChronoField.HOUR_OF_DAY);
            }
        }),
        daMINUTE("MINUTE", new Function<LocalDateTime, Long>(){

            @Override
            public Long apply(LocalDateTime t) {
                return t.get(ChronoField.MINUTE_OF_HOUR);
            }
        }),
        daSECOND("SECOND", new Function<LocalDateTime, Long>(){

            @Override
            public Long apply(LocalDateTime t) {
                return t.get(ChronoField.SECOND_OF_MINUTE);
            }
        }),
        daMILLISECOND("MILLISECOND", new Function<LocalDateTime, Long>(){

            @Override
            public Long apply(LocalDateTime t) {
                return (long)t.get(ChronoField.MILLI_OF_SECOND) + 1000L * (long)t.get(ChronoField.SECOND_OF_MINUTE);
            }
        }),
        daMICROSECOND("MICROSECOND", new Function<LocalDateTime, Long>(){

            @Override
            public Long apply(LocalDateTime t) {
                return (long)t.get(ChronoField.MICRO_OF_SECOND) + 1000000L * (long)t.get(ChronoField.SECOND_OF_MINUTE);
            }
        }),
        daNANOSECOND("NANOSECOND", new Function<LocalDateTime, Long>(){

            @Override
            public Long apply(LocalDateTime t) {
                return (long)t.get(ChronoField.NANO_OF_SECOND) + 1000000000L * (long)t.get(ChronoField.SECOND_OF_MINUTE);
            }
        }),
        daWEEK("WEEK", new Function<LocalDateTime, Long>(){

            @Override
            public Long apply(LocalDateTime t) {
                LocalDateTime year = DateTruncUnit.dtYEAR.trunc.apply(t);
                LocalDateTime week = DateTruncUnit.dtWEEK.trunc.apply(year = year.plusDays(3L));
                if (week.compareTo(t) > 0) {
                    year = year.minusYears(1L);
                    week = DateTruncUnit.dtWEEK.trunc.apply(year);
                }
                int weeks = 0;
                while (week.compareTo(t) <= 0) {
                    ++weeks;
                    week = week.plusWeeks(1L);
                }
                return weeks;
            }
        }),
        daDAYOFYEAR("DOY", new Function<LocalDateTime, Long>(){

            @Override
            public Long apply(LocalDateTime t) {
                return t.get(ChronoField.DAY_OF_YEAR);
            }
        });

        private String sqlToken;
        private Function<LocalDateTime, Long> extract;

        private DateExtractUnit(String token, Function<LocalDateTime, Long> f) {
            this.sqlToken = token;
            this.extract = f;
        }
    }

    static enum DateTruncUnit {
        dtYEAR("YEAR", new Function<LocalDateTime, LocalDateTime>(){

            @Override
            public LocalDateTime apply(LocalDateTime t) {
                t = t.withMonth(1);
                t = t.withDayOfMonth(1);
                t = t.truncatedTo(ChronoUnit.DAYS);
                return t;
            }
        }),
        dtQUARTER("QUARTER", new Function<LocalDateTime, LocalDateTime>(){

            @Override
            public LocalDateTime apply(LocalDateTime t) {
                int month = t.getMonthValue();
                switch (month) {
                    case 10: 
                    case 11: 
                    case 12: {
                        t = t.withMonth(10);
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        t = t.withMonth(7);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        t = t.withMonth(4);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        t = t.withMonth(1);
                    }
                }
                t = t.withDayOfMonth(1);
                t = t.truncatedTo(ChronoUnit.DAYS);
                return t;
            }
        }),
        dtMONTH("MONTH", new Function<LocalDateTime, LocalDateTime>(){

            @Override
            public LocalDateTime apply(LocalDateTime t) {
                t = t.withDayOfMonth(1);
                t = t.truncatedTo(ChronoUnit.DAYS);
                return t;
            }
        }),
        dtDAY("DAY", new Function<LocalDateTime, LocalDateTime>(){

            @Override
            public LocalDateTime apply(LocalDateTime t) {
                t = t.truncatedTo(ChronoUnit.DAYS);
                return t;
            }
        }),
        dtHOUR("HOUR", new Function<LocalDateTime, LocalDateTime>(){

            @Override
            public LocalDateTime apply(LocalDateTime t) {
                t = t.truncatedTo(ChronoUnit.HOURS);
                return t;
            }
        }),
        dtMINUTE("MINUTE", new Function<LocalDateTime, LocalDateTime>(){

            @Override
            public LocalDateTime apply(LocalDateTime t) {
                t = t.truncatedTo(ChronoUnit.MINUTES);
                return t;
            }
        }),
        dtSECOND("SECOND", new Function<LocalDateTime, LocalDateTime>(){

            @Override
            public LocalDateTime apply(LocalDateTime t) {
                t = t.truncatedTo(ChronoUnit.SECONDS);
                return t;
            }
        }),
        dtCENTURY("CENTURY", new Function<LocalDateTime, LocalDateTime>(){

            @Override
            public LocalDateTime apply(LocalDateTime t) {
                int range;
                int year = t.getYear();
                int diff = year % (range = 100);
                if (diff == 0) {
                    diff = range;
                }
                t = t.withYear((year -= diff) + 1);
                t = t.withMonth(1);
                t = t.withDayOfMonth(1);
                t = t.truncatedTo(ChronoUnit.DAYS);
                return t;
            }
        }),
        dtDECADE("DECADE", new Function<LocalDateTime, LocalDateTime>(){

            @Override
            public LocalDateTime apply(LocalDateTime t) {
                int year = t.getYear();
                int range = 10;
                int diff = year % range;
                t = t.withYear(year -= diff);
                t = t.withMonth(1);
                t = t.withDayOfMonth(1);
                t = t.truncatedTo(ChronoUnit.DAYS);
                return t;
            }
        }),
        dtMILLISECOND("MILLISECOND", new Function<LocalDateTime, LocalDateTime>(){

            @Override
            public LocalDateTime apply(LocalDateTime t) {
                t = t.truncatedTo(ChronoUnit.MILLIS);
                return t;
            }
        }),
        dtMICROSECOND("MICROSECOND", new Function<LocalDateTime, LocalDateTime>(){

            @Override
            public LocalDateTime apply(LocalDateTime t) {
                t = t.truncatedTo(ChronoUnit.MICROS);
                return t;
            }
        }),
        dtNANOSECOND("NANOSECOND", new Function<LocalDateTime, LocalDateTime>(){

            @Override
            public LocalDateTime apply(LocalDateTime t) {
                t = t.truncatedTo(ChronoUnit.NANOS);
                return t;
            }
        }),
        dtWEEK("WEEK", new Function<LocalDateTime, LocalDateTime>(){

            @Override
            public LocalDateTime apply(LocalDateTime t) {
                t = t.with(ChronoField.DAY_OF_WEEK, 1L);
                t = t.truncatedTo(ChronoUnit.DAYS);
                return t;
            }
        });

        private String sqlToken;
        Function<LocalDateTime, LocalDateTime> trunc;

        private DateTruncUnit(String token, Function<LocalDateTime, LocalDateTime> trunc) {
            this.sqlToken = token;
            this.trunc = trunc;
        }
    }
}

