/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.tests;

import com.mapd.tests.ConcurrencyTest;
import com.mapd.tests.HeavyDBTestClient;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DdlConcurrencyTest
extends ConcurrencyTest {
    static File scratchDir;
    static String scratchDirPath;

    public static void main(String[] args) throws Exception {
        DdlConcurrencyTest.configure();
        scratchDir = new File("./scratch");
        scratchDirPath = scratchDir.getCanonicalPath();
        DdlConcurrencyTest test = new DdlConcurrencyTest();
        test.testConcurrency();
    }

    public static void configure() {
        logger = DdlConcurrencyTest.getLogger();
        testName = DdlConcurrencyTest.getTestName();
        ports = DdlConcurrencyTest.getPorts();
        numThreads = DdlConcurrencyTest.getNumThreads();
        numIterations = DdlConcurrencyTest.getNumIterations();
        enableHeavyConnect = DdlConcurrencyTest.getEnableHeavyConnect();
        enableMonitorThread = DdlConcurrencyTest.getEnableMonitorThread();
        logger.info(DdlConcurrencyTest.getConfig());
    }

    public static Logger getLogger() {
        return LoggerFactory.getLogger(DdlConcurrencyTest.class);
    }

    public static String getTestName() {
        return "DdlConcurrencyTest";
    }

    @Override
    public List<ConcurrencyTest.SqlCommandThread[]> createTestThreads() {
        logger.info("Initializing test threads...");
        ArrayList<ConcurrencyTest.SqlCommandThread[]> tests = new ArrayList<ConcurrencyTest.SqlCommandThread[]>();
        tests.add(this.makeTests("ShowTable", "SHOW TABLES;"));
        tests.add(this.makeTests("ShowTableDetails", "SHOW TABLE DETAILS;"));
        tests.add(this.makeTests("ShowCreateTable", "SHOW CREATE TABLE test_table;"));
        tests.add(this.makeTests("ShowServers", "SHOW SERVERS;"));
        tests.add(this.makeTests("ShowCreateServer", "SHOW CREATE SERVER test_server;"));
        tests.add(this.makeTests("ShowFunctions", "SHOW FUNCTIONS;"));
        tests.add(this.makeTests("ShowRuntimeFunctions", "SHOW RUNTIME FUNCTIONS;"));
        tests.add(this.makeTests("ShowRuntimeTF", "SHOW RUNTIME TABLE FUNCTIONS;"));
        tests.add(this.makeTests("AlterDatabase", "ALTER DATABASE TestDB OWNER TO admin;"));
        tests.add(this.makeTests("ShowUserDetails", "SHOW USER DETAILS;"));
        tests.add(this.makeTests("ShowRoles", "SHOW ROLES"));
        tests.add(this.makeTests("ReassignOwned", "REASSIGN OWNED BY test_user TO admin;"));
        tests.add(this.makeTests("CreatePolicy", "CREATE POLICY ON COLUMN test_table.i TO test_user VALUES (1);", "already exists"));
        tests.add(this.makeTests("DropPolicy", "DROP POLICY ON COLUMN test_table.i FROM test_user;", "not found"));
        tests.add(this.makeTests("ShowPolicy", "SHOW POLICIES test_user;"));
        tests.add(this.makeTests("ShowSupportedDataSources", "SHOW POLICIES test_user;"));
        tests.add(this.makeTests("CreateTable", "CREATE TABLE IF NOT EXISTS test_table_<threadId> (i int);"));
        tests.add(this.makeTests("DropTable", "DROP TABLE IF EXISTS test_table_<threadId>;"));
        tests.add(this.makeTests("InsertTable", "INSERT INTO test_table (i) VALUES (2);"));
        tests.add(this.makeTests("UpdateTable", "UPDATE test_table SET i = 3 WHERE i = 2;"));
        tests.add(this.makeTests("AddColumn", "ALTER TABLE test_table ADD (x int DEFAULT 1);", "already exists"));
        tests.add(this.makeTests("DropColumn", "ALTER TABLE test_table DROP COLUMN x;", "does not exist"));
        tests.add(this.makeTests("RenameTable", "ALTER TABLE test_table_<threadId> RENAME TO altered_table_<threadId>;", Arrays.asList("not exist", "Attempted to overwrite")));
        tests.add(this.makeTests("DumpTable", "DUMP TABLE test_table to '" + scratchDirPath + "/dump.gz';", "exists"));
        tests.add(this.makeTests("RestoreTable", "RESTORE TABLE restore_table_<threadId> from '" + scratchDirPath + "/dump.gz';", Arrays.asList("does not exist", "exists"), "DROP TABLE IF EXISTS restore_table_<threadId>;"));
        tests.add(this.makeTests("TruncateTable", "TRUNCATE TABLE test_table;"));
        tests.add(this.makeTests("OptimizeTable", "OPTIMIZE TABLE test_table;"));
        tests.add(this.makeTests("CopyFrom", "COPY test_table FROM '../Tests/FsiDataFiles/1.csv';"));
        tests.add(this.makeTests("CopyTo", "COPY (SELECT * FROM test_table) TO '" + scratchDirPath + "/copy.csv';", "exists"));
        tests.add(this.makeTests("CreateDB", "CREATE DATABASE IF NOT EXISTS test_db_<threadId>;", Collections.emptyList(), "DROP DATABASE IF EXISTS test_db_<threadId>;"));
        tests.add(this.makeTests("DropDB", "DROP DATABASE IF EXISTS test_db_<threadId>;"));
        tests.add(this.makeTests("CreateUser", "CREATE USER test_user_<threadId> (password = 'pass');", "exists", "DROP USER IF EXISTS test_user_<threadId>;"));
        tests.add(this.makeTests("DropUser", "DROP USER IF EXISTS test_user_<threadId>;"));
        tests.add(this.makeTests("AlterUser", "ALTER USER test_user (password = 'pass');"));
        tests.add(this.makeTests("RenameUser", "ALTER USER test_user_<threadId> RENAME TO altered_user_<threadId>;", Arrays.asList("doesn't exist", "already exists", "does not exist"), "DROP USER IF EXISTS altered_user_<threadId>;"));
        tests.add(this.makeTests("CreateRole", "CREATE ROLE test_role_<threadId>;", "already exists", "DROP ROLE IF EXISTS test_role_<threadId>;"));
        tests.add(this.makeTests("DropRole", "DROP ROLE IF EXISTS test_role_<threadId>;"));
        tests.add(this.makeTests("GrantRole", "GRANT test_role_<threadId> TO test_user;", "does not exist"));
        tests.add(this.makeTests("RevokeRole", "REVOKE test_role_<threadId> FROM test_user;", Arrays.asList("does not exist", "have not been granted")));
        tests.add(this.makeTests("ValidateSystem", "Validate"));
        tests.add(this.makeTests("CreateView", "CREATE VIEW IF NOT EXISTS test_view_<threadId> AS (SELECT * FROM test_table);"));
        tests.add(this.makeTests("DropView", "DROP VIEW IF EXISTS test_view_<threadId>;"));
        if (enableHeavyConnect) {
            tests.add(this.makeTests("CreateServer", "CREATE SERVER IF NOT EXISTS test_server_<threadId> FOREIGN DATA WRAPPER delimited_file WITH (storage_type = 'LOCAL_FILE', base_path = '" + System.getProperty("user.dir") + "');"));
            tests.add(this.makeTests("DropServer", "DROP SERVER IF EXISTS test_server_<threadId>;"));
            tests.add(this.makeTests("AlterServer", "ALTER SERVER test_server SET (s3_bucket = 'diff_bucket');"));
            tests.add(this.makeTests("CreateForeignTable", "CREATE FOREIGN TABLE IF NOT EXISTS test_foreign_table_<threadId> (b BOOLEAN, t TINYINT, s SMALLINT, i INTEGER, bi BIGINT, f FLOAT, dc DECIMAL(10, 5), tm TIME, tp TIMESTAMP, d DATE, txt TEXT, txt_2 TEXT ENCODING NONE) SERVER default_local_delimited WITH (file_path = '../Tests/FsiDataFiles/scalar_types.csv', FRAGMENT_SIZE = 10);"));
            tests.add(this.makeTests("DropForeignTable", "DROP FOREIGN TABLE IF EXISTS test_foreign_table_<threadId>;"));
            tests.add(this.makeTests("CreateUserMapping", "CREATE USER MAPPING IF NOT EXISTS FOR PUBLIC SERVER test_server WITH (S3_ACCESS_KEY = 'test_key', S3_SECRET_KEY = 'test_key');"));
            tests.add(this.makeTests("DropUserMapping", "DROP USER MAPPING IF EXISTS FOR PUBLIC SERVER test_server;"));
            tests.add(this.makeTests("AlterForeignTable", "ALTER FOREIGN TABLE test_foreign_table SET (refresh_update_type = 'APPEND');"));
            tests.add(this.makeTests("ShowDiskCacheUsage", "SHOW DISK CACHE USAGE;"));
            tests.add(this.makeTests("RefreshForeignTable", "REFRESH FOREIGN TABLES test_foreign_table_<threadId>;", "does not exist"));
        }
        logger.info("Initialized test threads.");
        return tests;
    }

    public static List<String> customizeQueriesByThreadId(List<String> queries, int threadId) {
        ArrayList<String> customQueries = new ArrayList<String>();
        for (String query : queries) {
            customQueries.add(query.replaceAll("<threadId>", Integer.toString(threadId)));
        }
        return customQueries;
    }

    public final ConcurrencyTest.SqlCommandThread[] makeTests(String threadName, List<String> queries, List<String> expectedExceptions, List<String> cleanUpQueries, int numThreads) {
        ConcurrencyTest.SqlCommandThread[] threadGroup = new ConcurrencyTest.SqlCommandThread[numThreads];
        for (int threadId = 0; threadId < numThreads; ++threadId) {
            List<String> customQueries = DdlConcurrencyTest.customizeQueriesByThreadId(queries, threadId);
            List<String> customCleanUps = DdlConcurrencyTest.customizeQueriesByThreadId(cleanUpQueries, threadId);
            threadGroup[threadId] = new ConcurrencyTest.SqlCommandThread(this, threadName, customQueries, threadId, expectedExceptions, customCleanUps);
        }
        return threadGroup;
    }

    public final ConcurrencyTest.SqlCommandThread[] makeTests(String threadName, String query) {
        return this.makeTests(threadName, Arrays.asList(query), Collections.emptyList(), Collections.emptyList(), numThreads);
    }

    public final ConcurrencyTest.SqlCommandThread[] makeTests(String threadName, String query, String exception) {
        return this.makeTests(threadName, Arrays.asList(query), Arrays.asList(exception), Collections.emptyList(), numThreads);
    }

    public final ConcurrencyTest.SqlCommandThread[] makeTests(String threadName, String query, List<String> exceptions) {
        return this.makeTests(threadName, Arrays.asList(query), exceptions, Collections.emptyList(), numThreads);
    }

    public final ConcurrencyTest.SqlCommandThread[] makeTests(String threadName, String query, List<String> exceptions, String cleanUpQueries) {
        return this.makeTests(threadName, Arrays.asList(query), exceptions, Arrays.asList(cleanUpQueries), numThreads);
    }

    public final ConcurrencyTest.SqlCommandThread[] makeTests(String threadName, String query, String exceptions, String cleanUpQueries) {
        return this.makeTests(threadName, Arrays.asList(query), Arrays.asList(exceptions), Arrays.asList(cleanUpQueries), numThreads);
    }

    @Override
    public void setUpTests() throws Exception {
        logger.info("Starting Setup...");
        scratchDir.mkdirs();
        HeavyDBTestClient heavyAdmin = this.getAdminClient("heavyai");
        this.runAndLog(heavyAdmin, "DROP DATABASE IF EXISTS TestDB;");
        this.runAndLog(heavyAdmin, "CREATE DATABASE TestDB;");
        HeavyDBTestClient dbAdmin = this.getAdminClient("TestDB");
        this.runAndLog(dbAdmin, "DROP USER IF EXISTS test_user");
        this.runAndLog(dbAdmin, "CREATE USER test_user (password = 'pass');");
        this.runAndLog(dbAdmin, "CREATE TABLE test_table (i int);");
        if (enableHeavyConnect) {
            this.runAndLog(dbAdmin, "CREATE SERVER test_server FOREIGN DATA WRAPPER delimited_file WITH (storage_type = 'AWS_S3', s3_bucket = 'test_bucket', aws_region = 'test_region');");
            this.runAndLog(dbAdmin, "CREATE FOREIGN TABLE IF NOT EXISTS test_foreign_table (b BOOLEAN, t TINYINT, s SMALLINT, i INTEGER, bi BIGINT, f FLOAT, dc DECIMAL(10, 5), tm TIME, tp TIMESTAMP, d DATE, txt TEXT, txt_2 TEXT ENCODING NONE) SERVER default_local_delimited WITH (file_path = '../Tests/FsiDataFiles/scalar_types.csv', FRAGMENT_SIZE = 10);");
        }
        logger.info("Finished Setup.");
    }

    @Override
    public void cleanUpTests(List<ConcurrencyTest.SqlCommandThread[]> tests) throws Exception {
        logger.info("Starting cleanup...");
        HeavyDBTestClient heavyAdmin = this.getAdminClient("heavyai");
        this.runAndLog(heavyAdmin, "DROP USER test_user;");
        this.runAndLog(heavyAdmin, "DROP DATABASE TestDB;");
        for (ConcurrencyTest.SqlCommandThread[] testGroup : tests) {
            for (ConcurrencyTest.SqlCommandThread test : testGroup) {
                for (String query : test.cleanUpQueries) {
                    this.runAndLog(heavyAdmin, query);
                }
            }
        }
        DdlConcurrencyTest.deleteDirectory(scratchDir);
        logger.info("Finished cleanup.");
    }

    @Override
    public void runTests(List<ConcurrencyTest.SqlCommandThread[]> tests) throws Exception {
        logger.info("starting runTests.");
        int numTests = 0;
        for (ConcurrencyTest.SqlCommandThread[] threadGroup : tests) {
            numTests += threadGroup.length;
        }
        this.barrier = DdlConcurrencyTest.createBarrier(numTests);
        for (ConcurrencyTest.SqlCommandThread[] threadGroup : tests) {
            for (ConcurrencyTest.SqlCommandThread thread : threadGroup) {
                thread.start();
            }
        }
        logger.info("Waiting for threads to sync...");
        if (enableMonitorThread) {
            new ConcurrencyTest.MonitoringThread(this, tests, numThreads).start();
        }
        for (ConcurrencyTest.SqlCommandThread[] threadGroup : tests) {
            for (ConcurrencyTest.SqlCommandThread thread : threadGroup) {
                thread.join();
            }
        }
        DdlConcurrencyTest.printErrors(this.exceptionTexts);
        logger.info("Finished runTests.");
    }
}

