/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.tests;

import com.mapd.tests.HeavyDBTestClient;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CyclicBarrier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumpRestoreConcurrencyTest {
    static final Logger logger = LoggerFactory.getLogger(DumpRestoreConcurrencyTest.class);
    static String tar_ball_path_prefix = "/tmp/_Orz__";

    public static void main(String[] args) throws Exception {
        DumpRestoreConcurrencyTest test = new DumpRestoreConcurrencyTest();
        test.testConcurrency();
    }

    public void testConcurrency() throws Exception {
        logger.info("DumpRestoreConcurrencyTest()");
        this.runTest();
        logger.info("DumpRestoreConcurrencyTest() done");
    }

    private void deleteFileIfExist(String file) {
        try {
            Files.deleteIfExists(new File(file).toPath());
        }
        catch (Exception e) {
            logger.error("While Deleting Archives Caught Exception: " + e.getMessage(), e);
        }
    }

    List<String> getDumpRestoreQueries(String table_identifier) {
        return Arrays.asList("DROP TABLE IF EXISTS " + table_identifier + ";", "DROP TABLE IF EXISTS restored_" + table_identifier + ";", "CREATE TABLE " + table_identifier + " (v INT);", "INSERT INTO " + table_identifier + " VALUES (1),(2);", "DUMP TABLE " + table_identifier + " TO '" + tar_ball_path_prefix + "_" + table_identifier + "';", "RESTORE TABLE restored_" + table_identifier + " FROM '" + tar_ball_path_prefix + "_" + table_identifier + "';");
    }

    private void runTest() throws Exception {
        ArrayList<ThreadDbDumpRestoreQueries> queriesPerThread = new ArrayList<ThreadDbDumpRestoreQueries>(Arrays.asList(new ThreadDbDumpRestoreQueries(tar_ball_path_prefix + "_aa", this.getDumpRestoreQueries("aa")), new ThreadDbDumpRestoreQueries(tar_ball_path_prefix + "_bb", this.getDumpRestoreQueries("bb")), new ThreadDbDumpRestoreQueries(tar_ball_path_prefix + "_cc", this.getDumpRestoreQueries("cc")), new ThreadDbDumpRestoreQueries(tar_ball_path_prefix + "_dd", this.getDumpRestoreQueries("dd")), new ThreadDbDumpRestoreQueries(tar_ball_path_prefix + "_ee", this.getDumpRestoreQueries("ee"))));
        int num_threads = queriesPerThread.size();
        Exception[] exceptions = new Exception[num_threads];
        Thread[] threads = new Thread[num_threads];
        CyclicBarrier barrier = new CyclicBarrier(num_threads, () -> logger.info("Barrier acquired. Starting queries..."));
        int i22 = 0;
        while (i22 < queriesPerThread.size()) {
            ThreadDbDumpRestoreQueries threadQueries = (ThreadDbDumpRestoreQueries)queriesPerThread.get(i22);
            int threadId = i22++;
            threads[threadId] = new Thread(() -> {
                try {
                    logger.info("Starting thread[" + threadId + "]");
                    HeavyDBTestClient user = HeavyDBTestClient.getClient("localhost", 6274, "heavyai", "admin", "HyperInteractive");
                    this.deleteFileIfExist(threadQueries.archive);
                    barrier.await();
                    for (String query : threadQueries.queries) {
                        this.runSqlAsUser(query, user, threadId);
                    }
                    logger.info("Finished thread[" + threadId + "]");
                }
                catch (Exception e) {
                    logger.error("Thread[" + threadId + "] Caught Exception: " + e.getMessage(), e);
                    exceptions[threadId] = e;
                }
            });
            threads[threadId].start();
        }
        Thread[] i22 = threads;
        int threadQueries = i22.length;
        for (int i = 0; i < threadQueries; ++i) {
            Thread t = i22[i];
            t.join();
        }
        for (int i = 0; i < queriesPerThread.size(); ++i) {
            ThreadDbDumpRestoreQueries threadQueries2 = (ThreadDbDumpRestoreQueries)queriesPerThread.get(i);
            this.deleteFileIfExist(threadQueries2.archive);
        }
        for (Exception e : exceptions) {
            if (e == null) continue;
            logger.error("Exception: " + e.getMessage(), e);
            throw e;
        }
    }

    private void runSqlAsUser(String sql, HeavyDBTestClient user, int threadId) throws Exception {
        logger.info(threadId + " " + sql);
        user.runSql(sql);
    }

    private class ThreadDbDumpRestoreQueries {
        public final String archive;
        public final List<String> queries;

        public ThreadDbDumpRestoreQueries(String archive_file, List<String> queries) {
            this.archive = archive_file;
            this.queries = queries;
        }
    }
}

