/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.tests;

import com.mapd.tests.HeavyDBTestClient;
import java.util.ArrayList;
import java.util.concurrent.CyclicBarrier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForeignStorageConcurrencyTest {
    static final Logger logger = LoggerFactory.getLogger(ForeignStorageConcurrencyTest.class);

    public static void main(String[] args) throws Exception {
        ForeignStorageConcurrencyTest test = new ForeignStorageConcurrencyTest();
        test.testConcurrency();
    }

    private void runTest(final String db, final String adminName, final String adminPassword, final String userName, final String userPassword) throws Exception {
        int num_threads = 4;
        final ArrayList exceptions = new ArrayList();
        final CyclicBarrier barrier = new CyclicBarrier(4, new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info("Barrier acquired.");
                    HeavyDBTestClient dba = HeavyDBTestClient.getClient("localhost", 6274, db, adminName, adminPassword);
                    dba.runSql("CREATE SERVER test_server FOREIGN DATA WRAPPER delimited_file WITH (storage_type = 'LOCAL_FILE', base_path = '" + System.getProperty("user.dir") + "');");
                    dba.runSql("CREATE FOREIGN TABLE test_table (b BOOLEAN, t TINYINT, s SMALLINT, i INTEGER, bi BIGINT, f FLOAT, dc DECIMAL(10, 5), tm TIME, tp TIMESTAMP, d DATE, txt TEXT, txt_2 TEXT ENCODING NONE) SERVER test_server WITH (file_path = '../Tests/FsiDataFiles/scalar_types.csv', FRAGMENT_SIZE = 10);");
                    logger.info("Barrier released.");
                }
                catch (Exception e) {
                    logger.error("Barrier Caught Exception: " + e.getMessage(), e);
                    exceptions.add(e);
                }
            }
        });
        Thread[] threads = new Thread[4];
        threads[0] = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info("Starting thread[0]");
                    HeavyDBTestClient user = HeavyDBTestClient.getClient("localhost", 6274, db, userName, userPassword);
                    barrier.await();
                    ForeignStorageConcurrencyTest.this.runSqlAsUser("ALTER FOREIGN TABLE test_table RENAME COLUMN t TO tint", user, "0");
                    ForeignStorageConcurrencyTest.this.runSqlAsUser("SELECT * FROM test_table LIMIT 2", user, "0");
                    ForeignStorageConcurrencyTest.this.runSqlAsUser("SELECT * FROM test_table WHERE txt = 'quoted text'", user, "0");
                    ForeignStorageConcurrencyTest.this.runSqlValidateAsUser("SELECT COUNT(*) FROM test_table LIMIT 2", user, "0");
                    logger.info("Finished thread[0]");
                }
                catch (Exception e) {
                    logger.error("Thread[0] Caught Exception: " + e.getMessage(), e);
                    exceptions.add(e);
                }
            }
        });
        threads[0].start();
        threads[1] = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info("Starting thread[1]");
                    HeavyDBTestClient user = HeavyDBTestClient.getClient("localhost", 6274, db, userName, userPassword);
                    barrier.await();
                    ForeignStorageConcurrencyTest.this.runSqlAsUser("SELECT * FROM test_table LIMIT 2", user, "1");
                    ForeignStorageConcurrencyTest.this.runSqlAsUser("ALTER FOREIGN TABLE test_table RENAME COLUMN s TO sint", user, "1");
                    ForeignStorageConcurrencyTest.this.runSqlAsUser("SELECT * FROM test_table WHERE txt = 'quoted text'", user, "1");
                    ForeignStorageConcurrencyTest.this.runSqlValidateAsUser("SELECT COUNT(*) FROM test_table LIMIT 2", user, "1");
                    logger.info("Finished thread[1]");
                }
                catch (Exception e) {
                    logger.error("Thread[1] Caught Exception: " + e.getMessage(), e);
                    exceptions.add(e);
                }
            }
        });
        threads[1].start();
        threads[2] = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info("Starting thread[2]");
                    HeavyDBTestClient user = HeavyDBTestClient.getClient("localhost", 6274, db, userName, userPassword);
                    barrier.await();
                    ForeignStorageConcurrencyTest.this.runSqlAsUser("SELECT * FROM test_table LIMIT 2", user, "2");
                    ForeignStorageConcurrencyTest.this.runSqlAsUser("SELECT * FROM test_table WHERE txt = 'quoted text'", user, "2");
                    ForeignStorageConcurrencyTest.this.runSqlAsUser("ALTER FOREIGN TABLE test_table RENAME COLUMN i TO iint", user, "2");
                    ForeignStorageConcurrencyTest.this.runSqlValidateAsUser("SELECT COUNT(*) FROM test_table LIMIT 2", user, "2");
                    logger.info("Finished thread[2]");
                }
                catch (Exception e) {
                    logger.error("Thread[0] Caught Exception: " + e.getMessage(), e);
                    exceptions.add(e);
                }
            }
        });
        threads[2].start();
        threads[3] = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info("Starting thread[3]");
                    HeavyDBTestClient user = HeavyDBTestClient.getClient("localhost", 6274, db, userName, userPassword);
                    barrier.await();
                    ForeignStorageConcurrencyTest.this.runSqlAsUser("SELECT * FROM test_table LIMIT 2", user, "3");
                    ForeignStorageConcurrencyTest.this.runSqlAsUser("SELECT * FROM test_table WHERE txt = 'quoted text'", user, "3");
                    ForeignStorageConcurrencyTest.this.runSqlValidateAsUser("SELECT COUNT(*) FROM test_table LIMIT 2", user, "3");
                    ForeignStorageConcurrencyTest.this.runSqlAsUser("ALTER FOREIGN TABLE test_table RENAME COLUMN b TO bint", user, "3");
                    logger.info("Finished thread[3]");
                }
                catch (Exception e) {
                    logger.error("Thread[0] Caught Exception: " + e.getMessage(), e);
                    exceptions.add(e);
                }
            }
        });
        threads[3].start();
        for (Thread t : threads) {
            t.join();
        }
        HeavyDBTestClient dba = HeavyDBTestClient.getClient("localhost", 6274, db, adminName, adminPassword);
        dba.runSql("DROP FOREIGN TABLE test_table;");
        dba.runSql("DROP SERVER test_server;");
        for (Exception e : exceptions) {
            if (null == e) continue;
            logger.error("Exception: " + e.getMessage(), e);
            throw e;
        }
    }

    public void runSqlAsUser(String sql, HeavyDBTestClient user, String logPrefix) throws Exception {
        logger.info(logPrefix + " " + sql);
        user.runSql(sql);
    }

    public void runSqlValidateAsUser(String sql, HeavyDBTestClient user, String logPrefix) throws Exception {
        logger.info(logPrefix + " " + sql);
        user.sqlValidate(sql);
    }

    public void testConcurrency() throws Exception {
        logger.info("ForeignStorageConcurrencyTest()");
        HeavyDBTestClient su = HeavyDBTestClient.getClient("localhost", 6274, "heavyai", "admin", "HyperInteractive");
        su.runSql("DROP DATABASE IF EXISTS db1;");
        su.runSql("CREATE DATABASE db1;");
        this.runTest("db1", "admin", "HyperInteractive", "admin", "HyperInteractive");
        su.runSql("DROP DATABASE db1;");
        logger.info("ForeignStorageConcurrencyTest() done");
    }
}

