/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.tests;

import ai.heavy.thrift.server.Heavy;
import ai.heavy.thrift.server.TClusterHardwareInfo;
import ai.heavy.thrift.server.TColumn;
import ai.heavy.thrift.server.TColumnData;
import ai.heavy.thrift.server.TColumnType;
import ai.heavy.thrift.server.TCopyParams;
import ai.heavy.thrift.server.TCreateParams;
import ai.heavy.thrift.server.TDBException;
import ai.heavy.thrift.server.TDBObject;
import ai.heavy.thrift.server.TDBObjectType;
import ai.heavy.thrift.server.TDashboard;
import ai.heavy.thrift.server.TDatum;
import ai.heavy.thrift.server.TDatumVal;
import ai.heavy.thrift.server.TNodeMemoryInfo;
import ai.heavy.thrift.server.TQueryInfo;
import ai.heavy.thrift.server.TQueryResult;
import ai.heavy.thrift.server.TRow;
import ai.heavy.thrift.server.TServerStatus;
import ai.heavy.thrift.server.TStringRow;
import ai.heavy.thrift.server.TStringValue;
import ai.heavy.thrift.server.TTableDetails;
import ai.heavy.thrift.server.TTableMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.transport.TSocket;

public class HeavyDBTestClient {
    Heavy.Client client;
    String sessionId;

    public TServerStatus get_server_status() throws TDBException, TException {
        return this.client.get_server_status(this.sessionId);
    }

    public List<TServerStatus> get_status() throws TDBException, TException {
        return this.client.get_status(this.sessionId);
    }

    public TClusterHardwareInfo get_hardware_info() throws TDBException, TException {
        return this.client.get_hardware_info(this.sessionId);
    }

    public List<TNodeMemoryInfo> get_memory(String memory_level) throws TDBException, TException {
        return this.client.get_memory(this.sessionId, memory_level);
    }

    public TTableDetails get_table_details(String table_name) throws Exception {
        return this.client.get_table_details(this.sessionId, table_name);
    }

    public TTableDetails get_table_details_for_database(String tableName, String databaseName) throws Exception {
        return this.client.get_table_details_for_database(this.sessionId, tableName, databaseName);
    }

    public List<TTableMeta> get_tables_meta() throws TDBException, Exception {
        return this.client.get_tables_meta(this.sessionId);
    }

    public TQueryResult runSql(String sql) throws Exception {
        return this.client.sql_execute(this.sessionId, sql, true, null, -1, -1);
    }

    public List<TColumnType> sqlValidate(String sql) throws Exception {
        return this.client.sql_validate(this.sessionId, sql);
    }

    public int create_dashboard(String name) throws Exception {
        return this.client.create_dashboard(this.sessionId, name, "STATE", name + "_hash", name + "_meta");
    }

    public void replace_dashboard(int dashboard_id, String name, String new_owner) throws Exception {
        this.client.replace_dashboard(this.sessionId, dashboard_id, name, new_owner, "STATE", name + "_hash", name + "_meta");
    }

    public TDashboard get_dashboard(int id) throws Exception {
        TDashboard dashboard = this.client.get_dashboard(this.sessionId, id);
        return dashboard;
    }

    public void delete_dashboard(int id) throws Exception {
        this.client.delete_dashboard(this.sessionId, id);
    }

    public List<TDashboard> get_dashboards() throws Exception {
        return this.client.get_dashboards(this.sessionId);
    }

    public void import_table(String table_name, String file_name, TCopyParams copy_params) throws Exception {
        this.client.import_table(this.sessionId, table_name, file_name, copy_params);
    }

    public void import_geo_table(String table_name, String file_name, TCopyParams copy_params, List<TColumnType> row_desc, TCreateParams create_params) throws Exception {
        this.client.import_geo_table(this.sessionId, table_name, file_name, copy_params, row_desc, create_params);
    }

    public List<String> get_users() throws Exception {
        return this.client.get_users(this.sessionId);
    }

    public List<String> get_roles() throws Exception {
        return this.client.get_roles(this.sessionId);
    }

    public List<TDBObject> get_db_object_privs(String objectName, TDBObjectType type) throws Exception {
        return this.client.get_db_object_privs(this.sessionId, objectName, type);
    }

    public void disconnect() throws Exception {
        this.client.disconnect(this.sessionId);
    }

    public Collection<String> get_all_roles_for_user(String username) throws Exception {
        List<String> roles = this.client.get_all_roles_for_user(this.sessionId, username);
        return new HashSet<String>(roles);
    }

    public List<TQueryInfo> get_queries_info() throws Exception {
        return this.client.get_queries_info(this.sessionId);
    }

    public void load_table(String tableName, List<List<String>> rows, List<String> columnNames) throws Exception {
        ArrayList<TStringRow> load_rows = new ArrayList<TStringRow>();
        for (List<String> row : rows) {
            TStringRow tStringRow = new TStringRow(new ArrayList<TStringValue>());
            for (String value : row) {
                tStringRow.cols.add(new TStringValue(value, false));
            }
            load_rows.add(tStringRow);
        }
        this.client.load_table(this.sessionId, tableName, load_rows, columnNames);
    }

    public void load_table_binary(String tableName, List<List<Object>> rows, List<String> columnNames) throws Exception {
        ArrayList<TRow> load_rows = new ArrayList<TRow>();
        for (List<Object> row : rows) {
            TRow tRow = new TRow(new ArrayList<TDatum>());
            for (Object value : row) {
                tRow.cols.add(this.convertToTDatum(value));
            }
            load_rows.add(tRow);
        }
        this.client.load_table_binary(this.sessionId, tableName, load_rows, columnNames);
    }

    private TDatum convertToTDatum(Object value) {
        TDatumVal tDatumVal = new TDatumVal();
        if (value instanceof Long) {
            tDatumVal.int_val = (Long)value;
        } else if (value instanceof Double) {
            tDatumVal.real_val = (Double)value;
        } else if (value instanceof String) {
            tDatumVal.str_val = (String)value;
        } else if (value instanceof List) {
            tDatumVal.arr_val = new ArrayList<TDatum>();
            for (Object arrayValue : (List)value) {
                tDatumVal.arr_val.add(this.convertToTDatum(arrayValue));
            }
        } else {
            throw new RuntimeException("Unexpected value type. Value: " + value);
        }
        return new TDatum(tDatumVal, false);
    }

    public void load_table_binary_columnar(String tableName, List<List<Object>> columns, List<String> columnNames) throws Exception {
        List<TColumn> load_columns = this.convertToTColumns(columns);
        this.client.load_table_binary_columnar(this.sessionId, tableName, load_columns, columnNames);
    }

    private List<TColumn> convertToTColumns(List<List<Object>> columns) {
        ArrayList<TColumn> load_columns = new ArrayList<TColumn>();
        for (List<Object> column : columns) {
            load_columns.add(this.convertToTColumn(column));
        }
        return load_columns;
    }

    private TColumn convertToTColumn(List<Object> column) {
        TColumn tColumn = new TColumn();
        tColumn.data = new TColumnData(new ArrayList<Long>(), new ArrayList<Double>(), new ArrayList<String>(), new ArrayList<TColumn>());
        tColumn.nulls = new ArrayList<Boolean>();
        for (Object value : column) {
            if (value instanceof Long) {
                tColumn.data.int_col.add((Long)value);
            } else if (value instanceof Double) {
                tColumn.data.real_col.add((Double)value);
            } else if (value instanceof String) {
                tColumn.data.str_col.add((String)value);
            } else if (value instanceof List) {
                tColumn.data.arr_col.add(this.convertToTColumn((List)value));
            } else {
                throw new RuntimeException("Unexpected value type. Value: " + value);
            }
            tColumn.nulls.add(false);
        }
        return tColumn;
    }

    public static HeavyDBTestClient getClient(String host, int port, String db, String user, String password) throws Exception {
        TSocket transport = new TSocket(host, port);
        transport.open();
        TBinaryProtocol protocol = new TBinaryProtocol(transport);
        Heavy.Client client = new Heavy.Client(protocol);
        HeavyDBTestClient session = new HeavyDBTestClient();
        session.client = client;
        session.sessionId = client.connect(user, password, db);
        return session;
    }
}

