/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.tests;

import ai.heavy.thrift.server.TColumnType;
import ai.heavy.thrift.server.TCopyParams;
import ai.heavy.thrift.server.TCreateParams;
import ai.heavy.thrift.server.TDBException;
import ai.heavy.thrift.server.TImportHeaderRow;
import ai.heavy.thrift.server.TSourceType;
import com.mapd.tests.HeavyDBTestClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CyclicBarrier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportAlterValidateSelectConcurrencyTest {
    static final String csvTableName = "import_test_mixed_varlen";
    static final String geoTableName = "geospatial";
    String csv_file_path;
    String geo_file_path;
    static final Logger logger = LoggerFactory.getLogger(ImportAlterValidateSelectConcurrencyTest.class);

    public ImportAlterValidateSelectConcurrencyTest(String csv_file_path, String geo_file_path) {
        this.geo_file_path = geo_file_path;
        this.csv_file_path = csv_file_path;
    }

    public static void main(String[] args) throws Exception {
        assert (args.length == 2);
        ImportAlterValidateSelectConcurrencyTest test = new ImportAlterValidateSelectConcurrencyTest(args[0], args[1]);
        test.testConcurrency();
    }

    private void runTest(final String db, final String dbaUser, final String dbaPassword, final String dbUser, final String dbPassword) throws Exception {
        int num_threads = 4;
        int runs = 25;
        int fragment_size = 10;
        final Exception[] exceptions = new Exception[num_threads];
        final CyclicBarrier barrier = new CyclicBarrier(num_threads, new Runnable(){

            @Override
            public void run() {
                try {
                    HeavyDBTestClient dba = HeavyDBTestClient.getClient("localhost", 6274, db, dbaUser, dbaPassword);
                    dba.runSql("CREATE TABLE import_test_mixed_varlen(pt GEOMETRY(POINT), ls GEOMETRY(LINESTRING), faii INTEGER[2], fadc DECIMAL(5, 2)[2], fatx TEXT[] ENCODING DICT(32), fatx2 TEXT[2] ENCODING DICT(32)) WITH(FRAGMENT_SIZE = 10)");
                    dba.runSql("CREATE TABLE geospatial( trip INT, mpoly MULTIPOLYGON ) WITH(FRAGMENT_SIZE = 10)");
                }
                catch (Exception e) {
                    logger.error("[" + Thread.currentThread().getId() + "] Caught Exception: " + e.getMessage(), e);
                    exceptions[0] = e;
                }
            }
        });
        ArrayList<Thread> threads = new ArrayList<Thread>();
        int i = 0;
        while (i < num_threads) {
            logger.info("Starting " + i);
            final int threadId = i++;
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    long tid = Thread.currentThread().getId();
                    String logPrefix = "[" + tid + "]";
                    String sql = "";
                    TCopyParams copy_params = new TCopyParams();
                    copy_params.has_header = TImportHeaderRow.NO_HEADER;
                    copy_params.delimiter = ",";
                    copy_params.null_str = "\\N";
                    copy_params.quoted = true;
                    copy_params.quote = "\"";
                    copy_params.escape = "\"";
                    copy_params.line_delim = "\n";
                    copy_params.array_delim = ",";
                    copy_params.array_begin = "{";
                    copy_params.array_end = "}";
                    copy_params.threads = 0;
                    TCopyParams geo_copy_params = new TCopyParams();
                    geo_copy_params.delimiter = ",";
                    geo_copy_params.null_str = "\\N";
                    geo_copy_params.quoted = true;
                    geo_copy_params.quote = "\"";
                    geo_copy_params.escape = "\"";
                    geo_copy_params.line_delim = "\n";
                    geo_copy_params.array_delim = ",";
                    geo_copy_params.array_begin = "{";
                    geo_copy_params.array_end = "}";
                    geo_copy_params.threads = 0;
                    geo_copy_params.source_type = TSourceType.GEO_FILE;
                    try {
                        barrier.await();
                        HeavyDBTestClient user = HeavyDBTestClient.getClient("localhost", 6274, db, dbUser, dbPassword);
                        if (threadId % 2 == 0) {
                            logger.info(logPrefix + " IMPORT TABLE");
                            user.import_table(ImportAlterValidateSelectConcurrencyTest.csvTableName, ImportAlterValidateSelectConcurrencyTest.this.csv_file_path, copy_params);
                            if (threadId == 0) {
                                ImportAlterValidateSelectConcurrencyTest.this.loadTable(user, logPrefix);
                            } else {
                                ImportAlterValidateSelectConcurrencyTest.this.loadTableBinaryColumnar(user, logPrefix);
                                sql = "COPY import_test_mixed_varlen FROM '" + ImportAlterValidateSelectConcurrencyTest.this.csv_file_path + "' WITH (header = 'false');";
                                ImportAlterValidateSelectConcurrencyTest.this.logAndRunSql(sql, user, logPrefix);
                            }
                        }
                        sql = "DELETE FROM import_test_mixed_varlen WHERE fatx2 IS NULL;";
                        ImportAlterValidateSelectConcurrencyTest.this.logAndRunSql(sql, user, logPrefix);
                        sql = "SELECT COUNT(*) FROM import_test_mixed_varlen;";
                        ImportAlterValidateSelectConcurrencyTest.this.logAndRunSql(sql, user, logPrefix);
                        if (threadId == 1) {
                            Thread.sleep(5000L);
                            sql = "ALTER TABLE import_test_mixed_varlen DROP COLUMN faii;";
                            ImportAlterValidateSelectConcurrencyTest.this.logAndRunSql(sql, user, logPrefix);
                        }
                        if (threadId % 2 == 1) {
                            ImportAlterValidateSelectConcurrencyTest.this.getTableDetails(user, logPrefix);
                        } else {
                            ImportAlterValidateSelectConcurrencyTest.this.getTablesMetadata(user, logPrefix);
                        }
                        sql = "SELECT * FROM geospatial;";
                        logger.info(logPrefix + " VALIDATE " + sql);
                        String validateSql = sql;
                        ImportAlterValidateSelectConcurrencyTest.this.ignoreMissingTable(() -> user.sqlValidate(validateSql), ImportAlterValidateSelectConcurrencyTest.geoTableName);
                        String alterSql = "ALTER TABLE geospatial SET max_rows = 10;";
                        ImportAlterValidateSelectConcurrencyTest.this.ignoreMissingTable(() -> ImportAlterValidateSelectConcurrencyTest.this.logAndRunSql("ALTER TABLE geospatial SET max_rows = 10;", user, logPrefix), ImportAlterValidateSelectConcurrencyTest.geoTableName);
                        if (threadId == 3) {
                            logger.info(logPrefix + " IMPORT GEO TABLE");
                            ImportAlterValidateSelectConcurrencyTest.this.ignoreMissingTable(() -> user.import_geo_table(ImportAlterValidateSelectConcurrencyTest.geoTableName, ImportAlterValidateSelectConcurrencyTest.this.geo_file_path, geo_copy_params, new ArrayList<TColumnType>(), new TCreateParams()), ImportAlterValidateSelectConcurrencyTest.geoTableName);
                            ImportAlterValidateSelectConcurrencyTest.this.loadTableBinaryColumnar(user, logPrefix);
                        }
                        String selectSql = "SELECT * FROM geospatial LIMIT 2;";
                        ImportAlterValidateSelectConcurrencyTest.this.ignoreMissingTable(() -> ImportAlterValidateSelectConcurrencyTest.this.logAndRunSql("SELECT * FROM geospatial LIMIT 2;", user, logPrefix), ImportAlterValidateSelectConcurrencyTest.geoTableName);
                        sql = "SELECT * FROM import_test_mixed_varlen;";
                        logger.info(logPrefix + " VALIDATE " + sql);
                        user.sqlValidate(sql);
                        sql = "ALTER TABLE import_test_mixed_varlen SET max_rollback_epochs = 0;";
                        ImportAlterValidateSelectConcurrencyTest.this.logAndRunSql(sql, user, logPrefix);
                        sql = "COPY (SELECT * FROM  import_test_mixed_varlen) TO 'test_export.csv';";
                        ImportAlterValidateSelectConcurrencyTest.this.logAndRunSql(sql, user, logPrefix);
                        for (int i = 0; i < 5; ++i) {
                            String insertSql = "INSERT INTO geospatial VALUES (" + i + ", 'MULTIPOLYGON(((0 0, 1 1, 2 2)))');";
                            ImportAlterValidateSelectConcurrencyTest.this.ignoreMissingTable(() -> ImportAlterValidateSelectConcurrencyTest.this.logAndRunSql(insertSql, user, logPrefix), ImportAlterValidateSelectConcurrencyTest.geoTableName);
                        }
                        sql = "COPY (SELECT * FROM  import_test_mixed_varlen) TO 'test_export.csv';";
                        ImportAlterValidateSelectConcurrencyTest.this.logAndRunSql(sql, user, logPrefix);
                        sql = "TRUNCATE TABLE import_test_mixed_varlen;";
                        ImportAlterValidateSelectConcurrencyTest.this.logAndRunSql(sql, user, logPrefix);
                        sql = "SELECT COUNT(*) FROM import_test_mixed_varlen;";
                        logger.info(logPrefix + " VALIDATE " + sql);
                        user.sqlValidate(sql);
                        if (threadId == 0) {
                            Thread.sleep(5000L);
                            sql = "DROP TABLE geospatial;";
                            ImportAlterValidateSelectConcurrencyTest.this.logAndRunSql(sql, user, logPrefix);
                        }
                    }
                    catch (Exception e) {
                        logger.error(logPrefix + " Caught Exception: " + e.getMessage(), e);
                        exceptions[threadId] = e;
                    }
                }
            });
            t.start();
            threads.add(t);
        }
        for (Thread t : threads) {
            t.join();
        }
        HeavyDBTestClient dba = HeavyDBTestClient.getClient("localhost", 6274, db, dbaUser, dbaPassword);
        dba.runSql("DROP TABLE import_test_mixed_varlen;");
        for (Exception e : exceptions) {
            if (null == e) continue;
            logger.error("Exception: " + e.getMessage(), e);
            throw e;
        }
    }

    public void testConcurrency() throws Exception {
        logger.info("ImportAlterValidateSelectConcurrencyTest()");
        HeavyDBTestClient su = HeavyDBTestClient.getClient("localhost", 6274, "heavyai", "admin", "HyperInteractive");
        try {
            su.runSql("CREATE USER dba (password = 'password', is_super = 'true');");
            su.runSql("CREATE USER bob (password = 'password', is_super = 'false');");
            su.runSql("GRANT CREATE on DATABASE heavyai TO bob;");
            su.runSql("CREATE DATABASE db1;");
            su.runSql("GRANT CREATE on DATABASE db1 TO bob;");
            su.runSql("GRANT CREATE VIEW on DATABASE db1 TO bob;");
            su.runSql("GRANT DROP on DATABASE db1 TO bob;");
            su.runSql("GRANT DROP VIEW on DATABASE db1 TO bob;");
            this.runTest("db1", "admin", "HyperInteractive", "admin", "HyperInteractive");
        }
        finally {
            su.runSql("DROP DATABASE IF EXISTS db1;");
            su.runSql("DROP USER IF EXISTS bob;");
            su.runSql("DROP USER IF EXISTS dba;");
        }
        logger.info("ImportAlterValidateSelectConcurrencyTest() done");
    }

    private void ignoreMissingTable(VoidFunction function, String tableName) throws Exception {
        try {
            function.call();
        }
        catch (TDBException e) {
            Pattern pattern = Pattern.compile("(Table/View\\s+" + tableName + ".+does not exist|.+Object\\s+'" + tableName + "'\\s+not found)");
            Matcher matcher = pattern.matcher(e.error_msg);
            if (matcher.find()) {
                logger.info("Ignoring missing table error: " + e.error_msg);
            }
            throw e;
        }
    }

    private void logAndRunSql(String sql, HeavyDBTestClient user, String logPrefix) throws Exception {
        logger.info(logPrefix + " " + sql);
        user.runSql(sql);
    }

    private void loadTable(HeavyDBTestClient user, String logPrefix) throws Exception {
        logger.info(logPrefix + " Calling load_table API");
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        for (int i = 0; i < 5; ++i) {
            rows.add(Arrays.asList("point(0 0)", "linestring(0 0,1 1)", "{1,1}", "{1.11,1.11}", "{\"1\",\"1\"}", "{\"1\",\"1\"}"));
        }
        user.load_table(csvTableName, rows, new ArrayList<String>());
    }

    private void loadTableBinaryColumnar(HeavyDBTestClient user, String logPrefix) throws Exception {
        int i;
        logger.info(logPrefix + " Calling load_table_binary_columnar API");
        ArrayList<List<Object>> columns = new ArrayList<List<Object>>();
        for (i = 0; i < 3; ++i) {
            columns.add(new ArrayList());
        }
        for (i = 0; i < 5; ++i) {
            ((List)columns.get(0)).add(Arrays.asList(1L, 1L));
            ((List)columns.get(1)).add(Arrays.asList("1", "1"));
            ((List)columns.get(2)).add(Arrays.asList("1", "1"));
        }
        user.load_table_binary_columnar(csvTableName, columns, Arrays.asList("faii", "fatx", "fatx2"));
    }

    private void getTableDetails(HeavyDBTestClient user, String logPrefix) throws Exception {
        logger.info(logPrefix + " Calling get_table_details API");
        user.get_table_details(csvTableName);
        logger.info(logPrefix + " Calling get_table_details_for_database API");
        this.ignoreMissingTable(() -> user.get_table_details_for_database(geoTableName, "heavyai"), geoTableName);
    }

    private void getTablesMetadata(HeavyDBTestClient user, String logPrefix) throws Exception {
        logger.info(logPrefix + " Calling get_tables_meta API");
        user.get_tables_meta();
    }

    @FunctionalInterface
    private static interface VoidFunction {
        public void call() throws Exception;
    }
}

