/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.tests;

import com.mapd.tests.HeavyDBTestClient;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectCopyFromDeleteConcurrencyTest {
    static final Logger logger = LoggerFactory.getLogger(SelectCopyFromDeleteConcurrencyTest.class);
    Path input_file_path_;

    public SelectCopyFromDeleteConcurrencyTest(Path path) {
        this.input_file_path_ = path;
    }

    public static void main(String[] args) throws Exception {
        String path_str = "java/utility/src/main/java/com/mapd/tests/data/simple_test.csv";
        Path path = Paths.get(path_str, new String[0]).toAbsolutePath();
        assert (Files.exists(path, new LinkOption[0]));
        SelectCopyFromDeleteConcurrencyTest test = new SelectCopyFromDeleteConcurrencyTest(path);
        test.testSelecyCopyFromConcurrency(0);
        int shard_count = 4;
        test.testSelecyCopyFromConcurrency(shard_count);
    }

    private void run_test(HeavyDBTestClient dba, HeavyDBTestClient user, String prefix, Path filepath, int shard_count, int runs) throws Exception {
        String table_name = "table_" + prefix + "_";
        long tid = Thread.currentThread().getId();
        if (shard_count > 0) {
            logger.info("[" + tid + "] CREATE " + table_name + " WITH " + shard_count + " SHARDS");
            user.runSql("CREATE TABLE " + table_name + " (id INTEGER, str TEXT ENCODING DICT(32), x DOUBLE, y BIGINT, SHARD KEY(id)) WITH (FRAGMENT_SIZE=1, SHARD_COUNT=" + shard_count + ")");
        } else {
            logger.info("[" + tid + "] CREATE " + table_name);
            user.runSql("CREATE TABLE " + table_name + " (id INTEGER, str TEXT ENCODING DICT(32), x DOUBLE, y BIGINT) WITH (FRAGMENT_SIZE=1)");
        }
        for (int i = 0; i < runs; ++i) {
            logger.info("[" + tid + "] SELECT 1 " + table_name);
            user.runSql("SELECT id, str FROM " + table_name + " WHERE x < 5.0 LIMIT 1;");
            logger.info("[" + tid + "] COPY 1 " + table_name);
            user.runSql("COPY " + table_name + " FROM '" + filepath.toString() + "' WITH (header='false');");
            logger.info("[" + tid + "] SELECT 2 " + table_name);
            user.runSql("SELECT COUNT(*) FROM " + table_name + " WHERE x = (SELECT MIN(x) FROM " + table_name + ");");
            logger.info("[" + tid + "] DELETE 1 " + table_name);
            user.runSql("DELETE FROM " + table_name + " WHERE x = (SELECT MAX(x) FROM " + table_name + ");");
            logger.info("[" + tid + "] SELECT 2 " + table_name);
            user.runSql("COPY " + table_name + " FROM '" + filepath.toString() + "' WITH (header='false');");
            logger.info("[" + tid + "] TRUNCATE 1 " + table_name);
            user.runSql("TRUNCATE TABLE " + table_name);
            if (tid % 4L == 0L) {
                logger.info("[" + tid + "] COPY 3 " + table_name);
                dba.runSql("COPY " + table_name + " FROM '" + filepath.toString() + "' WITH (header='false');");
                continue;
            }
            logger.info("[" + tid + "] SELECT 3 " + table_name);
            user.runSql("SELECT COUNT(*) FROM " + table_name + " WHERE x = (SELECT MIN(x) FROM " + table_name + ");");
        }
        logger.info("[" + tid + "] DROP TABLE " + table_name);
        dba.runSql("DROP TABLE " + table_name + ";");
    }

    private void runTest(int num_threads, final int shard_count) throws Exception {
        int runs = 25;
        final Exception[] exceptions = new Exception[num_threads];
        ArrayList<Thread> threads = new ArrayList<Thread>();
        int i = 0;
        while (i < num_threads) {
            logger.info("Starting " + i);
            final int threadId = i++;
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String username = threadId % 2 == 0 ? "alice" : "bob";
                        HeavyDBTestClient dba = HeavyDBTestClient.getClient("localhost", 6274, "heavyai", "admin", "HyperInteractive");
                        HeavyDBTestClient user = HeavyDBTestClient.getClient("localhost", 6274, "heavyai", username, "password");
                        String prefix = "for_" + username + "_" + threadId + "_";
                        SelectCopyFromDeleteConcurrencyTest.this.run_test(dba, user, prefix, SelectCopyFromDeleteConcurrencyTest.this.input_file_path_, shard_count, 25);
                    }
                    catch (Exception e) {
                        logger.error("[" + Thread.currentThread().getId() + "] Caught Exception: " + e.getMessage());
                        exceptions[threadId] = e;
                    }
                }
            });
            t.start();
            threads.add(t);
        }
        for (Thread t : threads) {
            t.join();
        }
        for (Exception e : exceptions) {
            if (null == e) continue;
            logger.error("Exception: " + e.getMessage(), e);
            throw new Exception(e.getMessage(), e);
        }
    }

    public void testSelecyCopyFromConcurrency(int shard_count) throws Exception {
        logger.info("testSelectCopyFromConcurrency()");
        logger.info("Using import file: " + this.input_file_path_.toString());
        HeavyDBTestClient su = HeavyDBTestClient.getClient("localhost", 6274, "heavyai", "admin", "HyperInteractive");
        su.runSql("CREATE USER alice (password = 'password', is_super = 'false');");
        su.runSql("CREATE USER bob (password = 'password', is_super = 'false');");
        su.runSql("GRANT CREATE on DATABASE heavyai TO alice;");
        su.runSql("GRANT CREATE on DATABASE heavyai TO bob;");
        su.runSql("GRANT CREATE VIEW on DATABASE heavyai TO alice;");
        su.runSql("GRANT CREATE VIEW on DATABASE heavyai TO bob;");
        su.runSql("GRANT DROP VIEW on DATABASE heavyai TO alice;");
        su.runSql("GRANT DROP VIEW on DATABASE heavyai TO bob;");
        su.runSql("GRANT ACCESS on database heavyai TO alice;");
        su.runSql("GRANT ACCESS on database heavyai TO bob;");
        int num_threads = 5;
        this.runTest(5, shard_count);
        su.runSql("DROP USER alice;");
        su.runSql("DROP USER bob;");
        logger.info("Pass!");
    }
}

