/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.tests;

import com.mapd.tests.HeavyDBTestClient;
import java.util.ArrayList;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectUpdateDeleteDifferentTables {
    static final Logger logger = LoggerFactory.getLogger(SelectUpdateDeleteDifferentTables.class);
    static final String[] text_values = new String[]{"foo", "bar", "hello", "world", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p"};

    public static void main(String[] args) throws Exception {
        SelectUpdateDeleteDifferentTables test = new SelectUpdateDeleteDifferentTables();
        test.testConcurrency();
    }

    private void runTest(final String db, final String dbaUser, String dbaPassword, final String dbUser, final String dbPassword) throws Exception {
        int num_threads = 5;
        int runs = 5;
        int num_rows = 400;
        int fragment_size = 25;
        final Exception[] exceptions = new Exception[num_threads];
        ArrayList<Thread> threads = new ArrayList<Thread>();
        int i = 0;
        while (i < num_threads) {
            logger.info("Starting " + i);
            final int threadId = i++;
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    long tid = Thread.currentThread().getId();
                    String logPrefix = "[" + tid + "]";
                    String sql = "";
                    for (int runId = 0; runId < 5; ++runId) {
                        String tableName = dbaUser + "_" + threadId + "_" + runId;
                        try {
                            HeavyDBTestClient user = HeavyDBTestClient.getClient("localhost", 6274, db, dbUser, dbPassword);
                            user.runSql("CREATE TABLE " + tableName + "(x BIGINT, y INTEGER, z SMALLINT, a TINYINT, f FLOAT, d DOUBLE, deci DECIMAL(18,6), str TEXT ENCODING NONE) WITH (FRAGMENT_SIZE = " + 25 + ")");
                            for (int i = 0; i < 400; ++i) {
                                String integer_val = Integer.toString(i);
                                String small_val = Integer.toString(i % 128);
                                String fp_val = Double.toString((double)i * 1.1);
                                String deci_val = Double.toString((double)i + 0.01);
                                String str_val = "'" + text_values[i % text_values.length] + "'";
                                String values_string = String.join((CharSequence)" , ", integer_val, integer_val, small_val, small_val, fp_val, fp_val, deci_val, str_val);
                                user.runSql("INSERT INTO " + tableName + " VALUES (" + values_string + ")");
                            }
                            Random rand = new Random(tid);
                            sql = "ALTER TABLE " + tableName + " ADD COLUMN zz TEXT ENCODING DICT(8);";
                            logger.info(logPrefix + " " + sql);
                            user.runSql(sql);
                            sql = "SELECT * FROM " + tableName + " LIMIT 2;";
                            logger.info(logPrefix + " " + sql);
                            user.runSql(sql);
                            sql = "DELETE FROM " + tableName + " WHERE y = " + rand.nextInt(400) + ";";
                            logger.info(logPrefix + " " + sql);
                            user.runSql(sql);
                            sql = "ALTER TABLE " + tableName + " DROP COLUMN x;";
                            logger.info(logPrefix + " " + sql);
                            user.runSql(sql);
                            sql = "SELECT * FROM " + tableName + " WHERE str = '" + text_values[rand.nextInt(text_values.length)] + "';";
                            logger.info(logPrefix + " " + sql);
                            user.runSql(sql);
                            sql = "SELECT COUNT(*) FROM " + tableName + ";";
                            logger.info(logPrefix + " VALIDATE " + sql);
                            user.sqlValidate(sql);
                            String tableRename = tableName + "_rename";
                            sql = "ALTER TABLE " + tableName + " RENAME TO " + tableRename;
                            user.runSql(sql);
                            sql = "TRUNCATE TABLE " + tableRename + ";";
                            logger.info(logPrefix + " " + sql);
                            user.runSql(sql);
                            sql = "INSERT INTO " + tableRename + " VALUES (" + tid + "," + tid + "," + tid + "," + tid + "," + tid + "," + tid + "," + tid + "," + (tid % 2L == 0L ? "'value_1'" : "'value_2'") + ");";
                            logger.info(logPrefix + " " + sql);
                            user.runSql(sql);
                            sql = "DROP TABLE " + tableRename + ";";
                            logger.info(logPrefix + " " + sql);
                            user.runSql(sql);
                            continue;
                        }
                        catch (Exception e) {
                            logger.error(logPrefix + " Caught Exception: " + e.getMessage(), e);
                            exceptions[threadId] = e;
                        }
                    }
                }
            });
            t.start();
            threads.add(t);
        }
        for (Thread t : threads) {
            t.join();
        }
        for (Exception e : exceptions) {
            if (null == e) continue;
            logger.error("Exception: " + e.getMessage(), e);
            throw e;
        }
    }

    public void testConcurrency() throws Exception {
        logger.info("SelectUpdateDeleteDifferentTables()");
        HeavyDBTestClient su = HeavyDBTestClient.getClient("localhost", 6274, "heavyai", "admin", "HyperInteractive");
        su.runSql("CREATE USER dba (password = 'password', is_super = 'true');");
        su.runSql("CREATE USER bob (password = 'password', is_super = 'false');");
        su.runSql("GRANT CREATE on DATABASE heavyai TO bob;");
        su.runSql("CREATE DATABASE db1;");
        su.runSql("GRANT CREATE on DATABASE db1 TO bob;");
        su.runSql("GRANT CREATE VIEW on DATABASE db1 TO bob;");
        su.runSql("GRANT DROP on DATABASE db1 TO bob;");
        su.runSql("GRANT DROP VIEW on DATABASE db1 TO bob;");
        this.runTest("db1", "admin", "HyperInteractive", "admin", "HyperInteractive");
        su.runSql("DROP DATABASE db1;");
        su.runSql("DROP USER bob;");
        su.runSql("DROP USER dba;");
        logger.info("SelectUpdateDeleteDifferentTables() done");
    }
}

