/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.tests;

import com.mapd.tests.HeavyDBTestClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CyclicBarrier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTableConcurrencyTest {
    static final Logger logger = LoggerFactory.getLogger(SystemTableConcurrencyTest.class);

    public static void main(String[] args) throws Exception {
        SystemTableConcurrencyTest test = new SystemTableConcurrencyTest();
        test.testConcurrency();
    }

    public void testConcurrency() throws Exception {
        logger.info("SystemTableConcurrencyTest()");
        this.runTest();
        logger.info("SystemTableConcurrencyTest() done");
    }

    private void runTest() throws Exception {
        ArrayList<ThreadDbQueries> queriesPerThread = new ArrayList<ThreadDbQueries>(Arrays.asList(new ThreadDbQueries("heavyai", Arrays.asList("CREATE USER user_1 (password = 'HyperInteractive');", "ALTER USER user_1 (password = 'HyperInteractive2');", "DROP USER user_1;", "CREATE USER user_2 (password = 'HyperInteractive');", "ALTER USER user_2 (password = 'HyperInteractive2');", "DROP USER user_2;")), new ThreadDbQueries("heavyai", Arrays.asList("CREATE USER user_3 (password = 'HyperInteractive');", "GRANT SELECT ON DATABASE heavyai TO user_3;", "REVOKE SELECT ON DATABASE heavyai FROM user_3;", "GRANT CREATE ON DATABASE heavyai TO user_3;", "REVOKE CREATE ON DATABASE heavyai FROM user_3;", "DROP USER user_3;")), new ThreadDbQueries("heavyai", Arrays.asList("CREATE DATABASE db_1;", "CREATE DATABASE db_2;", "DROP DATABASE db_1;", "DROP DATABASE db_2;")), new ThreadDbQueries("heavyai", Arrays.asList("CREATE ROLE role_1;", "CREATE ROLE role_2;", "DROP ROLE role_1;", "DROP ROLE role_2;")), new ThreadDbQueries("heavyai", Arrays.asList("CREATE TABLE table_1 (i INTEGER, t TEXT);", "INSERT INTO table_1 VALUES (1, 'abc');", "SELECT AVG(i) FROM table_1;", "CREATE VIEW view_1 AS SELECT * FROM table_1;", "SELECT * FROM view_1;", "DROP VIEW view_1;", "DROP TABLE table_1;")), new ThreadDbQueries("heavyai", Arrays.asList("CREATE USER user_4 (password = 'HyperInteractive');", "CREATE USER user_5 (password = 'HyperInteractive');", "CREATE ROLE role_3;", "CREATE ROLE role_4;", "GRANT role_3, role_4 TO user_4, user_5;", "REVOKE role_3 FROM user_5;", "REVOKE role_4 FROM user_4, user_5;", "REVOKE role_3 FROM user_4;", "DROP USER user_4;", "DROP USER user_5;", "DROP ROLE role_3;", "DROP ROLE role_4;"))));
        List<String> systemTableQueries = Arrays.asList("SELECT * FROM users;", "SELECT * FROM permissions;", "SELECT * FROM databases;", "SELECT * FROM roles;", "SELECT * FROM tables;", "SELECT * FROM role_assignments;", "SELECT * FROM dashboards;", "SELECT * FROM memory_summary;", "SELECT * FROM memory_details;", "SELECT * FROM storage_details;");
        for (int i = 0; i < systemTableQueries.size(); ++i) {
            int parallelQueryCount = 5;
            for (int j = 0; j < 5; ++j) {
                queriesPerThread.add(new ThreadDbQueries("information_schema", Arrays.asList(systemTableQueries.get(i))));
            }
        }
        int num_threads = queriesPerThread.size() + 1;
        Exception[] exceptions = new Exception[num_threads];
        Thread[] threads = new Thread[num_threads];
        CyclicBarrier barrier = new CyclicBarrier(num_threads, () -> logger.info("Barrier acquired. Starting queries..."));
        threads[0] = new Thread(() -> {
            try {
                logger.info("Starting thread[0]");
                HeavyDBTestClient user = HeavyDBTestClient.getClient("localhost", 6274, "heavyai", "admin", "HyperInteractive");
                barrier.await();
                logger.info("0 create dashboard \"dashboard_1\"");
                int dashboardId = user.create_dashboard("dashboard_1");
                logger.info("0 get dashboard " + dashboardId);
                user.get_dashboard(dashboardId);
                logger.info("0 replace dashboard " + dashboardId);
                user.replace_dashboard(dashboardId, "dashboard_2", "admin");
                logger.info("0 delete dashboard " + dashboardId);
                user.delete_dashboard(dashboardId);
                logger.info("Finished thread[0]");
            }
            catch (Exception e) {
                logger.error("Thread[0] Caught Exception: " + e.getMessage(), e);
                exceptions[0] = e;
            }
        });
        threads[0].start();
        for (int i = 0; i < queriesPerThread.size(); ++i) {
            ThreadDbQueries threadQueries = (ThreadDbQueries)queriesPerThread.get(i);
            int threadId = i + 1;
            threads[threadId] = new Thread(() -> {
                try {
                    logger.info("Starting thread[" + threadId + "]");
                    HeavyDBTestClient user = HeavyDBTestClient.getClient("localhost", 6274, threadQueries.database, "admin", "HyperInteractive");
                    barrier.await();
                    for (String query : threadQueries.queries) {
                        this.runSqlAsUser(query, user, threadId);
                    }
                    logger.info("Finished thread[" + threadId + "]");
                }
                catch (Exception e) {
                    logger.error("Thread[" + threadId + "] Caught Exception: " + e.getMessage(), e);
                    exceptions[threadId] = e;
                }
            });
            threads[threadId].start();
        }
        for (Thread t : threads) {
            t.join();
        }
        for (Exception e : exceptions) {
            if (e == null) continue;
            logger.error("Exception: " + e.getMessage(), e);
            throw e;
        }
    }

    private void runSqlAsUser(String sql, HeavyDBTestClient user, int threadId) throws Exception {
        logger.info(threadId + " " + sql);
        user.runSql(sql);
    }

    private class ThreadDbQueries {
        public final String database;
        public final List<String> queries;

        public ThreadDbQueries(String database, List<String> queries) {
            this.database = database;
            this.queries = queries;
        }
    }
}

