/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.tests;

import com.mapd.tests.HeavyDBAsserts;
import com.mapd.tests.HeavyDBTestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TablePermissionsTest {
    static final Logger logger = LoggerFactory.getLogger(TablePermissionsTest.class);

    public static void main(String[] args) throws Exception {
        TablePermissionsTest test = new TablePermissionsTest();
        test.testTablePermissions();
    }

    public void testTablePermissions() throws Exception {
        logger.info("testTablePermissions()");
        HeavyDBTestClient su = HeavyDBTestClient.getClient("localhost", 6274, "mapd", "mapd", "HyperInteractive");
        su.runSql("CREATE USER dba (password = 'password', is_super = 'true');");
        su.runSql("CREATE USER bob (password = 'password', is_super = 'false');");
        su.runSql("CREATE USER bill (password = 'password', is_super = 'false');");
        su.runSql("CREATE ROLE salesDept;");
        su.runSql("CREATE USER foo (password = 'password', is_super = 'false');");
        su.runSql("GRANT salesDept TO foo;");
        su.runSql("CREATE DATABASE db1;");
        su.runSql("CREATE DATABASE db2;");
        su.runSql("GRANT ACCESS on database db1 TO bob;");
        su.runSql("GRANT ACCESS on database db1 TO bill;");
        su.runSql("GRANT ACCESS on database db1 TO foo;");
        su.runSql("GRANT ACCESS on database db1 TO dba;");
        HeavyDBTestClient dba = HeavyDBTestClient.getClient("localhost", 6274, "db1", "dba", "password");
        HeavyDBTestClient bill = HeavyDBTestClient.getClient("localhost", 6274, "db1", "bill", "password");
        HeavyDBTestClient bob = HeavyDBTestClient.getClient("localhost", 6274, "db1", "bob", "password");
        HeavyDBTestClient foo = HeavyDBTestClient.getClient("localhost", 6274, "db1", "foo", "password");
        HeavyDBAsserts.shouldThrowException("bill should not be able to create tables", () -> bill.runSql("CREATE TABLE bill_table(id integer);"));
        HeavyDBAsserts.shouldThrowException("bob should not be able to create tables", () -> bob.runSql("CREATE TABLE bob_table(id integer);"));
        HeavyDBAsserts.shouldThrowException("foo should not be able to create tables", () -> foo.runSql("CREATE TABLE foo_table(id integer);"));
        dba.runSql("GRANT CREATE ON DATABASE db1 TO bill");
        dba.runSql("GRANT DROP ON DATABASE db1 TO bill");
        bill.runSql("CREATE TABLE bill_table(id integer);");
        HeavyDBAsserts.shouldThrowException("not allowed to select", () -> bob.runSql("SELECT * from bill_table"));
        HeavyDBAsserts.shouldThrowException("not allowed to select", () -> foo.runSql("SELECT * from bill_table"));
        bill.runSql("GRANT SELECT ON TABLE bill_table TO bob");
        bob.runSql("SELECT * from bill_table");
        HeavyDBAsserts.shouldThrowException("foo not allowed to select", () -> foo.runSql("SELECT * from bill_table"));
        bill.runSql("GRANT SELECT ON TABLE bill_table TO salesDept");
        bob.runSql("SELECT * from bill_table");
        foo.runSql("SELECT * from bill_table");
        HeavyDBAsserts.shouldThrowException("insert not allowed", () -> bob.runSql("INSERT INTO bill_table VALUES(1)"));
        HeavyDBAsserts.shouldThrowException("insert not allowed ", () -> foo.runSql("INSERT INTO bill_table VALUES(1)"));
        bill.runSql("GRANT INSERT ON TABLE bill_table TO bob");
        bob.runSql("INSERT INTO bill_table VALUES(1)");
        HeavyDBAsserts.shouldThrowException("insert not allowed ", () -> foo.runSql("INSERT INTO bill_table VALUES(1)"));
        bill.runSql("GRANT INSERT ON TABLE bill_table TO salesDept");
        bob.runSql("INSERT INTO bill_table VALUES(1)");
        foo.runSql("INSERT INTO bill_table VALUES(1)");
        HeavyDBAsserts.shouldThrowException("update not allowed", () -> bob.runSql("UPDATE bill_table SET id = 2 WHERE id = 0"));
        HeavyDBAsserts.shouldThrowException("update not allowed ", () -> foo.runSql("UPDATE bill_table SET id = 2 WHERE id = 0"));
        bill.runSql("GRANT UPDATE ON TABLE bill_table TO bob");
        bob.runSql("UPDATE bill_table SET id = 2 WHERE id = 0");
        HeavyDBAsserts.shouldThrowException("update not allowed ", () -> foo.runSql("UPDATE bill_table SET id = 2 WHERE id = 0"));
        bill.runSql("GRANT UPDATE ON TABLE bill_table TO salesDept");
        bob.runSql("UPDATE bill_table SET id = 2 WHERE id = 0");
        foo.runSql("UPDATE bill_table SET id = 2 WHERE id = 0");
        HeavyDBAsserts.shouldThrowException("update not allowed", () -> bob.runSql("DELETE FROM bill_table WHERE id = 0"));
        HeavyDBAsserts.shouldThrowException("update not allowed ", () -> foo.runSql("DELETE FROM bill_table WHERE id = 0"));
        bill.runSql("GRANT DELETE ON TABLE bill_table TO bob");
        bob.runSql("DELETE FROM bill_table WHERE id = 0");
        HeavyDBAsserts.shouldThrowException("update not allowed ", () -> foo.runSql("DELETE FROM bill_table WHERE id = 0"));
        bill.runSql("GRANT DELETE ON TABLE bill_table TO salesDept");
        bob.runSql("DELETE FROM bill_table WHERE id = 0");
        foo.runSql("DELETE FROM bill_table WHERE id = 0");
        su.runSql("DROP DATABASE db1;");
        su.runSql("DROP DATABASE db2;");
        su.runSql("DROP USER foo;");
        su.runSql("DROP ROLE salesDept;");
        su.runSql("DROP USER bob;");
        su.runSql("DROP USER bill;");
        su.runSql("DROP USER dba;");
    }
}

