/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.tests;

import com.mapd.tests.HeavyDBTestClient;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.CyclicBarrier;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateDeleteInsertConcurrencyTest {
    static final Logger logger = LoggerFactory.getLogger(UpdateDeleteInsertConcurrencyTest.class);
    static final String[] text_values = new String[]{"foo", "bar", "hello", "world", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p"};
    private Boolean useTemporaryTables_ = false;

    public static void main(String[] args) throws Exception {
        Options options = new Options();
        options.addOption(Option.builder("t").longOpt("temptables").desc("Use temporary tables for test").build());
        DefaultParser clp = new DefaultParser();
        CommandLine commandLine = clp.parse(options, args);
        Boolean useTemporaryTables = commandLine.hasOption("temptables");
        UpdateDeleteInsertConcurrencyTest test = new UpdateDeleteInsertConcurrencyTest();
        test.testUpdateDeleteInsertConcurrency(useTemporaryTables);
    }

    private void runTest(final String db, final String dbaUser, final String dbaPassword, final String dbUser, final String dbPassword, final Boolean concurrentInserts) throws Exception {
        final int num_threads = 5;
        int runs = 25;
        int num_rows = 1000;
        int fragment_size = 10;
        String tableName = "test";
        final Exception[] exceptions = new Exception[num_threads];
        final CyclicBarrier barrier = new CyclicBarrier(num_threads, new Runnable(){

            @Override
            public void run() {
                try {
                    HeavyDBTestClient dba = HeavyDBTestClient.getClient("localhost", 6274, db, dbaUser, dbaPassword);
                    String createPrefix = UpdateDeleteInsertConcurrencyTest.this.useTemporaryTables_ != false ? "CREATE TEMPORARY TABLE " : "CREATE TABLE ";
                    dba.runSql(createPrefix + "test" + "(x BIGINT, y INTEGER, z SMALLINT, a TINYINT, f FLOAT, d DOUBLE, deci DECIMAL(18,6), str TEXT ENCODING NONE) WITH (FRAGMENT_SIZE = " + 10 + ")");
                    if (!concurrentInserts.booleanValue()) {
                        for (int i = 0; i < 1000; ++i) {
                            String integer_val = Integer.toString(i);
                            String small_val = Integer.toString(i % 128);
                            String fp_val = Double.toString((double)i * 1.1);
                            String deci_val = Double.toString((double)i + 0.01);
                            String str_val = "'" + text_values[i % text_values.length] + "'";
                            String values_string = String.join((CharSequence)" , ", integer_val, integer_val, small_val, small_val, fp_val, fp_val, deci_val, str_val);
                            dba.runSql("INSERT INTO test VALUES (" + values_string + ")");
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("[" + Thread.currentThread().getId() + "] Caught Exception: " + e.getMessage(), e);
                    exceptions[0] = e;
                }
            }
        });
        ArrayList<Thread> threads = new ArrayList<Thread>();
        int i = 0;
        while (i < num_threads) {
            logger.info("Starting " + i);
            final int threadId = i++;
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    long tid = Thread.currentThread().getId();
                    String logPrefix = "[" + tid + "]";
                    String sql = "";
                    try {
                        barrier.await();
                        HeavyDBTestClient user = HeavyDBTestClient.getClient("localhost", 6274, db, dbUser, dbPassword);
                        if (concurrentInserts.booleanValue()) {
                            for (int i = 0; i < 1000 / num_threads; ++i) {
                                String integer_val = Integer.toString(i);
                                String small_val = Integer.toString(i % 128);
                                String fp_val = Double.toString((double)i * 1.1);
                                String deci_val = Double.toString((double)i + 0.01);
                                String str_val = "'" + text_values[i % text_values.length] + "'";
                                String values_string = String.join((CharSequence)" , ", integer_val, integer_val, small_val, small_val, fp_val, fp_val, deci_val, str_val);
                                user.runSql("INSERT INTO test VALUES (" + values_string + ")");
                            }
                        }
                        Random rand = new Random(tid);
                        sql = "DELETE FROM test WHERE x = " + tid * 2L + ";";
                        logger.info(logPrefix + " " + sql);
                        user.runSql(sql);
                        sql = "DELETE FROM test WHERE y = " + rand.nextInt(1000) + ";";
                        logger.info(logPrefix + " " + sql);
                        user.runSql(sql);
                        sql = "SELECT COUNT(*) FROM test WHERE x > " + tid * 2L + ";";
                        logger.info(logPrefix + " " + sql);
                        user.runSql(sql);
                        sql = "DELETE FROM test WHERE str = '" + text_values[rand.nextInt(text_values.length)] + "';";
                        logger.info(logPrefix + " " + sql);
                        user.runSql(sql);
                        sql = "SELECT * FROM test WHERE str = '" + text_values[rand.nextInt(text_values.length)] + "';";
                        logger.info(logPrefix + " " + sql);
                        user.runSql(sql);
                        sql = "DELETE FROM test WHERE d <  " + rand.nextInt(250) + ";";
                        logger.info(logPrefix + " " + sql);
                        user.runSql(sql);
                        sql = "INSERT INTO test VALUES (" + tid + "," + tid + "," + tid + "," + tid + "," + tid + "," + tid + "," + tid + "," + (tid % 2L == 0L ? "'value_1'" : "'value_2'") + ");";
                        logger.info(logPrefix + " " + sql);
                        user.runSql(sql);
                        sql = "DELETE FROM test WHERE z = " + tid + ";";
                        logger.info(logPrefix + " " + sql);
                        user.runSql(sql);
                    }
                    catch (Exception e) {
                        logger.error(logPrefix + " Caught Exception: " + e.getMessage(), e);
                        exceptions[threadId] = e;
                    }
                }
            });
            t.start();
            threads.add(t);
        }
        for (Thread t : threads) {
            t.join();
        }
        HeavyDBTestClient dba = HeavyDBTestClient.getClient("localhost", 6274, db, dbaUser, dbaPassword);
        dba.runSql("DROP TABLE test;");
        for (Exception e : exceptions) {
            if (null == e) continue;
            logger.error("Exception: " + e.getMessage(), e);
            throw e;
        }
    }

    public void testUpdateDeleteInsertConcurrency(Boolean useTemporaryTables) throws Exception {
        logger.info("testUpdateDeleteInsertConcurrency()");
        this.useTemporaryTables_ = useTemporaryTables;
        if (this.useTemporaryTables_.booleanValue()) {
            logger.info("Using temporary tables");
        }
        HeavyDBTestClient su = HeavyDBTestClient.getClient("localhost", 6274, "heavyai", "admin", "HyperInteractive");
        su.runSql("CREATE USER dba (password = 'password', is_super = 'true');");
        su.runSql("CREATE USER bob (password = 'password', is_super = 'false');");
        su.runSql("GRANT CREATE on DATABASE heavyai TO bob;");
        su.runSql("CREATE DATABASE db1;");
        su.runSql("GRANT CREATE on DATABASE db1 TO bob;");
        su.runSql("GRANT CREATE VIEW on DATABASE db1 TO bob;");
        su.runSql("GRANT DROP on DATABASE db1 TO bob;");
        su.runSql("GRANT DROP VIEW on DATABASE db1 TO bob;");
        this.runTest("db1", "admin", "HyperInteractive", "admin", "HyperInteractive", false);
        this.runTest("db1", "admin", "HyperInteractive", "admin", "HyperInteractive", true);
        su.runSql("DROP DATABASE db1;");
        su.runSql("DROP USER bob;");
        su.runSql("DROP USER dba;");
        logger.info("testUpdateDeleteInsertConcurrency() done");
    }
}

