/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.testthrift;

import ai.heavy.thrift.server.Heavy;
import ai.heavy.thrift.server.TColumn;
import ai.heavy.thrift.server.TColumnData;
import ai.heavy.thrift.server.TColumnType;
import ai.heavy.thrift.server.TDBException;
import ai.heavy.thrift.server.TDBInfo;
import ai.heavy.thrift.server.TDatum;
import ai.heavy.thrift.server.TQueryResult;
import ai.heavy.thrift.server.TRow;
import ai.heavy.thrift.server.TRowSet;
import ai.heavy.thrift.server.TTableDetails;
import java.util.List;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftTester {
    static final Logger logger = LoggerFactory.getLogger(ThriftTester.class);

    public static void main(String[] args) {
        logger.info("Hello, World");
        ThriftTester x = new ThriftTester();
        x.doWork(args);
    }

    void doWork(String[] args) {
        logger.info("In doWork");
        TSocket transport = null;
        try {
            transport = new TSocket("localhost", 6274);
            ((TTransport)transport).open();
            TBinaryProtocol protocol = new TBinaryProtocol(transport);
            Heavy.Client client = new Heavy.Client(protocol);
            String session = null;
            session = client.connect("admin", "HyperInteractive", "omnisci");
            logger.info("Connected session is " + session);
            List<TDBInfo> dbs = client.get_databases(session);
            for (TDBInfo tDBInfo : dbs) {
                logger.info("db is " + tDBInfo.toString());
            }
            List<String> tables = client.get_tables(session);
            for (String string : tables) {
                logger.info("Tables is " + string);
            }
            logger.info("Version " + client.get_version());
            TTableDetails tTableDetails = client.get_table_details(session, "flights");
            for (TColumnType col : tTableDetails.row_desc) {
                logger.info("col name :" + col.col_name);
                logger.info("\tcol encoding :" + col.col_type.encoding);
                logger.info("\tcol is_array :" + col.col_type.is_array);
                logger.info("\tcol nullable :" + col.col_type.nullable);
                logger.info("\tcol type :" + col.col_type.type);
            }
            logger.info(" -- before query -- ");
            TQueryResult tQueryResult = client.sql_execute(session, "Select uniquecarrier,flightnum  from flights LIMIT 3;", true, null, -1, -1);
            logger.info(" -- after query -- ");
            logger.info("TQueryResult execution time is " + tQueryResult.getExecution_time_ms());
            logger.info("TQueryResult is " + tQueryResult.toString());
            logger.info("TQueryResult getFieldValue is " + tQueryResult.getFieldValue(TQueryResult._Fields.ROW_SET));
            TRowSet row_set = tQueryResult.getRow_set();
            Object fieldValue = tQueryResult.getFieldValue(TQueryResult._Fields.ROW_SET);
            logger.info("fieldValue " + fieldValue);
            logger.info("TRowSet is " + row_set.toString());
            logger.info("Get rows size " + row_set.getRowsSize());
            logger.info("Get col size " + row_set.getRowsSize());
            List<TRow> rows = row_set.getRows();
            int count = 1;
            for (TRow tRow : rows) {
                List<TDatum> cols = tRow.getCols();
                if (cols == null) continue;
                for (TDatum dat : cols) {
                    logger.info("ROW " + count + " " + dat.getFieldValue(TDatum._Fields.VAL));
                }
                ++count;
            }
            List<TColumn> columns = row_set.getColumns();
            logger.info("columns " + columns);
            count = 1;
            for (TColumn col : columns) {
                TColumnData data = col.getData();
                if (data != null) {
                    logger.info("COL " + count + " " + data.toString());
                }
                ++count;
            }
            int n = client.create_dashboard(session, "test1", "state", "image", "metadata");
            logger.info("dash id is " + n);
            int dash2 = client.create_dashboard(session, "test2", "state2", "image2", "metadata2");
            logger.info("dash2 id is " + dash2);
            client.replace_dashboard(session, dash2, "test3", "mapd", "state3", "image3", "metadata3");
            logger.info("replaced");
            logger.info("Trying to disconnect session " + session);
            client.disconnect(session);
        }
        catch (TDBException ex) {
            logger.error(ex.getError_msg());
            ex.printStackTrace();
        }
        catch (TException ex) {
            logger.error(ex.toString());
            ex.printStackTrace();
        }
        catch (Exception ex) {
            logger.error(ex.toString());
            ex.printStackTrace();
        }
        logger.info("Connection Ended");
        logger.info("Exit");
    }
}

