/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.utility;

import ai.heavy.thrift.server.Heavy;
import ai.heavy.thrift.server.TColumn;
import ai.heavy.thrift.server.TColumnData;
import ai.heavy.thrift.server.TColumnType;
import ai.heavy.thrift.server.TDBException;
import ai.heavy.thrift.server.TDatumType;
import ai.heavy.thrift.server.TQueryResult;
import ai.heavy.thrift.server.TTableDetails;
import com.mapd.common.SockTransportProperties;
import com.mapd.utility.DateTimeUtils;
import com.mapd.utility.SQLImporter_args;
import com.mapd.utility.db_vendors.Db_vendor_types;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLImporter {
    protected String session = null;
    protected Heavy.Client client = null;
    private CommandLine cmd = null;
    static final Logger LOGGER = LoggerFactory.getLogger(SQLImporter.class);
    private DateTimeUtils dateTimeUtils = milliseconds -> milliseconds / 1000L;
    Db_vendor_types vendor_types = null;

    public static void main(String[] args) {
        SQLImporter sq = new SQLImporter();
        sq.doWork(args);
    }

    void doWork(String[] args) {
        SQLImporter_args s_args = new SQLImporter_args();
        try {
            this.cmd = s_args.parse(args);
        }
        catch (ParseException ex) {
            LOGGER.error(ex.getLocalizedMessage());
            s_args.printHelpMessage();
            System.exit(0);
        }
        this.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeQuery() {
        Connection conn = null;
        Statement stmt = null;
        long totalTime = 0L;
        try {
            int i;
            LOGGER.info("Connecting to database url :" + this.cmd.getOptionValue("jdbcConnect"));
            conn = DriverManager.getConnection(this.cmd.getOptionValue("jdbcConnect"), this.cmd.getOptionValue("sourceUser"), this.cmd.getOptionValue("sourcePasswd"));
            this.vendor_types = Db_vendor_types.Db_vendor_factory(this.cmd.getOptionValue("jdbcConnect"));
            long startTime = System.currentTimeMillis();
            if (this.cmd.hasOption("initializeFile")) {
                this.run_init(conn);
            }
            try {
                if (this.vendor_types.isAutoCommitDisabledRequired()) {
                    conn.setAutoCommit(false);
                }
            }
            catch (SQLException se) {
                LOGGER.warn("SQLException when attempting to setAutoCommit to false, jdbc driver probably doesnt support it.  Error is " + se.toString());
            }
            stmt = conn.createStatement();
            int bufferSize = Integer.valueOf(this.cmd.getOptionValue("bufferSize", "10000"));
            stmt.setFetchSize(bufferSize);
            ResultSet rs = stmt.executeQuery(this.cmd.getOptionValue("sqlStmt"));
            ResultSetMetaData md = rs.getMetaData();
            this.checkDBTable(conn, md);
            long timer = System.currentTimeMillis();
            long resultCount = 0L;
            int bufferCount = 0;
            long total = 0L;
            ArrayList<TColumn> cols = new ArrayList<TColumn>(md.getColumnCount());
            for (i = 1; i <= md.getColumnCount(); ++i) {
                TColumn col = this.setupBinaryColumn(i, md, bufferSize);
                cols.add(col);
            }
            while (rs.next()) {
                for (i = 1; i <= md.getColumnCount(); ++i) {
                    this.setColValue(rs, (TColumn)cols.get(i - 1), md.getColumnType(i), i, md.getScale(i), md.getColumnTypeName(i));
                }
                ++resultCount;
                if (++bufferCount != bufferSize) continue;
                bufferCount = 0;
                this.client.load_table_binary_columnar(this.session, this.cmd.getOptionValue("targetTable"), cols, null);
                for (i = 1; i <= md.getColumnCount(); ++i) {
                    this.resetBinaryColumn(i, md, bufferSize, (TColumn)cols.get(i - 1));
                }
                if (resultCount % 100000L != 0L) continue;
                LOGGER.info("Imported " + resultCount + " records");
            }
            if (bufferCount > 0) {
                this.client.load_table_binary_columnar(this.session, this.cmd.getOptionValue("targetTable"), cols, null);
                bufferCount = 0;
            }
            LOGGER.info("result set count is " + resultCount + " read time is " + (System.currentTimeMillis() - timer) + "ms");
            rs.close();
            stmt.close();
            conn.close();
            totalTime = System.currentTimeMillis() - startTime;
        }
        catch (SQLException se) {
            LOGGER.error("SQLException - " + se.toString());
            se.printStackTrace();
        }
        catch (TDBException ex) {
            LOGGER.error("TDBException - " + ex.getError_msg());
            ex.printStackTrace();
        }
        catch (TException ex) {
            LOGGER.error("TException failed - " + ex.toString());
            ex.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException se) {
                LOGGER.error("SQlException in close - " + se.toString());
                se.printStackTrace();
            }
            try {
                if (this.session != null) {
                    this.client.disconnect(this.session);
                }
            }
            catch (TDBException ex) {
                LOGGER.error("TDBException - in finalization " + ex.getError_msg());
                ex.printStackTrace();
            }
            catch (TException ex) {
                LOGGER.error("TException - in finalization" + ex.toString());
                ex.printStackTrace();
            }
        }
    }

    private void run_init(Connection conn) {
        String line = "";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.cmd.getOptionValue("initializeFile")));
            Statement stmt = conn.createStatement();
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty()) continue;
                LOGGER.info("Running : " + line);
                stmt.execute(line);
            }
            stmt.close();
            reader.close();
        }
        catch (IOException e) {
            LOGGER.error("Exception occurred trying to read initialize file: " + this.cmd.getOptionValue("initFile"));
            System.exit(1);
        }
        catch (SQLException e) {
            LOGGER.error("Exception occurred trying to execute initialize file entry : " + line);
            System.exit(1);
        }
    }

    private void help(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setOptionComparator(null);
        formatter.printHelp("SQLImporter", options);
    }

    private void checkDBTable(Connection otherdb_conn, ResultSetMetaData md) throws SQLException {
        this.createDBConnection();
        String tName = this.cmd.getOptionValue("targetTable");
        if (this.tableExists(tName)) {
            if (this.cmd.hasOption("truncate")) {
                this.executeDBCommand("Drop table " + tName);
                this.createDBTable(otherdb_conn, md);
            } else {
                List<TColumnType> columnInfo = this.getColumnInfo(tName);
                this.verifyColumnSignaturesMatch(otherdb_conn, columnInfo, md);
            }
        } else {
            this.createDBTable(otherdb_conn, md);
        }
    }

    private void verifyColumnSignaturesMatch(Connection otherdb_conn, List<TColumnType> dstColumns, ResultSetMetaData srcColumns) throws SQLException {
        if (srcColumns.getColumnCount() != dstColumns.size()) {
            LOGGER.error("Table sizes do not match: Destination " + dstColumns.size() + " versus Source " + srcColumns.getColumnCount());
            System.exit(1);
        }
        for (int i = 1; i <= dstColumns.size(); ++i) {
            if (!dstColumns.get(i - 1).getCol_name().equalsIgnoreCase(srcColumns.getColumnName(i))) {
                LOGGER.error("Destination table does not have matching column in same order for column number " + i + " destination column name is " + dstColumns.get((int)(i - 1)).col_name + " versus target column " + srcColumns.getColumnName(i));
                System.exit(1);
            }
            TDatumType dstType = dstColumns.get(i - 1).getCol_type().getType();
            int dstPrecision = dstColumns.get(i - 1).getCol_type().getPrecision();
            int dstScale = dstColumns.get(i - 1).getCol_type().getScale();
            int srcType = srcColumns.getColumnType(i);
            int srcPrecision = srcColumns.getPrecision(i);
            int srcScale = srcColumns.getScale(i);
            boolean match = false;
            block0 : switch (srcType) {
                case -6: {
                    match |= dstType == TDatumType.TINYINT;
                }
                case 5: {
                    match |= dstType == TDatumType.SMALLINT;
                }
                case 4: {
                    match |= dstType == TDatumType.INT;
                }
                case -5: {
                    match |= dstType == TDatumType.BIGINT;
                    if (!this.cmd.hasOption("AllowIntegerNarrowing")) break;
                    match |= dstType == TDatumType.TINYINT || dstType == TDatumType.SMALLINT || dstType == TDatumType.INT;
                    break;
                }
                case 2: 
                case 3: {
                    match = dstType == TDatumType.DECIMAL && dstPrecision == srcPrecision && dstScale == srcScale;
                    break;
                }
                case 6: 
                case 7: {
                    match |= dstType == TDatumType.FLOAT;
                }
                case 8: {
                    match |= dstType == TDatumType.DOUBLE;
                    if (!this.cmd.hasOption("AllowDoubleToFloat")) break;
                    match |= dstType == TDatumType.FLOAT;
                    break;
                }
                case 92: {
                    match = dstType == TDatumType.TIME;
                    break;
                }
                case 93: {
                    match = dstType == TDatumType.TIMESTAMP;
                    break;
                }
                case 91: {
                    match = dstType == TDatumType.DATE;
                    break;
                }
                case -7: 
                case 16: {
                    match = dstType == TDatumType.BOOL;
                    break;
                }
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    match = dstType == TDatumType.STR || dstType == TDatumType.POINT || dstType == TDatumType.POLYGON || dstType == TDatumType.MULTIPOLYGON || dstType == TDatumType.LINESTRING || dstType == TDatumType.MULTILINESTRING || dstType == TDatumType.MULTIPOINT;
                    break;
                }
                case 1111: {
                    Db_vendor_types.GisType gisType = this.vendor_types.find_gis_type(otherdb_conn, srcColumns, i);
                    if (gisType.srid != dstScale) {
                        match = false;
                        break;
                    }
                    switch (dstType) {
                        case POINT: {
                            match = gisType.type.equalsIgnoreCase("POINT");
                            break block0;
                        }
                        case MULTIPOINT: {
                            match = gisType.type.equalsIgnoreCase("MULTIPOINT");
                            break block0;
                        }
                        case LINESTRING: {
                            match = gisType.type.equalsIgnoreCase("LINESTRING");
                            break block0;
                        }
                        case MULTILINESTRING: {
                            match = gisType.type.equalsIgnoreCase("MULTILINESTRING");
                            break block0;
                        }
                        case POLYGON: {
                            match = gisType.type.equalsIgnoreCase("POLYGON");
                            break block0;
                        }
                        case MULTIPOLYGON: {
                            match = gisType.type.equalsIgnoreCase("MULTIPOLYGON");
                            break block0;
                        }
                    }
                    LOGGER.error("Column type " + JDBCType.valueOf(srcType).getName() + " not Supported");
                    System.exit(1);
                    break;
                }
                default: {
                    LOGGER.error("Column type " + JDBCType.valueOf(srcType).getName() + " not Supported");
                    System.exit(1);
                }
            }
            if (match) continue;
            LOGGER.error("Source and destination types for column " + srcColumns.getColumnName(i) + " do not match. Please make sure that type, precision and scale are exactly the same");
            System.exit(1);
        }
    }

    private void createDBTable(Connection otherdb_conn, ResultSetMetaData metaData) {
        StringBuilder sb = new StringBuilder();
        sb.append("Create table ").append(this.cmd.getOptionValue("targetTable")).append("(");
        try {
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                if (i > 1) {
                    sb.append(",");
                }
                LOGGER.debug("Column name is " + metaData.getColumnName(i));
                LOGGER.debug("Column type is " + metaData.getColumnTypeName(i));
                LOGGER.debug("Column type is " + metaData.getColumnType(i));
                sb.append(metaData.getColumnName(i)).append(" ");
                int col_type = metaData.getColumnType(i);
                if (col_type == 1111) {
                    Db_vendor_types.GisType type = this.vendor_types.find_gis_type(otherdb_conn, metaData, i);
                    sb.append(Db_vendor_types.gis_type_to_str(type));
                    continue;
                }
                sb.append(this.getColType(metaData.getColumnType(i), metaData.getPrecision(i), metaData.getScale(i)));
            }
            sb.append(")");
            if (Integer.valueOf(this.cmd.getOptionValue("fragmentSize", "0")) > 0) {
                sb.append(" with (fragment_size = ");
                sb.append(this.cmd.getOptionValue("fragmentSize", "0"));
                sb.append(")");
            }
        }
        catch (SQLException ex) {
            LOGGER.error("Error processing the metadata - " + ex.toString());
            System.exit(1);
        }
        this.executeDBCommand(sb.toString());
    }

    private void createDBConnection() {
        TTransport transport = null;
        TProtocol protocol = new TBinaryProtocol(transport);
        int port = Integer.valueOf(this.cmd.getOptionValue("port", "6274"));
        String server = this.cmd.getOptionValue("server", "localhost");
        try {
            boolean load_trust_store = this.cmd.hasOption("https");
            SockTransportProperties skT = null;
            if (this.cmd.hasOption("https")) {
                skT = SockTransportProperties.getEncryptedClientDefaultTrustStore(!this.cmd.hasOption("insecure"));
                transport = skT.openHttpsClientTransport(server, port);
                transport.open();
                protocol = new TJSONProtocol(transport);
            } else if (this.cmd.hasOption("http")) {
                skT = SockTransportProperties.getUnencryptedClient();
                transport = skT.openHttpClientTransport(server, port);
                protocol = new TJSONProtocol(transport);
            } else {
                skT = SockTransportProperties.getUnencryptedClient();
                transport = skT.openClientTransport(server, port);
                transport.open();
                protocol = new TBinaryProtocol(transport);
            }
            this.client = new Heavy.Client(protocol);
            if (this.cmd.hasOption("user")) {
                this.session = this.client.connect(this.cmd.getOptionValue("user", "admin"), this.cmd.getOptionValue("passwd", "HyperInteractive"), this.cmd.getOptionValue("database", "omnisci"));
            }
            LOGGER.debug("Connected session is " + this.session);
        }
        catch (TTransportException ex) {
            LOGGER.error("Connection failed - " + ex.toString());
            System.exit(1);
        }
        catch (TDBException ex) {
            LOGGER.error("Connection failed - " + ex.getError_msg());
            System.exit(2);
        }
        catch (TException ex) {
            LOGGER.error("Connection failed - " + ex.toString());
            System.exit(3);
        }
        catch (Exception ex) {
            LOGGER.error("General exception - " + ex.toString());
            System.exit(4);
        }
    }

    private List<TColumnType> getColumnInfo(String tName) {
        LOGGER.debug("Getting columns for  " + tName);
        List<TColumnType> row_descriptor = null;
        try {
            TTableDetails table_details = this.client.get_table_details(this.session, tName);
            row_descriptor = table_details.row_desc;
        }
        catch (TDBException ex) {
            LOGGER.error("column check failed - " + ex.getError_msg());
            System.exit(3);
        }
        catch (TException ex) {
            LOGGER.error("column check failed - " + ex.toString());
            System.exit(3);
        }
        return row_descriptor;
    }

    private boolean tableExists(String tName) {
        LOGGER.debug("Check for table " + tName);
        try {
            List<String> recv_get_tables = this.client.get_tables(this.session);
            for (String s2 : recv_get_tables) {
                if (!s2.equals(tName)) continue;
                return true;
            }
        }
        catch (TDBException ex) {
            LOGGER.error("Table check failed - " + ex.getError_msg());
            System.exit(3);
        }
        catch (TException ex) {
            LOGGER.error("Table check failed - " + ex.toString());
            System.exit(3);
        }
        return false;
    }

    private void executeDBCommand(String sql) {
        LOGGER.info("Run Command - " + sql);
        try {
            TQueryResult tQueryResult = this.client.sql_execute(this.session, sql + ";", true, null, -1, -1);
        }
        catch (TDBException ex) {
            LOGGER.error("SQL Execute failed - " + ex.getError_msg());
            System.exit(1);
        }
        catch (TException ex) {
            LOGGER.error("SQL Execute failed - " + ex.toString());
            System.exit(1);
        }
    }

    private String getColType(int cType, int precision, int scale) {
        if (precision > 19) {
            precision = 19;
        }
        if (scale > 19) {
            scale = 18;
        }
        switch (cType) {
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 3: {
                return "DECIMAL(" + precision + "," + scale + ")";
            }
            case 8: {
                return "DOUBLE";
            }
            case 7: {
                return "REAL";
            }
            case 2: {
                return "NUMERIC(" + precision + "," + scale + ")";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 91: {
                return "DATE";
            }
            case -7: 
            case 16: {
                return "BOOLEAN";
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return "TEXT ENCODING DICT";
            }
        }
        throw new AssertionError((Object)("Column type " + cType + " not Supported"));
    }

    private TColumn setupBinaryColumn(int i, ResultSetMetaData md, int bufferSize) throws SQLException {
        TColumn col = new TColumn();
        col.nulls = new ArrayList<Boolean>(bufferSize);
        col.data = new TColumnData();
        switch (md.getColumnType(i)) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 16: 
            case 91: 
            case 92: 
            case 93: {
                col.data.int_col = new ArrayList<Long>(bufferSize);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                col.data.real_col = new ArrayList<Double>(bufferSize);
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 1111: {
                col.data.str_col = new ArrayList<String>(bufferSize);
                break;
            }
            default: {
                throw new AssertionError((Object)("Column type " + md.getColumnType(i) + " not Supported"));
            }
        }
        return col;
    }

    private void setColValue(ResultSet rs, TColumn col, int columnType, int colNum, int scale, String colTypeName) throws SQLException {
        switch (columnType) {
            case -7: 
            case 16: {
                Boolean b = rs.getBoolean(colNum);
                if (rs.wasNull()) {
                    col.nulls.add(Boolean.TRUE);
                    col.data.int_col.add(0L);
                    break;
                }
                col.nulls.add(Boolean.FALSE);
                col.data.int_col.add(b != false ? 1L : 0L);
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bd = rs.getBigDecimal(colNum);
                if (rs.wasNull()) {
                    col.nulls.add(Boolean.TRUE);
                    col.data.int_col.add(0L);
                    break;
                }
                col.nulls.add(Boolean.FALSE);
                col.data.int_col.add(bd.multiply(new BigDecimal(Math.pow(10.0, scale))).longValue());
                break;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                Long l = rs.getLong(colNum);
                if (rs.wasNull()) {
                    col.nulls.add(Boolean.TRUE);
                    col.data.int_col.add(new Long(0L));
                    break;
                }
                col.nulls.add(Boolean.FALSE);
                col.data.int_col.add(l);
                break;
            }
            case 92: {
                Time t = rs.getTime(colNum);
                if (rs.wasNull()) {
                    col.nulls.add(Boolean.TRUE);
                    col.data.int_col.add(0L);
                    break;
                }
                col.data.int_col.add(this.dateTimeUtils.getSecondsFromMilliseconds(t.getTime()));
                col.nulls.add(Boolean.FALSE);
                break;
            }
            case 93: {
                Timestamp ts = rs.getTimestamp(colNum);
                if (rs.wasNull()) {
                    col.nulls.add(Boolean.TRUE);
                    col.data.int_col.add(0L);
                    break;
                }
                col.data.int_col.add(this.dateTimeUtils.getSecondsFromMilliseconds(ts.getTime()));
                col.nulls.add(Boolean.FALSE);
                break;
            }
            case 91: {
                Date d = rs.getDate(colNum);
                if (rs.wasNull()) {
                    col.nulls.add(Boolean.TRUE);
                    col.data.int_col.add(0L);
                    break;
                }
                col.data.int_col.add(this.dateTimeUtils.getSecondsFromMilliseconds(d.getTime()));
                col.nulls.add(Boolean.FALSE);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                Double db = rs.getDouble(colNum);
                if (rs.wasNull()) {
                    col.nulls.add(Boolean.TRUE);
                    col.data.real_col.add(new Double(0.0));
                    break;
                }
                col.nulls.add(Boolean.FALSE);
                col.data.real_col.add(db);
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                String strVal = rs.getString(colNum);
                if (rs.wasNull()) {
                    col.nulls.add(Boolean.TRUE);
                    col.data.str_col.add("");
                    break;
                }
                col.data.str_col.add(strVal);
                col.nulls.add(Boolean.FALSE);
                break;
            }
            case 1111: {
                Object objVal = rs.getObject(colNum);
                if (rs.wasNull()) {
                    col.nulls.add(Boolean.TRUE);
                    col.data.str_col.add("");
                    break;
                }
                col.data.str_col.add(this.vendor_types.get_wkt(rs, colNum, colTypeName));
                col.nulls.add(Boolean.FALSE);
                break;
            }
            default: {
                throw new AssertionError((Object)("Column type " + columnType + " not Supported"));
            }
        }
    }

    private void resetBinaryColumn(int i, ResultSetMetaData md, int bufferSize, TColumn col) throws SQLException {
        col.nulls.clear();
        switch (md.getColumnType(i)) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 16: 
            case 91: 
            case 92: 
            case 93: {
                col.data.int_col.clear();
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                col.data.real_col.clear();
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 1111: {
                col.data.str_col.clear();
                break;
            }
            default: {
                throw new AssertionError((Object)("Column type " + md.getColumnType(i) + " not Supported"));
            }
        }
    }
}

