/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.utility;

import com.mapd.utility.MutuallyExlusiveOptionsException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;

class SQLImporter_args {
    private Options options = new Options();

    void printVersion() {
        System.out.println("SQLImporter Version 4.6.0");
    }

    void printHelpMessage() {
        StringBuffer sb = new StringBuffer("\nSQLImporter ");
        sb.append("-u <userid> -p <password> [(--binary|--http|--https [--insecure])]\n");
        sb.append("-s <omnisci server host> -db <omnisci db> --port <omnisci server port>\n");
        sb.append("[-d <other database JDBC drive class>] -c <other database JDBC connection string>\n");
        sb.append("-su <other database user> -sp <other database user password> -ss <other database sql statement>\n");
        sb.append("-t <HEAVYAI target table> -b <transfer buffer size> -f <table fragment size>\n");
        sb.append("[-tr] [-adtf] [-nprg] -i <init commands file>\n");
        sb.append("\nSQLImporter -h | --help\n\n");
        HelpFormatter formatter = new HelpFormatter();
        formatter.setOptionComparator(null);
        int help_width = 100;
        formatter.printHelp(help_width, sb.toString(), "", this.options, "");
    }

    SQLImporter_args() {
        this.options.addOption("r", true, "Row Load Limit");
        this.options.addOption(Option.builder("h").desc("help message").longOpt("help").build());
        this.options.addOption(Option.builder("u").hasArg().desc("HEAVYAI User").longOpt("user").build());
        this.options.addOption(Option.builder("p").hasArg().desc("HEAVYAI Password").longOpt("passwd").build());
        OptionGroup transport_grp = new OptionGroup();
        transport_grp.addOption(Option.builder().desc("use binary transport to connect to HEAVYAI ").longOpt("binary").build());
        transport_grp.addOption(Option.builder().desc("use http transport to connect to HEAVYAI ").longOpt("http").build());
        transport_grp.addOption(Option.builder().desc("use https transport to connect to HEAVYAI ").longOpt("https").build());
        this.options.addOptionGroup(transport_grp);
        this.options.addOption(Option.builder("s").hasArg().desc("HEAVYAI Server").longOpt("server").build());
        this.options.addOption(Option.builder("db").hasArg().desc("HEAVYAI Database").longOpt("database").build());
        this.options.addOption(Option.builder().hasArg().desc("HEAVYAI Port").longOpt("port").build());
        this.options.addOption(Option.builder().hasArg().desc("CA certificate trust store").longOpt("ca-trust-store").build());
        this.options.addOption(Option.builder().hasArg().desc("CA certificate trust store password").longOpt("ca-trust-store-passwd").build());
        this.options.addOption(Option.builder().desc("Insecure TLS - do not validate server HEAVYAI server credentials").longOpt("insecure").build());
        this.options.addOption(Option.builder("d").hasArg().desc("JDBC driver class").longOpt("driver").build());
        this.options.addOption(Option.builder("c").hasArg().desc("JDBC Connection string").longOpt("jdbcConnect").required().build());
        this.options.addOption(Option.builder("su").hasArg().desc("Source User").longOpt("sourceUser").required().build());
        this.options.addOption(Option.builder("sp").hasArg().desc("Source Password").longOpt("sourcePasswd").required().build());
        this.options.addOption(Option.builder("ss").hasArg().desc("SQL Select statement").longOpt("sqlStmt").required().build());
        this.options.addOption(Option.builder("t").hasArg().desc("HEAVYAI Target Table").longOpt("targetTable").required().build());
        this.options.addOption(Option.builder("b").hasArg().desc("transfer buffer size").longOpt("bufferSize").build());
        this.options.addOption(Option.builder("f").hasArg().desc("table fragment size").longOpt("fragmentSize").build());
        this.options.addOption(Option.builder("tr").desc("Truncate table if it exists").longOpt("truncate").build());
        this.options.addOption(Option.builder("i").hasArg().desc("File containing init command for DB").longOpt("initializeFile").build());
        this.options.addOption(Option.builder("adtf").desc("Allow double to float conversion, note precision will be reduced").longOpt("AllowDoubleToFloat").build());
        this.options.addOption(Option.builder("ain").desc("Allow conversion from bigger integer types to smaller. Overflow might occur, use it only when casting is impossible").longOpt("AllowIntegerNarrowing").build());
    }

    private Option setOptionRequired(Option option) {
        option.setRequired(true);
        return option;
    }

    public CommandLine parse(String[] args) throws ParseException {
        DefaultParser clp = new DefaultParser(){

            @Override
            public CommandLine parse(Options options, String[] strings) throws ParseException {
                Options helpOptions = new Options();
                helpOptions.addOption(Option.builder("h").desc("help message").longOpt("help").build());
                try {
                    CommandLine commandLine = super.parse(helpOptions, strings);
                }
                catch (UnrecognizedOptionException unrecognizedOptionException) {
                    // empty catch block
                }
                if (this.cmd.hasOption("help")) {
                    SQLImporter_args.this.printHelpMessage();
                    System.exit(0);
                }
                if (this.cmd.hasOption("version")) {
                    SQLImporter_args.this.printVersion();
                    System.exit(0);
                }
                this.cmd = super.parse(options, strings);
                if (!this.cmd.hasOption("user") && !this.cmd.hasOption("client-cert")) {
                    throw new MissingArgumentException("Must supply either an HEAVYAI db user or a user certificate");
                }
                if (this.cmd.hasOption("user") || this.cmd.hasOption("passwd")) {
                    options.addOption(SQLImporter_args.this.setOptionRequired(options.getOption("user")));
                    options.addOption(SQLImporter_args.this.setOptionRequired(options.getOption("passwd")));
                    super.parse(options, strings);
                }
                if (this.cmd.hasOption("insecure") && !this.cmd.hasOption("https")) {
                    MutuallyExlusiveOptionsException meo = MutuallyExlusiveOptionsException.create("insecure can only be use with https", strings);
                    throw meo;
                }
                return this.cmd;
            }

            @Override
            public CommandLine parse(Options options, String[] strings, boolean b) throws ParseException {
                return null;
            }
        };
        return clp.parse(this.options, args);
    }
}

