/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.utility.db_vendors;

import com.mapd.utility.db_vendors.HeavyDBGeo_types;
import com.mapd.utility.db_vendors.Other_types;
import com.mapd.utility.db_vendors.PostGis_types;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;

public abstract class Db_vendor_types {
    protected static HashSet<Integer> valid_srid = new HashSet<Integer>(Arrays.asList(4326, 900913));

    protected Db_vendor_types() {
    }

    public abstract boolean isAutoCommitDisabledRequired();

    public abstract GisType find_gis_type(Connection var1, ResultSetMetaData var2, int var3) throws SQLException;

    public abstract String get_wkt(ResultSet var1, int var2, String var3) throws SQLException;

    public static Db_vendor_types Db_vendor_factory(String connection_str) {
        if (connection_str.toLowerCase().contains("postgres")) {
            return new PostGis_types();
        }
        if (connection_str.toLowerCase().contains("omnisci")) {
            return new HeavyDBGeo_types();
        }
        return new Other_types();
    }

    public static String gis_type_to_str(GisType type) {
        StringBuffer column_sql_definition = new StringBuffer();
        if (!type.subtype.isEmpty()) {
            column_sql_definition.append(type.subtype + "(");
        }
        column_sql_definition.append(type.type);
        if (type.srid != 0) {
            column_sql_definition.append("," + type.srid);
        }
        if (!type.subtype.isEmpty()) {
            column_sql_definition.append(")");
        }
        return column_sql_definition.toString();
    }

    public static class GisType {
        public String subtype;
        public String type;
        public int srid;
    }
}

