/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.utility.db_vendors;

import com.mapd.utility.db_vendors.Db_vendor_types;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;

class HeavyDBGeo_types
extends Db_vendor_types {
    private static final HashSet<String> geo_types = new HashSet<String>(Arrays.asList("point", "linestring", "polygon", "multipolygon"));
    private static Hashtable<Integer, String> subtypes = new Hashtable(){
        {
            this.put(23, "GEOMETRY");
            this.put(24, "GEOGRAPHY");
        }
    };

    protected HeavyDBGeo_types() {
    }

    @Override
    public boolean isAutoCommitDisabledRequired() {
        return false;
    }

    @Override
    public String get_wkt(ResultSet rs, int column_number, String gis_type_name) throws SQLException {
        return rs.getString(column_number);
    }

    @Override
    public Db_vendor_types.GisType find_gis_type(Connection conn, ResultSetMetaData metadata, int column_number) throws SQLException {
        String column_name = metadata.getColumnName(column_number);
        String column_type_name = metadata.getColumnTypeName(column_number);
        if (!geo_types.contains(column_type_name.toLowerCase())) {
            throw new SQLException("type not supported: " + column_type_name + " for column " + column_name);
        }
        int srid = metadata.getScale(column_number);
        if (!valid_srid.contains(srid) && srid != 0) {
            throw new SQLException("srid is not supported: " + srid + " for column " + column_name);
        }
        int subtype = metadata.getPrecision(column_number);
        if (!subtypes.containsKey(subtype)) {
            throw new SQLException("Subtype is not supported: " + subtype + " for column " + column_name);
        }
        Db_vendor_types.GisType result = new Db_vendor_types.GisType();
        result.srid = srid;
        result.subtype = subtypes.get(subtype);
        result.type = column_type_name.toUpperCase();
        return result;
    }
}

