/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.utility.db_vendors;

import com.mapd.utility.db_vendors.Db_vendor_types;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import org.postgis.PGgeometry;
import org.postgresql.geometric.PGlseg;
import org.postgresql.geometric.PGpoint;
import org.postgresql.geometric.PGpolygon;

class PostGis_types
extends Db_vendor_types {
    private static Hashtable<String, String> extra_types = new Hashtable(){
        {
            this.put("point", "POINT");
            this.put("lseg", "linestring");
            this.put("linestring", "linestring");
            this.put("polygon", "polygon");
            this.put("multipolygon", "multipolygon");
        }
    };

    protected PostGis_types() {
    }

    @Override
    public boolean isAutoCommitDisabledRequired() {
        return true;
    }

    private String wkt_point(PGpoint point) {
        return new String("" + point.x + " " + point.y);
    }

    @Override
    public String get_wkt(ResultSet rs, int column_number, String gis_type_name) throws SQLException {
        if (gis_type_name.equalsIgnoreCase("geometry") || gis_type_name.equalsIgnoreCase("geography")) {
            Object gis_object = rs.getObject(column_number);
            PGgeometry pGeometry = (PGgeometry)gis_object;
            if (pGeometry == null) {
                throw new SQLException("unknown type");
            }
            int semi_colon_indx = pGeometry.getValue().indexOf(59);
            if (-1 != semi_colon_indx && semi_colon_indx < pGeometry.getValue().length()) {
                return pGeometry.getValue().substring(semi_colon_indx + 1);
            }
            return pGeometry.getValue();
        }
        StringBuffer WKT_string = new StringBuffer();
        if (gis_type_name.equalsIgnoreCase("point")) {
            PGpoint point = (PGpoint)rs.getObject(column_number);
            WKT_string.append(extra_types.get(gis_type_name) + "(" + this.wkt_point(point) + ")");
        } else if (gis_type_name.equalsIgnoreCase("polygon")) {
            PGpolygon polygon = (PGpolygon)rs.getObject(column_number);
            WKT_string.append(extra_types.get(gis_type_name) + "((");
            for (PGpoint p : polygon.points) {
                WKT_string.append(this.wkt_point(p) + ",");
            }
            WKT_string.replace(WKT_string.length() - 1, WKT_string.length(), "))");
        } else if (gis_type_name.equalsIgnoreCase("lseg")) {
            PGlseg lseg = (PGlseg)rs.getObject(column_number);
            WKT_string.append(extra_types.get(gis_type_name) + "(");
            for (PGpoint p : lseg.point) {
                WKT_string.append(this.wkt_point(p) + ",");
            }
            WKT_string.replace(WKT_string.length() - 1, WKT_string.length(), ")");
        }
        return WKT_string.toString();
    }

    @Override
    public Db_vendor_types.GisType find_gis_type(Connection conn, ResultSetMetaData metadata, int column_number) throws SQLException {
        String column_name = metadata.getColumnName(column_number);
        String table_name = metadata.getTableName(column_number);
        String column_type_name = metadata.getColumnTypeName(column_number);
        if (column_type_name.equalsIgnoreCase("geography")) {
            return this.find_type_detail(conn, "geography_columns", "f_geography_column", column_name, table_name);
        }
        if (column_type_name.equalsIgnoreCase("geometry")) {
            return this.find_type_detail(conn, "geometry_columns", "f_geometry_column", column_name, table_name);
        }
        if (!extra_types.containsKey(column_type_name)) {
            throw new SQLException("type not supported: " + column_type_name + " for column " + column_name);
        }
        Db_vendor_types.GisType result = new Db_vendor_types.GisType();
        result.type = extra_types.get(column_type_name);
        return result;
    }

    private Db_vendor_types.GisType find_type_detail(Connection conn, String ref_table_name, String ref_column_name, String column_name, String table_name) throws SQLException {
        Statement detail_st = conn.createStatement();
        String select = "select type, srid from " + ref_table_name + " where " + ref_column_name + " = '" + column_name + "'";
        if (table_name.length() > 0) {
            select = select + " and f_table_name = '" + table_name + "'";
        }
        ResultSet rs = detail_st.executeQuery(select);
        Db_vendor_types.GisType result = new Db_vendor_types.GisType();
        result.subtype = "GEOMETRY";
        result.type = null;
        result.srid = 0;
        while (rs.next()) {
            String type = rs.getString(1);
            int srid = rs.getInt(2);
            if (result.type == null) {
                result.type = type;
                result.srid = srid;
                continue;
            }
            if (result.type.equalsIgnoreCase(type) && srid == result.srid) continue;
            throw new SQLException("multiple column definitions [" + result.type + ":" + type + "] found for column_name [" + column_name + "].\nYou can try to switch the jar positions in the classpath or use a more recent postgreSQL driver.");
        }
        if (!extra_types.containsKey(result.type.toLowerCase())) {
            throw new SQLException("type not supported");
        }
        result.type = extra_types.get(result.type.toLowerCase()).toUpperCase();
        return result;
    }
}

