/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.Util;

public abstract class RepeatUnion
extends BiRel {
    public final boolean all;
    public final int iterationLimit;

    protected RepeatUnion(RelOptCluster cluster, RelTraitSet traitSet, RelNode seed, RelNode iterative, boolean all, int iterationLimit) {
        super(cluster, traitSet, seed, iterative);
        this.iterationLimit = iterationLimit;
        this.all = all;
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        double seedRowCount = mq.getRowCount(this.getSeedRel());
        if (this.iterationLimit == 0) {
            return seedRowCount;
        }
        return seedRowCount + mq.getRowCount(this.getIterativeRel()) * (double)(this.iterationLimit < 0 ? 10 : this.iterationLimit);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        if (this.iterationLimit >= 0) {
            pw.item("iterationLimit", this.iterationLimit);
        }
        return pw.item("all", this.all);
    }

    public RelNode getSeedRel() {
        return this.left;
    }

    public RelNode getIterativeRel() {
        return this.right;
    }

    @Override
    protected RelDataType deriveRowType() {
        List<RelDataType> inputRowTypes = Lists.transform(this.getInputs(), RelNode::getRowType);
        RelDataType rowType = this.getCluster().getTypeFactory().leastRestrictive(inputRowTypes);
        if (rowType == null) {
            throw new IllegalArgumentException("Cannot compute compatible row type for arguments: " + Util.sepList(inputRowTypes, ", "));
        }
        return rowType;
    }
}

