/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mapd.calcite.parser.HeavyDBParserOptions;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.rules.FilterJoinRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;

public class DynamicFilterJoinRule
extends FilterJoinRule.FilterIntoJoinRule {
    private final List<HeavyDBParserOptions.FilterPushDownInfo> filter_push_down_info;
    private final boolean smart;

    public DynamicFilterJoinRule(boolean smart, RelBuilderFactory relBuilderFactory, FilterJoinRule.Predicate predicate, List<HeavyDBParserOptions.FilterPushDownInfo> filter_push_down_info) {
        super(smart, relBuilderFactory, predicate);
        this.filter_push_down_info = filter_push_down_info;
        this.smart = smart;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        Join join = (Join)call.rel(1);
        this.performSelectivePushDown(call, filter, join);
    }

    public void performSelectivePushDown(RelOptRuleCall call, Filter filter, Join join) {
        ArrayList<RexNode> filtersToBePushedDown = new ArrayList<RexNode>();
        List<Object> filtersAboveRemained = filter != null ? RelOptUtil.conjunctions(filter.getCondition()) : new ArrayList();
        for (RexNode each_filter : RelOptUtil.conjunctions(filter.getCondition())) {
            ImmutableBitSet filterRefs = RelOptUtil.InputFinder.bits(each_filter);
            if (filterRefs.cardinality() != 1) continue;
            Integer ref_index = filterRefs.toList().get(0);
            for (HeavyDBParserOptions.FilterPushDownInfo cand : this.filter_push_down_info) {
                if (ref_index < cand.input_start || ref_index >= cand.input_next) continue;
                filtersToBePushedDown.add(each_filter);
                filtersAboveRemained.remove(each_filter);
            }
        }
        List<RexNode> joinFilters = RelOptUtil.conjunctions(join.getCondition());
        ImmutableList<RexNode> origJoinFilters = ImmutableList.copyOf(joinFilters);
        if (filter == null && joinFilters.isEmpty()) {
            return;
        }
        List<Object> aboveFilters = filtersAboveRemained;
        ImmutableList<RexNode> origAboveFilters = ImmutableList.copyOf(aboveFilters);
        JoinRelType joinType = join.getJoinType();
        if (this.smart && !origAboveFilters.isEmpty() && join.getJoinType() != JoinRelType.INNER) {
            joinType = RelOptUtil.simplifyJoin(join, origAboveFilters, joinType);
        }
        ArrayList<RexNode> leftFilters = new ArrayList<RexNode>();
        ArrayList<RexNode> rightFilters = new ArrayList<RexNode>();
        boolean filterPushed = false;
        if (RelOptUtil.classifyFilters(join, filtersToBePushedDown, joinType, !join.analyzeCondition().nonEquiConditions.isEmpty(), !joinType.generatesNullsOnLeft(), !joinType.generatesNullsOnRight(), joinFilters, leftFilters, rightFilters)) {
            filterPushed = true;
        }
        this.validateJoinFilters(aboveFilters, joinFilters, join, joinType);
        if (leftFilters.isEmpty() && rightFilters.isEmpty() && joinFilters.size() == origJoinFilters.size() && Sets.newHashSet(joinFilters).equals(Sets.newHashSet(origJoinFilters))) {
            filterPushed = false;
        }
        if (RelOptUtil.classifyFilters(join, joinFilters, joinType, false, !joinType.generatesNullsOnLeft(), !joinType.generatesNullsOnRight(), joinFilters, leftFilters, rightFilters)) {
            filterPushed = true;
        }
        if (!filterPushed && joinType == join.getJoinType() || joinFilters.isEmpty() && leftFilters.isEmpty() && rightFilters.isEmpty()) {
            return;
        }
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        RelBuilder relBuilder = call.builder();
        RelNode leftRel = relBuilder.push(join.getLeft()).filter(leftFilters).build();
        RelNode rightRel = relBuilder.push(join.getRight()).filter(rightFilters).build();
        ImmutableCollection fieldTypes = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(RelOptUtil.getFieldTypeList(leftRel.getRowType()))).addAll(RelOptUtil.getFieldTypeList(rightRel.getRowType()))).build();
        RexNode joinFilter = RexUtil.composeConjunction(rexBuilder, RexUtil.fixUp(rexBuilder, joinFilters, (List<RelDataType>)((Object)fieldTypes)), false);
        if (joinFilter.isAlwaysTrue() && leftFilters.isEmpty() && rightFilters.isEmpty() && joinType == join.getJoinType()) {
            return;
        }
        Join newJoinRel = join.copy(join.getTraitSet(), joinFilter, leftRel, rightRel, joinType, join.isSemiJoinDone());
        call.getPlanner().onCopy(join, newJoinRel);
        if (!leftFilters.isEmpty()) {
            call.getPlanner().onCopy(filter, leftRel);
        }
        if (!rightFilters.isEmpty()) {
            call.getPlanner().onCopy(filter, rightRel);
        }
        relBuilder.push(newJoinRel);
        relBuilder.convert(join.getRowType(), false);
        relBuilder.filter(RexUtil.fixUp(rexBuilder, aboveFilters, RelOptUtil.getFieldTypeList(relBuilder.peek().getRowType())));
        call.transformTo(relBuilder.build());
    }
}

