/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.rules.Restriction;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectFilterRule
extends RelRule<Config> {
    public static Set<String> visitedMemo = new HashSet<String>();
    static final Logger HEAVYDBLOGGER = LoggerFactory.getLogger(InjectFilterRule.class);
    final List<Restriction> restrictions;

    public InjectFilterRule(Config config, List<Restriction> restrictions) {
        super(config);
        this.restrictions = restrictions;
        this.clearMemo();
    }

    void clearMemo() {
        visitedMemo.clear();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalTableScan childScanNode = (LogicalTableScan)call.rel(0);
        String scanNodeString = childScanNode.toString();
        if (visitedMemo.contains(scanNodeString)) {
            return;
        }
        visitedMemo.add(scanNodeString);
        RelOptTable table = childScanNode.getTable();
        List<String> qname = table.getQualifiedName();
        String query_database = null;
        String query_table = null;
        if (qname.size() == 2) {
            query_database = qname.get(0);
            query_table = qname.get(1);
        }
        if (query_database == null || query_database.isEmpty() || query_table == null || query_table.isEmpty()) {
            throw new RuntimeException("Restrictions: Expected qualified name as [database, table] but got: " + qname);
        }
        ArrayList<RexNode> orList = new ArrayList<RexNode>();
        RelBuilder builder = call.builder();
        RexBuilder rBuilder = builder.getRexBuilder();
        builder = builder.push(childScanNode);
        boolean found = false;
        for (Restriction restriction : this.restrictions) {
            String rest_database = restriction.getRestrictionDatabase();
            if (rest_database != null && !rest_database.isEmpty() && !rest_database.equals(query_database)) {
                HEAVYDBLOGGER.debug("RLS row-level security restriction for database " + rest_database + " ignored because this query is on database " + query_database);
                continue;
            }
            String rest_table = restriction.getRestrictionTable();
            if (rest_table != null && !rest_table.isEmpty() && !rest_table.equals(query_table)) {
                HEAVYDBLOGGER.debug("RLS row-level security restriction for table " + rest_table + " ignored because this query is on table " + query_table);
                continue;
            }
            RelDataTypeField field = table.getRowType().getField(restriction.getRestrictionColumn(), false, false);
            if (field == null) {
                HEAVYDBLOGGER.debug("RLS row-level security restriction for column " + restriction.getRestrictionColumn() + " ignored because column not present in query table " + query_table);
                continue;
            }
            found = true;
            HEAVYDBLOGGER.debug("Scan is " + childScanNode.toString() + " TABLE is " + table.toString());
            HEAVYDBLOGGER.debug("Column " + restriction.getRestrictionColumn() + " exists in table " + table.getQualifiedName());
            for (String val : restriction.getRestrictionValues()) {
                RexNode lit;
                HEAVYDBLOGGER.debug("Column is " + restriction.getRestrictionColumn() + " literal is '" + val + "'");
                if (SqlTypeName.NUMERIC_TYPES.indexOf((Object)field.getType().getSqlTypeName()) == -1) {
                    if (val.length() < 2 || val.charAt(0) != '\'' || val.charAt(val.length() - 1) != '\'') {
                        throw new RuntimeException("Restrictions: Expected a CREATE POLICY VALUES string with single quotes.");
                    }
                    lit = rBuilder.makeLiteral(val.substring(1, val.length() - 1), field.getType(), false);
                } else {
                    lit = rBuilder.makeLiteral(Integer.parseInt(val), field.getType(), false);
                }
                RexNode rn = builder.call((SqlOperator)SqlStdOperatorTable.EQUALS, builder.field(restriction.getRestrictionColumn()), lit);
                orList.add(rn);
            }
        }
        if (found) {
            RexNode relOr = builder.call((SqlOperator)SqlStdOperatorTable.OR, (Iterable<? extends RexNode>)orList);
            RelNode newNode = builder.filter(relOr).build();
            call.transformTo(newNode);
        }
    }

    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = EMPTY.withOperandSupplier(b0 -> b0.operand(LogicalTableScan.class).noInputs()).as(Config.class);

        @Override
        default public InjectFilterRule toRule() {
            return new InjectFilterRule(this, null);
        }

        default public InjectFilterRule toRule(List<Restriction> rests) {
            return new InjectFilterRule(this, rests);
        }
    }
}

