/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;

public class SqlBinaryOperator
extends SqlOperator {
    public SqlBinaryOperator(String name, SqlKind kind, int prec, boolean leftAssoc, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        super(name, kind, SqlBinaryOperator.leftPrec(prec, leftAssoc), SqlBinaryOperator.rightPrec(prec, leftAssoc), returnTypeInference, operandTypeInference, operandTypeChecker);
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.BINARY;
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        Util.discard(operandsCount);
        return "{1} {0} {2}";
    }

    @Override
    boolean needsSpace() {
        return !this.getName().equals(".");
    }

    @Override
    protected RelDataType adjustType(SqlValidator validator, SqlCall call, RelDataType type) {
        return this.convertType(validator, call, type);
    }

    private RelDataType convertType(SqlValidator validator, SqlCall call, RelDataType type) {
        RelDataType operandType0 = validator.getValidatedNodeType((SqlNode)call.operand(0));
        RelDataType operandType1 = validator.getValidatedNodeType((SqlNode)call.operand(1));
        if (SqlTypeUtil.inCharFamily(operandType0) && SqlTypeUtil.inCharFamily(operandType1)) {
            Charset cs0 = operandType0.getCharset();
            Charset cs1 = operandType1.getCharset();
            assert (null != cs0 && null != cs1) : "An implicit or explicit charset should have been set";
            if (!cs0.equals(cs1)) {
                throw validator.newValidationError(call, Static.RESOURCE.incompatibleCharset(this.getName(), cs0.name(), cs1.name()));
            }
            SqlCollation collation0 = operandType0.getCollation();
            SqlCollation collation1 = operandType1.getCollation();
            assert (null != collation0 && null != collation1) : "An implicit or explicit collation should have been set";
            SqlCollation resultCol = SqlCollation.getCoercibilityDyadicOperator(collation0, collation1);
            if (SqlTypeUtil.inCharFamily(type)) {
                type = validator.getTypeFactory().createTypeWithCharsetAndCollation(type, type.getCharset(), resultCol);
            }
        }
        return type;
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        RelDataType type = super.deriveType(validator, scope, call);
        return this.convertType(validator, call, type);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        if (this.getName().equals("/")) {
            SqlMonotonicity mono0 = call.getOperandMonotonicity(0);
            SqlMonotonicity mono1 = call.getOperandMonotonicity(1);
            if (mono1 == SqlMonotonicity.CONSTANT && call.isOperandLiteral(1, false)) {
                switch (call.getOperandLiteralValue(1, BigDecimal.class).signum()) {
                    case -1: {
                        return mono0.reverse().unstrict();
                    }
                    case 0: {
                        return SqlMonotonicity.CONSTANT;
                    }
                }
                return mono0.unstrict();
            }
        }
        return super.getMonotonicity(call);
    }

    @Override
    public boolean validRexOperands(int count, Litmus litmus) {
        if (count != 2) {
            if ((this == SqlStdOperatorTable.AND || this == SqlStdOperatorTable.OR) && count > 2) {
                return true;
            }
            return litmus.fail("wrong operand count {} for {}", count, this);
        }
        return litmus.succeed();
    }
}

