/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.rex.RexWindowBounds;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlPostfixOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.Symbolizable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.ControlFlowException;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;

public class SqlWindow
extends SqlCall {
    public static final SqlPostfixOperator FOLLOWING_OPERATOR = new SqlPostfixOperator("FOLLOWING", SqlKind.FOLLOWING, 20, ReturnTypes.ARG0, null, null);
    public static final SqlPostfixOperator PRECEDING_OPERATOR = new SqlPostfixOperator("PRECEDING", SqlKind.PRECEDING, 20, ReturnTypes.ARG0, null, null);
    SqlIdentifier declName;
    SqlIdentifier refName;
    SqlNodeList partitionList;
    SqlNodeList orderList;
    SqlLiteral isRows;
    SqlNode lowerBound;
    SqlNode upperBound;
    SqlLiteral allowPartial;
    private SqlCall windowCall = null;

    public SqlWindow(SqlParserPos pos, SqlIdentifier declName, SqlIdentifier refName, SqlNodeList partitionList, SqlNodeList orderList, SqlLiteral isRows, SqlNode lowerBound, SqlNode upperBound, SqlLiteral allowPartial) {
        super(pos);
        this.declName = declName;
        this.refName = refName;
        this.partitionList = partitionList;
        this.orderList = orderList;
        this.isRows = isRows;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.allowPartial = allowPartial;
        assert (declName == null || declName.isSimple());
        assert (partitionList != null);
        assert (orderList != null);
    }

    public static SqlWindow create(SqlIdentifier declName, SqlIdentifier refName, SqlNodeList partitionList, SqlNodeList orderList, SqlLiteral isRows, SqlNode lowerBound, SqlNode upperBound, SqlLiteral allowPartial, SqlParserPos pos) {
        if (upperBound == null && lowerBound != null && lowerBound.getKind() == SqlKind.FOLLOWING) {
            upperBound = lowerBound;
            lowerBound = null;
        }
        return new SqlWindow(pos, declName, refName, partitionList, orderList, isRows, lowerBound, upperBound, allowPartial);
    }

    @Override
    public SqlOperator getOperator() {
        return SqlWindowOperator.INSTANCE;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.WINDOW;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.declName, this.refName, this.partitionList, this.orderList, this.isRows, this.lowerBound, this.upperBound, this.allowPartial, new SqlNode[0]);
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        switch (i) {
            case 0: {
                this.declName = (SqlIdentifier)operand;
                break;
            }
            case 1: {
                this.refName = (SqlIdentifier)operand;
                break;
            }
            case 2: {
                this.partitionList = (SqlNodeList)operand;
                break;
            }
            case 3: {
                this.orderList = (SqlNodeList)operand;
                break;
            }
            case 4: {
                this.isRows = (SqlLiteral)operand;
                break;
            }
            case 5: {
                this.lowerBound = operand;
                break;
            }
            case 6: {
                this.upperBound = operand;
                break;
            }
            case 7: {
                this.allowPartial = (SqlLiteral)operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (null != this.declName) {
            this.declName.unparse(writer, 0, 0);
            writer.keyword("AS");
        }
        this.getOperator().unparse(writer, this, 0, 0);
    }

    public SqlIdentifier getDeclName() {
        return this.declName;
    }

    public void setDeclName(SqlIdentifier declName) {
        assert (declName.isSimple());
        this.declName = declName;
    }

    public SqlNode getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(SqlNode lowerBound) {
        this.lowerBound = lowerBound;
    }

    public SqlNode getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(SqlNode upperBound) {
        this.upperBound = upperBound;
    }

    public boolean isAlwaysNonEmpty() {
        RexWindowBound upper;
        RexWindowBound lower;
        if (this.lowerBound == null) {
            lower = this.upperBound == null ? RexWindowBounds.UNBOUNDED_PRECEDING : RexWindowBounds.CURRENT_ROW;
        } else if (this.lowerBound instanceof SqlLiteral) {
            lower = RexWindowBounds.create(this.lowerBound, null);
        } else {
            return false;
        }
        if (this.upperBound == null) {
            upper = RexWindowBounds.CURRENT_ROW;
        } else if (this.upperBound instanceof SqlLiteral) {
            upper = RexWindowBounds.create(this.upperBound, null);
        } else {
            return false;
        }
        int lowerKey = lower.getOrderKey();
        int upperKey = upper.getOrderKey();
        return lowerKey > -1 && lowerKey <= upperKey;
    }

    public void setRows(SqlLiteral isRows) {
        this.isRows = isRows;
    }

    public boolean isRows() {
        return this.isRows.booleanValue();
    }

    public SqlNodeList getOrderList() {
        return this.orderList;
    }

    public void setOrderList(SqlNodeList orderList) {
        this.orderList = orderList;
    }

    public SqlNodeList getPartitionList() {
        return this.partitionList;
    }

    public void setPartitionList(SqlNodeList partitionList) {
        this.partitionList = partitionList;
    }

    public SqlIdentifier getRefName() {
        return this.refName;
    }

    public void setWindowCall(SqlCall windowCall) {
        this.windowCall = windowCall;
        assert (windowCall == null || windowCall.getOperator() instanceof SqlAggFunction);
    }

    public SqlCall getWindowCall() {
        return this.windowCall;
    }

    static void checkSpecialLiterals(SqlWindow window, SqlValidator validator) {
        SqlNode lowerBound = window.getLowerBound();
        SqlNode upperBound = window.getUpperBound();
        Object lowerLitType = null;
        Object upperLitType = null;
        SqlOperator lowerOp = null;
        SqlOperator upperOp = null;
        if (null != lowerBound) {
            if (lowerBound.getKind() == SqlKind.LITERAL) {
                lowerLitType = ((SqlLiteral)lowerBound).getValue();
                if (Bound.UNBOUNDED_FOLLOWING == lowerLitType) {
                    throw validator.newValidationError(lowerBound, Static.RESOURCE.badLowerBoundary());
                }
            } else if (lowerBound instanceof SqlCall) {
                lowerOp = ((SqlCall)lowerBound).getOperator();
            }
        }
        if (null != upperBound) {
            if (upperBound.getKind() == SqlKind.LITERAL) {
                upperLitType = ((SqlLiteral)upperBound).getValue();
                if (Bound.UNBOUNDED_PRECEDING == upperLitType) {
                    throw validator.newValidationError(upperBound, Static.RESOURCE.badUpperBoundary());
                }
            } else if (upperBound instanceof SqlCall) {
                upperOp = ((SqlCall)upperBound).getOperator();
            }
        }
        if (Bound.CURRENT_ROW == lowerLitType) {
            if (null != upperOp && upperOp == PRECEDING_OPERATOR) {
                throw validator.newValidationError(upperBound, Static.RESOURCE.currentRowPrecedingError());
            }
        } else if (null != lowerOp && lowerOp == FOLLOWING_OPERATOR) {
            if (null != upperOp) {
                if (upperOp == PRECEDING_OPERATOR) {
                    throw validator.newValidationError(upperBound, Static.RESOURCE.followingBeforePrecedingError());
                }
            } else if (null != upperLitType && Bound.CURRENT_ROW == upperLitType) {
                throw validator.newValidationError(upperBound, Static.RESOURCE.currentRowFollowingError());
            }
        }
    }

    public static SqlNode createCurrentRow(SqlParserPos pos) {
        return Bound.CURRENT_ROW.symbol(pos);
    }

    public static SqlNode createUnboundedFollowing(SqlParserPos pos) {
        return Bound.UNBOUNDED_FOLLOWING.symbol(pos);
    }

    public static SqlNode createUnboundedPreceding(SqlParserPos pos) {
        return Bound.UNBOUNDED_PRECEDING.symbol(pos);
    }

    public static SqlNode createFollowing(SqlNode e, SqlParserPos pos) {
        return FOLLOWING_OPERATOR.createCall(pos, e);
    }

    public static SqlNode createPreceding(SqlNode e, SqlParserPos pos) {
        return PRECEDING_OPERATOR.createCall(pos, e);
    }

    public static SqlNode createBound(SqlLiteral range) {
        return range;
    }

    public static boolean isCurrentRow(SqlNode node) {
        return node instanceof SqlLiteral && ((SqlLiteral)node).symbolValue(Bound.class) == Bound.CURRENT_ROW;
    }

    public static boolean isUnboundedPreceding(SqlNode node) {
        return node instanceof SqlLiteral && ((SqlLiteral)node).symbolValue(Bound.class) == Bound.UNBOUNDED_PRECEDING;
    }

    public static boolean isUnboundedFollowing(SqlNode node) {
        return node instanceof SqlLiteral && ((SqlLiteral)node).symbolValue(Bound.class) == Bound.UNBOUNDED_FOLLOWING;
    }

    public SqlWindow overlay(SqlWindow that, SqlValidator validator) {
        SqlNodeList partitions = this.getPartitionList();
        if (0 != partitions.size()) {
            throw validator.newValidationError(partitions.get(0), Static.RESOURCE.partitionNotAllowed());
        }
        SqlNodeList baseOrder = this.getOrderList();
        SqlNodeList refOrder = that.getOrderList();
        if (0 != baseOrder.size() && 0 != refOrder.size()) {
            throw validator.newValidationError(baseOrder.get(0), Static.RESOURCE.orderByOverlap());
        }
        SqlNode lowerBound = that.getLowerBound();
        SqlNode upperBound = that.getUpperBound();
        if (null != lowerBound || null != upperBound) {
            throw validator.newValidationError(that.isRows, Static.RESOURCE.refWindowWithFrame());
        }
        SqlIdentifier declNameNew = this.declName;
        SqlIdentifier refNameNew = this.refName;
        SqlNodeList partitionListNew = this.partitionList;
        SqlNodeList orderListNew = this.orderList;
        SqlLiteral isRowsNew = this.isRows;
        SqlNode lowerBoundNew = lowerBound;
        SqlNode upperBoundNew = upperBound;
        SqlLiteral allowPartialNew = this.allowPartial;
        refNameNew = null;
        if (SqlWindow.setOperand(partitionListNew, that.partitionList, validator)) {
            partitionListNew = that.partitionList;
        }
        if (SqlWindow.setOperand(orderListNew, that.orderList, validator)) {
            orderListNew = that.orderList;
        }
        if (SqlWindow.setOperand(lowerBoundNew, that.lowerBound, validator)) {
            lowerBoundNew = that.lowerBound;
        }
        if (SqlWindow.setOperand(upperBoundNew, that.upperBound, validator)) {
            upperBoundNew = that.upperBound;
        }
        return new SqlWindow(SqlParserPos.ZERO, declNameNew, refNameNew, partitionListNew, orderListNew, isRowsNew, lowerBoundNew, upperBoundNew, allowPartialNew);
    }

    private static boolean setOperand(SqlNode clonedOperand, SqlNode thatOperand, SqlValidator validator) {
        if (thatOperand != null && !SqlNodeList.isEmptyList(thatOperand)) {
            if (clonedOperand == null || SqlNodeList.isEmptyList(clonedOperand)) {
                return true;
            }
            throw validator.newValidationError(clonedOperand, Static.RESOURCE.cannotOverrideWindowAttribute());
        }
        return false;
    }

    @Override
    public boolean equalsDeep(SqlNode node, Litmus litmus) {
        return node == this || node instanceof SqlWindow && SqlNode.equalDeep(Util.skip(this.getOperandList()), Util.skip(((SqlWindow)node).getOperandList()), litmus);
    }

    public boolean isAllowPartial() {
        return this.allowPartial == null || this.allowPartial.booleanValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        SqlValidatorScope operandScope = scope;
        SqlIdentifier declName = this.declName;
        SqlIdentifier refName = this.refName;
        SqlNodeList partitionList = this.partitionList;
        SqlNodeList orderList = this.orderList;
        SqlLiteral isRows = this.isRows;
        SqlNode lowerBound = this.lowerBound;
        SqlNode upperBound = this.upperBound;
        SqlLiteral allowPartial = this.allowPartial;
        if (refName != null) {
            Iterator<SqlNode> win = validator.resolveWindow(this, operandScope);
            partitionList = ((SqlWindow)((Object)win)).partitionList;
            orderList = ((SqlWindow)((Object)win)).orderList;
            isRows = ((SqlWindow)((Object)win)).isRows;
            lowerBound = ((SqlWindow)((Object)win)).lowerBound;
            upperBound = ((SqlWindow)((Object)win)).upperBound;
            allowPartial = ((SqlWindow)((Object)win)).allowPartial;
        }
        for (SqlNode partitionItem : partitionList) {
            try {
                partitionItem.accept(Util.OverFinder.INSTANCE);
            }
            catch (ControlFlowException e) {
                throw validator.newValidationError(this, Static.RESOURCE.partitionbyShouldNotContainOver());
            }
            partitionItem.validateExpr(validator, operandScope);
        }
        for (SqlNode orderItem : orderList) {
            boolean savedColumnReferenceExpansion = validator.config().columnReferenceExpansion();
            validator.transform(config -> config.withColumnReferenceExpansion(false));
            try {
                orderItem.accept(Util.OverFinder.INSTANCE);
            }
            catch (ControlFlowException e) {
                throw validator.newValidationError(this, Static.RESOURCE.orderbyShouldNotContainOver());
            }
            try {
                orderItem.validateExpr(validator, scope);
            }
            finally {
                validator.transform(config -> config.withColumnReferenceExpansion(savedColumnReferenceExpansion));
            }
        }
        if (orderList.size() == 0 && !SqlValidatorUtil.containsMonotonic(scope) && this.windowCall != null && this.windowCall.getOperator().requiresOrder()) {
            throw validator.newValidationError(this, Static.RESOURCE.funcNeedsOrderBy());
        }
        if (upperBound != null || lowerBound != null) {
            if (this.windowCall != null && !this.windowCall.getOperator().allowsFraming()) {
                throw validator.newValidationError(isRows, Static.RESOURCE.rankWithFrame());
            }
            SqlTypeFamily orderTypeFam = null;
            if (orderList.size() > 0) {
                if (orderList.size() > 1 && !this.isRows()) {
                    throw validator.newValidationError(isRows, Static.RESOURCE.compoundOrderByProhibitsRange());
                }
                RelDataType orderType = validator.deriveType(operandScope, orderList.get(0));
                orderTypeFam = orderType.getSqlTypeName().getFamily();
            } else if (!this.isRows() && !SqlValidatorUtil.containsMonotonic(scope)) {
                throw validator.newValidationError(this, Static.RESOURCE.overMissingOrderBy());
            }
            this.validateFrameBoundary(lowerBound, this.isRows(), orderTypeFam, validator, operandScope);
            this.validateFrameBoundary(upperBound, this.isRows(), orderTypeFam, validator, operandScope);
            SqlWindow.checkSpecialLiterals(this, validator);
        } else if (orderList.size() == 0 && !SqlValidatorUtil.containsMonotonic(scope) && this.windowCall != null && this.windowCall.getOperator().requiresOrder()) {
            throw validator.newValidationError(this, Static.RESOURCE.overMissingOrderBy());
        }
        if (!this.isRows() && !this.isAllowPartial()) {
            throw validator.newValidationError(allowPartial, Static.RESOURCE.cannotUseDisallowPartialWithRange());
        }
    }

    private void validateFrameBoundary(SqlNode bound, boolean isRows, SqlTypeFamily orderTypeFam, SqlValidator validator, SqlValidatorScope scope) {
        if (null == bound) {
            return;
        }
        bound.validate(validator, scope);
        block0 : switch (bound.getKind()) {
            case LITERAL: {
                break;
            }
            case OTHER: 
            case FOLLOWING: 
            case PRECEDING: {
                SqlNumericLiteral boundLiteral;
                assert (bound instanceof SqlCall);
                Object boundVal = ((SqlCall)bound).operand(0);
                if (isRows && boundVal instanceof SqlNumericLiteral && (!(boundLiteral = (SqlNumericLiteral)boundVal).isExact() || boundLiteral.getScale() != 0 || 0L > boundLiteral.longValue(true))) {
                    throw validator.newValidationError((SqlNode)boundVal, Static.RESOURCE.rowMustBeNonNegativeIntegral());
                }
                if (orderTypeFam == null || isRows) break;
                RelDataType bndType = validator.deriveType(scope, (SqlNode)boundVal);
                SqlTypeFamily bndTypeFam = bndType.getSqlTypeName().getFamily();
                switch (orderTypeFam) {
                    case NUMERIC: {
                        if (SqlTypeFamily.NUMERIC == bndTypeFam) break block0;
                        throw validator.newValidationError((SqlNode)boundVal, Static.RESOURCE.orderByRangeMismatch());
                    }
                    case DATE: 
                    case TIME: 
                    case TIMESTAMP: {
                        if (SqlTypeFamily.INTERVAL_DAY_TIME == bndTypeFam || SqlTypeFamily.INTERVAL_YEAR_MONTH == bndTypeFam) break block0;
                        throw validator.newValidationError((SqlNode)boundVal, Static.RESOURCE.orderByRangeMismatch());
                    }
                    default: {
                        throw validator.newValidationError((SqlNode)boundVal, Static.RESOURCE.orderByDataTypeProhibitsRange());
                    }
                }
            }
            default: {
                throw new AssertionError((Object)"Unexpected node type");
            }
        }
    }

    public SqlWindow createCurrentRowWindow(String columnName) {
        return SqlWindow.create(null, null, new SqlNodeList(SqlParserPos.ZERO), new SqlNodeList(ImmutableList.of(new SqlIdentifier(columnName, SqlParserPos.ZERO)), SqlParserPos.ZERO), SqlLiteral.createBoolean(true, SqlParserPos.ZERO), SqlWindow.createCurrentRow(SqlParserPos.ZERO), SqlWindow.createCurrentRow(SqlParserPos.ZERO), SqlLiteral.createBoolean(true, SqlParserPos.ZERO), SqlParserPos.ZERO);
    }

    public SqlWindow createUnboundedPrecedingWindow(String columnName) {
        return SqlWindow.create(null, null, new SqlNodeList(SqlParserPos.ZERO), new SqlNodeList(ImmutableList.of(new SqlIdentifier(columnName, SqlParserPos.ZERO)), SqlParserPos.ZERO), SqlLiteral.createBoolean(false, SqlParserPos.ZERO), SqlWindow.createUnboundedPreceding(SqlParserPos.ZERO), SqlWindow.createCurrentRow(SqlParserPos.ZERO), SqlLiteral.createBoolean(false, SqlParserPos.ZERO), SqlParserPos.ZERO);
    }

    @Deprecated
    public void populateBounds() {
        if (this.lowerBound == null && this.upperBound == null) {
            this.setLowerBound(SqlWindow.createUnboundedPreceding(this.pos));
        }
        if (this.lowerBound == null) {
            this.setLowerBound(SqlWindow.createCurrentRow(this.pos));
        }
        if (this.upperBound == null) {
            this.setUpperBound(SqlWindow.createCurrentRow(this.pos));
        }
    }

    private static class SqlWindowOperator
    extends SqlOperator {
        private static final SqlWindowOperator INSTANCE = new SqlWindowOperator();

        private SqlWindowOperator() {
            super("WINDOW", SqlKind.WINDOW, 2, true, null, null, null);
        }

        @Override
        public SqlSyntax getSyntax() {
            return SqlSyntax.SPECIAL;
        }

        @Override
        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            assert (functionQualifier == null);
            assert (operands.length == 8);
            return SqlWindow.create((SqlIdentifier)operands[0], (SqlIdentifier)operands[1], (SqlNodeList)operands[2], (SqlNodeList)operands[3], (SqlLiteral)operands[4], operands[5], operands[6], (SqlLiteral)operands[7], pos);
        }

        @Override
        public <R> void acceptCall(SqlVisitor<R> visitor, SqlCall call, boolean onlyExpressions, SqlBasicVisitor.ArgHandler<R> argHandler) {
            if (onlyExpressions) {
                for (Ord<SqlNode> operand : Ord.zip(call.getOperandList())) {
                    if (operand.e == null || operand.i == 1 && operand.e instanceof SqlIdentifier) continue;
                    argHandler.visitChild(visitor, call, operand.i, (SqlNode)operand.e);
                }
            } else {
                super.acceptCall(visitor, call, onlyExpressions, argHandler);
            }
        }

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            SqlWindow window = (SqlWindow)call;
            SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.WINDOW, "(", ")");
            if (window.refName != null) {
                window.refName.unparse(writer, 0, 0);
            }
            if (window.partitionList.size() > 0) {
                writer.sep("PARTITION BY");
                SqlWriter.Frame partitionFrame = writer.startList("", "");
                window.partitionList.unparse(writer, 0, 0);
                writer.endList(partitionFrame);
            }
            if (window.orderList.size() > 0) {
                writer.sep("ORDER BY");
                SqlWriter.Frame orderFrame = writer.startList("", "");
                window.orderList.unparse(writer, 0, 0);
                writer.endList(orderFrame);
            }
            if (window.lowerBound != null) {
                if (window.upperBound == null) {
                    if (window.isRows()) {
                        writer.sep("ROWS");
                    } else {
                        writer.sep("RANGE");
                    }
                    window.lowerBound.unparse(writer, 0, 0);
                } else {
                    if (window.isRows()) {
                        writer.sep("ROWS BETWEEN");
                    } else {
                        writer.sep("RANGE BETWEEN");
                    }
                    window.lowerBound.unparse(writer, 0, 0);
                    writer.keyword("AND");
                    window.upperBound.unparse(writer, 0, 0);
                }
            }
            if (window.allowPartial != null && !window.isAllowPartial()) {
                writer.keyword("DISALLOW PARTIAL");
            }
            writer.endList(frame);
        }
    }

    static enum Bound implements Symbolizable
    {
        CURRENT_ROW("CURRENT ROW"),
        UNBOUNDED_PRECEDING("UNBOUNDED PRECEDING"),
        UNBOUNDED_FOLLOWING("UNBOUNDED FOLLOWING");

        private final String sql;

        private Bound(String sql) {
            this.sql = sql;
        }

        public String toString() {
            return this.sql;
        }
    }
}

