/*
 * Decompiled with CFR 0.152.
 */
package ai.heavy.jdbc;

import ai.heavy.jdbc.HeavyAIArray;
import ai.heavy.jdbc.HeavyAIDatabaseMetaData;
import ai.heavy.jdbc.HeavyAIExceptionText;
import ai.heavy.jdbc.HeavyAIPreparedStatement;
import ai.heavy.jdbc.HeavyAIStatement;
import ai.heavy.jdbc.KeyLoader;
import ai.heavy.jdbc.Options;
import ai.heavy.thrift.server.Heavy;
import ai.heavy.thrift.server.TDBException;
import ai.heavy.thrift.server.TDatumType;
import ai.heavy.thrift.server.TServerStatus;
import com.mapd.common.SockTransportProperties;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.crypto.Cipher;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeavyAIConnection
implements Connection,
Cloneable {
    static final Logger logger = LoggerFactory.getLogger(HeavyAIConnection.class);
    Set<String> protocol_set = new HashSet<String>(Arrays.asList("binary", "binary_tls", "http", "https", "https_insecure"));
    protected String session = null;
    protected Heavy.Client client = null;
    protected String catalog;
    protected TTransport transport;
    protected SQLWarning warnings;
    protected String url;
    protected Connection_properties cP = null;

    public HeavyAIConnection getAlternateConnection() throws SQLException {
        logger.debug("HeavyAIConnection clone");
        HeavyAIConnection dbConnection = null;
        try {
            dbConnection = (HeavyAIConnection)super.clone();
        }
        catch (CloneNotSupportedException eE) {
            throw new SQLException("Error cloning connection [" + HeavyAIExceptionText.getExceptionDetail(eE), eE);
        }
        try {
            TProtocol protocol = dbConnection.manageConnection();
            dbConnection.client = new Heavy.Client(protocol);
        }
        catch (Exception jE) {
            throw new SQLException("Error creating new connection " + HeavyAIExceptionText.getExceptionDetail(jE), jE);
        }
        return dbConnection;
    }

    private TProtocol manageConnection() throws Exception {
        SockTransportProperties skT = null;
        String trust_store = null;
        if (this.cP.getProperty(Options.server_trust_store) != null && !this.cP.getProperty(Options.server_trust_store).isEmpty()) {
            trust_store = this.cP.getProperty(Options.server_trust_store);
        }
        String trust_store_pwd = null;
        if (this.cP.getProperty(Options.server_trust_store_pwd) != null && !this.cP.getProperty(Options.server_trust_store_pwd).isEmpty()) {
            trust_store_pwd = this.cP.getProperty(Options.server_trust_store_pwd);
        }
        TProtocol protocol = null;
        if (this.cP.isHttpProtocol()) {
            skT = SockTransportProperties.getUnencryptedClient();
            this.transport = skT.openHttpClientTransport(this.cP.getProperty(Options.host_name), Integer.parseInt(this.cP.getProperty(Options.port_num)));
            this.transport.open();
            protocol = new TJSONProtocol(this.transport);
        } else if (this.cP.isBinary()) {
            skT = SockTransportProperties.getUnencryptedClient();
            this.transport = skT.openClientTransport(this.cP.getProperty(Options.host_name), Integer.parseInt(this.cP.getProperty(Options.port_num)));
            if (!this.transport.isOpen()) {
                this.transport.open();
            }
            protocol = new TBinaryProtocol(this.transport);
        } else if (this.cP.isHttpsProtocol() || this.cP.isHttpsProtocol_insecure()) {
            skT = trust_store == null ? SockTransportProperties.getEncryptedClientDefaultTrustStore(!this.cP.isHttpsProtocol_insecure()) : SockTransportProperties.getEncryptedClientSpecifiedTrustStore(trust_store, trust_store_pwd, !this.cP.isHttpsProtocol_insecure());
            this.transport = skT.openHttpsClientTransport(this.cP.getProperty(Options.host_name), Integer.parseInt(this.cP.getProperty(Options.port_num)));
            this.transport.open();
            protocol = new TJSONProtocol(this.transport);
        } else if (this.cP.isBinary_tls()) {
            skT = trust_store == null ? SockTransportProperties.getEncryptedClientDefaultTrustStore(false) : SockTransportProperties.getEncryptedClientSpecifiedTrustStore(trust_store, trust_store_pwd, false);
            this.transport = skT.openClientTransport(this.cP.getProperty(Options.host_name), Integer.parseInt(this.cP.getProperty(Options.port_num)));
            if (!this.transport.isOpen()) {
                this.transport.open();
            }
            protocol = new TBinaryProtocol(this.transport);
        } else {
            throw new SQLException("Invalid protocol supplied");
        }
        return protocol;
    }

    private void setSession(Object pki_auth) throws Exception {
        KeyLoader.S_struct s_struct = null;
        if (pki_auth != null && pki_auth.toString().equalsIgnoreCase("true")) {
            s_struct = KeyLoader.getDetails_pkcs12(this.cP.getProperty(Options.sslcert), this.cP.getProperty(Options.sslkey_password));
            this.cP.setProperty(Options.password, s_struct.cert);
        }
        this.session = this.client.connect(this.cP.getProperty(Options.user), this.cP.getProperty(Options.password), this.cP.getProperty(Options.db_name));
        if (pki_auth != null && pki_auth.toString().equalsIgnoreCase("true")) {
            Cipher cipher = Cipher.getInstance(s_struct.key.getAlgorithm());
            cipher.init(2, s_struct.key);
            byte[] decodedBytes = Base64.getDecoder().decode(this.session);
            byte[] decoded_bytes = cipher.doFinal(decodedBytes);
            this.session = new String(decoded_bytes, "UTF-8");
        }
    }

    public HeavyAIConnection(String url, Properties base_properties) throws SQLException {
        this.url = url;
        this.cP = new Connection_properties(url, base_properties);
        try {
            TProtocol protocol = this.manageConnection();
            this.client = new Heavy.Client(protocol);
            this.setSession(this.cP.getProperty(Options.pkiauth));
            this.catalog = this.cP.getProperty(Options.db_name);
        }
        catch (TTransportException ex) {
            throw new SQLException("Thrift transport connection failed - " + HeavyAIExceptionText.getExceptionDetail(ex), ex);
        }
        catch (TDBException ex) {
            throw new SQLException("HEAVY.AI connection failed - " + HeavyAIExceptionText.getExceptionDetail(ex), ex);
        }
        catch (TException ex) {
            throw new SQLException("Thrift failed - " + HeavyAIExceptionText.getExceptionDetail(ex), ex);
        }
        catch (Exception ex) {
            throw new SQLException("Connection failed - " + HeavyAIExceptionText.getExceptionDetail(ex), ex);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new HeavyAIStatement(this.session, this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new HeavyAIPreparedStatement(sql, this.session, this);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void close() throws SQLException {
        try {
            logger.debug("Session at close is " + this.session);
            if (this.session != null) {
                this.client.disconnect(this.session);
            }
            this.closeConnection();
        }
        catch (TDBException ex) {
            throw new SQLException("disconnect failed." + ex.getError_msg());
        }
        catch (TException ex) {
            throw new SQLException("disconnect failed." + ex.toString());
        }
    }

    protected void closeConnection() throws SQLException {
        this.session = null;
        this.transport.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.session == null;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        HeavyAIDatabaseMetaData dbMetaData = new HeavyAIDatabaseMetaData(this);
        return dbMetaData;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            if (this.session != null) {
                TServerStatus server_status = this.client.get_server_status(this.session);
                return server_status.read_only;
            }
        }
        catch (TDBException ex) {
            throw new SQLException("get_server_status failed during isReadOnly check." + ex.getError_msg());
        }
        catch (TException ex) {
            throw new SQLException("get_server_status failed during isReadOnly check." + ex.toString());
        }
        return true;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.catalog;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new HeavyAIStatement(this.session, this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new HeavyAIPreparedStatement(sql, this.session, this);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        try {
            this.client.get_server_status(this.session);
        }
        catch (TTransportException ex) {
            throw new SQLException("Connection failed - " + ex.toString());
        }
        catch (TDBException ex) {
            throw new SQLException("Connection failed - " + ex.getError_msg());
        }
        catch (TException ex) {
            throw new SQLException("Connection failed - " + ex.toString());
        }
        return true;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        TDatumType type;
        try {
            type = TDatumType.valueOf(typeName.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new SQLException("No matching heavyDB type for " + typeName);
        }
        return new HeavyAIArray(type, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        String db_name = this.cP.getProperty(Options.db_name);
        if (db_name == null) {
            throw new SQLException("db name not set,  line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
        }
        if (!schema.equals(db_name.toString())) {
            logger.warn("Connected to schema [" + schema + "] differs from db name [" + db_name + "].");
        }
    }

    @Override
    public String getSchema() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    class Connection_properties
    extends Properties {
        private String extract_and_remove_query_components(String connection_url, Properties query_props) throws SQLException {
            String[] url_components = connection_url.split("\\?");
            if (url_components.length == 2) {
                StringReader reader = new StringReader(url_components[1].replace('&', '\n'));
                try {
                    query_props.load(reader);
                }
                catch (IOException iex) {
                    throw new SQLException(iex.toString());
                }
            } else if (url_components.length > 2) {
                throw new SQLException("Invalid connection string. Multiple query components included [" + connection_url + "]");
            }
            return url_components[0];
        }

        public Connection_properties(String connection_url, Properties baseProperties) throws SQLException {
            connection_url = this.extract_and_remove_query_components(connection_url, this);
            String[] url_values = connection_url.split(":");
            if (url_values.length > Options.option_order.length + 2) {
                throw new SQLException("Invalid number of arguments provided in url [" + url_values.length + "]. Maximum allowed [" + (Options.option_order.length + 2) + "]");
            }
            for (int i = 2; i < url_values.length; ++i) {
                String existingValue = this.getProperty(Options.option_order[i - 2]);
                if (existingValue != null && !existingValue.equals(url_values[i])) {
                    logger.warn("Connection property [" + Options.option_order[i - 2] + "] has been provided with different values in the URL and query component of the url. Defaulting to the URL value");
                }
                this.setProperty(Options.option_order[i - 2], url_values[i]);
            }
            for (String key : baseProperties.stringPropertyNames()) {
                String existingValue = this.getProperty(key);
                if (existingValue != null && !existingValue.equals(baseProperties.getProperty(key))) {
                    logger.warn("Connection property " + key + "] has been provided with different values in the properties object and the url. Defaulting to the URL value");
                    continue;
                }
                this.setProperty(key, baseProperties.getProperty(key));
            }
            this.validate_params();
        }

        private void validate_params() throws SQLException {
            String hN;
            for (String key : this.stringPropertyNames()) {
                if (key == Options.user || key == Options.password || Arrays.asList(Options.option_order).contains(key)) continue;
                logger.warn("Unsupported configuration key" + key + " used.");
            }
            if (this.containsKey(Options.host_name) && (hN = this.getProperty(Options.host_name)).startsWith("//")) {
                this.setProperty(Options.host_name, hN.substring(2));
            }
            String protocol = "binary";
            if (this.containsKey(Options.protocol)) {
                protocol = this.getProperty(Options.protocol);
                protocol.toLowerCase();
                if (!HeavyAIConnection.this.protocol_set.contains(protocol)) {
                    logger.warn("Incorrect protcol [" + protocol + "] supplied. Possible values are [" + HeavyAIConnection.this.protocol_set.toString() + "]. Using binary as default");
                    protocol = "binary";
                }
            }
            this.setProperty(Options.protocol, protocol);
            if (this.containsKey(Options.port_num)) {
                try {
                    Integer.parseInt(this.getProperty(Options.port_num));
                }
                catch (NumberFormatException nfe) {
                    throw new SQLException("Invalid port number supplied" + this.getProperty(Options.port_num));
                }
            }
            if (this.containsKey(Options.server_trust_store) && !this.containsKey(Options.server_trust_store_pwd)) {
                logger.warn("server trust store [" + this.getProperty(Options.server_trust_store) + " specfied without a password");
            }
            if (this.containsKey(Options.server_trust_store_pwd) && !this.containsKey(Options.server_trust_store)) {
                logger.warn("server trust store password specified without a keystore file");
            }
            if (!this.containsKey(Options.max_rows)) {
                this.setProperty(Options.max_rows, "100000");
            } else {
                try {
                    Integer.parseInt(this.getProperty(Options.max_rows));
                }
                catch (NumberFormatException nfe) {
                    throw new SQLException("Invalid value supplied for max rows " + this.getProperty(Options.max_rows));
                }
            }
        }

        boolean isHttpProtocol() {
            return this.containsKey(Options.protocol) && this.getProperty(Options.protocol).equals("http");
        }

        boolean isHttpsProtocol_insecure() {
            return this.containsKey(Options.protocol) && this.getProperty(Options.protocol).equals("https_insecure");
        }

        boolean isHttpsProtocol() {
            return this.containsKey(Options.protocol) && this.getProperty(Options.protocol).equals("https");
        }

        boolean isBinary() {
            return this.containsKey(Options.protocol) && this.getProperty(Options.protocol).equals("binary");
        }

        boolean isBinary_tls() {
            return this.containsKey(Options.protocol) && this.getProperty(Options.protocol).equals("binary_tls");
        }

        boolean containsTrustStore() {
            return this.containsKey(Options.server_trust_store);
        }
    }
}

