/*
 * Decompiled with CFR 0.152.
 */
package ai.heavy.jdbc;

import ai.heavy.jdbc.HeavyAIConnection;
import ai.heavy.jdbc.HeavyAIData;
import ai.heavy.jdbc.HeavyAIDriver;
import ai.heavy.jdbc.HeavyAIResultSet;
import ai.heavy.jdbc.HeavyAIType;
import ai.heavy.jdbc.Options;
import ai.heavy.thrift.server.TColumn;
import ai.heavy.thrift.server.TColumnData;
import ai.heavy.thrift.server.TColumnType;
import ai.heavy.thrift.server.TDBInfo;
import ai.heavy.thrift.server.TDBObject;
import ai.heavy.thrift.server.TDBObjectType;
import ai.heavy.thrift.server.TDatumType;
import ai.heavy.thrift.server.TEncodingType;
import ai.heavy.thrift.server.TQueryResult;
import ai.heavy.thrift.server.TQueryType;
import ai.heavy.thrift.server.TRowSet;
import ai.heavy.thrift.server.TTableDetails;
import ai.heavy.thrift.server.TTablePermissions;
import ai.heavy.thrift.server.TTypeInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HeavyAIDatabaseMetaData
implements DatabaseMetaData {
    static final Logger HEAVYDBLOGGER = LoggerFactory.getLogger(HeavyAIDatabaseMetaData.class);
    HeavyAIConnection con = null;
    int databaseMajorVersion = 0;
    int databaseMinorVersion = 0;
    String databaseVersion = null;

    public HeavyAIDatabaseMetaData(HeavyAIConnection connection) throws SQLException {
        this.con = connection;
        try {
            this.databaseVersion = this.con.client.get_version();
        }
        catch (TException ex) {
            throw new SQLException("Failed to get DB version " + ex.toString());
        }
        String[] vers = this.databaseVersion.split("\\.");
        try {
            this.databaseMajorVersion = Integer.parseInt(vers[0]);
            this.databaseMinorVersion = Integer.parseInt(vers[1]);
        }
        catch (NumberFormatException ex) {
            throw new SQLException("Non-numeric version returned from HEAVY.AI server: " + ex.getMessage());
        }
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return this.con.url;
    }

    @Override
    public String getUserName() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return (String)this.con.cP.get(Options.user);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return "OmniSciDB";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return this.databaseVersion;
    }

    @Override
    public String getDriverName() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return "OmniSciDB JDBC Driver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return HeavyAIDriver.DriverVersion;
    }

    @Override
    public int getDriverMajorVersion() {
        return HeavyAIDriver.DriverMajorVersion;
    }

    @Override
    public int getDriverMinorVersion() {
        return HeavyAIDriver.DriverMinorVersion;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return " ";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return "";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return "ACOS(float), ACOS(number), ASIN, ATAN2, CEIL, COS, COT, DEGREES, EXP, FLOOR, LN, LOG, PI(), POWER, SQRT, RADIANS, ROUND, SIN, TAN, ATAN, ABS, MOD SIGN, TRUNCATE";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return "CHAR_LENGTH, CHAR, KEY_FOR_STRING";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return "";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return "DATE_TRUNC, NOW, EXTRACT";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return "Database";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return "N/A";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return "N/A";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 0;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return null;
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    public TColumnType createTColumnType(String colName, TTypeInfo colType) {
        return this.createTColumnType(colName, colType, false);
    }

    public TColumnType createTColumnType(String colName, TTypeInfo colType, Boolean irk) {
        TColumnType ct = new TColumnType();
        ct.col_name = colName;
        ct.col_type = colType;
        ct.is_reserved_keyword = irk;
        ct.is_system = false;
        ct.is_physical = false;
        return ct;
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        List<String> views;
        List<String> tables;
        HEAVYDBLOGGER.debug("Entered");
        try {
            tables = this.con.client.get_tables_for_database(this.con.session, catalog);
        }
        catch (TException ex) {
            throw new SQLException("get_tables_for_database failed " + ex.toString());
        }
        try {
            views = this.con.client.get_views(this.con.session);
        }
        catch (TException ex) {
            throw new SQLException("get_views failed " + ex.toString());
        }
        TTypeInfo strTTI = new TTypeInfo(TDatumType.STR, TEncodingType.NONE, false, false, 0, 0, 0);
        TColumnType[] columns = new TColumnType[]{this.createTColumnType("TABLE_CAT", new TTypeInfo(strTTI)), this.createTColumnType("TABLE_SCHEM", new TTypeInfo(strTTI)), this.createTColumnType("TABLE_NAME", new TTypeInfo(strTTI)), this.createTColumnType("TABLE_TYPE", new TTypeInfo(strTTI)), this.createTColumnType("REMARKS", new TTypeInfo(strTTI)), this.createTColumnType("TYPE_CAT", new TTypeInfo(strTTI)), this.createTColumnType("TYPE_SCHEM", new TTypeInfo(strTTI)), this.createTColumnType("TYPE_NAME", new TTypeInfo(strTTI)), this.createTColumnType("SELF_REFERENCING_COL_NAME", new TTypeInfo(strTTI)), this.createTColumnType("REF_GENERATION", new TTypeInfo(strTTI))};
        HashMap dataMap = new HashMap(columns.length);
        HashMap nullMap = new HashMap(columns.length);
        ArrayList<TColumnType> rowDesc = new ArrayList<TColumnType>(columns.length);
        for (TColumnType col : columns) {
            rowDesc.add(col);
            dataMap.put(col.col_name, new ArrayList());
            nullMap.put(col.col_name, new ArrayList());
        }
        if (schemaPattern == null || schemaPattern.toLowerCase().equals(this.con.getCatalog().toLowerCase())) {
            for (String x : tables) {
                ((ArrayList)dataMap.get("TABLE_NAME")).add(x);
                ((ArrayList)nullMap.get("TABLE_NAME")).add(false);
                ((ArrayList)nullMap.get("TABLE_SCHEM")).add(true);
                ((ArrayList)nullMap.get("TABLE_CAT")).add(true);
                if (views.contains(x)) {
                    ((ArrayList)dataMap.get("TABLE_TYPE")).add("VIEW");
                } else {
                    ((ArrayList)dataMap.get("TABLE_TYPE")).add("TABLE");
                }
                ((ArrayList)nullMap.get("TABLE_TYPE")).add(false);
                ((ArrayList)nullMap.get("REMARKS")).add(true);
                ((ArrayList)nullMap.get("TYPE_CAT")).add(true);
                ((ArrayList)nullMap.get("TYPE_SCHEM")).add(true);
                ((ArrayList)nullMap.get("TYPE_NAME")).add(true);
                ((ArrayList)nullMap.get("SELF_REFERENCING_COL_NAME")).add(true);
                ((ArrayList)nullMap.get("REF_GENERATION")).add(true);
            }
        }
        ArrayList<TColumn> columnsList = new ArrayList<TColumn>(columns.length);
        for (TColumnType col : columns) {
            TColumn schemaCol = this.createTColumnData(dataMap.get(col.col_name), (List)nullMap.get(col.col_name));
            columnsList.add(schemaCol);
        }
        TRowSet rowSet = new TRowSet(rowDesc, null, columnsList, true);
        TQueryResult result = new TQueryResult(rowSet, 0L, 0L, null, null, true, TQueryType.UNKNOWN);
        HeavyAIResultSet tab = new HeavyAIResultSet(result, "GetTables");
        return tab;
    }

    private TColumn createTColumnData(Object data, List<Boolean> nullsList) {
        TColumnData colData = new TColumnData();
        colData.setStr_col((List)data);
        TColumn col = new TColumn(colData, nullsList);
        return col;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        List<TDBInfo> databases = null;
        try {
            databases = this.con.client.get_databases(this.con.session);
        }
        catch (TException ex) {
            throw new SQLException("get_database failed " + ex.toString());
        }
        TTypeInfo strTTI = new TTypeInfo(TDatumType.STR, TEncodingType.NONE, false, false, 0, 0, 0);
        TColumnType[] columns = new TColumnType[]{this.createTColumnType("TABLE_SCHEM", new TTypeInfo(strTTI)), this.createTColumnType("TABLE_CATALOG", new TTypeInfo(strTTI))};
        ArrayList<TColumnType> rowDesc = new ArrayList<TColumnType>();
        for (TColumnType col : columns) {
            rowDesc.add(col);
        }
        ArrayList<String> schemaList = new ArrayList<String>();
        ArrayList<Boolean> nullList = new ArrayList<Boolean>();
        ArrayList<Boolean> catalogNullList = new ArrayList<Boolean>();
        for (TDBInfo x : databases) {
            schemaList.add(x.db_name);
            nullList.add(false);
            catalogNullList.add(true);
        }
        TColumnData colData = new TColumnData();
        colData.setStr_col(schemaList);
        TColumn schemaCol = new TColumn(colData, nullList);
        TColumn catalogCol = new TColumn(null, catalogNullList);
        ArrayList<TColumn> columnsList = new ArrayList<TColumn>();
        columnsList.add(schemaCol);
        columnsList.add(catalogCol);
        TRowSet rowSet = new TRowSet(rowDesc, null, columnsList, true);
        TQueryResult result = new TQueryResult(rowSet, 0L, 0L, null, null, true, TQueryType.UNKNOWN);
        HeavyAIResultSet schemas = new HeavyAIResultSet(result, "getSchemas");
        return schemas;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return this.getSchemas();
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        TTypeInfo strTTI = new TTypeInfo(TDatumType.STR, TEncodingType.NONE, false, false, 0, 0, 0);
        TColumnType[] columns = new TColumnType[]{this.createTColumnType("TABLE_TYPE", new TTypeInfo(strTTI))};
        HashMap<String, HeavyAIData> dataMap = new HashMap<String, HeavyAIData>(columns.length);
        ArrayList<TColumnType> rowDesc = new ArrayList<TColumnType>(columns.length);
        for (TColumnType col : columns) {
            rowDesc.add(col);
            dataMap.put(col.col_name, new HeavyAIData(col.col_type.type));
        }
        ((HeavyAIData)dataMap.get("TABLE_TYPE")).add("TABLE");
        ((HeavyAIData)dataMap.get("TABLE_TYPE")).add("VIEW");
        ArrayList<TColumn> columnsList = new ArrayList<TColumn>(columns.length);
        for (TColumnType col : columns) {
            TColumn schemaCol = ((HeavyAIData)dataMap.get(col.col_name)).getTColumn();
            columnsList.add(schemaCol);
        }
        TRowSet rowSet = new TRowSet(rowDesc, null, columnsList, true);
        TQueryResult result = new TQueryResult(rowSet, 0L, 0L, null, null, true, TQueryType.UNKNOWN);
        HeavyAIResultSet tab = new HeavyAIResultSet(result, "getTableTypes");
        return tab;
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        List<String> tables;
        HEAVYDBLOGGER.debug("Entered");
        HEAVYDBLOGGER.debug("TablePattern " + tableNamePattern + " columnNamePattern " + columnNamePattern);
        String modifiedTablePattern = tableNamePattern.replaceAll("%", ".*");
        String modifiedColumnPattern = columnNamePattern == null ? null : columnNamePattern.replaceAll("%", ".*");
        HEAVYDBLOGGER.debug("TablePattern " + tableNamePattern + " modifiedColumnPattern " + modifiedColumnPattern);
        TTypeInfo strTTI = new TTypeInfo(TDatumType.STR, TEncodingType.NONE, false, false, 0, 0, 0);
        TTypeInfo intTTI = new TTypeInfo(TDatumType.INT, TEncodingType.NONE, false, false, 0, 0, 0);
        TTypeInfo smallIntTTI = new TTypeInfo(TDatumType.SMALLINT, TEncodingType.NONE, false, false, 0, 0, 0);
        TColumnType[] columns = new TColumnType[]{this.createTColumnType("TABLE_CAT", new TTypeInfo(strTTI)), this.createTColumnType("TABLE_SCHEM", new TTypeInfo(strTTI)), this.createTColumnType("TABLE_NAME", new TTypeInfo(strTTI)), this.createTColumnType("COLUMN_NAME", new TTypeInfo(strTTI)), this.createTColumnType("DATA_TYPE", new TTypeInfo(intTTI)), this.createTColumnType("TYPE_NAME", new TTypeInfo(strTTI)), this.createTColumnType("COLUMN_SIZE", new TTypeInfo(intTTI)), this.createTColumnType("BUFFER_LENGTH", new TTypeInfo(strTTI)), this.createTColumnType("DECIMAL_DIGITS", new TTypeInfo(intTTI)), this.createTColumnType("NUM_PREC_RADIX", new TTypeInfo(intTTI)), this.createTColumnType("NULLABLE", new TTypeInfo(intTTI)), this.createTColumnType("REMARKS", new TTypeInfo(strTTI)), this.createTColumnType("COLUMN_DEF", new TTypeInfo(strTTI)), this.createTColumnType("SQL_DATA_TYPE", new TTypeInfo(intTTI)), this.createTColumnType("SQL_DATETIME_SUB", new TTypeInfo(intTTI)), this.createTColumnType("CHAR_OCTET_LENGTH", new TTypeInfo(intTTI)), this.createTColumnType("ORDINAL_POSITION", new TTypeInfo(intTTI)), this.createTColumnType("IS_NULLABLE", new TTypeInfo(strTTI)), this.createTColumnType("SCOPE_CATALOG", new TTypeInfo(strTTI)), this.createTColumnType("SCOPE_SCHEMA", new TTypeInfo(strTTI)), this.createTColumnType("SCOPE_TABLE", new TTypeInfo(strTTI)), this.createTColumnType("SOURCE_DATA_TYPE", new TTypeInfo(smallIntTTI)), this.createTColumnType("IS_AUTOINCREMENT", new TTypeInfo(strTTI)), this.createTColumnType("IS_GENERATEDCOLUMN", new TTypeInfo(strTTI))};
        HashMap<String, HeavyAIData> dataMap = new HashMap<String, HeavyAIData>(columns.length);
        ArrayList<TColumnType> rowDesc = new ArrayList<TColumnType>(columns.length);
        for (TColumnType col : columns) {
            rowDesc.add(col);
            dataMap.put(col.col_name, new HeavyAIData(col.col_type.type));
        }
        try {
            tables = this.con.client.get_tables_for_database(this.con.session, catalog);
        }
        catch (TException ex) {
            throw new SQLException("get_tables_for_database failed " + ex.toString());
        }
        for (String tableName : tables) {
            TTableDetails tableDetails;
            if (tableNamePattern != null && !tableNamePattern.equals(tableName)) continue;
            try {
                tableDetails = this.con.client.get_table_details(this.con.session, tableName);
            }
            catch (TException ex) {
                throw new SQLException("get_table_details failed " + ex.toString());
            }
            int ordinal = 0;
            for (TColumnType value : tableDetails.row_desc) {
                ++ordinal;
                if (columnNamePattern != null && !value.col_name.matches(modifiedColumnPattern)) continue;
                ((HeavyAIData)dataMap.get("TABLE_CAT")).setNull(true);
                ((HeavyAIData)dataMap.get("TABLE_SCHEM")).setNull(true);
                ((HeavyAIData)dataMap.get("TABLE_NAME")).add(tableName);
                ((HeavyAIData)dataMap.get("COLUMN_NAME")).add(value.col_name);
                ((HeavyAIData)dataMap.get("DATA_TYPE")).add(HeavyAIType.toJava(value.col_type.type));
                ((HeavyAIData)dataMap.get("TYPE_NAME")).add(value.col_type.type.name() + (value.col_type.is_array ? "[]" : ""));
                if (value.col_type.type == TDatumType.DECIMAL) {
                    ((HeavyAIData)dataMap.get("COLUMN_SIZE")).add(value.col_type.precision);
                } else {
                    ((HeavyAIData)dataMap.get("COLUMN_SIZE")).add(100);
                }
                ((HeavyAIData)dataMap.get("BUFFER_LENGTH")).setNull(true);
                if (value.col_type.type == TDatumType.DECIMAL) {
                    ((HeavyAIData)dataMap.get("DECIMAL_DIGITS")).add(value.col_type.scale);
                } else {
                    ((HeavyAIData)dataMap.get("DECIMAL_DIGITS")).setNull(true);
                }
                ((HeavyAIData)dataMap.get("NUM_PREC_RADIX")).add(10);
                ((HeavyAIData)dataMap.get("NULLABLE")).add(value.col_type.nullable ? 1 : 0);
                ((HeavyAIData)dataMap.get("REMARKS")).add(" ");
                ((HeavyAIData)dataMap.get("COLUMN_DEF")).setNull(true);
                ((HeavyAIData)dataMap.get("SQL_DATA_TYPE")).add(0);
                ((HeavyAIData)dataMap.get("SQL_DATETIME_SUB")).setNull(true);
                ((HeavyAIData)dataMap.get("CHAR_OCTET_LENGTH")).add(0);
                ((HeavyAIData)dataMap.get("ORDINAL_POSITION")).add(ordinal);
                ((HeavyAIData)dataMap.get("IS_NULLABLE")).add(value.col_type.nullable ? "YES" : "NO");
                ((HeavyAIData)dataMap.get("SCOPE_CATALOG")).setNull(true);
                ((HeavyAIData)dataMap.get("SCOPE_SCHEMA")).setNull(true);
                ((HeavyAIData)dataMap.get("SCOPE_TABLE")).setNull(true);
                ((HeavyAIData)dataMap.get("SOURCE_DATA_TYPE")).add(HeavyAIType.toJava(value.col_type.type));
                ((HeavyAIData)dataMap.get("IS_AUTOINCREMENT")).add("NO");
                ((HeavyAIData)dataMap.get("IS_GENERATEDCOLUMN")).add("NO");
            }
        }
        ArrayList<TColumn> columnsList = new ArrayList<TColumn>(columns.length);
        for (TColumnType col : columns) {
            TColumn schemaCol = ((HeavyAIData)dataMap.get(col.col_name)).getTColumn();
            columnsList.add(schemaCol);
        }
        TRowSet rowSet = new TRowSet(rowDesc, null, columnsList, true);
        TQueryResult result = new TQueryResult(rowSet, 0L, 0L, null, null, true, TQueryType.UNKNOWN);
        HeavyAIResultSet cols = new HeavyAIResultSet(result, "getColumns");
        return cols;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    public ResultSet getEmptyResultSet() {
        return new HeavyAIResultSet();
    }

    public ResultSet getEmptyResultSetWithDesc(TColumnType[] columns) throws SQLException {
        HashMap<String, HeavyAIData> dataMap = new HashMap<String, HeavyAIData>(columns.length);
        ArrayList<TColumnType> rowDesc = new ArrayList<TColumnType>(columns.length);
        for (TColumnType col : columns) {
            rowDesc.add(col);
            dataMap.put(col.col_name, new HeavyAIData(col.col_type.type));
        }
        ArrayList<TColumn> columnsList = new ArrayList<TColumn>(columns.length);
        for (TColumnType col : columns) {
            TColumn schemaCol = ((HeavyAIData)dataMap.get(col.col_name)).getTColumn();
            columnsList.add(schemaCol);
        }
        TRowSet rowSet = new TRowSet(rowDesc, null, columnsList, true);
        TQueryResult result = new TQueryResult(rowSet, 0L, 0L, null, null, true, TQueryType.UNKNOWN);
        HeavyAIResultSet cols = new HeavyAIResultSet(result, "getColumns");
        return cols;
    }

    private void tablePermProcess(List<String> tables, Map<String, HeavyAIData> dataMap, String tableNamePattern) throws TException {
        for (String table : tables) {
            if (tableNamePattern != null && !table.matches(tableNamePattern)) continue;
            List<TDBObject> db_objects = this.con.client.get_db_object_privs(this.con.session, table, TDBObjectType.TableDBObjectType);
            for (TDBObject db_object : db_objects) {
                if (db_object.objectName.equalsIgnoreCase("super")) {
                    db_object.objectName = table;
                }
                if (!db_object.objectName.equalsIgnoreCase(table)) continue;
                TTablePermissions tt = new TTablePermissions(db_object.privs.get(0), db_object.privs.get(1), db_object.privs.get(2), db_object.privs.get(3), db_object.privs.get(4), db_object.privs.get(5), db_object.privs.get(6), db_object.privs.get(7));
                int ordinal = 1;
                TTablePermissions._Fields field = tt.fieldForId(ordinal);
                while (field != null) {
                    Boolean x = (Boolean)tt.getFieldValue(field);
                    if (x.booleanValue()) {
                        dataMap.get("PRIVILEGE").add(field.getFieldName().toUpperCase().replace("_", ""));
                        dataMap.get("TABLE_CAT").setNull(true);
                        dataMap.get("TABLE_SCHEM").setNull(true);
                        dataMap.get("TABLE_NAME").add(db_object.objectName);
                        dataMap.get("GRANTOR").setNull(true);
                        dataMap.get("GRANTEE").add(db_object.grantee);
                        dataMap.get("IS_GRANTABLE").add("NO");
                    }
                    field = tt.fieldForId(++ordinal);
                }
            }
        }
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        String modifiedTablePattern = tableNamePattern == null ? null : tableNamePattern.replaceAll("%", ".*");
        HEAVYDBLOGGER.debug("TablePattern " + tableNamePattern + " modifiedTableNamePattern " + modifiedTablePattern);
        TTypeInfo strTTI = new TTypeInfo(TDatumType.STR, TEncodingType.NONE, false, false, 0, 0, 0);
        final TDatumType datumType = strTTI.type;
        HashMap dataMap = new HashMap(){
            {
                this.put("TABLE_CAT", new HeavyAIData(datumType));
                this.put("TABLE_SCHEM", new HeavyAIData(datumType));
                this.put("TABLE_NAME", new HeavyAIData(datumType));
                this.put("GRANTOR", new HeavyAIData(datumType));
                this.put("GRANTEE", new HeavyAIData(datumType));
                this.put("PRIVILEGE", new HeavyAIData(datumType));
                this.put("IS_GRANTABLE", new HeavyAIData(datumType));
            }
        };
        try {
            List<String> tables = this.con.client.get_tables(this.con.session);
            this.tablePermProcess(tables, dataMap, modifiedTablePattern);
        }
        catch (TException ex) {
            throw new SQLException("get_privileges failed " + ex.toString());
        }
        ArrayList<TColumnType> rowDesc = new ArrayList<TColumnType>(dataMap.size());
        ArrayList<TColumn> columnsList = new ArrayList<TColumn>(dataMap.size());
        for (Map.Entry pair : dataMap.entrySet()) {
            columnsList.add(((HeavyAIData)pair.getValue()).getTColumn());
            rowDesc.add(this.createTColumnType((String)pair.getKey(), new TTypeInfo(strTTI)));
        }
        TRowSet rowSet = new TRowSet(rowDesc, null, columnsList, true);
        TQueryResult result = new TQueryResult(rowSet, 0L, 0L, null, null, true, TQueryType.UNKNOWN);
        HeavyAIResultSet cols = new HeavyAIResultSet(result, "getPrivileges");
        return cols;
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        TTypeInfo strTTI = new TTypeInfo(TDatumType.STR, TEncodingType.NONE, false, false, 0, 0, 0);
        TTypeInfo intTTI = new TTypeInfo(TDatumType.INT, TEncodingType.NONE, false, false, 0, 0, 0);
        TTypeInfo smallIntTTI = new TTypeInfo(TDatumType.SMALLINT, TEncodingType.NONE, false, false, 0, 0, 0);
        TColumnType[] columns = new TColumnType[]{this.createTColumnType("TABLE_CAT", new TTypeInfo(strTTI)), this.createTColumnType("TABLE_SCHEM", new TTypeInfo(strTTI)), this.createTColumnType("TABLE_NAME", new TTypeInfo(strTTI)), this.createTColumnType("COLUMN_NAME", new TTypeInfo(strTTI)), this.createTColumnType("KEY_SEQ", new TTypeInfo(smallIntTTI)), this.createTColumnType("PK_NAME", new TTypeInfo(strTTI))};
        return this.getEmptyResultSetWithDesc(columns);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        TTypeInfo strTTI = new TTypeInfo(TDatumType.STR, TEncodingType.NONE, false, false, 0, 0, 0);
        TTypeInfo intTTI = new TTypeInfo(TDatumType.INT, TEncodingType.NONE, false, false, 0, 0, 0);
        TTypeInfo smallIntTTI = new TTypeInfo(TDatumType.SMALLINT, TEncodingType.NONE, false, false, 0, 0, 0);
        TColumnType[] columns = new TColumnType[]{this.createTColumnType("PKTABLE_CAT", new TTypeInfo(strTTI)), this.createTColumnType("PKTABLE_SCHEM", new TTypeInfo(strTTI)), this.createTColumnType("PKTABLE_NAME", new TTypeInfo(strTTI)), this.createTColumnType("PKCOLUMN_NAME", new TTypeInfo(strTTI)), this.createTColumnType("FKTABLE_CAT", new TTypeInfo(strTTI)), this.createTColumnType("FKTABLE_SCHEM", new TTypeInfo(strTTI)), this.createTColumnType("FKTABLE_NAME", new TTypeInfo(strTTI)), this.createTColumnType("FKCOLUMN_NAME", new TTypeInfo(strTTI)), this.createTColumnType("KEY_SEQ", new TTypeInfo(smallIntTTI)), this.createTColumnType("UPDATE_RULE", new TTypeInfo(smallIntTTI)), this.createTColumnType("DELETE_RULE", new TTypeInfo(smallIntTTI)), this.createTColumnType("FK_NAME", new TTypeInfo(strTTI)), this.createTColumnType("PK_NAME", new TTypeInfo(strTTI)), this.createTColumnType("DEFERRABILITY", new TTypeInfo(smallIntTTI))};
        return this.getEmptyResultSetWithDesc(columns);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        TTypeInfo strTTI = new TTypeInfo(TDatumType.STR, TEncodingType.NONE, false, false, 0, 0, 0);
        TTypeInfo intTTI = new TTypeInfo(TDatumType.INT, TEncodingType.NONE, false, false, 0, 0, 0);
        TTypeInfo smallIntTTI = new TTypeInfo(TDatumType.SMALLINT, TEncodingType.NONE, false, false, 0, 0, 0);
        TColumnType[] columns = new TColumnType[]{this.createTColumnType("FKTABLE_CAT", new TTypeInfo(strTTI)), this.createTColumnType("FKTABLE_SCHEM", new TTypeInfo(strTTI)), this.createTColumnType("FKTABLE_NAME", new TTypeInfo(strTTI)), this.createTColumnType("FKCOLUMN_NAME", new TTypeInfo(strTTI)), this.createTColumnType("PKTABLE_CAT", new TTypeInfo(strTTI)), this.createTColumnType("PKTABLE_SCHEM", new TTypeInfo(strTTI)), this.createTColumnType("PKTABLE_NAME", new TTypeInfo(strTTI)), this.createTColumnType("PKCOLUMN_NAME", new TTypeInfo(strTTI)), this.createTColumnType("KEY_SEQ", new TTypeInfo(smallIntTTI)), this.createTColumnType("UPDATE_RULE", new TTypeInfo(smallIntTTI)), this.createTColumnType("DELETE_RULE", new TTypeInfo(smallIntTTI)), this.createTColumnType("PK_NAME", new TTypeInfo(strTTI)), this.createTColumnType("FK_NAME", new TTypeInfo(strTTI)), this.createTColumnType("DEFERRABILITY", new TTypeInfo(smallIntTTI))};
        return this.getEmptyResultSetWithDesc(columns);
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        TTypeInfo strTTI = new TTypeInfo(TDatumType.STR, TEncodingType.NONE, false, false, 0, 0, 0);
        TTypeInfo intTTI = new TTypeInfo(TDatumType.INT, TEncodingType.NONE, false, false, 0, 0, 0);
        TTypeInfo smallIntTTI = new TTypeInfo(TDatumType.SMALLINT, TEncodingType.NONE, false, false, 0, 0, 0);
        TTypeInfo boolTTI = new TTypeInfo(TDatumType.BOOL, TEncodingType.NONE, false, false, 0, 0, 0);
        TColumnType[] columns = new TColumnType[]{this.createTColumnType("TYPE_NAME", new TTypeInfo(strTTI)), this.createTColumnType("DATA_TYPE", new TTypeInfo(intTTI)), this.createTColumnType("PRECISION", new TTypeInfo(intTTI)), this.createTColumnType("LITERAL_PREFIX", new TTypeInfo(strTTI)), this.createTColumnType("LITERAL_SUFFIX", new TTypeInfo(strTTI)), this.createTColumnType("CREATE_PARAMS", new TTypeInfo(strTTI)), this.createTColumnType("NULLABLE", new TTypeInfo(smallIntTTI)), this.createTColumnType("CASE_SENSITIVE", new TTypeInfo(boolTTI)), this.createTColumnType("SEARCHABLE", new TTypeInfo(smallIntTTI)), this.createTColumnType("UNSIGNED_ATTRIBUTE", new TTypeInfo(boolTTI)), this.createTColumnType("FIXED_PREC_SCALE", new TTypeInfo(boolTTI)), this.createTColumnType("AUTO_INCREMENT", new TTypeInfo(boolTTI)), this.createTColumnType("LOCAL_TYPE_NAME", new TTypeInfo(strTTI)), this.createTColumnType("MINIMUM_SCALE", new TTypeInfo(smallIntTTI)), this.createTColumnType("MAXIMUM_SCALE", new TTypeInfo(smallIntTTI)), this.createTColumnType("SQL_DATA_TYPE", new TTypeInfo(intTTI)), this.createTColumnType("SQL_DATETIME_SUB", new TTypeInfo(intTTI)), this.createTColumnType("NUM_PREC_RADIX", new TTypeInfo(intTTI))};
        HashMap<String, HeavyAIData> dataMap = new HashMap<String, HeavyAIData>(columns.length);
        ArrayList<TColumnType> rowDesc = new ArrayList<TColumnType>(columns.length);
        for (TColumnType col : columns) {
            rowDesc.add(col);
            dataMap.put(col.col_name, new HeavyAIData(col.col_type.type));
        }
        ((HeavyAIData)dataMap.get("TYPE_NAME")).setNull(true);
        ((HeavyAIData)dataMap.get("DATA_TYPE")).setNull(true);
        ((HeavyAIData)dataMap.get("PRECISION")).setNull(true);
        ((HeavyAIData)dataMap.get("LITERAL_PREFIX")).setNull(true);
        ((HeavyAIData)dataMap.get("LITERAL_SUFFIX")).setNull(true);
        ((HeavyAIData)dataMap.get("CREATE_PARAMS")).setNull(true);
        ((HeavyAIData)dataMap.get("NULLABLE")).setNull(true);
        ((HeavyAIData)dataMap.get("CASE_SENSITIVE")).setNull(true);
        ((HeavyAIData)dataMap.get("SEARCHABLE")).setNull(true);
        ((HeavyAIData)dataMap.get("UNSIGNED_ATTRIBUTE")).setNull(true);
        ((HeavyAIData)dataMap.get("FIXED_PREC_SCALE")).setNull(true);
        ((HeavyAIData)dataMap.get("AUTO_INCREMENT")).setNull(false);
        ((HeavyAIData)dataMap.get("LOCAL_TYPE_NAME")).setNull(true);
        ((HeavyAIData)dataMap.get("MINIMUM_SCALE")).setNull(true);
        ((HeavyAIData)dataMap.get("MAXIMUM_SCALE")).setNull(true);
        ((HeavyAIData)dataMap.get("SQL_DATA_TYPE")).setNull(true);
        ((HeavyAIData)dataMap.get("SQL_DATETIME_SUB")).setNull(true);
        ((HeavyAIData)dataMap.get("NUM_PREC_RADIX")).setNull(true);
        ArrayList<TColumn> columnsList = new ArrayList<TColumn>(columns.length);
        for (TColumnType col : columns) {
            TColumn schemaCol = ((HeavyAIData)dataMap.get(col.col_name)).getTColumn();
            columnsList.add(schemaCol);
        }
        TRowSet rowSet = new TRowSet(rowDesc, null, columnsList, true);
        TQueryResult result = new TQueryResult(rowSet, 0L, 0L, null, null, true, TQueryType.UNKNOWN);
        HeavyAIResultSet cols = new HeavyAIResultSet(result, "getTypeInfo");
        return cols;
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return this.getEmptyResultSet();
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public Connection getConnection() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return this.con;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return this.databaseMajorVersion;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return this.databaseMinorVersion;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 0;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 0;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 0;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return RowIdLifetime.ROWID_VALID_OTHER;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return this.getSchemas();
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return false;
    }
}

