/*
 * Decompiled with CFR 0.152.
 */
package ai.heavy.jdbc;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class HeavyAIEscapeFunctions {
    private static final ConcurrentMap<String, Method> FUNCTION_MAP = HeavyAIEscapeFunctions.createFunctionMap("sql");

    private static ConcurrentMap<String, Method> createFunctionMap(String prefix) {
        Method[] methods = HeavyAIEscapeFunctions.class.getMethods();
        ConcurrentHashMap<String, Method> functionMap = new ConcurrentHashMap<String, Method>(methods.length * 2);
        for (Method method : methods) {
            if (!method.getName().startsWith(prefix)) continue;
            functionMap.put(method.getName().substring(prefix.length()).toLowerCase(Locale.US), method);
        }
        return functionMap;
    }

    public static Method getFunction(String functionName) {
        Method method = (Method)FUNCTION_MAP.get(functionName);
        if (method != null) {
            return method;
        }
        String nameLower = functionName.toLowerCase(Locale.US);
        if (nameLower.equals(functionName)) {
            return null;
        }
        method = (Method)FUNCTION_MAP.get(nameLower);
        if (method != null && FUNCTION_MAP.size() < 1000) {
            FUNCTION_MAP.putIfAbsent(functionName, method);
        }
        return method;
    }

    public static void sqlceiling(StringBuilder buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        HeavyAIEscapeFunctions.singleArgumentFunctionCall(buf, "ceil(", "ceiling", parsedArgs);
    }

    public static void sqldayofmonth(StringBuilder buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        HeavyAIEscapeFunctions.singleArgumentFunctionCall(buf, "extract(day from ", "dayofmonth", parsedArgs);
    }

    public static void sqldayofweek(StringBuilder buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        if (parsedArgs.size() != 1) {
            throw new RuntimeException("Syntax error function 'dayofweek' takes one and only one argument.");
        }
        HeavyAIEscapeFunctions.appendCall(buf, "extract(dow from ", ",", ")+1", parsedArgs);
    }

    public static void sqldayofyear(StringBuilder buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        HeavyAIEscapeFunctions.singleArgumentFunctionCall(buf, "extract(doy from ", "dayofyear", parsedArgs);
    }

    public static void sqlhour(StringBuilder buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        HeavyAIEscapeFunctions.singleArgumentFunctionCall(buf, "extract(hour from ", "hour", parsedArgs);
    }

    public static void sqlminute(StringBuilder buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        HeavyAIEscapeFunctions.singleArgumentFunctionCall(buf, "extract(minute from ", "minute", parsedArgs);
    }

    public static void sqlmonth(StringBuilder buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        HeavyAIEscapeFunctions.singleArgumentFunctionCall(buf, "extract(month from ", "month", parsedArgs);
    }

    public static void sqlquarter(StringBuilder buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        HeavyAIEscapeFunctions.singleArgumentFunctionCall(buf, "extract(quarter from ", "quarter", parsedArgs);
    }

    public static void sqlsecond(StringBuilder buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        HeavyAIEscapeFunctions.singleArgumentFunctionCall(buf, "extract(second from ", "second", parsedArgs);
    }

    public static void sqlweek(StringBuilder buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        HeavyAIEscapeFunctions.singleArgumentFunctionCall(buf, "extract(week from ", "week", parsedArgs);
    }

    public static void sqlyear(StringBuilder buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        HeavyAIEscapeFunctions.singleArgumentFunctionCall(buf, "extract(year from ", "year", parsedArgs);
    }

    private static void singleArgumentFunctionCall(StringBuilder buf, String call, String functionName, List<? extends CharSequence> parsedArgs) {
        if (parsedArgs.size() != 1) {
            throw new RuntimeException("Syntax error " + functionName + " takes one and only one argument.");
        }
        CharSequence arg0 = parsedArgs.get(0);
        buf.ensureCapacity(buf.length() + call.length() + arg0.length() + 1);
        buf.append(call).append(arg0).append(')');
    }

    public static void appendCall(StringBuilder sb, String begin, String separator, String end, List<? extends CharSequence> args) {
        int i;
        int size = begin.length();
        int numberOfArguments = args.size();
        for (i = 0; i < numberOfArguments; ++i) {
            size += args.get(i).length();
        }
        sb.ensureCapacity(sb.length() + (size += separator.length() * (numberOfArguments - 1)) + 1);
        sb.append(begin);
        for (i = 0; i < numberOfArguments; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(args.get(i));
        }
        sb.append(end);
    }
}

