/*
 * Decompiled with CFR 0.152.
 */
package ai.heavy.jdbc;

import ai.heavy.jdbc.HeavyAIEscapeFunctions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HeavyAIEscapeParser {
    private static final char[] QUOTE_OR_ALPHABETIC_MARKER = new char[]{'\"', '0'};
    private static final char[] SINGLE_QUOTE = new char[]{'\''};

    private static String process_sql(String sql, Pair index) {
        String value = sql.substring(index.start, index.end);
        boolean found_match = false;
        for (EscapeFunctions xx : EscapeFunctions.values()) {
            String newsql = xx.makeMatch(value);
            if (newsql == null) continue;
            sql = sql.substring(0, index.start) + newsql + " " + sql.substring(index.end + 1, sql.length());
            int x = newsql.length();
            index.end = index.start + newsql.length();
            found_match = true;
            break;
        }
        if (!found_match) {
            sql = sql.substring(0, index.start) + "{" + sql.substring(index.start);
            ++index.end;
        }
        return sql;
    }

    public static String parse(String sql) {
        Parser_return pR = HeavyAIEscapeParser.parse(sql, 0);
        if (pR.bracket_cnt != 0) {
            throw new RuntimeException("Invalid java escape syntax - badly matched '}'");
        }
        return pR.sql_value;
    }

    private static Parser_return parse(String sql, int bracket_cnt) {
        Parser_return pR;
        int index = 0;
        boolean in_quote = false;
        do {
            if (sql.charAt(index) == '\'') {
                in_quote = !in_quote;
                continue;
            }
            if (sql.charAt(index) == '{' && !in_quote) {
                if (index + 1 == sql.length()) {
                    throw new RuntimeException("Invalid java escape syntax - badly matched '{'");
                }
                pR = HeavyAIEscapeParser.parse(sql.substring(index + 1), ++bracket_cnt);
                bracket_cnt = pR.bracket_cnt;
                String sql_snippet = pR.sql_value;
                sql = sql.substring(0, index) + " " + sql_snippet;
                index += pR.end_idx;
                continue;
            }
            if (sql.charAt(index) != '}' || in_quote) continue;
            Pair ptr = new Pair(0);
            ptr.end = index;
            Parser_return pR2 = new Parser_return();
            pR2.sql_value = HeavyAIEscapeParser.process_sql(sql, ptr);
            pR2.bracket_cnt = --bracket_cnt;
            pR2.end_idx = ptr.end + 1;
            return pR2;
        } while (++index < sql.length());
        if (in_quote) {
            throw new RuntimeException("Invalid java escape syntax - badly matched '''");
        }
        pR = new Parser_return();
        pR.sql_value = sql;
        pR.bracket_cnt = bracket_cnt;
        pR.end_idx = sql.length();
        return pR;
    }

    static class Parser_return {
        public String sql_value;
        public int bracket_cnt;
        public int end_idx;

        Parser_return() {
        }
    }

    private static class Pair {
        public int start;
        public int end;

        public Pair(int s) {
            this.start = s;
        }
    }

    private static enum EscapeFunctions {
        ESC_FUNCTION("\\s*fn\\s+([^ ]*?)\\s*\\(", "\\(\\s*(.*)\\s*\\)", null),
        ESC_DATE("\\s*(d)\\s+", "('.*?')", "DATE "),
        ESC_TIME("\\s*(t)\\s+", "('.*?')", "TIME "),
        ESC_TIMESTAMP("\\s*(ts)\\s+", "('.*?')", "TIMESTAMP ");

        private final Pattern escapePattern;
        private final Pattern argPattern;
        private final String replacementKeyword;

        private EscapeFunctions(String escapePattern, String argPattern, String replacementKeyword) {
            this.escapePattern = Pattern.compile(escapePattern);
            this.argPattern = Pattern.compile(argPattern);
            this.replacementKeyword = replacementKeyword;
        }

        private String call_escape_fn(String all_arguments, Method method) {
            try {
                StringBuilder sb = new StringBuilder();
                ArrayList<String> parseArgs = new ArrayList<String>(3);
                int bracket_cnt = 0;
                StringBuilder args_sb = new StringBuilder();
                for (int index = 0; index < all_arguments.length(); ++index) {
                    if (all_arguments.charAt(index) == ',' && bracket_cnt == 0) {
                        parseArgs.add(args_sb.toString());
                        args_sb.delete(0, args_sb.length());
                        continue;
                    }
                    if (all_arguments.charAt(index) == '(') {
                        ++bracket_cnt;
                    } else if (all_arguments.charAt(index) == ')') {
                        --bracket_cnt;
                    }
                    args_sb.append(all_arguments.charAt(index));
                }
                parseArgs.add(args_sb.toString());
                method.invoke(null, sb, parseArgs);
                return sb.toString();
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Invocation fn argument parse error" + e.getMessage());
            }
            catch (IllegalAccessException ilE) {
                throw new RuntimeException("Access  fn argument error" + ilE.getMessage());
            }
        }

        private String makeMatch(String sql) {
            Matcher matcher = this.escapePattern.matcher(sql);
            if (matcher.find()) {
                if (this == ESC_DATE || this == ESC_TIME || this == ESC_TIMESTAMP) {
                    matcher = this.argPattern.matcher(sql);
                    if (matcher.find()) {
                        String new_sql = this.replacementKeyword + matcher.group(1);
                        return new_sql;
                    }
                } else if (this == ESC_FUNCTION) {
                    String fn_name = matcher.group(1);
                    Method method = HeavyAIEscapeFunctions.getFunction(fn_name);
                    matcher = this.argPattern.matcher(sql);
                    if (matcher.find()) {
                        if (method == null) {
                            String new_sql = fn_name + '(' + matcher.group(1) + ')';
                            return new_sql;
                        }
                        return this.call_escape_fn(matcher.group(1), method);
                    }
                }
            }
            return null;
        }

        public static String simple(String arg) {
            return arg;
        }

        public static String function(String arg) {
            return arg;
        }
    }
}

