/*
 * Decompiled with CFR 0.152.
 */
package ai.heavy.jdbc;

import ai.heavy.jdbc.HeavyAIConnection;
import ai.heavy.jdbc.HeavyAIStatement;
import ai.heavy.thrift.server.Heavy;
import ai.heavy.thrift.server.TColumnType;
import ai.heavy.thrift.server.TDBException;
import ai.heavy.thrift.server.TStringRow;
import ai.heavy.thrift.server.TStringValue;
import ai.heavy.thrift.server.TTableDetails;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HeavyAIPreparedStatement
implements PreparedStatement {
    static final Logger HEAVYDBLOGGER = LoggerFactory.getLogger(HeavyAIPreparedStatement.class);
    public SQLWarning rootWarning = null;
    private String currentSQL;
    private String insertTableName;
    private int parmCount = 0;
    private String[] brokenSQL;
    private String[] parmRep;
    private boolean[] parmIsNull;
    private String[] listOfFields;
    private int repCount;
    private String session;
    private Heavy.Client client;
    private HeavyAIStatement stmt = null;
    private boolean isInsert = false;
    private boolean isNewBatch = true;
    private boolean[] parmIsString = null;
    private List<TStringRow> rows = null;
    private static final Pattern REGEX_PATTERN = Pattern.compile("(?i)\\s+INTO\\s+(\\w+)");
    private static final Pattern REGEX_LOF_PATTERN = Pattern.compile("(?i)\\s*insert\\s+into\\s+[\\w:\\.]+\\s*\\(([\\w:\\s:\\,:\\']+)\\)[\\w:\\s]+\\(");
    private static final Pattern REGEX_IS_SELECT_PATTERN = Pattern.compile("^(?:\\s|--.*?\\R|/\\*[\\S\\s]*?\\*/|\\s*)*\\s*select[\\S\\s]*", 10);
    private boolean isClosed = false;

    HeavyAIPreparedStatement(String sql, String session, HeavyAIConnection connection) {
        HEAVYDBLOGGER.debug("Entered");
        this.currentSQL = sql;
        this.client = connection.client;
        this.session = session;
        this.stmt = new HeavyAIStatement(session, connection);
        HEAVYDBLOGGER.debug("Prepared statement is " + this.currentSQL);
        this.brokenSQL = this.currentSQL.split("\\?", -1);
        this.parmCount = this.brokenSQL.length - 1;
        this.parmRep = new String[this.parmCount];
        this.parmIsNull = new boolean[this.parmCount];
        this.parmIsString = new boolean[this.parmCount];
        this.repCount = 0;
        if (this.currentSQL.toUpperCase().contains("INSERT ")) {
            this.currentSQL = this.currentSQL.replaceAll("\"", " ");
            HEAVYDBLOGGER.debug("Insert Prepared statement is " + this.currentSQL);
            this.isInsert = true;
            Matcher matcher = REGEX_PATTERN.matcher(this.currentSQL);
            while (matcher.find()) {
                this.insertTableName = matcher.group(1);
                HEAVYDBLOGGER.debug("Table name for insert is '" + this.insertTableName + "'");
            }
        }
    }

    private String getQuery() {
        String qsql;
        if (this.parmCount > 0) {
            if (this.repCount != this.parmCount) {
                throw new UnsupportedOperationException("Incorrect number of replace parameters for prepared statement " + this.currentSQL + " has only " + this.repCount + " parameters");
            }
            StringBuilder modQuery = new StringBuilder(this.currentSQL.length() * 5);
            for (int i = 0; i < this.repCount; ++i) {
                modQuery.append(this.brokenSQL[i]);
                if (this.parmIsNull[i]) {
                    modQuery.append("NULL");
                    continue;
                }
                if (this.parmIsString[i]) {
                    modQuery.append("'").append(this.parmRep[i]).append("'");
                    continue;
                }
                modQuery.append(this.parmRep[i]);
            }
            modQuery.append(this.brokenSQL[this.parmCount]);
            qsql = modQuery.toString();
        } else {
            qsql = this.currentSQL;
        }
        qsql = qsql.replace(" WHERE 1=0", " LIMIT 1 ");
        HEAVYDBLOGGER.debug("Query is now " + qsql);
        this.repCount = 0;
        return qsql;
    }

    private boolean isSelect() {
        Matcher matcher = REGEX_IS_SELECT_PATTERN.matcher(this.currentSQL);
        return matcher.matches();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.isNewBatch) {
            String qsql = this.getQuery();
            HEAVYDBLOGGER.debug("executeQuery, sql=" + qsql);
            return this.stmt.executeQuery(qsql);
        }
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public int executeUpdate() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        this.executeQuery();
        return -1;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        this.parmIsNull[parameterIndex - 1] = true;
        ++this.repCount;
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        this.parmRep[parameterIndex - 1] = x ? "true" : "false";
        this.parmIsString[parameterIndex - 1] = false;
        this.parmIsNull[parameterIndex - 1] = false;
        ++this.repCount;
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        this.parmRep[parameterIndex - 1] = Short.toString(x);
        this.parmIsNull[parameterIndex - 1] = false;
        ++this.repCount;
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        this.parmRep[parameterIndex - 1] = Integer.toString(x);
        this.parmIsNull[parameterIndex - 1] = false;
        ++this.repCount;
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        this.parmRep[parameterIndex - 1] = Long.toString(x);
        this.parmIsNull[parameterIndex - 1] = false;
        ++this.repCount;
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        this.parmRep[parameterIndex - 1] = Float.toString(x);
        this.parmIsNull[parameterIndex - 1] = false;
        ++this.repCount;
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        this.parmRep[parameterIndex - 1] = Double.toString(x);
        this.parmIsNull[parameterIndex - 1] = false;
        ++this.repCount;
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        this.parmRep[parameterIndex - 1] = x.toString();
        this.parmIsNull[parameterIndex - 1] = false;
        ++this.repCount;
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        this.parmRep[parameterIndex - 1] = x = x.replaceAll("'", "''");
        this.parmIsString[parameterIndex - 1] = true;
        this.parmIsNull[parameterIndex - 1] = false;
        ++this.repCount;
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        this.parmRep[parameterIndex - 1] = x.toString();
        this.parmIsString[parameterIndex - 1] = true;
        this.parmIsNull[parameterIndex - 1] = false;
        ++this.repCount;
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        this.parmRep[parameterIndex - 1] = x.toString();
        this.parmIsString[parameterIndex - 1] = true;
        this.parmIsNull[parameterIndex - 1] = false;
        ++this.repCount;
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        this.parmRep[parameterIndex - 1] = x.toString();
        this.parmIsString[parameterIndex - 1] = true;
        this.parmIsNull[parameterIndex - 1] = false;
        ++this.repCount;
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void clearParameters() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public boolean execute() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        String tQuery = this.getQuery();
        return this.stmt.execute(tQuery);
    }

    @Override
    public void addBatch() throws SQLException {
        TStringRow tsr;
        HEAVYDBLOGGER.debug("Entered");
        if (this.isInsert) {
            if (this.isNewBatch) {
                Matcher matcher = REGEX_LOF_PATTERN.matcher(this.currentSQL);
                if (matcher.find()) {
                    this.listOfFields = matcher.group(1).trim().split("\\s*,+\\s*,*\\s*");
                    if (this.listOfFields.length != this.parmCount) {
                        throw new SQLException("Too many or too few values");
                    }
                    if (Arrays.stream(this.listOfFields).distinct().toArray().length != this.listOfFields.length) {
                        throw new SQLException("Duplicated column name");
                    }
                    ArrayList<String> listOfColumns = new ArrayList<String>();
                    try {
                        TTableDetails tableDetails = this.client.get_table_details(this.session, this.insertTableName);
                        for (TColumnType column : tableDetails.row_desc) {
                            listOfColumns.add(column.col_name.toLowerCase());
                        }
                    }
                    catch (TException ex) {
                        throw new SQLException(ex.toString());
                    }
                    for (String paramName : this.listOfFields) {
                        if (listOfColumns.indexOf(paramName) != -1) continue;
                        throw new SQLException("Column " + paramName.toLowerCase() + " does not exist");
                    }
                } else {
                    this.listOfFields = new String[0];
                }
                this.rows = new ArrayList<TStringRow>(5000);
                this.isNewBatch = false;
            }
            tsr = new TStringRow();
            for (int i = 0; i < this.parmCount; ++i) {
                TStringValue tsv = new TStringValue();
                if (this.parmIsNull[i]) {
                    tsv.is_null = true;
                } else {
                    tsv.str_val = this.parmRep[i];
                    tsv.is_null = false;
                }
                tsr.addToCols(tsv);
            }
        } else {
            throw new UnsupportedOperationException("addBatch only supported for insert, line:" + new Throwable().getStackTrace()[0].getLineNumber());
        }
        this.rows.add(tsr);
        HEAVYDBLOGGER.debug("addBatch, rows=" + this.rows.size());
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        this.parmRep[parameterIndex - 1] = x.toString();
        this.parmIsNull[parameterIndex - 1] = false;
        ++this.repCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        if (!this.isSelect()) {
            return null;
        }
        if (this.stmt.getResultSet() != null) {
            return this.stmt.getResultSet().getMetaData();
        }
        try (Statement ps = null;){
            ps = new HeavyAIPreparedStatement(this.currentSQL, this.session, (HeavyAIConnection)this.getConnection());
            ps.setMaxRows(0);
            for (int i = 1; i <= this.parmCount; ++i) {
                ps.setNull(i, 0);
            }
            ResultSet rs = ps.executeQuery();
            if (rs != null) {
                ResultSetMetaData resultSetMetaData = rs.getMetaData();
                return resultSetMetaData;
            }
            ResultSetMetaData resultSetMetaData = null;
            return resultSetMetaData;
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void close() throws SQLException {
        HEAVYDBLOGGER.debug("close");
        if (this.stmt != null) {
            this.stmt.close();
            this.stmt = null;
        }
        this.isClosed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public int getMaxRows() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return this.stmt.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        HEAVYDBLOGGER.debug("SetMaxRows to " + max);
        this.stmt.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        SQLWarning warning = new SQLWarning("Query timeouts are not supported.  Substituting a value of zero.");
        if (this.rootWarning == null) {
            this.rootWarning = warning;
        } else {
            this.rootWarning.setNextWarning(warning);
        }
    }

    @Override
    public void cancel() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return this.rootWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        this.rootWarning = null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return this.stmt.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return this.stmt.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return this.stmt.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public int getFetchDirection() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
    }

    @Override
    public int getFetchSize() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public int getResultSetType() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void clearBatch() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        if (this.rows != null) {
            this.rows.clear();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        int[] ret = null;
        if (this.rows != null) {
            HEAVYDBLOGGER.debug("executeBatch, rows=" + this.rows.size());
            try {
                this.client.load_table(this.session, this.insertTableName, this.rows, Arrays.asList(this.listOfFields));
            }
            catch (TDBException ex) {
                throw new SQLException("executeBatch failed: " + ex.getError_msg());
            }
            catch (TException ex) {
                throw new SQLException("executeBatch failed: " + ex.toString());
            }
            ret = new int[this.rows.size()];
            for (int i = 0; i < this.rows.size(); ++i) {
                ret[i] = 1;
            }
            this.clearBatch();
        }
        return ret;
    }

    @Override
    public Connection getConnection() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return this.stmt.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public boolean isClosed() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public boolean isPoolable() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        HEAVYDBLOGGER.debug("Entered");
        throw new UnsupportedOperationException("Not supported yet, line:" + new Throwable().getStackTrace()[0].getLineNumber() + " class:" + new Throwable().getStackTrace()[0].getClassName() + " method:" + new Throwable().getStackTrace()[0].getMethodName());
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("PreparedStatement is closed.");
        }
    }
}

