/*
 * Decompiled with CFR 0.152.
 */
package ai.heavy.jdbc;

import ai.heavy.jdbc.HeavyAIConnection;
import java.io.FileInputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.Base64;
import java.util.Enumeration;

class KeyLoader {
    KeyLoader() {
    }

    public static String getX509(X509Certificate cert) throws Exception {
        String encoded = Base64.getMimeEncoder().encodeToString(cert.getEncoded());
        encoded = "-----BEGIN CERTIFICATE-----\n" + encoded + "\n" + "-----END CERTIFICATE-----";
        return encoded;
    }

    public static S_struct getDetails_pkcs12(String filename, String password) throws Exception {
        S_struct s_struct = new S_struct();
        try {
            KeyStore keystore = KeyStore.getInstance("PKCS12");
            FileInputStream fis = new FileInputStream(filename);
            keystore.load(fis, password.toCharArray());
            String alias = null;
            Enumeration<String> eE = keystore.aliases();
            int count = 0;
            while (eE.hasMoreElements()) {
                alias = eE.nextElement();
                ++count;
            }
            if (count != 1) {
                throw new SQLException("pkcs12 file [" + filename + "] contains an incorrect number [" + count + "] of certificate(s); only a single certificate is allowed");
            }
            X509Certificate cert = (X509Certificate)keystore.getCertificate(alias);
            s_struct.cert = KeyLoader.getX509(cert);
            s_struct.key = keystore.getKey(alias, password.toCharArray());
        }
        catch (Exception eX) {
            HeavyAIConnection.logger.error(eX.getMessage());
            throw eX;
        }
        return s_struct;
    }

    static class S_struct {
        public String cert;
        public Key key;

        S_struct() {
        }
    }
}

