/*
 * Decompiled with CFR 0.152.
 */
package ai.heavy.thrift.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TEnum;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.TUnion;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.SetMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.transport.TIOStreamTransport;

public class TCountDistinctSetStorage
extends TUnion<TCountDistinctSetStorage, _Fields> {
    private static final TStruct STRUCT_DESC = new TStruct("TCountDistinctSetStorage");
    private static final TField BITMAP_FIELD_DESC = new TField("bitmap", 11, 1);
    private static final TField SPARSE_SET_FIELD_DESC = new TField("sparse_set", 14, 2);
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TCountDistinctSetStorage() {
    }

    public TCountDistinctSetStorage(_Fields setField, Object value) {
        super(setField, value);
    }

    public TCountDistinctSetStorage(TCountDistinctSetStorage other) {
        super(other);
    }

    @Override
    public TCountDistinctSetStorage deepCopy() {
        return new TCountDistinctSetStorage(this);
    }

    public static TCountDistinctSetStorage bitmap(ByteBuffer value) {
        TCountDistinctSetStorage x = new TCountDistinctSetStorage();
        x.setBitmap(value);
        return x;
    }

    public static TCountDistinctSetStorage bitmap(byte[] value) {
        TCountDistinctSetStorage x = new TCountDistinctSetStorage();
        x.setBitmap(ByteBuffer.wrap((byte[])value.clone()));
        return x;
    }

    public static TCountDistinctSetStorage sparse_set(Set<Long> value) {
        TCountDistinctSetStorage x = new TCountDistinctSetStorage();
        x.setSparse_set(value);
        return x;
    }

    @Override
    protected void checkType(_Fields setField, Object value) throws ClassCastException {
        switch (setField) {
            case BITMAP: {
                if (value instanceof ByteBuffer) break;
                throw new ClassCastException("Was expecting value of type java.nio.ByteBuffer for field 'bitmap', but got " + value.getClass().getSimpleName());
            }
            case SPARSE_SET: {
                if (value instanceof Set) break;
                throw new ClassCastException("Was expecting value of type java.util.Set<java.lang.Long> for field 'sparse_set', but got " + value.getClass().getSimpleName());
            }
            default: {
                throw new IllegalArgumentException("Unknown field id " + setField);
            }
        }
    }

    @Override
    protected Object standardSchemeReadValue(TProtocol iprot, TField field) throws TException {
        _Fields setField = _Fields.findByThriftId(field.id);
        if (setField != null) {
            switch (setField) {
                case BITMAP: {
                    if (field.type == TCountDistinctSetStorage.BITMAP_FIELD_DESC.type) {
                        ByteBuffer bitmap = iprot.readBinary();
                        return bitmap;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    return null;
                }
                case SPARSE_SET: {
                    if (field.type == TCountDistinctSetStorage.SPARSE_SET_FIELD_DESC.type) {
                        TSet _set48 = iprot.readSetBegin();
                        HashSet<Long> sparse_set = new HashSet<Long>(2 * _set48.size);
                        for (int _i50 = 0; _i50 < _set48.size; ++_i50) {
                            long _elem49 = iprot.readI64();
                            sparse_set.add(_elem49);
                        }
                        iprot.readSetEnd();
                        return sparse_set;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    return null;
                }
            }
            throw new IllegalStateException("setField wasn't null, but didn't match any of the case statements!");
        }
        TProtocolUtil.skip(iprot, field.type);
        return null;
    }

    @Override
    protected void standardSchemeWriteValue(TProtocol oprot) throws TException {
        switch ((_Fields)this.setField_) {
            case BITMAP: {
                ByteBuffer bitmap = (ByteBuffer)this.value_;
                oprot.writeBinary(bitmap);
                return;
            }
            case SPARSE_SET: {
                Set sparse_set = (Set)this.value_;
                oprot.writeSetBegin(new TSet(10, sparse_set.size()));
                Iterator iterator = sparse_set.iterator();
                while (iterator.hasNext()) {
                    long _iter51 = (Long)iterator.next();
                    oprot.writeI64(_iter51);
                }
                oprot.writeSetEnd();
                return;
            }
        }
        throw new IllegalStateException("Cannot write union with unknown field " + this.setField_);
    }

    @Override
    protected Object tupleSchemeReadValue(TProtocol iprot, short fieldID) throws TException {
        _Fields setField = _Fields.findByThriftId(fieldID);
        if (setField != null) {
            switch (setField) {
                case BITMAP: {
                    ByteBuffer bitmap = iprot.readBinary();
                    return bitmap;
                }
                case SPARSE_SET: {
                    TSet _set52 = iprot.readSetBegin();
                    HashSet<Long> sparse_set = new HashSet<Long>(2 * _set52.size);
                    for (int _i54 = 0; _i54 < _set52.size; ++_i54) {
                        long _elem53 = iprot.readI64();
                        sparse_set.add(_elem53);
                    }
                    iprot.readSetEnd();
                    return sparse_set;
                }
            }
            throw new IllegalStateException("setField wasn't null, but didn't match any of the case statements!");
        }
        throw new TProtocolException("Couldn't find a field with field id " + fieldID);
    }

    @Override
    protected void tupleSchemeWriteValue(TProtocol oprot) throws TException {
        switch ((_Fields)this.setField_) {
            case BITMAP: {
                ByteBuffer bitmap = (ByteBuffer)this.value_;
                oprot.writeBinary(bitmap);
                return;
            }
            case SPARSE_SET: {
                Set sparse_set = (Set)this.value_;
                oprot.writeSetBegin(new TSet(10, sparse_set.size()));
                Iterator iterator = sparse_set.iterator();
                while (iterator.hasNext()) {
                    long _iter55 = (Long)iterator.next();
                    oprot.writeI64(_iter55);
                }
                oprot.writeSetEnd();
                return;
            }
        }
        throw new IllegalStateException("Cannot write union with unknown field " + this.setField_);
    }

    @Override
    protected TField getFieldDesc(_Fields setField) {
        switch (setField) {
            case BITMAP: {
                return BITMAP_FIELD_DESC;
            }
            case SPARSE_SET: {
                return SPARSE_SET_FIELD_DESC;
            }
        }
        throw new IllegalArgumentException("Unknown field id " + setField);
    }

    @Override
    protected TStruct getStructDesc() {
        return STRUCT_DESC;
    }

    @Override
    protected _Fields enumForId(short id) {
        return _Fields.findByThriftIdOrThrow(id);
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public byte[] getBitmap() {
        this.setBitmap(TBaseHelper.rightSize(this.bufferForBitmap()));
        ByteBuffer b = this.bufferForBitmap();
        return b == null ? null : b.array();
    }

    public ByteBuffer bufferForBitmap() {
        if (this.getSetField() == _Fields.BITMAP) {
            return TBaseHelper.copyBinary((ByteBuffer)this.getFieldValue());
        }
        throw new RuntimeException("Cannot get field 'bitmap' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setBitmap(byte[] value) {
        this.setBitmap(ByteBuffer.wrap((byte[])value.clone()));
    }

    public void setBitmap(ByteBuffer value) {
        this.setField_ = _Fields.BITMAP;
        this.value_ = Objects.requireNonNull(value, "_Fields.BITMAP");
    }

    public Set<Long> getSparse_set() {
        if (this.getSetField() == _Fields.SPARSE_SET) {
            return (Set)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'sparse_set' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setSparse_set(Set<Long> value) {
        this.setField_ = _Fields.SPARSE_SET;
        this.value_ = Objects.requireNonNull(value, "_Fields.SPARSE_SET");
    }

    public boolean isSetBitmap() {
        return this.setField_ == _Fields.BITMAP;
    }

    public boolean isSetSparse_set() {
        return this.setField_ == _Fields.SPARSE_SET;
    }

    public boolean equals(Object other) {
        if (other instanceof TCountDistinctSetStorage) {
            return this.equals((TCountDistinctSetStorage)other);
        }
        return false;
    }

    public boolean equals(TCountDistinctSetStorage other) {
        return other != null && this.getSetField() == other.getSetField() && this.getFieldValue().equals(other.getFieldValue());
    }

    @Override
    public int compareTo(TCountDistinctSetStorage other) {
        int lastComparison = TBaseHelper.compareTo((Comparable)this.getSetField(), (Comparable)other.getSetField());
        if (lastComparison == 0) {
            return TBaseHelper.compareTo(this.getFieldValue(), other.getFieldValue());
        }
        return lastComparison;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.getClass().getName());
        Object setField = this.getSetField();
        if (setField != null) {
            list.add(setField.getThriftFieldId());
            Object value = this.getFieldValue();
            if (value instanceof TEnum) {
                list.add(((TEnum)this.getFieldValue()).getValue());
            } else {
                list.add(value);
            }
        }
        return list.hashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.BITMAP, new FieldMetaData("bitmap", 2, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.SPARSE_SET, new FieldMetaData("sparse_set", 2, new SetMetaData(14, new FieldValueMetaData(10))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TCountDistinctSetStorage.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        BITMAP(1, "bitmap"),
        SPARSE_SET(2, "sparse_set");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return BITMAP;
                }
                case 2: {
                    return SPARSE_SET;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

