/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamBase;
import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Envelope3D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryAccelerators;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.MathUtils;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Point3D;
import com.esri.core.geometry.VertexDescription;
import com.esri.core.geometry.VertexDescriptionDesignerImpl;

abstract class MultiVertexGeometryImpl
extends MultiVertexGeometry {
    private static final long serialVersionUID = 1L;
    AttributeStreamBase[] m_vertexAttributes;
    GeometryAccelerators m_accelerators = null;
    Envelope m_envelope;
    protected int m_pointCount = 0;
    protected int m_reservedPointCount = -1;
    protected int m_flagsMask = 65535;
    protected double m_simpleTolerance;

    abstract void _copyToImpl(MultiVertexGeometryImpl var1);

    protected abstract void _notifyModifiedAllImpl();

    protected abstract void _verifyStreamsImpl();

    @Override
    public int getPointCount() {
        return this.m_pointCount;
    }

    @Override
    public boolean isEmpty() {
        return this.isEmptyImpl();
    }

    public VertexDescription getDescriptionImpl() {
        return this.m_description;
    }

    boolean isEmptyImpl() {
        return this.m_pointCount == 0;
    }

    protected boolean _hasDirtyFlag(int flag) {
        return (this.m_flagsMask & flag) != 0;
    }

    protected void _setDirtyFlag(int flag, boolean bYesNo) {
        this.m_flagsMask = bYesNo ? (this.m_flagsMask |= flag) : (this.m_flagsMask &= ~flag);
    }

    protected void _verifyAllStreams() {
        if (this._hasDirtyFlag(32)) {
            this._verifyAllStreamsImpl();
        }
    }

    protected void throwIfEmpty() {
        if (this.isEmptyImpl()) {
            throw new GeometryException("This operation was performed on an Empty Geometry.");
        }
    }

    @Override
    public void getPointByVal(int index, Point dst) {
        if (index < 0 || index >= this.m_pointCount) {
            throw new GeometryException("index out of bounds");
        }
        this._verifyAllStreams();
        Point outPoint = dst;
        outPoint.assignVertexDescription(this.m_description);
        if (outPoint.isEmpty()) {
            outPoint._setToDefault();
        }
        for (int attributeIndex = 0; attributeIndex < this.m_description.getAttributeCount(); ++attributeIndex) {
            int semantics = this.m_description._getSemanticsImpl(attributeIndex);
            int ncomp = VertexDescription.getComponentCount(semantics);
            for (int icomp = 0; icomp < ncomp; ++icomp) {
                double v = this.m_vertexAttributes[attributeIndex].readAsDbl(ncomp * index + icomp);
                outPoint.setAttribute(semantics, icomp, v);
            }
        }
    }

    @Override
    public void setPointByVal(int index, Point src) {
        if (index < 0 || index >= this.m_pointCount) {
            throw new GeometryException("index out of bounds");
        }
        Point point = src;
        if (src.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this._verifyAllStreams();
        VertexDescription vdin = point.getDescription();
        for (int attributeIndex = 0; attributeIndex < vdin.getAttributeCount(); ++attributeIndex) {
            int semantics = vdin._getSemanticsImpl(attributeIndex);
            int ncomp = VertexDescription.getComponentCount(semantics);
            for (int icomp = 0; icomp < ncomp; ++icomp) {
                double v = point.getAttributeAsDbl(semantics, icomp);
                this.setAttribute(semantics, index, icomp, v);
            }
        }
    }

    @Override
    public Point2D getXY(int index) {
        Point2D pt = new Point2D();
        this.getXY(index, pt);
        return pt;
    }

    @Override
    public void getXY(int index, Point2D pt) {
        if (index < 0 || index >= this.getPointCount()) {
            throw new IndexOutOfBoundsException();
        }
        this._verifyAllStreams();
        AttributeStreamOfDbl v = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        v.read(index * 2, pt);
    }

    @Override
    public void setXY(int index, Point2D pt) {
        if (index < 0 || index >= this.m_pointCount) {
            throw new IndexOutOfBoundsException();
        }
        this._verifyAllStreams();
        AttributeStreamOfDbl v = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        v.write(index * 2, pt);
        this.notifyModified(1993);
    }

    public void setXY(int index, double x, double y) {
        if (index < 0 || index >= this.m_pointCount) {
            throw new IndexOutOfBoundsException();
        }
        this._verifyAllStreams();
        AttributeStreamOfDbl v = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        v.write(index * 2, x);
        v.write(index * 2 + 1, y);
        this.notifyModified(1993);
    }

    @Override
    public Point3D getXYZ(int index) {
        if (index < 0 || index >= this.getPointCount()) {
            throw new IndexOutOfBoundsException();
        }
        this._verifyAllStreams();
        AttributeStreamOfDbl v = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        Point3D pt = new Point3D();
        pt.x = v.read(index * 2);
        pt.y = v.read(index * 2 + 1);
        pt.z = this.hasAttribute(1) ? this.m_vertexAttributes[1].readAsDbl(index) : VertexDescription.getDefaultValue(1);
        return pt;
    }

    @Override
    public void setXYZ(int index, Point3D pt) {
        if (index < 0 || index >= this.getPointCount()) {
            throw new IndexOutOfBoundsException();
        }
        this.addAttribute(1);
        this._verifyAllStreams();
        this.notifyModified(1993);
        AttributeStreamOfDbl v = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        v.write(index * 2, pt.x);
        v.write(index * 2 + 1, pt.y);
        this.m_vertexAttributes[1].writeAsDbl(index, pt.z);
    }

    @Override
    public double getAttributeAsDbl(int semantics, int offset, int ordinate) {
        if (offset < 0 || offset >= this.m_pointCount) {
            throw new IndexOutOfBoundsException();
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        if (ordinate >= ncomps) {
            throw new IndexOutOfBoundsException();
        }
        this._verifyAllStreams();
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        if (attributeIndex >= 0) {
            return this.m_vertexAttributes[attributeIndex].readAsDbl(offset * ncomps + ordinate);
        }
        return VertexDescription.getDefaultValue(semantics);
    }

    @Override
    public int getAttributeAsInt(int semantics, int offset, int ordinate) {
        return (int)this.getAttributeAsDbl(semantics, offset, ordinate);
    }

    @Override
    public void setAttribute(int semantics, int offset, int ordinate, double value) {
        if (offset < 0 || offset >= this.m_pointCount) {
            throw new IndexOutOfBoundsException();
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        if (ordinate >= ncomps) {
            throw new IndexOutOfBoundsException();
        }
        this.addAttribute(semantics);
        this._verifyAllStreams();
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        this.notifyModified(1993);
        this.m_vertexAttributes[attributeIndex].writeAsDbl(offset * ncomps + ordinate, value);
    }

    @Override
    public void setAttribute(int semantics, int offset, int ordinate, int value) {
        this.setAttribute(semantics, offset, ordinate, (double)value);
    }

    public AttributeStreamBase getAttributeStreamRef(int semantics) {
        this.throwIfEmpty();
        this.addAttribute(semantics);
        this._verifyAllStreams();
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        return this.m_vertexAttributes[attributeIndex];
    }

    public void setAttributeStreamRef(int semantics, AttributeStreamBase stream) {
        if (stream != null && VertexDescription.getPersistence(semantics) != stream.getPersistence()) {
            throw new IllegalArgumentException();
        }
        this.addAttribute(semantics);
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        if (this.m_vertexAttributes == null) {
            this.m_vertexAttributes = new AttributeStreamBase[this.m_description.getAttributeCount()];
        }
        this.m_vertexAttributes[attributeIndex] = stream;
        this.notifyModified(0xFFFFFF);
    }

    @Override
    protected void _assignVertexDescriptionImpl(VertexDescription newDescription) {
        AttributeStreamBase[] newAttributes = null;
        if (this.m_vertexAttributes != null) {
            int[] mapping = VertexDescriptionDesignerImpl.mapAttributes(newDescription, this.m_description);
            newAttributes = new AttributeStreamBase[newDescription.getAttributeCount()];
            int n = newDescription.getAttributeCount();
            for (int i = 0; i < n; ++i) {
                if (mapping[i] == -1) continue;
                int m3 = mapping[i];
                newAttributes[i] = this.m_vertexAttributes[m3];
            }
        }
        this.m_description = newDescription;
        this.m_vertexAttributes = newAttributes;
        this.m_reservedPointCount = -1;
        this.notifyModified(0xFFFFFF);
    }

    protected void _updateEnvelope(Envelope2D env) {
        this._updateAllDirtyIntervals(true);
        this.m_envelope.queryEnvelope2D(env);
    }

    protected void _updateEnvelope(Envelope3D env) {
        this._updateAllDirtyIntervals(true);
        this.m_envelope.queryEnvelope3D(env);
    }

    protected void _updateLooseEnvelope(Envelope2D env) {
        this._updateAllDirtyIntervals(false);
        this.m_envelope.queryEnvelope2D(env);
    }

    protected void _updateLooseEnvelope(Envelope3D env) {
        this._updateAllDirtyIntervals(false);
        this.m_envelope.queryEnvelope3D(env);
    }

    @Override
    public void queryEnvelope(Envelope env) {
        this._updateAllDirtyIntervals(true);
        this.m_envelope.copyTo(env);
    }

    @Override
    public void queryEnvelope2D(Envelope2D env) {
        this._updateEnvelope(env);
    }

    @Override
    public void queryEnvelope3D(Envelope3D env) {
        this._updateEnvelope(env);
    }

    @Override
    public void queryLooseEnvelope2D(Envelope2D env) {
        this._updateLooseEnvelope(env);
    }

    @Override
    public void queryLooseEnvelope3D(Envelope3D env) {
        this._updateLooseEnvelope(env);
    }

    @Override
    public Envelope1D queryInterval(int semantics, int ordinate) {
        Envelope1D env = new Envelope1D();
        if (this.isEmptyImpl()) {
            env.setEmpty();
            return env;
        }
        this._updateAllDirtyIntervals(true);
        return this.m_envelope.queryInterval(semantics, ordinate);
    }

    public int hashCode() {
        int hashCode = this.m_description.hashCode();
        if (!this.isEmptyImpl()) {
            int pointCount = this.getPointCount();
            int n = this.m_description.getAttributeCount();
            for (int i = 0; i < n; ++i) {
                int components = VertexDescription.getComponentCount(this.m_description._getSemanticsImpl(i));
                AttributeStreamBase stream = this.m_vertexAttributes[i];
                hashCode = stream.calculateHashImpl(hashCode, 0, pointCount * components);
            }
        }
        return hashCode;
    }

    public boolean equals(Object other) {
        int pointCountOther;
        if (other == this) {
            return true;
        }
        if (!(other instanceof MultiVertexGeometryImpl)) {
            return false;
        }
        MultiVertexGeometryImpl otherMulti = (MultiVertexGeometryImpl)other;
        if (!this.m_description.equals(otherMulti.m_description)) {
            return false;
        }
        if (this.isEmptyImpl() != otherMulti.isEmptyImpl()) {
            return false;
        }
        if (this.isEmptyImpl()) {
            return true;
        }
        int pointCount = this.getPointCount();
        if (pointCount != (pointCountOther = otherMulti.getPointCount())) {
            return false;
        }
        for (int i = 0; i < this.m_description.getAttributeCount(); ++i) {
            int components;
            AttributeStreamBase streamOther;
            int semantics = this.m_description.getSemantics(i);
            AttributeStreamBase stream = this.getAttributeStreamRef(semantics);
            if (stream.equals(streamOther = otherMulti.getAttributeStreamRef(semantics), 0, pointCount * (components = VertexDescription.getComponentCount(semantics)))) continue;
            return false;
        }
        return true;
    }

    public void setEnvelope(Envelope env) {
        if (!this.m_description.equals(env.getDescription())) {
            throw new IllegalArgumentException();
        }
        this.m_envelope = (Envelope)env.createInstance();
        env.copyTo(this.m_envelope);
        this._setDirtyFlag(192, false);
    }

    @Override
    public void copyTo(Geometry dstGeom) {
        MultiVertexGeometryImpl dst = (MultiVertexGeometryImpl)dstGeom;
        if (dst.getType() != this.getType()) {
            throw new IllegalArgumentException();
        }
        this._copyToUnsafe(dst);
    }

    void _copyToUnsafe(MultiVertexGeometryImpl dst) {
        this._verifyAllStreams();
        dst.m_description = this.m_description;
        dst.m_vertexAttributes = null;
        int nattrib = this.m_description.getAttributeCount();
        AttributeStreamBase[] cloneAttributes = null;
        if (this.m_vertexAttributes != null) {
            cloneAttributes = new AttributeStreamBase[nattrib];
            for (int i = 0; i < nattrib; ++i) {
                if (this.m_vertexAttributes[i] == null) continue;
                int ncomps = VertexDescription.getComponentCount(this.m_description._getSemanticsImpl(i));
                cloneAttributes[i] = this.m_vertexAttributes[i].restrictedClone(this.getPointCount() * ncomps);
            }
        }
        if (this.m_envelope != null) {
            dst.m_envelope = (Envelope)this.m_envelope.createInstance();
            this.m_envelope.copyTo(dst.m_envelope);
        } else {
            dst.m_envelope = null;
        }
        dst.m_pointCount = this.m_pointCount;
        dst.m_flagsMask = this.m_flagsMask;
        dst.m_vertexAttributes = cloneAttributes;
        try {
            this._copyToImpl(dst);
        }
        catch (Exception ex) {
            dst.setEmpty();
            throw new RuntimeException(ex);
        }
    }

    public boolean _attributeStreamIsAllocated(int semantics) {
        this.throwIfEmpty();
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        return attributeIndex >= 0 && this.m_vertexAttributes[attributeIndex] != null;
    }

    void _setEmptyImpl() {
        this.m_pointCount = 0;
        this.m_reservedPointCount = -1;
        this.m_vertexAttributes = null;
        this.notifyModified(0xFFFFFF);
    }

    public void notifyModified(int flags) {
        if (flags == 0xFFFFFF) {
            this.m_reservedPointCount = -1;
            this._notifyModifiedAllImpl();
        }
        this.m_flagsMask |= flags;
        this._clearAccelerators();
        this._touch();
    }

    protected void _updateAllDirtyIntervals(boolean bExact) {
        this._verifyAllStreams();
        if (this._hasDirtyFlag(192)) {
            if (null == this.m_envelope) {
                this.m_envelope = new Envelope(this.m_description);
            } else {
                this.m_envelope.assignVertexDescription(this.m_description);
            }
            if (this.isEmpty()) {
                this.m_envelope.setEmpty();
                return;
            }
            this._updateXYImpl(bExact);
            for (int attributeIndex = 1; attributeIndex < this.m_description.getAttributeCount(); ++attributeIndex) {
                int semantics = this.m_description._getSemanticsImpl(attributeIndex);
                int ncomps = VertexDescription.getComponentCount(semantics);
                AttributeStreamBase stream = this.m_vertexAttributes[attributeIndex];
                for (int iord = 0; iord < ncomps; ++iord) {
                    Envelope1D interval = new Envelope1D();
                    interval.setEmpty();
                    for (int i = 0; i < this.m_pointCount; ++i) {
                        double value = stream.readAsDbl(i * ncomps + iord);
                        interval.merge(value);
                    }
                    this.m_envelope.setInterval(semantics, iord, interval);
                }
            }
            if (bExact) {
                this._setDirtyFlag(192, false);
            }
        }
    }

    public void _updateXYImpl(boolean bExact) {
        this.m_envelope.setEmpty();
        AttributeStreamOfDbl stream = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        Point2D pt = new Point2D();
        for (int i = 0; i < this.m_pointCount; ++i) {
            stream.read(2 * i, pt);
            this.m_envelope.merge(pt);
        }
    }

    void calculateEnvelope2D(Envelope2D env, boolean bExact) {
        env.setEmpty();
        AttributeStreamOfDbl stream = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        Point2D pt = new Point2D();
        for (int i = 0; i < this.m_pointCount; ++i) {
            stream.read(2 * i, pt);
            env.merge(pt);
        }
    }

    protected void _verifyAllStreamsImpl() {
        if (this.m_reservedPointCount < this.m_pointCount) {
            if (this.m_vertexAttributes == null) {
                this.m_vertexAttributes = new AttributeStreamBase[this.m_description.getAttributeCount()];
            }
            this.m_reservedPointCount = NumberUtils.intMax();
            for (int attributeIndex = 0; attributeIndex < this.m_description.getAttributeCount(); ++attributeIndex) {
                int semantics = this.m_description._getSemanticsImpl(attributeIndex);
                if (this.m_vertexAttributes[attributeIndex] != null) {
                    int ncomp = VertexDescription.getComponentCount(semantics);
                    int size = this.m_vertexAttributes[attributeIndex].virtualSize() / ncomp;
                    if (size < this.m_pointCount) {
                        size = this.m_reservedPointCount > this.m_pointCount + 5 ? (this.m_pointCount * 5 + 3) / 4 : this.m_pointCount;
                        this.m_vertexAttributes[attributeIndex].resize(size * ncomp, VertexDescription.getDefaultValue(semantics));
                    }
                    if (size >= this.m_reservedPointCount) continue;
                    this.m_reservedPointCount = size;
                    continue;
                }
                this.m_vertexAttributes[attributeIndex] = AttributeStreamBase.createAttributeStreamWithSemantics(semantics, this.m_pointCount);
                this.m_reservedPointCount = this.m_pointCount;
            }
        }
        this._verifyStreamsImpl();
        this._setDirtyFlag(32, false);
    }

    void _resizeImpl(int pointCount) {
        if (pointCount < 0) {
            throw new IllegalArgumentException();
        }
        if (pointCount == this.m_pointCount) {
            return;
        }
        this.m_pointCount = pointCount;
        this.notifyModified(65535);
    }

    int queryCoordinates(Point2D[] dst, int dstSize, int beginIndex, int endIndex) {
        int endIndexC = endIndex < 0 ? this.m_pointCount : endIndex;
        endIndexC = Math.min(endIndexC, beginIndex + dstSize);
        if (beginIndex < 0 || beginIndex >= this.m_pointCount || endIndexC < beginIndex) {
            throw new IllegalArgumentException();
        }
        AttributeStreamOfDbl xy = (AttributeStreamOfDbl)this.getAttributeStreamRef(0);
        int j = 0;
        double[] dstArray = new double[dst.length * 2];
        xy.readRange(2 * beginIndex, (endIndexC - beginIndex) * 2, dstArray, j, true);
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = new Point2D(dstArray[i * 2], dstArray[i * 2 + 1]);
        }
        return endIndexC;
    }

    int QueryCoordinates(Point3D[] dst, int dstSize, int beginIndex, int endIndex) {
        int endIndexC = endIndex < 0 ? this.m_pointCount : endIndex;
        endIndexC = Math.min(endIndexC, beginIndex + dstSize);
        if (beginIndex < 0 || beginIndex >= this.m_pointCount || endIndexC < beginIndex) {
            throw new IllegalArgumentException();
        }
        AttributeStreamOfDbl xy = (AttributeStreamOfDbl)this.getAttributeStreamRef(0);
        AttributeStreamOfDbl z = null;
        double v = VertexDescription.getDefaultValue(1);
        boolean bHasZ = this.hasAttribute(1);
        if (bHasZ) {
            z = (AttributeStreamOfDbl)this.getAttributeStreamRef(1);
        }
        int j = 0;
        int i = beginIndex;
        while (i < endIndexC) {
            dst[j].x = xy.read(2 * i);
            dst[j].y = xy.read(2 * i + 1);
            dst[j].z = bHasZ ? z.read(i) : v;
            dst[j] = this.getXYZ(i);
            ++i;
            ++j;
        }
        return endIndexC;
    }

    public int getIsSimple(double tolerance) {
        if (!this._hasDirtyFlag(1)) {
            if (!this._hasDirtyFlag(2)) {
                return 0;
            }
            if (this.m_simpleTolerance >= tolerance) {
                if (!this._hasDirtyFlag(8)) {
                    return 2;
                }
                return 1;
            }
            return -1;
        }
        return -1;
    }

    void setIsSimple(int isSimpleRes, double tolerance, boolean ogc_known) {
        this.m_simpleTolerance = tolerance;
        if (isSimpleRes == -1) {
            this._setDirtyFlag(1, true);
            this._setDirtyFlag(8, true);
            return;
        }
        this._setDirtyFlag(1, false);
        if (!ogc_known) {
            this._setDirtyFlag(8, true);
        }
        if (isSimpleRes == 0) {
            this._setDirtyFlag(2, false);
            this._setDirtyFlag(4, false);
        } else if (isSimpleRes == 1) {
            this._setDirtyFlag(2, true);
            this._setDirtyFlag(4, false);
        } else if (isSimpleRes == 2) {
            this._setDirtyFlag(2, true);
            this._setDirtyFlag(4, true);
        } else {
            throw GeometryException.GeometryInternalError();
        }
    }

    double _getSimpleTolerance() {
        return this.m_simpleTolerance;
    }

    public GeometryAccelerators _getAccelerators() {
        return this.m_accelerators;
    }

    void _clearAccelerators() {
        if (this.m_accelerators != null) {
            this.m_accelerators = null;
        }
    }

    void _interpolateTwoVertices(int vertex1, int vertex2, double f, Point outPoint) {
        if (vertex1 < 0 || vertex1 >= this.m_pointCount) {
            throw new GeometryException("index out of bounds.");
        }
        if (vertex2 < 0 || vertex2 >= this.m_pointCount) {
            throw new GeometryException("index out of bounds.");
        }
        this._verifyAllStreams();
        outPoint.assignVertexDescription(this.m_description);
        if (outPoint.isEmpty()) {
            outPoint._setToDefault();
        }
        for (int attributeIndex = 0; attributeIndex < this.m_description.getAttributeCount(); ++attributeIndex) {
            int semantics = this.m_description._getSemanticsImpl(attributeIndex);
            int ncomp = VertexDescription.getComponentCount(semantics);
            for (int icomp = 0; icomp < ncomp; ++icomp) {
                double v1 = this.m_vertexAttributes[attributeIndex].readAsDbl(ncomp * vertex1 + icomp);
                double v2 = this.m_vertexAttributes[attributeIndex].readAsDbl(ncomp * vertex2 + icomp);
                outPoint.setAttribute(semantics, icomp, MathUtils.lerp(v1, v2, f));
            }
        }
    }

    double _getShortestDistance(int vertex1, int vertex2) {
        Point2D pt = this.getXY(vertex1);
        pt.sub(this.getXY(vertex2));
        return pt.length();
    }

    @Override
    public Point getPoint(int index) {
        if (index < 0 || index >= this.m_pointCount) {
            throw new IndexOutOfBoundsException();
        }
        this._verifyAllStreams();
        Point outPoint = new Point();
        outPoint.assignVertexDescription(this.m_description);
        if (outPoint.isEmpty()) {
            outPoint._setToDefault();
        }
        for (int attributeIndex = 0; attributeIndex < this.m_description.getAttributeCount(); ++attributeIndex) {
            int semantics = this.m_description.getSemantics(attributeIndex);
            int ncomp = VertexDescription.getComponentCount(semantics);
            for (int icomp = 0; icomp < ncomp; ++icomp) {
                double v = this.m_vertexAttributes[attributeIndex].readAsDbl(ncomp * index + icomp);
                outPoint.setAttribute(semantics, icomp, v);
            }
        }
        return outPoint;
    }

    @Override
    public void setPoint(int index, Point src) {
        if (index < 0 || index >= this.m_pointCount) {
            throw new IndexOutOfBoundsException();
        }
        Point point = src;
        if (src.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this._verifyAllStreams();
        VertexDescription vdin = point.getDescription();
        for (int attributeIndex = 0; attributeIndex < vdin.getAttributeCount(); ++attributeIndex) {
            int semantics = vdin.getSemantics(attributeIndex);
            int ncomp = VertexDescription.getComponentCount(semantics);
            for (int icomp = 0; icomp < ncomp; ++icomp) {
                double v = point.getAttributeAsDbl(semantics, icomp);
                this.setAttribute(semantics, index, icomp, v);
            }
        }
    }

    @Override
    public void queryCoordinates(Point[] dst) {
        int sz = this.m_pointCount;
        if (dst.length < sz) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < sz; ++i) {
            dst[i] = this.getPoint(i);
        }
    }

    @Override
    public void queryCoordinates(Point2D[] dst) {
        int sz = this.m_pointCount;
        if (dst.length < sz) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < sz; ++i) {
            dst[i] = this.getXY(i);
        }
    }

    @Override
    public void queryCoordinates(Point3D[] dst) {
        int sz = this.m_pointCount;
        if (dst.length < sz) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < sz; ++i) {
            dst[i] = this.getXYZ(i);
        }
    }

    @Override
    public void replaceNaNs(int semantics, double value) {
        this.addAttribute(semantics);
        if (this.isEmpty()) {
            return;
        }
        boolean modified = false;
        int ncomps = VertexDescription.getComponentCount(semantics);
        for (int i = 0; i < ncomps; ++i) {
            AttributeStreamBase streamBase = this.getAttributeStreamRef(semantics);
            if (streamBase instanceof AttributeStreamOfDbl) {
                AttributeStreamOfDbl dblStream = (AttributeStreamOfDbl)streamBase;
                int n = this.m_pointCount * ncomps;
                for (int ivert = 0; ivert < n; ++ivert) {
                    double v = dblStream.read(ivert);
                    if (!Double.isNaN(v)) continue;
                    dblStream.write(ivert, value);
                    modified = true;
                }
                continue;
            }
            int n = this.m_pointCount * ncomps;
            for (int ivert = 0; ivert < n; ++ivert) {
                double v = streamBase.readAsDbl(ivert);
                if (!Double.isNaN(v)) continue;
                streamBase.writeAsDbl(ivert, value);
                modified = true;
            }
        }
        if (modified) {
            this.notifyModified(1993);
        }
    }

    public abstract boolean _buildRasterizedGeometryAccelerator(double var1, Geometry.GeometryAccelerationDegree var3);

    public abstract boolean _buildQuadTreeAccelerator(Geometry.GeometryAccelerationDegree var1);

    @Override
    public String toString() {
        return "MultiVertexGeometryImpl";
    }

    public static interface DirtyFlags {
        public static final int DirtyIsKnownSimple = 1;
        public static final int IsWeakSimple = 2;
        public static final int IsStrongSimple = 4;
        public static final int DirtyOGCFlags = 8;
        public static final int DirtyVerifiedStreams = 32;
        public static final int DirtyExactIntervals = 64;
        public static final int DirtyLooseIntervals = 128;
        public static final int DirtyIntervals = 192;
        public static final int DirtyIsEnvelope = 256;
        public static final int DirtyLength2D = 512;
        public static final int DirtyRingAreas2D = 1024;
        public static final int DirtyCoordinates = 1993;
        public static final int DirtyAllInternal = 65535;
        public static final int DirtyAll = 0xFFFFFF;
    }

    public static interface GeometryXSimple {
        public static final int Unknown = -1;
        public static final int Not = 0;
        public static final int Weak = 1;
        public static final int Strong = 2;
    }
}

