/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.calcite.parser;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.mapd.calcite.parser.CaseInsensitiveListSqlOperatorTable;
import com.mapd.calcite.parser.ExtTableFunctionTypeChecker;
import com.mapd.parser.extension.ddl.SqlFirstLastValueInFrame;
import com.mapd.parser.extension.ddl.SqlLeadLag;
import com.mapd.parser.extension.ddl.SqlNthValueInFrame;
import com.mapd.parser.server.ExtensionFunction;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.metadata.RelColumnMapping;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlTableFunction;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlArrayValueConstructor;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SameOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import org.apache.calcite.sql.util.ListSqlOperatorTable;
import org.apache.calcite.sql.util.ReflectiveSqlOperatorTable;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Optionality;
import org.apache.calcite.util.Static;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeavyDBSqlOperatorTable
extends ChainedSqlOperatorTable {
    public static final SqlArrayValueConstructorAllowingEmpty ARRAY_VALUE_CONSTRUCTOR = new SqlArrayValueConstructorAllowingEmpty();
    public static final SqlFunction TRY_CAST = new TryCast();
    static final Logger HEAVYDBLOGGER;
    private final ListSqlOperatorTable listOpTab;

    public HeavyDBSqlOperatorTable(SqlOperatorTable parentTable) {
        super(ImmutableList.of(parentTable, new CaseInsensitiveListSqlOperatorTable()));
        this.listOpTab = (ListSqlOperatorTable)this.tableList.get(1);
    }

    public void addOperator(SqlOperator op) {
        this.listOpTab.add(op);
    }

    public void addUDF(Map<String, ExtensionFunction> extSigs) {
        this.addOperator(new MyUDFFunction());
        this.addOperator(new PgUnnest());
        this.addOperator(new Any());
        this.addOperator(new All());
        this.addOperator(new Now());
        this.addOperator(new Datetime());
        this.addOperator(new PgExtract());
        this.addOperator(new Dateadd());
        this.addOperator(new Datediff());
        this.addOperator(new Datepart());
        this.addOperator(new PgDateTrunc());
        this.addOperator(new Length());
        this.addOperator(new CharLength());
        this.addOperator(new KeyForString());
        this.addOperator(new SampleRatio());
        this.addOperator(new WidthBucket());
        this.addOperator(new ArrayLength());
        this.addOperator(new PgILike());
        this.addOperator(new LTrim());
        this.addOperator(new RTrim());
        this.addOperator(new LPad());
        this.addOperator(new RPad());
        this.addOperator(new Replace());
        this.addOperator(new Reverse());
        this.addOperator(new Repeat());
        this.addOperator(new SplitPart());
        this.addOperator(new RegexpLike());
        this.addOperator(new RegexpReplace());
        this.addOperator(new RegexpSubstr());
        this.addOperator(new RegexpMatch());
        this.addOperator(new Base64Encode());
        this.addOperator(new Base64Decode());
        this.addOperator(new Likely());
        this.addOperator(new Unlikely());
        this.addOperator(new Sign());
        this.addOperator(new Truncate());
        this.addOperator(new TryCast());
        this.addOperator(new ST_IsEmpty());
        this.addOperator(new ST_IsValid());
        this.addOperator(new ST_Contains());
        this.addOperator(new ST_Equals());
        this.addOperator(new ST_Intersects());
        this.addOperator(new ST_Overlaps());
        this.addOperator(new ST_Approx_Overlaps());
        this.addOperator(new ST_Disjoint());
        this.addOperator(new ST_Within());
        this.addOperator(new ST_DWithin());
        this.addOperator(new ST_DFullyWithin());
        this.addOperator(new ST_Distance());
        this.addOperator(new ST_MaxDistance());
        this.addOperator(new ST_GeogFromText());
        this.addOperator(new ST_GeomFromText());
        this.addOperator(new ST_Transform());
        this.addOperator(new ST_X());
        this.addOperator(new ST_Y());
        this.addOperator(new ST_XMin());
        this.addOperator(new ST_XMax());
        this.addOperator(new ST_YMin());
        this.addOperator(new ST_YMax());
        this.addOperator(new ST_PointN());
        this.addOperator(new ST_StartPoint());
        this.addOperator(new ST_EndPoint());
        this.addOperator(new ST_Length());
        this.addOperator(new ST_Perimeter());
        this.addOperator(new ST_Area());
        this.addOperator(new ST_NPoints());
        this.addOperator(new ST_NRings());
        this.addOperator(new ST_NumGeometries());
        this.addOperator(new ST_SRID());
        this.addOperator(new ST_SetSRID());
        this.addOperator(new ST_Point());
        this.addOperator(new ST_Centroid());
        this.addOperator(new ST_Buffer());
        this.addOperator(new ST_ConcaveHull());
        this.addOperator(new ST_ConvexHull());
        this.addOperator(new ST_Intersection());
        this.addOperator(new ST_Union());
        this.addOperator(new ST_Difference());
        this.addOperator(new CastToGeography());
        this.addOperator(new EncodeText());
        this.addOperator(new OffsetInFragment());
        this.addOperator(new ApproxCountDistinct());
        this.addOperator(new ApproxMedian());
        this.addOperator(new ApproxPercentile());
        this.addOperator(new ApproxQuantile());
        this.addOperator(new MapDAvg());
        this.addOperator(new Mode());
        this.addOperator(new Sample());
        this.addOperator(new LastSample());
        this.addOperator(new ForwardFill());
        this.addOperator(new BackwardFill());
        this.addOperator(new NthValueInFrame());
        this.addOperator(new FirstValueInFrame());
        this.addOperator(new LastValueInFrame());
        this.addOperator(new LagInFrame());
        this.addOperator(new LeadInFrame());
        this.addOperator(new CountIf());
        this.addOperator(new SumIf());
        this.addOperator(new ConditionalChangeEvent());
        this.addOperator(new HeavyDB_Geo_PolyBoundsPtr());
        this.addOperator(new convert_meters_to_pixel_width());
        this.addOperator(new convert_meters_to_pixel_height());
        this.addOperator(new is_point_in_view());
        this.addOperator(new is_point_size_in_view());
        this.addOperator(new usTimestamp());
        this.addOperator(new nsTimestamp());
        this.addOperator(new MLPredict());
        if (extSigs == null) {
            return;
        }
        HashSet<String> demangledNames = new HashSet<String>();
        for (Map.Entry<String, ExtensionFunction> extSig : extSigs.entrySet()) {
            String demangledNameArity;
            String demangledName = HeavyDBSqlOperatorTable.dropSuffix(extSig.getKey());
            String string = demangledNameArity = extSig.getValue().isTableUdf() ? String.format("%s-%s-%s", demangledName, extSig.getValue().getArgs(), extSig.getValue().getCursorFieldTypes()) : String.format("%s-%d", demangledName, extSig.getValue().getArgs().size());
            if (demangledNames.contains(demangledNameArity)) continue;
            demangledNames.add(demangledNameArity);
            if (extSig.getValue().isRowUdf()) {
                this.addOperator(new ExtFunction(demangledName, extSig.getValue()));
                continue;
            }
            this.addOperator(new ExtTableFunction(demangledName, extSig.getValue()));
        }
    }

    private static String dropSuffix(String str) {
        int suffix_idx = str.indexOf("__");
        if (suffix_idx == -1) {
            return str;
        }
        assert (suffix_idx > 0);
        return str.substring(0, suffix_idx);
    }

    static {
        try {
            Map.Entry entry;
            Field f = ReflectiveSqlOperatorTable.class.getDeclaredField("caseSensitiveOperators");
            f.setAccessible(true);
            Multimap operators = (Multimap)f.get(SqlStdOperatorTable.instance());
            Iterator i = operators.entries().iterator();
            while (i.hasNext()) {
                entry = i.next();
                if (entry.getValue() != SqlStdOperatorTable.APPROX_COUNT_DISTINCT && entry.getValue() != SqlStdOperatorTable.AVG && entry.getValue() != SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR) continue;
                i.remove();
            }
            f = ReflectiveSqlOperatorTable.class.getDeclaredField("caseInsensitiveOperators");
            f.setAccessible(true);
            operators = (Multimap)f.get(SqlStdOperatorTable.instance());
            i = operators.entries().iterator();
            while (i.hasNext()) {
                entry = i.next();
                if (entry.getValue() != SqlStdOperatorTable.APPROX_COUNT_DISTINCT && entry.getValue() != SqlStdOperatorTable.AVG && entry.getValue() != SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR) continue;
                i.remove();
            }
            SqlStdOperatorTable.instance().register(ARRAY_VALUE_CONSTRUCTOR);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HEAVYDBLOGGER = LoggerFactory.getLogger(HeavyDBSqlOperatorTable.class);
    }

    public class BackwardFill
    extends SqlAggFunction {
        public BackwardFill() {
            super("BACKWARD_FILL", null, SqlKind.WINDOW, ReturnTypes.ARG0, null, OperandTypes.family(SqlTypeFamily.ANY), SqlFunctionCategory.SYSTEM, false, true, Optionality.FORBIDDEN);
        }

        @Override
        public boolean allowsFraming() {
            return false;
        }
    }

    public class ForwardFill
    extends SqlAggFunction {
        public ForwardFill() {
            super("FORWARD_FILL", null, SqlKind.WINDOW, ReturnTypes.ARG0, null, OperandTypes.family(SqlTypeFamily.ANY), SqlFunctionCategory.SYSTEM, false, true, Optionality.FORBIDDEN);
        }

        @Override
        public boolean allowsFraming() {
            return false;
        }
    }

    public static class nsTimestamp
    extends SqlFunction {
        public nsTimestamp() {
            super("nsTIMESTAMP", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.STRING, SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.TIMESTAMP, 9);
        }
    }

    public static class usTimestamp
    extends SqlFunction {
        public usTimestamp() {
            super("usTIMESTAMP", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.STRING, SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.TIMESTAMP, 6);
        }
    }

    static class is_point_size_in_view
    extends SqlFunction {
        is_point_size_in_view() {
            super("is_point_size_in_view", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 6);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        }
    }

    static class is_point_in_view
    extends SqlFunction {
        is_point_in_view() {
            super("is_point_in_view", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 5);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        }
    }

    static class convert_meters_to_pixel_height
    extends SqlFunction {
        convert_meters_to_pixel_height() {
            super("convert_meters_to_pixel_height", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.ANY, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 6);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.DOUBLE);
        }
    }

    static class convert_meters_to_pixel_width
    extends SqlFunction {
        convert_meters_to_pixel_width() {
            super("convert_meters_to_pixel_width", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.ANY, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 6);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.DOUBLE);
        }
    }

    static class HeavyDB_Geo_PolyBoundsPtr
    extends SqlFunction {
        HeavyDB_Geo_PolyBoundsPtr() {
            super("HeavyDB_Geo_PolyBoundsPtr", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.ANY), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.BIGINT);
        }
    }

    public class ExtTableFunction
    extends SqlFunction
    implements SqlTableFunction {
        private final List<ExtensionFunction.ExtArgumentType> arg_types;
        private final List<ExtensionFunction.ExtArgumentType> outs;
        private final List<String> arg_names;
        private final List<String> pretty_arg_names;
        private final List<String> out_names;
        private final Map<String, String> options;
        private final Map<String, List<ExtensionFunction.ExtArgumentType>> cursor_field_types;
        private final Map<String, Comparable<?>> default_values;

        ExtTableFunction(String name, ExtensionFunction sig) {
            super(name, SqlKind.OTHER_FUNCTION, ReturnTypes.CURSOR, null, new ExtTableFunctionTypeChecker(HeavyDBSqlOperatorTable.this), SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION);
            this.arg_types = sig.getArgs();
            this.outs = sig.getOuts();
            this.out_names = sig.getOutNames();
            this.arg_names = sig.getArgNames();
            this.pretty_arg_names = sig.getPrettyArgNames();
            this.options = sig.getOptions();
            this.cursor_field_types = sig.getCursorFieldTypes();
            this.default_values = sig.getDefaultValues();
        }

        @Override
        public List<String> getParamNames() {
            return this.pretty_arg_names;
        }

        public List<FunctionParameter> getParameters() {
            final Boolean has_names = this.pretty_arg_names != null && this.pretty_arg_names.size() == this.arg_types.size();
            ArrayList<FunctionParameter> parameters = new ArrayList<FunctionParameter>();
            int i = 0;
            while (i < this.arg_types.size()) {
                final int arg_idx = i++;
                parameters.add(new FunctionParameter(){

                    @Override
                    public int getOrdinal() {
                        return arg_idx;
                    }

                    @Override
                    public String getName() {
                        if (has_names.booleanValue()) {
                            return (String)ExtTableFunction.this.pretty_arg_names.get(arg_idx);
                        }
                        return "arg" + arg_idx;
                    }

                    @Override
                    public RelDataType getType(RelDataTypeFactory typeFactory) {
                        SqlTypeFamily type = ExtensionFunction.toSqlTypeName((ExtensionFunction.ExtArgumentType)((Object)ExtTableFunction.this.arg_types.get(arg_idx))).getFamily();
                        return type.getDefaultConcreteType(typeFactory);
                    }

                    @Override
                    public boolean isOptional() {
                        return false;
                    }
                });
            }
            return parameters;
        }

        @Override
        public SqlReturnTypeInference getRowTypeInference() {
            return opBinding -> {
                RelDataTypeFactory fact = opBinding.getTypeFactory();
                RelDataTypeFactory.FieldInfoBuilder ret = fact.builder();
                for (int out_idx = 0; out_idx < this.outs.size(); ++out_idx) {
                    RelDataType type;
                    if (ExtensionFunction.toSqlTypeName(this.outs.get(out_idx)) == SqlTypeName.ARRAY) {
                        ExtensionFunction.ExtArgumentType extSubType = ExtensionFunction.getValueType(this.outs.get(out_idx));
                        if (ExtensionFunction.isColumnArrayType(this.outs.get(out_idx))) {
                            extSubType = ExtensionFunction.getValueType(extSubType);
                        }
                        RelDataType subtype = fact.createSqlType(ExtensionFunction.toSqlTypeName(extSubType));
                        type = fact.createArrayType(subtype, -1L);
                    } else {
                        type = fact.createSqlType(ExtensionFunction.toSqlTypeName(this.outs.get(out_idx)));
                    }
                    ret = ret.add(this.out_names.get(out_idx), type);
                    ret = ret.nullable(true);
                }
                return ret.build();
            };
        }

        private void debugPrint(String msg, Boolean debugMode) {
            if (debugMode.booleanValue()) {
                System.out.println(msg);
            }
        }

        public Set<RelColumnMapping> getColumnMappings() {
            Boolean debugMode = false;
            HashSet<RelColumnMapping> s2 = new HashSet<RelColumnMapping>();
            this.debugPrint("getNameAsId() -> " + this.getNameAsId() + ", arg_names=" + this.arg_names + ", out_names=" + this.out_names, debugMode);
            if (Integer.valueOf(this.options.getOrDefault("filter_table_function_transpose", "0")) == 1) {
                this.debugPrint("getNameAsId() -> " + this.getNameAsId(), debugMode);
                int rel_idx = -1;
                for (int arg_idx = 0; arg_idx < this.arg_names.size(); ++arg_idx) {
                    Object[] fields;
                    String arg_name = this.arg_names.get(arg_idx);
                    int start = arg_name.indexOf("[");
                    if (start != -1) {
                        ++rel_idx;
                        int end = arg_name.lastIndexOf("]");
                        fields = arg_name.substring(start + 1, end).replaceAll("\\s+", "").split(",", 0);
                    } else {
                        fields = new String[]{arg_name};
                    }
                    this.debugPrint("fields=" + Arrays.toString(fields), debugMode);
                    for (int field_idx = 0; field_idx < fields.length; ++field_idx) {
                        int out_idx = this.out_names.indexOf(fields[field_idx]);
                        if (out_idx < 0) continue;
                        s2.add(new RelColumnMapping(out_idx, rel_idx, field_idx, false));
                        this.debugPrint("out_idx, arg_idx/rel_idx, field_idx=" + out_idx + ", " + arg_idx + "/" + rel_idx + ", " + field_idx, debugMode);
                    }
                }
            }
            return s2;
        }

        public String getExtendedSignature() {
            StringBuilder ret = new StringBuilder();
            ret.append("'");
            ret.append(this.getName());
            ret.append("(");
            for (int i = 0; i < this.arg_types.size(); ++i) {
                if (i > 0) {
                    ret.append(", ");
                }
                ExtensionFunction.ExtArgumentType type = this.arg_types.get(i);
                String paramName = this.arg_names.get(i);
                ret.append(paramName).append(" => ");
                String t = type.toString().toUpperCase(Locale.ROOT);
                ret.append("<").append(t);
                if (type == ExtensionFunction.ExtArgumentType.Cursor) {
                    List<ExtensionFunction.ExtArgumentType> field_types = this.cursor_field_types.get(paramName);
                    ret.append("[");
                    for (int j = 0; j < field_types.size(); ++j) {
                        ExtensionFunction.ExtArgumentType subtype;
                        if (j > 0) {
                            ret.append(",");
                        }
                        ExtensionFunction.ExtArgumentType field_type = field_types.get(j);
                        ret.append((Object)ExtensionFunction.toSqlTypeName(field_type));
                        if (ExtensionFunction.isColumnListType(field_type)) {
                            subtype = ExtensionFunction.getValueType(field_type);
                            ret.append("[");
                            ret.append((Object)ExtensionFunction.toSqlTypeName(subtype));
                            ret.append("]");
                            continue;
                        }
                        if (!ExtensionFunction.isColumnArrayType(field_type) && !ExtensionFunction.isArrayType(field_type)) continue;
                        subtype = ExtensionFunction.getValueType(ExtensionFunction.getValueType(field_type));
                        ret.append("[");
                        ret.append((Object)ExtensionFunction.toSqlTypeName(subtype));
                        ret.append("]");
                    }
                    ret.append("]");
                }
                ret.append(">");
            }
            ret.append(")'");
            return ret.toString();
        }

        public List<String> getExtendedParamNames() {
            return this.arg_names;
        }

        @Override
        public int hashCode() {
            return this.getExtendedSignature().hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            ExtTableFunction other = (ExtTableFunction)obj;
            if (!this.getName().equals(other.getName())) {
                return false;
            }
            if (this.arg_types.size() != other.arg_types.size()) {
                return false;
            }
            for (int i = 0; i < this.arg_types.size(); ++i) {
                String otherParamName;
                if (this.arg_types.get(i) != other.arg_types.get(i)) {
                    return false;
                }
                if (this.arg_types.get(i) != ExtensionFunction.ExtArgumentType.Cursor) continue;
                String paramName = this.arg_names.get(i);
                if (!paramName.equals(otherParamName = other.getExtendedParamNames().get(i))) {
                    return false;
                }
                List<ExtensionFunction.ExtArgumentType> field_types = this.getCursorFieldTypes().get(paramName);
                List<ExtensionFunction.ExtArgumentType> other_field_types = other.getCursorFieldTypes().get(paramName);
                if (field_types.size() != other_field_types.size()) {
                    return false;
                }
                for (int j = 0; j < field_types.size(); ++j) {
                    if (field_types.get(j) == other_field_types.get(j)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public String toString() {
            return this.getExtendedSignature();
        }

        public Map<String, List<ExtensionFunction.ExtArgumentType>> getCursorFieldTypes() {
            return this.cursor_field_types;
        }

        public List<ExtensionFunction.ExtArgumentType> getArgTypes() {
            return this.arg_types;
        }

        Map<String, Comparable<?>> getDefaultValues() {
            return this.default_values;
        }

        public boolean supportsDefaultArguments() {
            return this.default_values.size() > 0;
        }

        public boolean isArgumentOptional(int i) {
            String paramName = this.getParamNames().get(i);
            return this.getDefaultValues().get(paramName) != null;
        }

        public int getNumOptionalArguments() {
            return this.getDefaultValues().size();
        }

        public SqlCall rewriteCallWithDefaultArguments(SqlCall permutedCall) {
            for (Ord<SqlNode> operand : Ord.zip(permutedCall.getOperandList())) {
                SqlBasicCall operandAsCall;
                if (((SqlNode)operand.e).getClass() != SqlBasicCall.class || (operandAsCall = (SqlBasicCall)operand.e).getOperator().getName() != "DEFAULT") continue;
                ExtTableFunction tf = (ExtTableFunction)permutedCall.getOperator();
                String paramName = tf.getExtendedParamNames().get(operand.i);
                Comparable<?> defaultVal = tf.getDefaultValues().get(paramName);
                SqlLiteral newOperand = this.createLiteralForDefaultValue(defaultVal, ((SqlNode)operand.e).getParserPosition());
                permutedCall.setOperand(operand.i, newOperand);
            }
            return permutedCall;
        }

        SqlLiteral createLiteralForDefaultValue(Comparable<?> value, SqlParserPos pos) {
            if (value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
                return SqlLiteral.createExactNumeric(value.toString(), pos);
            }
            if (value instanceof Boolean) {
                Boolean asBool = (Boolean)value;
                return SqlLiteral.createBoolean(asBool, pos);
            }
            if (value instanceof String) {
                return SqlLiteral.createCharString(value.toString(), pos);
            }
            return null;
        }

        @Override
        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            return this.getOperandTypeChecker().checkOperandTypes(callBinding, throwOnFailure);
        }
    }

    static class ExtFunction
    extends SqlFunction {
        private final ExtensionFunction sig;
        private final List<String> arg_names;

        ExtFunction(String name, ExtensionFunction sig) {
            super(name, SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(sig.toSqlSignature()), SqlFunctionCategory.USER_DEFINED_FUNCTION);
            this.sig = sig;
            this.arg_names = sig.getArgNames();
        }

        @Override
        public List<String> getParamNames() {
            return this.arg_names;
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            if (ExtensionFunction.isArrayType(this.sig.getRet())) {
                SqlTypeName valueType = ExtensionFunction.toSqlTypeName(ExtensionFunction.getValueType(this.sig.getRet()));
                RelDataType subType = typeFactory.createSqlType(valueType, -1);
                RelDataType arr = typeFactory.createArrayType(subType, -1L);
                return arr;
            }
            SqlTypeName ret = this.sig.getSqlRet();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(ret), true);
        }
    }

    public static class ConditionalChangeEvent
    extends SqlAggFunction {
        public ConditionalChangeEvent() {
            super("CONDITIONAL_CHANGE_EVENT", null, SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.ANY), SqlFunctionCategory.SYSTEM, false, true, Optionality.FORBIDDEN);
        }

        @Override
        public boolean allowsFraming() {
            return true;
        }

        @Override
        public boolean allowsNullTreatment() {
            return true;
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.BIGINT);
        }
    }

    static class SumIf
    extends SqlAggFunction {
        SumIf() {
            super("SUM_IF", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.BOOLEAN), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return opBinding.getOperandType(0);
        }
    }

    static class CountIf
    extends SqlAggFunction {
        CountIf() {
            super("COUNT_IF", null, SqlKind.OTHER_FUNCTION, null, null, OperandTypes.ANY, SqlFunctionCategory.SYSTEM, false, false, Optionality.FORBIDDEN);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return opBinding.getOperandType(0);
        }
    }

    public static class LastSample
    extends SqlAggFunction {
        public LastSample() {
            super("LAST_SAMPLE", null, SqlKind.OTHER_FUNCTION, null, null, OperandTypes.ANY, SqlFunctionCategory.SYSTEM, false, false, Optionality.FORBIDDEN);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return opBinding.getOperandType(0);
        }
    }

    public static class Sample
    extends SqlAggFunction {
        public Sample() {
            super("SAMPLE", null, SqlKind.OTHER_FUNCTION, null, null, OperandTypes.ANY, SqlFunctionCategory.SYSTEM, false, false, Optionality.FORBIDDEN);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return opBinding.getOperandType(0);
        }
    }

    static class Mode
    extends SqlAggFunction {
        Mode() {
            super("MODE", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.ANY, SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return opBinding.getOperandType(0);
        }
    }

    static class MapDAvg
    extends SqlAggFunction {
        MapDAvg() {
            super("AVG", null, SqlKind.OTHER_FUNCTION, null, null, OperandTypes.or(OperandTypes.family(SqlTypeFamily.NUMERIC), OperandTypes.family(SqlTypeFamily.GEO)), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.DOUBLE);
        }
    }

    static class ApproxQuantile
    extends SqlAggFunction {
        ApproxQuantile() {
            super("APPROX_QUANTILE", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.DOUBLE);
        }
    }

    static class ApproxPercentile
    extends SqlAggFunction {
        ApproxPercentile() {
            super("APPROX_PERCENTILE", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.DOUBLE);
        }
    }

    static class ApproxMedian
    extends SqlAggFunction {
        ApproxMedian() {
            super("APPROX_MEDIAN", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.NUMERIC), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.DOUBLE);
        }
    }

    static class ApproxCountDistinct
    extends SqlAggFunction {
        ApproxCountDistinct() {
            super("APPROX_COUNT_DISTINCT", null, SqlKind.OTHER_FUNCTION, null, null, OperandTypes.or(OperandTypes.family(SqlTypeFamily.ANY), OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.INTEGER)), SqlFunctionCategory.SYSTEM, false, false, Optionality.FORBIDDEN);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.BIGINT);
        }
    }

    public static class OffsetInFragment
    extends SqlFunction {
        public OffsetInFragment() {
            super("OFFSET_IN_FRAGMENT", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.NILADIC, SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 0);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.BIGINT);
        }
    }

    static class EncodeText
    extends SqlFunction {
        EncodeText() {
            super("ENCODE_TEXT", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.STRING), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            return opBinding.getOperandType(0);
        }
    }

    static class CastToGeography
    extends SqlFunction {
        CastToGeography() {
            super("CastToGeography", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.ANY), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.INTEGER);
        }
    }

    static class ST_Difference
    extends SqlFunction {
        ST_Difference() {
            super("ST_Difference", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(ST_Difference.signature()), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 2);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.INTEGER);
        }

        private static List<SqlTypeFamily> signature() {
            ArrayList<SqlTypeFamily> st_difference_sig = new ArrayList<SqlTypeFamily>();
            st_difference_sig.add(SqlTypeFamily.ANY);
            st_difference_sig.add(SqlTypeFamily.ANY);
            return st_difference_sig;
        }
    }

    static class ST_Union
    extends SqlFunction {
        ST_Union() {
            super("ST_Union", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(ST_Union.signature()), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 2);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.INTEGER);
        }

        private static List<SqlTypeFamily> signature() {
            ArrayList<SqlTypeFamily> st_union_sig = new ArrayList<SqlTypeFamily>();
            st_union_sig.add(SqlTypeFamily.ANY);
            st_union_sig.add(SqlTypeFamily.ANY);
            return st_union_sig;
        }
    }

    static class ST_Intersection
    extends SqlFunction {
        ST_Intersection() {
            super("ST_Intersection", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(ST_Intersection.signature()), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 2);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.INTEGER);
        }

        private static List<SqlTypeFamily> signature() {
            ArrayList<SqlTypeFamily> st_intersection_sig = new ArrayList<SqlTypeFamily>();
            st_intersection_sig.add(SqlTypeFamily.ANY);
            st_intersection_sig.add(SqlTypeFamily.ANY);
            return st_intersection_sig;
        }
    }

    static class ST_ConvexHull
    extends SqlFunction {
        ST_ConvexHull() {
            super("ST_ConvexHull", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(ST_ConvexHull.signature()), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.INTEGER);
        }

        private static List<SqlTypeFamily> signature() {
            ArrayList<SqlTypeFamily> st_convexhull_sig = new ArrayList<SqlTypeFamily>();
            st_convexhull_sig.add(SqlTypeFamily.ANY);
            return st_convexhull_sig;
        }
    }

    static class ST_ConcaveHull
    extends SqlFunction {
        ST_ConcaveHull() {
            super("ST_ConcaveHull", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(ST_ConcaveHull.signature()), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 2);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.INTEGER);
        }

        private static List<SqlTypeFamily> signature() {
            ArrayList<SqlTypeFamily> st_concavehull_sig = new ArrayList<SqlTypeFamily>();
            st_concavehull_sig.add(SqlTypeFamily.ANY);
            st_concavehull_sig.add(SqlTypeFamily.NUMERIC);
            return st_concavehull_sig;
        }
    }

    static class ST_Buffer
    extends SqlFunction {
        ST_Buffer() {
            super("ST_Buffer", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(ST_Buffer.signature()), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 2);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.INTEGER);
        }

        private static List<SqlTypeFamily> signature() {
            ArrayList<SqlTypeFamily> st_buffer_sig = new ArrayList<SqlTypeFamily>();
            st_buffer_sig.add(SqlTypeFamily.ANY);
            st_buffer_sig.add(SqlTypeFamily.NUMERIC);
            return st_buffer_sig;
        }
    }

    static class ST_Centroid
    extends SqlFunction {
        ST_Centroid() {
            super("ST_Centroid", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(ST_Centroid.signature()), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.INTEGER);
        }

        private static List<SqlTypeFamily> signature() {
            ArrayList<SqlTypeFamily> st_centroid_sig = new ArrayList<SqlTypeFamily>();
            st_centroid_sig.add(SqlTypeFamily.ANY);
            return st_centroid_sig;
        }
    }

    static class ST_Point
    extends SqlFunction {
        ST_Point() {
            super("ST_Point", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 2);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.INTEGER);
        }
    }

    static class ST_SetSRID
    extends SqlFunction {
        ST_SetSRID() {
            super("ST_SetSRID", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.INTEGER), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.INTEGER), opBinding.getOperandType(0).isNullable());
        }
    }

    static class ST_SRID
    extends SqlFunction {
        ST_SRID() {
            super("ST_SRID", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.ANY), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.INTEGER), opBinding.getOperandType(0).isNullable());
        }
    }

    static class ST_NumGeometries
    extends SqlFunction {
        ST_NumGeometries() {
            super("ST_NumGeometries", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.ANY), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.INTEGER), opBinding.getOperandType(0).isNullable());
        }
    }

    static class ST_NRings
    extends SqlFunction {
        ST_NRings() {
            super("ST_NRings", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.ANY), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.INTEGER), opBinding.getOperandType(0).isNullable());
        }
    }

    static class ST_NPoints
    extends SqlFunction {
        ST_NPoints() {
            super("ST_NPoints", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.ANY), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.INTEGER), opBinding.getOperandType(0).isNullable());
        }
    }

    static class ST_Area
    extends SqlFunction {
        ST_Area() {
            super("ST_Area", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.ANY), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), opBinding.getOperandType(0).isNullable());
        }
    }

    static class ST_Perimeter
    extends SqlFunction {
        ST_Perimeter() {
            super("ST_Perimeter", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.ANY), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), opBinding.getOperandType(0).isNullable());
        }
    }

    static class ST_Length
    extends SqlFunction {
        ST_Length() {
            super("ST_Length", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.ANY), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), opBinding.getOperandType(0).isNullable());
        }
    }

    static class ST_StartPoint
    extends SqlFunction {
        ST_StartPoint() {
            super("ST_StartPoint", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.ANY), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.INTEGER), opBinding.getOperandType(0).isNullable());
        }
    }

    static class ST_EndPoint
    extends SqlFunction {
        ST_EndPoint() {
            super("ST_EndPoint", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.ANY), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.INTEGER), opBinding.getOperandType(0).isNullable());
        }
    }

    static class ST_PointN
    extends SqlFunction {
        ST_PointN() {
            super("ST_PointN", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.INTEGER), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.INTEGER), opBinding.getOperandType(0).isNullable());
        }
    }

    static class ST_YMax
    extends SqlFunction {
        ST_YMax() {
            super("ST_YMax", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.ANY), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), opBinding.getOperandType(0).isNullable());
        }
    }

    static class ST_YMin
    extends SqlFunction {
        ST_YMin() {
            super("ST_YMin", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.ANY), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), opBinding.getOperandType(0).isNullable());
        }
    }

    static class ST_XMax
    extends SqlFunction {
        ST_XMax() {
            super("ST_XMax", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.ANY), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), opBinding.getOperandType(0).isNullable());
        }
    }

    static class ST_XMin
    extends SqlFunction {
        ST_XMin() {
            super("ST_XMin", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.ANY), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), opBinding.getOperandType(0).isNullable());
        }
    }

    static class ST_Y
    extends SqlFunction {
        ST_Y() {
            super("ST_Y", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.ANY), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), opBinding.getOperandType(0).isNullable());
        }
    }

    static class ST_X
    extends SqlFunction {
        ST_X() {
            super("ST_X", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.ANY), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), opBinding.getOperandType(0).isNullable());
        }
    }

    static class ST_Transform
    extends SqlFunction {
        ST_Transform() {
            super("ST_Transform", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.INTEGER), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.INTEGER), opBinding.getOperandType(0).isNullable());
        }
    }

    static class ST_GeomFromText
    extends SqlFunction {
        ST_GeomFromText() {
            super("ST_GeomFromText", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.or(OperandTypes.family(SqlTypeFamily.ANY), OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.INTEGER)), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.INTEGER);
        }
    }

    static class ST_GeogFromText
    extends SqlFunction {
        ST_GeogFromText() {
            super("ST_GeogFromText", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.or(OperandTypes.family(SqlTypeFamily.ANY), OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.INTEGER)), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.INTEGER);
        }
    }

    static class ST_MaxDistance
    extends SqlFunction {
        ST_MaxDistance() {
            super("ST_MaxDistance", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(ST_MaxDistance.signature()), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 2);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), opBinding.getOperandType(0).isNullable() || opBinding.getOperandType(1).isNullable());
        }

        private static List<SqlTypeFamily> signature() {
            ArrayList<SqlTypeFamily> st_maxdistance_sig = new ArrayList<SqlTypeFamily>();
            st_maxdistance_sig.add(SqlTypeFamily.ANY);
            st_maxdistance_sig.add(SqlTypeFamily.ANY);
            return st_maxdistance_sig;
        }
    }

    static class ST_Distance
    extends SqlFunction {
        ST_Distance() {
            super("ST_Distance", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(ST_Distance.signature()), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 2);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), opBinding.getOperandType(0).isNullable() || opBinding.getOperandType(1).isNullable());
        }

        private static List<SqlTypeFamily> signature() {
            ArrayList<SqlTypeFamily> st_distance_sig = new ArrayList<SqlTypeFamily>();
            st_distance_sig.add(SqlTypeFamily.ANY);
            st_distance_sig.add(SqlTypeFamily.ANY);
            return st_distance_sig;
        }
    }

    static class ST_DFullyWithin
    extends SqlFunction {
        ST_DFullyWithin() {
            super("ST_DFullyWithin", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(ST_DFullyWithin.signature()), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 3);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BOOLEAN), opBinding.getOperandType(0).isNullable() || opBinding.getOperandType(1).isNullable() || opBinding.getOperandType(2).isNullable());
        }

        private static List<SqlTypeFamily> signature() {
            ArrayList<SqlTypeFamily> st_dwithin_sig = new ArrayList<SqlTypeFamily>();
            st_dwithin_sig.add(SqlTypeFamily.ANY);
            st_dwithin_sig.add(SqlTypeFamily.ANY);
            st_dwithin_sig.add(SqlTypeFamily.NUMERIC);
            return st_dwithin_sig;
        }
    }

    static class ST_DWithin
    extends SqlFunction {
        ST_DWithin() {
            super("ST_DWithin", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(ST_DWithin.signature()), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 3);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BOOLEAN), opBinding.getOperandType(0).isNullable() || opBinding.getOperandType(1).isNullable() || opBinding.getOperandType(2).isNullable());
        }

        private static List<SqlTypeFamily> signature() {
            ArrayList<SqlTypeFamily> st_dwithin_sig = new ArrayList<SqlTypeFamily>();
            st_dwithin_sig.add(SqlTypeFamily.ANY);
            st_dwithin_sig.add(SqlTypeFamily.ANY);
            st_dwithin_sig.add(SqlTypeFamily.NUMERIC);
            return st_dwithin_sig;
        }
    }

    static class ST_Within
    extends SqlFunction {
        ST_Within() {
            super("ST_Within", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(ST_Within.signature()), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 2);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BOOLEAN), opBinding.getOperandType(0).isNullable() || opBinding.getOperandType(1).isNullable());
        }

        private static List<SqlTypeFamily> signature() {
            ArrayList<SqlTypeFamily> st_within_sig = new ArrayList<SqlTypeFamily>();
            st_within_sig.add(SqlTypeFamily.ANY);
            st_within_sig.add(SqlTypeFamily.ANY);
            return st_within_sig;
        }
    }

    static class ST_Disjoint
    extends SqlFunction {
        ST_Disjoint() {
            super("ST_Disjoint", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(ST_Disjoint.signature()), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 2);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BOOLEAN), opBinding.getOperandType(0).isNullable() || opBinding.getOperandType(1).isNullable());
        }

        private static List<SqlTypeFamily> signature() {
            ArrayList<SqlTypeFamily> st_disjoint_sig = new ArrayList<SqlTypeFamily>();
            st_disjoint_sig.add(SqlTypeFamily.ANY);
            st_disjoint_sig.add(SqlTypeFamily.ANY);
            return st_disjoint_sig;
        }
    }

    static class ST_Approx_Overlaps
    extends SqlFunction {
        ST_Approx_Overlaps() {
            super("ST_Approx_Overlaps", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(ST_Approx_Overlaps.signature()), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 2);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        }

        private static List<SqlTypeFamily> signature() {
            ArrayList<SqlTypeFamily> st_overlaps_sig = new ArrayList<SqlTypeFamily>();
            st_overlaps_sig.add(SqlTypeFamily.ANY);
            st_overlaps_sig.add(SqlTypeFamily.ANY);
            return st_overlaps_sig;
        }
    }

    static class ST_Overlaps
    extends SqlFunction {
        ST_Overlaps() {
            super("ST_Overlaps", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(ST_Overlaps.signature()), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 2);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        }

        private static List<SqlTypeFamily> signature() {
            ArrayList<SqlTypeFamily> st_overlaps_sig = new ArrayList<SqlTypeFamily>();
            st_overlaps_sig.add(SqlTypeFamily.ANY);
            st_overlaps_sig.add(SqlTypeFamily.ANY);
            return st_overlaps_sig;
        }
    }

    static class ST_Intersects
    extends SqlFunction {
        ST_Intersects() {
            super("ST_Intersects", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(ST_Intersects.signature()), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 2);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BOOLEAN), opBinding.getOperandType(0).isNullable() || opBinding.getOperandType(1).isNullable());
        }

        private static List<SqlTypeFamily> signature() {
            ArrayList<SqlTypeFamily> st_intersects_sig = new ArrayList<SqlTypeFamily>();
            st_intersects_sig.add(SqlTypeFamily.ANY);
            st_intersects_sig.add(SqlTypeFamily.ANY);
            return st_intersects_sig;
        }
    }

    static class ST_Equals
    extends SqlFunction {
        ST_Equals() {
            super("ST_Equals", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(ST_Equals.signature()), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 2);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        }

        private static List<SqlTypeFamily> signature() {
            ArrayList<SqlTypeFamily> st_equals_sig = new ArrayList<SqlTypeFamily>();
            st_equals_sig.add(SqlTypeFamily.ANY);
            st_equals_sig.add(SqlTypeFamily.ANY);
            return st_equals_sig;
        }
    }

    static class ST_Contains
    extends SqlFunction {
        ST_Contains() {
            super("ST_Contains", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(ST_Contains.signature()), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 2);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BOOLEAN), opBinding.getOperandType(0).isNullable() || opBinding.getOperandType(1).isNullable());
        }

        private static List<SqlTypeFamily> signature() {
            ArrayList<SqlTypeFamily> st_contains_sig = new ArrayList<SqlTypeFamily>();
            st_contains_sig.add(SqlTypeFamily.ANY);
            st_contains_sig.add(SqlTypeFamily.ANY);
            return st_contains_sig;
        }
    }

    static class ST_IsValid
    extends SqlFunction {
        ST_IsValid() {
            super("ST_IsValid", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(ST_IsValid.signature()), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        }

        private static List<SqlTypeFamily> signature() {
            ArrayList<SqlTypeFamily> st_isvalid_sig = new ArrayList<SqlTypeFamily>();
            st_isvalid_sig.add(SqlTypeFamily.ANY);
            return st_isvalid_sig;
        }
    }

    static class ST_IsEmpty
    extends SqlFunction {
        ST_IsEmpty() {
            super("ST_IsEmpty", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(ST_IsEmpty.signature()), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        }

        private static List<SqlTypeFamily> signature() {
            ArrayList<SqlTypeFamily> st_isempty_sig = new ArrayList<SqlTypeFamily>();
            st_isempty_sig.add(SqlTypeFamily.ANY);
            return st_isempty_sig;
        }
    }

    static class Truncate
    extends SqlFunction {
        Truncate() {
            super("TRUNCATE", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(Truncate.signature()), SqlFunctionCategory.NUMERIC);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 2);
            return opBinding.getOperandType(0);
        }

        private static List<SqlTypeFamily> signature() {
            ArrayList<SqlTypeFamily> truncate_sig = new ArrayList<SqlTypeFamily>();
            truncate_sig.add(SqlTypeFamily.NUMERIC);
            truncate_sig.add(SqlTypeFamily.INTEGER);
            return truncate_sig;
        }
    }

    public static class Sign
    extends SqlFunction {
        public Sign() {
            super("SIGN", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return opBinding.getOperandType(0);
        }
    }

    public static class Unlikely
    extends SqlFunction {
        public Unlikely() {
            super("UNLIKELY", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.BOOLEAN, SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return opBinding.getOperandType(0);
        }
    }

    public static class Likely
    extends SqlFunction {
        public Likely() {
            super("LIKELY", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.BOOLEAN, SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return opBinding.getOperandType(0);
        }
    }

    public static class TryCast
    extends SqlFunction {
        public TryCast() {
            super("TRY_CAST", SqlKind.OTHER_FUNCTION, null, InferTypes.FIRST_KNOWN, null, SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            SqlCallBinding callBinding;
            SqlNode operand0;
            assert (opBinding.getOperandCount() == 2);
            RelDataType ret = opBinding.getOperandType(1);
            RelDataType firstType = opBinding.getOperandType(0);
            ret = opBinding.getTypeFactory().createTypeWithNullability(ret, firstType.isNullable());
            if (opBinding instanceof SqlCallBinding && ((operand0 = (callBinding = (SqlCallBinding)opBinding).operand(0)) instanceof SqlLiteral && ((SqlLiteral)operand0).getValue() == null || operand0 instanceof SqlDynamicParam)) {
                SqlValidatorImpl validator = (SqlValidatorImpl)callBinding.getValidator();
                validator.setValidatedNodeType(operand0, ret);
            }
            return ret;
        }

        @Override
        public String getSignatureTemplate(int operandsCount) {
            assert (operandsCount == 2);
            return "{0}({1} AS {2})";
        }

        @Override
        public SqlOperandCountRange getOperandCountRange() {
            return SqlOperandCountRanges.of(2);
        }

        @Override
        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            SqlNode left = callBinding.operand(0);
            SqlNode right = callBinding.operand(1);
            if (SqlUtil.isNullLiteral(left, false) || left instanceof SqlDynamicParam) {
                return true;
            }
            RelDataType validatedNodeType = callBinding.getValidator().getValidatedNodeType(left);
            RelDataType returnType = callBinding.getValidator().deriveType(callBinding.getScope(), right);
            if (!SqlTypeUtil.canCastFrom(returnType, validatedNodeType, true)) {
                if (throwOnFailure) {
                    throw callBinding.newError(Static.RESOURCE.cannotCastValue(validatedNodeType.toString(), returnType.toString()));
                }
                return false;
            }
            if (SqlTypeUtil.areCharacterSetsMismatched(validatedNodeType, returnType)) {
                if (throwOnFailure) {
                    throw callBinding.newError(Static.RESOURCE.cannotCastValue(validatedNodeType.getFullTypeString(), returnType.getFullTypeString()));
                }
                return false;
            }
            return true;
        }

        @Override
        public SqlSyntax getSyntax() {
            return SqlSyntax.FUNCTION;
        }

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            assert (call.operandCount() == 2);
            SqlWriter.Frame frame = writer.startFunCall(this.getName());
            ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
            writer.sep("AS");
            if (call.operand(1) instanceof SqlIntervalQualifier) {
                writer.sep("INTERVAL");
            }
            ((SqlNode)call.operand(1)).unparse(writer, 0, 0);
            writer.endFunCall(frame);
        }
    }

    public static class Base64Decode
    extends SqlFunction {
        public Base64Decode() {
            super("BASE64_DECODE", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(Base64Decode.getSignatureFamilies()), SqlFunctionCategory.STRING);
        }

        private static List<SqlTypeFamily> getSignatureFamilies() {
            ArrayList<SqlTypeFamily> families = new ArrayList<SqlTypeFamily>();
            families.add(SqlTypeFamily.STRING);
            return families;
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return opBinding.getOperandType(0);
        }
    }

    public static class Base64Encode
    extends SqlFunction {
        public Base64Encode() {
            super("BASE64_ENCODE", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(Base64Encode.getSignatureFamilies()), SqlFunctionCategory.STRING);
        }

        private static List<SqlTypeFamily> getSignatureFamilies() {
            ArrayList<SqlTypeFamily> families = new ArrayList<SqlTypeFamily>();
            families.add(SqlTypeFamily.STRING);
            return families;
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return opBinding.getOperandType(0);
        }
    }

    public static class RegexpMatch
    extends RegexpSubstr {
        public RegexpMatch() {
            super("REGEXP_MATCH");
        }
    }

    public static class RegexpSubstr
    extends SqlFunction {
        public RegexpSubstr() {
            super("REGEXP_SUBSTR", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(RegexpSubstr.getSignatureFamilies()), SqlFunctionCategory.STRING);
        }

        public RegexpSubstr(String alias) {
            super(alias, SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(RegexpSubstr.getSignatureFamilies()), SqlFunctionCategory.SYSTEM);
        }

        private static List<SqlTypeFamily> getSignatureFamilies() {
            ArrayList<SqlTypeFamily> families = new ArrayList<SqlTypeFamily>();
            families.add(SqlTypeFamily.STRING);
            families.add(SqlTypeFamily.STRING);
            families.add(SqlTypeFamily.INTEGER);
            families.add(SqlTypeFamily.INTEGER);
            families.add(SqlTypeFamily.STRING);
            families.add(SqlTypeFamily.INTEGER);
            return families;
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            assert (functionQualifier == null);
            int num_operands = operands.length;
            if (num_operands < 2 || num_operands > 6) {
                throw new IllegalArgumentException("Invalid operand count " + Arrays.toString(operands));
            }
            SqlNode[] new_operands = new SqlNode[]{operands[0], operands[1], num_operands < 3 || operands[2] == null ? SqlLiteral.createExactNumeric("1", pos) : operands[2], num_operands < 4 || operands[3] == null ? SqlLiteral.createExactNumeric("1", pos) : operands[3], num_operands < 5 || operands[4] == null ? SqlLiteral.createCharString("c", pos) : operands[4], num_operands < 6 || operands[5] == null ? SqlLiteral.createExactNumeric("1", pos) : operands[5]};
            return super.createCall(functionQualifier, pos, new_operands);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return opBinding.getOperandType(0);
        }
    }

    public static class RegexpReplace
    extends SqlFunction {
        public RegexpReplace() {
            super("REGEXP_REPLACE", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(RegexpReplace.getSignatureFamilies()), SqlFunctionCategory.STRING);
        }

        private static List<SqlTypeFamily> getSignatureFamilies() {
            ArrayList<SqlTypeFamily> families = new ArrayList<SqlTypeFamily>();
            families.add(SqlTypeFamily.STRING);
            families.add(SqlTypeFamily.STRING);
            families.add(SqlTypeFamily.STRING);
            families.add(SqlTypeFamily.INTEGER);
            families.add(SqlTypeFamily.INTEGER);
            families.add(SqlTypeFamily.STRING);
            return families;
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            assert (functionQualifier == null);
            int num_operands = operands.length;
            if (num_operands < 2 || num_operands > 6) {
                throw new IllegalArgumentException("Invalid operand count " + Arrays.toString(operands));
            }
            SqlNode[] new_operands = new SqlNode[]{operands[0], operands[1], num_operands < 3 || operands[2] == null ? SqlLiteral.createCharString("", pos) : operands[2], num_operands < 4 || operands[3] == null ? SqlLiteral.createExactNumeric("1", pos) : operands[3], num_operands < 5 || operands[4] == null ? SqlLiteral.createExactNumeric("0", pos) : operands[4], num_operands < 6 || operands[5] == null ? SqlLiteral.createCharString("c", pos) : operands[5]};
            return super.createCall(functionQualifier, pos, new_operands);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return opBinding.getOperandType(0);
        }
    }

    public static class Repeat
    extends SqlFunction {
        public Repeat() {
            super("REPEAT", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(Repeat.getSignatureFamilies()), SqlFunctionCategory.STRING);
        }

        private static List<SqlTypeFamily> getSignatureFamilies() {
            ArrayList<SqlTypeFamily> families = new ArrayList<SqlTypeFamily>();
            families.add(SqlTypeFamily.STRING);
            families.add(SqlTypeFamily.INTEGER);
            return families;
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return opBinding.getOperandType(0);
        }
    }

    public static class Reverse
    extends SqlFunction {
        public Reverse() {
            super("REVERSE", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(Reverse.getSignatureFamilies()), SqlFunctionCategory.STRING);
        }

        private static List<SqlTypeFamily> getSignatureFamilies() {
            ArrayList<SqlTypeFamily> families = new ArrayList<SqlTypeFamily>();
            families.add(SqlTypeFamily.STRING);
            return families;
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return opBinding.getOperandType(0);
        }
    }

    public static class Replace
    extends SqlFunction {
        public Replace() {
            super("REPLACE", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(Replace.getSignatureFamilies()), SqlFunctionCategory.STRING);
        }

        private static List<SqlTypeFamily> getSignatureFamilies() {
            ArrayList<SqlTypeFamily> families = new ArrayList<SqlTypeFamily>();
            families.add(SqlTypeFamily.STRING);
            families.add(SqlTypeFamily.STRING);
            families.add(SqlTypeFamily.STRING);
            return families;
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return opBinding.getOperandType(0);
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            assert (functionQualifier == null);
            switch (operands.length) {
                case 2: {
                    operands = new SqlNode[]{operands[0], operands[1], SqlLiteral.createCharString("", pos)};
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid operand count " + Arrays.toString(operands));
                }
            }
            return super.createCall(functionQualifier, pos, operands);
        }

        @Override
        public boolean requiresCreate(List<SqlNode> operands) {
            return operands.size() == 2;
        }
    }

    public static class SplitPart
    extends SqlFunction {
        public SplitPart() {
            super("SPLIT_PART", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SplitPart.getSignatureFamilies()), SqlFunctionCategory.STRING);
        }

        private static List<SqlTypeFamily> getSignatureFamilies() {
            ArrayList<SqlTypeFamily> families = new ArrayList<SqlTypeFamily>();
            families.add(SqlTypeFamily.STRING);
            families.add(SqlTypeFamily.STRING);
            families.add(SqlTypeFamily.INTEGER);
            return families;
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return opBinding.getOperandType(0);
        }
    }

    public static class RPad
    extends LeftRightPad {
        public RPad() {
            super("RPAD");
        }
    }

    public static class LPad
    extends LeftRightPad {
        public LPad() {
            super("LPAD");
        }
    }

    public static class LeftRightPad
    extends SqlFunction {
        public LeftRightPad(String name) {
            super(name, SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0.andThen(SqlTypeTransforms.TO_NULLABLE).andThen(SqlTypeTransforms.TO_VARYING), null, OperandTypes.and(OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.STRING), new SameOperandTypeChecker(3){

                @Override
                protected List<Integer> getOperandList(int operandCount) {
                    return ImmutableList.of(Integer.valueOf(0), Integer.valueOf(2));
                }
            }), SqlFunctionCategory.STRING);
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            assert (functionQualifier == null);
            switch (operands.length) {
                case 2: {
                    operands = new SqlNode[]{operands[0], operands[1], SqlLiteral.createCharString(" ", pos)};
                    break;
                }
                case 3: {
                    if (operands[2] == null) {
                        operands[2] = SqlLiteral.createCharString(" ", pos);
                    }
                    operands = new SqlNode[]{operands[0], operands[1], operands[2]};
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid operand count " + Arrays.toString(operands));
                }
            }
            return super.createCall(functionQualifier, pos, operands);
        }

        @Override
        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            if (!super.checkOperandTypes(callBinding, throwOnFailure)) {
                return false;
            }
            switch (this.kind) {
                case TRIM: {
                    return SqlTypeUtil.isCharTypeComparable(callBinding, ImmutableList.of(callBinding.operand(0), callBinding.operand(2)), throwOnFailure);
                }
            }
            return true;
        }

        @Override
        public boolean requiresCreate(List<SqlNode> operands) {
            return operands.size() == 2;
        }
    }

    public static class RTrim
    extends LeftRightTrim {
        public RTrim() {
            super("RTRIM", SqlKind.RTRIM);
        }
    }

    public static class LTrim
    extends LeftRightTrim {
        public LTrim() {
            super("LTRIM", SqlKind.LTRIM);
        }
    }

    public static class LeftRightTrim
    extends SqlFunction {
        public LeftRightTrim(String name, SqlKind kind) {
            super(name, kind, ReturnTypes.ARG0.andThen(SqlTypeTransforms.TO_NULLABLE).andThen(SqlTypeTransforms.TO_VARYING), null, OperandTypes.and(OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING), new SameOperandTypeChecker(2){

                @Override
                protected List<Integer> getOperandList(int operandCount) {
                    return ImmutableList.of(Integer.valueOf(0), Integer.valueOf(1));
                }
            }), SqlFunctionCategory.STRING);
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            assert (functionQualifier == null);
            switch (operands.length) {
                case 1: {
                    operands = new SqlNode[]{operands[0], SqlLiteral.createCharString(" ", pos)};
                    break;
                }
                case 2: {
                    if (operands[1] == null) {
                        operands[1] = SqlLiteral.createCharString(" ", pos);
                    }
                    operands = new SqlNode[]{operands[0], operands[1]};
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid operand count " + Arrays.toString(operands));
                }
            }
            return super.createCall(functionQualifier, pos, operands);
        }

        @Override
        public boolean requiresCreate(List<SqlNode> operands) {
            return operands.size() == 1;
        }
    }

    public static class RegexpLike
    extends SqlFunction {
        public RegexpLike() {
            super("REGEXP_LIKE", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(RegexpLike.getSignatureFamilies(), new EscapeOptional()), SqlFunctionCategory.SYSTEM);
        }

        private static List<SqlTypeFamily> getSignatureFamilies() {
            ArrayList<SqlTypeFamily> families = new ArrayList<SqlTypeFamily>();
            families.add(SqlTypeFamily.STRING);
            families.add(SqlTypeFamily.STRING);
            families.add(SqlTypeFamily.STRING);
            return families;
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        }

        private static class EscapeOptional
        implements java.util.function.Predicate<Integer>,
        Predicate<Integer> {
            private EscapeOptional() {
            }

            @Override
            public boolean test(Integer t) {
                return this.apply(t);
            }

            @Override
            public boolean apply(Integer t) {
                return t == 2;
            }
        }
    }

    public static class PgILike
    extends SqlFunction {
        public PgILike() {
            super("PG_ILIKE", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(PgILike.getSignatureFamilies(), new EscapeOptional()), SqlFunctionCategory.SYSTEM);
        }

        private static List<SqlTypeFamily> getSignatureFamilies() {
            ArrayList<SqlTypeFamily> families = new ArrayList<SqlTypeFamily>();
            families.add(SqlTypeFamily.STRING);
            families.add(SqlTypeFamily.STRING);
            families.add(SqlTypeFamily.STRING);
            return families;
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        }

        private static class EscapeOptional
        implements java.util.function.Predicate<Integer>,
        Predicate<Integer> {
            private EscapeOptional() {
            }

            @Override
            public boolean test(Integer t) {
                return this.apply(t);
            }

            @Override
            public boolean apply(Integer t) {
                return t == 2;
            }
        }
    }

    public static class ArrayLength
    extends SqlFunction {
        public static final ArrayLengthErrors _ERRORS = Resources.create(ArrayLengthErrors.class);

        public ArrayLength() {
            super("ARRAY_LENGTH", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.ARRAY, SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.INTEGER);
        }

        @Override
        public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
            for (int i = 0; i < call.operandCount(); ++i) {
                SqlFunction call_func;
                SqlCall operand_call;
                SqlOperator call_oper;
                Object operand = call.operand(i);
                if (!(operand instanceof SqlCall) || !((call_oper = (operand_call = (SqlCall)operand).getOperator()) instanceof SqlFunction) || (call_func = (SqlFunction)call_oper).getFunctionType() != SqlFunctionCategory.USER_DEFINED_FUNCTION) continue;
                throw validator.newValidationError(call, _ERRORS.illegalArrayLengthCall(call.toString()));
            }
            super.validateCall(call, validator, scope, operandScope);
        }

        public static interface ArrayLengthErrors {
            @Resources.BaseMessage(value="Illegal argument to 'ARRAY_LENGTH': ''{0}''")
            public Resources.ExInst<SqlValidatorException> illegalArrayLengthCall(String var1);
        }
    }

    public static class LastValueInFrame
    extends SqlFirstLastValueInFrame {
        public LastValueInFrame() {
            super("LAST_VALUE_IN_FRAME", SqlKind.LAST_VALUE);
        }
    }

    public static class FirstValueInFrame
    extends SqlFirstLastValueInFrame {
        public FirstValueInFrame() {
            super("FIRST_VALUE_IN_FRAME", SqlKind.FIRST_VALUE);
        }
    }

    public static class NthValueInFrame
    extends SqlNthValueInFrame {
        public NthValueInFrame() {
            super("NTH_VALUE_IN_FRAME");
        }
    }

    public static class LagInFrame
    extends SqlLeadLag {
        public LagInFrame() {
            super("LAG_IN_FRAME", SqlKind.LAG);
        }
    }

    public static class LeadInFrame
    extends SqlLeadLag {
        public LeadInFrame() {
            super("LEAD_IN_FRAME", SqlKind.LEAD);
        }
    }

    public static class MLPredict
    extends SqlFunction {
        public MLPredict() {
            super("ML_PREDICT", SqlKind.OTHER_FUNCTION, null, null, null, SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), true);
        }

        @Override
        public SqlOperandCountRange getOperandCountRange() {
            return SqlOperandCountRanges.from(2);
        }

        @Override
        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            SqlValidator validator = callBinding.getValidator();
            int num_operands = callBinding.getOperandCount();
            if (num_operands < 2) {
                throw new IllegalArgumentException("At least 2 arguments are required, the model name and one or more predictors.");
            }
            Boolean first_numeric_argument_found = false;
            for (int operand_idx = 0; operand_idx < num_operands; ++operand_idx) {
                SqlNode operand = callBinding.operand(operand_idx);
                SqlTypeName operand_type = validator.getValidatedNodeType(operand).getSqlTypeName();
                SqlTypeFamily operand_type_family = operand_type.getFamily();
                if (operand_idx == 0) {
                    if (operand.isA(EnumSet.of(SqlKind.LITERAL)) && operand_type_family == SqlTypeFamily.CHARACTER) continue;
                    throw new IllegalArgumentException("First argument must be TEXT literal denoting the model name.");
                }
                if (operand.isA(EnumSet.of(SqlKind.LITERAL))) {
                    throw new IllegalArgumentException("Literals are not supported as predictors.");
                }
                if (operand_type_family != SqlTypeFamily.NUMERIC && operand_type_family != SqlTypeFamily.CHARACTER) {
                    throw new IllegalArgumentException("Only TEXT and NUMERIC predictors are supported.");
                }
                if (operand_type_family == SqlTypeFamily.NUMERIC) {
                    first_numeric_argument_found = true;
                    continue;
                }
                if (!first_numeric_argument_found.booleanValue()) continue;
                throw new IllegalArgumentException("Categorical predictors of type TEXT must precede numeric predictors.");
            }
            return true;
        }
    }

    public static class WidthBucket
    extends SqlFunction {
        public WidthBucket() {
            super("WIDTH_BUCKET", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(WidthBucket.signature()), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.INTEGER), true);
        }

        private static List<SqlTypeFamily> signature() {
            ArrayList<SqlTypeFamily> families = new ArrayList<SqlTypeFamily>();
            families.add(SqlTypeFamily.NUMERIC);
            families.add(SqlTypeFamily.NUMERIC);
            families.add(SqlTypeFamily.NUMERIC);
            families.add(SqlTypeFamily.INTEGER);
            return families;
        }
    }

    public static class SampleRatio
    extends SqlFunction {
        public SampleRatio() {
            super("SAMPLE_RATIO", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SampleRatio.signature()), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        }

        private static List<SqlTypeFamily> signature() {
            ArrayList<SqlTypeFamily> families = new ArrayList<SqlTypeFamily>();
            families.add(SqlTypeFamily.NUMERIC);
            return families;
        }
    }

    public static class KeyForString
    extends SqlFunction {
        public KeyForString() {
            super("KEY_FOR_STRING", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.STRING, SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.INTEGER), opBinding.getOperandType(0).isNullable());
        }
    }

    public static class CharLength
    extends SqlFunction {
        public CharLength() {
            super("CHAR_LENGTH", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.STRING, SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.INTEGER);
        }
    }

    public static class Length
    extends SqlFunction {
        public Length() {
            super("LENGTH", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.STRING, SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.INTEGER);
        }
    }

    public static class PgDateTrunc
    extends SqlFunction {
        public PgDateTrunc() {
            super("PG_DATE_TRUNC", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.DATETIME), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.TIMESTAMP, opBinding.getOperandType(1).getPrecision()), opBinding.getOperandType(1).isNullable());
        }
    }

    public static class Datediff
    extends SqlFunction {
        public Datediff() {
            super("DATEDIFF", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.DATETIME, SqlTypeFamily.DATETIME), SqlFunctionCategory.TIMEDATE);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BIGINT), opBinding.getOperandType(1).isNullable() || opBinding.getOperandType(2).isNullable());
        }
    }

    public static class Dateadd
    extends SqlFunction {
        public Dateadd() {
            super("DATEADD", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.DATETIME), SqlFunctionCategory.TIMEDATE);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.TIMESTAMP, opBinding.getOperandType(2).getPrecision()), opBinding.getOperandType(2).isNullable());
        }
    }

    public static class Datepart
    extends SqlFunction {
        public Datepart() {
            super("DATEPART", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.DATETIME), SqlFunctionCategory.TIMEDATE);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BIGINT), opBinding.getOperandType(1).isNullable());
        }
    }

    public static class PgExtract
    extends SqlFunction {
        public PgExtract() {
            super("PG_EXTRACT", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.DATETIME), SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BIGINT), opBinding.getOperandType(1).isNullable());
        }
    }

    public static class Datetime
    extends SqlFunction {
        public Datetime() {
            super("DATETIME", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.STRING, SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.TIMESTAMP, opBinding.getOperandType(0).getPrecision());
        }
    }

    public static class Now
    extends SqlFunction {
        public Now() {
            super("NOW", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.NILADIC, SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 0);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
        }
    }

    public static class All
    extends SqlFunction {
        public All() {
            super("PG_ALL", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.ARRAY, SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataType elem_type = opBinding.getOperandType(0).getComponentType();
            assert (elem_type != null);
            return elem_type;
        }
    }

    public static class Any
    extends SqlFunction {
        public Any() {
            super("PG_ANY", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.ARRAY, SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataType elem_type = opBinding.getOperandType(0).getComponentType();
            assert (elem_type != null);
            return elem_type;
        }
    }

    public static class PgUnnest
    extends SqlFunction {
        public PgUnnest() {
            super("PG_UNNEST", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.ARRAY, SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            assert (opBinding.getOperandCount() == 1);
            RelDataType elem_type = opBinding.getOperandType(0).getComponentType();
            assert (elem_type != null);
            return elem_type;
        }
    }

    public static class MyUDFFunction
    extends SqlFunction {
        public MyUDFFunction() {
            super("MyUDF", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.STRING_STRING, SqlFunctionCategory.SYSTEM);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createSqlType(SqlTypeName.BIGINT);
        }
    }

    public static class DedupFunction
    extends SqlFunction {
        public DedupFunction() {
            super("DEDUP", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.VARIADIC, SqlFunctionCategory.USER_DEFINED_FUNCTION);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.builder().add("NAME", SqlTypeName.VARCHAR, 1024).build();
        }
    }

    public static class RampFunction
    extends SqlFunction {
        public RampFunction() {
            super("RAMP", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.NUMERIC, SqlFunctionCategory.USER_DEFINED_FUNCTION);
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.builder().add("I", SqlTypeName.INTEGER).build();
        }
    }

    public static class SqlArrayValueConstructorAllowingEmpty
    extends SqlArrayValueConstructor {
        @Override
        protected RelDataType getComponentType(RelDataTypeFactory typeFactory, List<RelDataType> argTypes) {
            if (argTypes.isEmpty()) {
                return typeFactory.createSqlType(SqlTypeName.NULL);
            }
            return super.getComponentType(typeFactory, argTypes);
        }

        @Override
        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            if (callBinding.operands().isEmpty()) {
                return true;
            }
            return super.checkOperandTypes(callBinding, throwOnFailure);
        }
    }
}

