/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.calcite.parser;

import ai.heavy.thrift.server.TColumnType;
import ai.heavy.thrift.server.TDatumType;
import ai.heavy.thrift.server.TTableDetails;
import ai.heavy.thrift.server.TTypeInfo;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeavyDBTable
implements Table {
    private static final AtomicLong VERSION_PROVIDER = new AtomicLong();
    static final Logger HEAVYDBLOGGER = LoggerFactory.getLogger(HeavyDBTable.class);
    private final TTableDetails rowInfo;
    private final long version = VERSION_PROVIDER.incrementAndGet();
    private final HashSet<String> systemColumnNames;

    public long getVersion() {
        return this.version;
    }

    public HeavyDBTable(TTableDetails ri) {
        this.rowInfo = ri;
        this.systemColumnNames = this.rowInfo.row_desc.stream().filter(row_desc -> row_desc.is_system).map(row_desc -> row_desc.col_name).collect(Collectors.toCollection(HashSet::new));
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory rdtf) {
        RelDataTypeFactory.FieldInfoBuilder builder = rdtf.builder();
        for (TColumnType tct : this.rowInfo.getRow_desc()) {
            HEAVYDBLOGGER.debug("'" + tct.col_name + "' \t" + tct.getCol_type().getEncoding() + " \t" + tct.getCol_type().getFieldValue(TTypeInfo._Fields.TYPE) + " \t" + tct.getCol_type().nullable + " \t" + tct.getCol_type().is_array + " \t" + tct.getCol_type().precision + " \t" + tct.getCol_type().scale);
            ((RelDataTypeFactory.Builder)builder).add(tct.col_name, this.createType(tct, rdtf));
        }
        return builder.build();
    }

    @Override
    public Statistic getStatistic() {
        return Statistics.UNKNOWN;
    }

    @Override
    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.TABLE;
    }

    private RelDataType createType(TColumnType value, RelDataTypeFactory typeFactory) {
        RelDataType cType = this.getRelDataType(value.col_type.type, value.col_type.precision, value.col_type.scale, typeFactory);
        if (value.col_type.is_array) {
            cType = typeFactory.createArrayType(typeFactory.createTypeWithNullability(cType, true), -1L);
        }
        if (value.col_type.isNullable()) {
            return typeFactory.createTypeWithNullability(cType, true);
        }
        return cType;
    }

    private RelDataType getRelDataType(TDatumType dType, int precision, int scale, RelDataTypeFactory typeFactory) {
        switch (dType) {
            case TINYINT: {
                return typeFactory.createSqlType(SqlTypeName.TINYINT);
            }
            case SMALLINT: {
                return typeFactory.createSqlType(SqlTypeName.SMALLINT);
            }
            case INT: {
                return typeFactory.createSqlType(SqlTypeName.INTEGER);
            }
            case BIGINT: {
                return typeFactory.createSqlType(SqlTypeName.BIGINT);
            }
            case FLOAT: {
                return typeFactory.createSqlType(SqlTypeName.FLOAT);
            }
            case DECIMAL: {
                return typeFactory.createSqlType(SqlTypeName.DECIMAL, precision, scale);
            }
            case DOUBLE: {
                return typeFactory.createSqlType(SqlTypeName.DOUBLE);
            }
            case STR: {
                return typeFactory.createSqlType(SqlTypeName.VARCHAR, 50);
            }
            case TIME: {
                return typeFactory.createSqlType(SqlTypeName.TIME);
            }
            case TIMESTAMP: {
                return typeFactory.createSqlType(SqlTypeName.TIMESTAMP, precision);
            }
            case DATE: {
                return typeFactory.createSqlType(SqlTypeName.DATE);
            }
            case BOOL: {
                return typeFactory.createSqlType(SqlTypeName.BOOLEAN);
            }
            case INTERVAL_DAY_TIME: {
                return typeFactory.createSqlType(SqlTypeName.INTERVAL_DAY);
            }
            case INTERVAL_YEAR_MONTH: {
                return typeFactory.createSqlType(SqlTypeName.INTERVAL_YEAR_MONTH);
            }
            case POINT: {
                return typeFactory.createSqlType(SqlTypeName.GEOMETRY);
            }
            case MULTIPOINT: {
                return typeFactory.createSqlType(SqlTypeName.GEOMETRY);
            }
            case LINESTRING: {
                return typeFactory.createSqlType(SqlTypeName.GEOMETRY);
            }
            case MULTILINESTRING: {
                return typeFactory.createSqlType(SqlTypeName.GEOMETRY);
            }
            case POLYGON: {
                return typeFactory.createSqlType(SqlTypeName.GEOMETRY);
            }
            case MULTIPOLYGON: {
                return typeFactory.createSqlType(SqlTypeName.GEOMETRY);
            }
        }
        throw new AssertionError((Object)dType.name());
    }

    @Override
    public boolean isRolledUp(String string) {
        return false;
    }

    @Override
    public boolean rolledUpColumnValidInsideAgg(String string, SqlCall sc, SqlNode sn, CalciteConnectionConfig ccc) {
        throw new UnsupportedOperationException("rolledUpColumnValidInsideAgg Not supported yet.");
    }

    public boolean isSystemColumn(String columnName) {
        return this.systemColumnNames.contains(columnName);
    }
}

