/*
 * Decompiled with CFR 0.152.
 */
package com.mapd.calcite.parser;

import com.mapd.calcite.parser.HeavyDBSqlOperatorTable;
import com.mapd.parser.server.ExtensionFunction;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.IntervalSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.implicit.TypeCoercionImpl;

public class HeavyDBTypeCoercion
extends TypeCoercionImpl {
    public HeavyDBTypeCoercion(RelDataTypeFactory typeFactory, SqlValidator validator) {
        super(typeFactory, validator);
    }

    public int calculateTypeCoercionScore(SqlCallBinding callBinding, HeavyDBSqlOperatorTable.ExtTableFunction udtf) {
        List<ExtensionFunction.ExtArgumentType> paramTypes = udtf.getArgTypes();
        SqlCall permutedCall = callBinding.permutedCall();
        assert (paramTypes != null);
        int score = 0;
        for (int i = 0; i < permutedCall.operandCount(); ++i) {
            Object operand = permutedCall.operand(i);
            if (((SqlNode)operand).getKind() == SqlKind.DEFAULT) continue;
            RelDataType actualRelType = this.validator.deriveType(callBinding.getScope(), (SqlNode)operand);
            RelDataType formalRelType = ExtensionFunction.toRelDataType(paramTypes.get(i), this.factory);
            if (actualRelType.getSqlTypeName() == SqlTypeName.CURSOR) {
                SqlCall cursorCall = (SqlCall)operand;
                int cursorScore = this.calculateScoreForCursorOperand((SqlNode)cursorCall.operand(0), i, callBinding.getScope(), udtf);
                if (cursorScore < 0) {
                    return -1;
                }
                score += cursorScore;
                continue;
            }
            if (actualRelType == formalRelType) continue;
            if (SqlTypeUtil.isInterval(actualRelType) && SqlTypeUtil.isInterval(formalRelType)) {
                IntervalSqlType actualInterval = (IntervalSqlType)actualRelType;
                IntervalSqlType formalInterval = (IntervalSqlType)formalRelType;
                if (actualInterval.getIntervalQualifier().isYearMonth() == formalInterval.getIntervalQualifier().isYearMonth()) continue;
                return -1;
            }
            RelDataType widerType = this.getWiderTypeForTwo(actualRelType, formalRelType, false);
            if (widerType == null) {
                return -1;
            }
            if (!SqlTypeUtil.isTimestamp(widerType) && SqlTypeUtil.sameNamedType(formalRelType, actualRelType)) continue;
            if (actualRelType == widerType) {
                return -1;
            }
            if (widerType == actualRelType) continue;
            score += this.getScoreForTypes(widerType, actualRelType, false);
        }
        return score;
    }

    private int calculateScoreForCursorOperand(SqlNode cursorOperand, int index, SqlValidatorScope scope, HeavyDBSqlOperatorTable.ExtTableFunction udtf) {
        int score = 0;
        String formalOperandName = udtf.getExtendedParamNames().get(index);
        List<ExtensionFunction.ExtArgumentType> formalFieldTypes = udtf.getCursorFieldTypes().get(formalOperandName);
        if (formalFieldTypes == null || formalFieldTypes.size() == 0) {
            System.out.println("Warning: UDTF has no CURSOR field subtype data. Proceeding assuming CURSOR typechecks.");
            return 1000;
        }
        switch (cursorOperand.getKind()) {
            case SELECT: {
                int iActual;
                SqlSelect selectNode = (SqlSelect)cursorOperand;
                int iFormal = 0;
                for (iActual = 0; iActual < selectNode.getSelectList().size() && iFormal < formalFieldTypes.size(); ++iActual, ++iFormal) {
                    SqlNode selectOperand = selectNode.getSelectList().get(iActual);
                    ExtensionFunction.ExtArgumentType extType = formalFieldTypes.get(iFormal);
                    RelDataType formalRelType = ExtensionFunction.toRelDataType(extType, this.factory);
                    RelDataType actualRelType = this.factory.createTypeWithNullability(this.validator.deriveType(scope, selectOperand), true);
                    RelDataType widerType = this.getWiderTypeForTwo(formalRelType, actualRelType, false);
                    if (formalRelType.getSqlTypeName() == SqlTypeName.COLUMN_LIST) {
                        int colListSize;
                        ExtensionFunction.ExtArgumentType colListSubtype = ExtensionFunction.getValueType(extType);
                        RelDataType formalSubtype = ExtensionFunction.toRelDataType(colListSubtype, this.factory);
                        if (ExtensionFunction.isArrayType(colListSubtype) && actualRelType.getSqlTypeName() == SqlTypeName.ARRAY) {
                            ArraySqlType formalArrayType = (ArraySqlType)formalSubtype;
                            ArraySqlType actualArrayType = (ArraySqlType)actualRelType;
                            if (!SqlTypeUtil.sameNamedType(formalArrayType.getComponentType(), actualArrayType.getComponentType())) {
                                return -1;
                            }
                        }
                        widerType = this.getWiderTypeForTwo(actualRelType, formalSubtype, false);
                        if (!(SqlTypeUtil.sameNamedType(actualRelType, formalSubtype) || widerType != null && widerType != actualRelType)) {
                            return -1;
                        }
                        int numFormalArgumentsLeft = formalFieldTypes.size() - 1 - iFormal;
                        int maxColListSize = selectNode.getSelectList().size() - numFormalArgumentsLeft - iActual;
                        for (colListSize = 0; colListSize < maxColListSize; ++colListSize) {
                            SqlNode curOperand = selectNode.getSelectList().get(iActual + colListSize);
                            actualRelType = scope.getValidator().deriveType(scope, curOperand);
                            widerType = this.getWiderTypeForTwo(formalSubtype, actualRelType, false);
                            if (!SqlTypeUtil.sameNamedType(actualRelType, formalSubtype)) {
                                if (widerType == null || !SqlTypeUtil.sameNamedType(widerType, formalSubtype) || widerType != formalSubtype) break;
                                score += this.getScoreForTypes(widerType, actualRelType, true);
                                continue;
                            }
                            score += this.shouldCoerceBinOpOperand(curOperand, widerType, scope) ? 100 : 0;
                        }
                        iActual += colListSize - 1;
                        continue;
                    }
                    if (actualRelType != formalRelType) {
                        if (widerType == null) {
                            return -1;
                        }
                        if (!SqlTypeUtil.isTimestamp(widerType) && SqlTypeUtil.sameNamedType(formalRelType, actualRelType)) continue;
                        if (actualRelType == widerType || !SqlTypeUtil.sameNamedType(widerType, formalRelType)) {
                            return -1;
                        }
                        score += this.getScoreForTypes(widerType, actualRelType, true);
                        continue;
                    }
                    score += this.shouldCoerceBinOpOperand(selectOperand, widerType, scope) ? 100 : 0;
                }
                if (iActual < selectNode.getSelectList().size()) {
                    return -1;
                }
                return score;
            }
        }
        System.out.println("Unsupported subquery kind in UDTF CURSOR input argument: " + (Object)((Object)cursorOperand.getKind()));
        return -1;
    }

    @Override
    public RelDataType getWiderTypeForTwo(RelDataType type1, RelDataType type2, boolean stringPromotion) {
        RelDataType returnType = super.getWiderTypeForTwo(type1, type2, stringPromotion);
        if (SqlTypeUtil.isTimestamp(type1) && SqlTypeUtil.isTimestamp(type2)) {
            returnType = type1.getPrecision() > type2.getPrecision() ? type1 : type2;
        } else if ((SqlTypeUtil.isDouble(type1) || SqlTypeUtil.isDouble(type2)) && SqlTypeUtil.isApproximateNumeric(type1) && SqlTypeUtil.isApproximateNumeric(type2)) {
            returnType = this.factory.createTypeWithNullability(this.factory.createSqlType(SqlTypeName.DOUBLE), true);
        }
        return returnType;
    }

    public boolean extTableFunctionTypeCoercion(SqlCallBinding callBinding, HeavyDBSqlOperatorTable.ExtTableFunction udtf) {
        boolean coerced = false;
        List<ExtensionFunction.ExtArgumentType> paramTypes = udtf.getArgTypes();
        SqlCall permutedCall = callBinding.permutedCall();
        for (int i = 0; i < permutedCall.operandCount(); ++i) {
            RelDataType widerType;
            RelDataType formalRelType;
            Object operand = permutedCall.operand(i);
            if (((SqlNode)operand).getKind() == SqlKind.DEFAULT) continue;
            RelDataType actualRelType = this.validator.deriveType(callBinding.getScope(), (SqlNode)operand);
            if (actualRelType.getSqlTypeName() == SqlTypeName.CURSOR) {
                SqlCall cursorCall = (SqlCall)operand;
                this.coerceCursorType(callBinding.getScope(), permutedCall, i, (SqlNode)cursorCall.operand(0), udtf);
            }
            if (actualRelType == (formalRelType = ExtensionFunction.toRelDataType(paramTypes.get(i), this.factory))) continue;
            if (SqlTypeUtil.isInterval(actualRelType) && SqlTypeUtil.isInterval(formalRelType)) {
                IntervalSqlType actualInterval = (IntervalSqlType)actualRelType;
                IntervalSqlType formalInterval = (IntervalSqlType)formalRelType;
                if (actualInterval.getIntervalQualifier().isYearMonth() == formalInterval.getIntervalQualifier().isYearMonth()) continue;
            }
            if (!SqlTypeUtil.isTimestamp(widerType = this.getWiderTypeForTwo(actualRelType, formalRelType, false)) && SqlTypeUtil.sameNamedType(formalRelType, actualRelType)) continue;
            coerced = this.coerceOperandType(callBinding.getScope(), permutedCall, i, widerType) || coerced;
        }
        return coerced;
    }

    private void coerceCursorType(SqlValidatorScope scope, SqlCall call, int index, SqlNode cursorOperand, HeavyDBSqlOperatorTable.ExtTableFunction udtf) {
        String formalOperandName = udtf.getExtendedParamNames().get(index);
        List<ExtensionFunction.ExtArgumentType> formalFieldTypes = udtf.getCursorFieldTypes().get(formalOperandName);
        if (formalFieldTypes == null || formalFieldTypes.size() == 0) {
            return;
        }
        switch (cursorOperand.getKind()) {
            case SELECT: {
                SqlSelect selectNode = (SqlSelect)cursorOperand;
                int iFormal = 0;
                ArrayList<RelDataTypeField> newValidatedTypeList = new ArrayList<RelDataTypeField>();
                for (int iActual = 0; iActual < selectNode.getSelectList().size() && iFormal < formalFieldTypes.size(); ++iFormal, ++iActual) {
                    SqlNode selectOperand = selectNode.getSelectList().get(iActual);
                    ExtensionFunction.ExtArgumentType extType = formalFieldTypes.get(iFormal);
                    RelDataType formalRelType = ExtensionFunction.toRelDataType(extType, this.factory);
                    RelDataType actualRelType = this.validator.deriveType(scope, selectOperand);
                    RelDataType widerType = this.getWiderTypeForTwo(formalRelType, actualRelType, false);
                    if (ExtensionFunction.isColumnArrayType(extType) || ExtensionFunction.isColumnListArrayType(extType)) {
                        this.updateValidatedType(newValidatedTypeList, selectNode, iActual);
                        continue;
                    }
                    if (formalRelType.getSqlTypeName() == SqlTypeName.COLUMN_LIST) {
                        int colListSize;
                        ExtensionFunction.ExtArgumentType colListSubtype = ExtensionFunction.getValueType(extType);
                        RelDataType formalSubtype = ExtensionFunction.toRelDataType(colListSubtype, this.factory);
                        widerType = this.getWiderTypeForTwo(actualRelType, formalSubtype, false);
                        int numFormalArgumentsLeft = formalFieldTypes.size() - 1 - iFormal;
                        int maxColListSize = selectNode.getSelectList().size() - numFormalArgumentsLeft - iActual;
                        for (colListSize = 0; colListSize < maxColListSize; ++colListSize) {
                            SqlNode curOperand = selectNode.getSelectList().get(iActual + colListSize);
                            actualRelType = scope.getValidator().deriveType(scope, curOperand);
                            widerType = this.getWiderTypeForTwo(formalSubtype, actualRelType, false);
                            if (!SqlTypeUtil.sameNamedType(actualRelType, formalSubtype)) {
                                if (widerType == null) break;
                                if (actualRelType != widerType) {
                                    this.coerceColumnType(scope, selectNode.getSelectList(), iActual + colListSize, widerType);
                                }
                            } else if (this.shouldCoerceBinOpOperand(curOperand, widerType, scope)) {
                                this.coerceBinOpOperand((SqlBasicCall)curOperand, widerType, scope);
                            }
                            this.updateValidatedType(newValidatedTypeList, selectNode, iActual + colListSize);
                        }
                        iActual += colListSize - 1;
                        continue;
                    }
                    if (actualRelType != formalRelType) {
                        if (!SqlTypeUtil.isTimestamp(widerType) && SqlTypeUtil.sameNamedType(actualRelType, formalRelType)) {
                            this.updateValidatedType(newValidatedTypeList, selectNode, iActual);
                            continue;
                        }
                        if (widerType != actualRelType) {
                            this.coerceColumnType(scope, selectNode.getSelectList(), iActual, widerType);
                        }
                        this.updateValidatedType(newValidatedTypeList, selectNode, iActual);
                        continue;
                    }
                    if (this.shouldCoerceBinOpOperand(selectOperand, widerType, scope)) {
                        this.coerceBinOpOperand((SqlBasicCall)selectOperand, widerType, scope);
                    }
                    this.updateValidatedType(newValidatedTypeList, selectNode, iActual);
                }
                RelDataType newCursorStructType = this.factory.createStructType(newValidatedTypeList);
                RelDataType newCursorType = this.factory.createTypeWithNullability(newCursorStructType, this.validator.getValidatedNodeType(selectNode).isNullable());
                this.validator.setValidatedNodeType(selectNode, newCursorType);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    protected boolean needToCast(SqlValidatorScope scope, SqlNode node, RelDataType toType) {
        RelDataType fromType = this.validator.deriveType(scope, node);
        if (fromType == null) {
            return false;
        }
        if (fromType instanceof RelDataTypeFactoryImpl.JavaType && toType.getSqlTypeName() == fromType.getSqlTypeName()) {
            return false;
        }
        if (toType.getSqlTypeName() == SqlTypeName.ANY || fromType.getSqlTypeName() == SqlTypeName.ANY) {
            return false;
        }
        if (SqlTypeUtil.isCharacter(toType) && SqlTypeUtil.isCharacter(fromType)) {
            return false;
        }
        if (SqlTypeUtil.equalSansNullability(this.factory, fromType, toType)) {
            return false;
        }
        assert (SqlTypeUtil.canCastFrom(toType, fromType, true));
        return true;
    }

    private void updateValidatedType(List<RelDataTypeField> typeList, SqlSelect selectNode, int operandIndex) {
        SqlCall asCall;
        SqlNode operand = selectNode.getSelectList().get(operandIndex);
        RelDataType newType = this.validator.getValidatedNodeType(operand);
        if (operand instanceof SqlCall && (asCall = (SqlCall)operand).getOperator().getKind() == SqlKind.AS) {
            newType = this.validator.getValidatedNodeType((SqlNode)asCall.operand(0));
        }
        RelDataTypeField oldTypeField = this.validator.getValidatedNodeType(selectNode).getFieldList().get(operandIndex);
        RelDataTypeFieldImpl newTypeField = new RelDataTypeFieldImpl(oldTypeField.getName(), oldTypeField.getIndex(), newType);
        typeList.add(newTypeField);
    }

    private int getScoreForTypes(RelDataType targetType, RelDataType originalType, boolean isCursorArgument) {
        int baseScore = isCursorArgument ? 100 : 1;
        switch (originalType.getSqlTypeName()) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                int multiplier = 1;
                if (SqlTypeUtil.isApproximateNumeric(targetType)) {
                    multiplier = 10;
                }
                return baseScore * multiplier;
            }
        }
        return baseScore;
    }

    private void coerceBinOpOperand(SqlBasicCall binOp, RelDataType targetType, SqlValidatorScope scope) {
        if (binOp.getKind() == SqlKind.AS) {
            binOp = (SqlBasicCall)binOp.operand(0);
        }
        this.coerceOperandType(scope, binOp, 0, targetType);
        this.coerceOperandType(scope, binOp, 1, targetType);
    }

    private boolean shouldCoerceBinOpOperand(SqlNode op, RelDataType targetType, SqlValidatorScope scope) {
        if (op instanceof SqlBasicCall) {
            SqlBasicCall asCall = (SqlBasicCall)op;
            if (asCall.getOperator().getKind() == SqlKind.AS) {
                Object op2 = asCall.operand(0);
                if (op2 instanceof SqlBasicCall) {
                    asCall = (SqlBasicCall)op2;
                } else {
                    return false;
                }
            }
            if (asCall.getOperator() instanceof SqlBinaryOperator) {
                Object lhs = asCall.operand(0);
                Object rhs = asCall.operand(1);
                RelDataType lhsType = this.validator.deriveType(scope, (SqlNode)lhs);
                RelDataType rhsType = this.validator.deriveType(scope, (SqlNode)rhs);
                if (lhsType != targetType && rhsType != targetType && (((SqlNode)lhs).getKind() == SqlKind.LITERAL || ((SqlNode)rhs).getKind() == SqlKind.LITERAL)) {
                    return true;
                }
            }
        }
        return false;
    }
}

